/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.point.BSerialLcdPointExtension;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.util.ArrayUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;

public class SerialLcdSettingsPage
extends SerialLcdPage {
    private BSerialLcdPointExtension[] exts = new BSerialLcdPointExtension[0];
    private boolean rowIsSelected = false;
    private int currentActiveRow = -1;
    int curRow = 2;
    boolean boolIsInEditMode = false;
    int intCurrentHour;
    int intCurrentMinute;
    private String strCurrentMonth = "JAN";
    private int intCurrentMonth;
    private int intCurrentDay;
    private int intCurrentYear;
    private int intEditItem = 0;
    int intNumTimeZones = 0;
    BTimeZone[] arrTimeZones;
    String[] arrJavaTimeZones;

    public SerialLcdSettingsPage(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void displayPage() {
        this.boolIsInEditMode = false;
        this.updateTime();
        this.getNetwork().setStallOutput(false);
        if (this.arrTimeZones == null) {
            this.arrTimeZones = TimeZoneDatabase.get().getTimeZones();
        }
        this.curRow = 2;
        try {
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            this.strCurrentMonth = this.getCurrentMonth(this.intCurrentMonth);
            String strCurrentTimeOfDay = (this.intCurrentHour < 10 ? "0" + this.intCurrentHour : "" + this.intCurrentHour) + ":" + (this.intCurrentMinute < 10 ? "0" + this.intCurrentMinute : "" + this.intCurrentMinute);
            String strTimeZoneToDisplay = "";
            strTimeZoneToDisplay = BAbsTime.now().getTimeZone().getId();
            if (strTimeZoneToDisplay.length() > 13) {
                strTimeZoneToDisplay = strTimeZoneToDisplay.substring(0, 13);
            }
            int intSavingTimeAdjustment = BTimeZone.getTimeZone((String)BAbsTime.now().getTimeZone().getId()).getDaylightAdjustment() == -1 ? 0 : BTimeZone.getTimeZone((String)BAbsTime.now().getTimeZone().getId()).getDaylightAdjustment() / 3600000;
            int intCurrentTimeZoneUTC = BTimeZone.getTimeZone((String)BAbsTime.now().getTimeZone().getId()).getUtcOffset() == 0 ? 0 : BTimeZone.getTimeZone((String)BAbsTime.now().getTimeZone().getId()).getUtcOffset() / 3600000;
            String strUTC_Offset = "(";
            if (intSavingTimeAdjustment == 0) {
                strUTC_Offset = strUTC_Offset + intCurrentTimeZoneUTC + ")";
            } else {
                int intDSTAdjustment = intCurrentTimeZoneUTC + intSavingTimeAdjustment;
                strUTC_Offset = strUTC_Offset + intDSTAdjustment + "/" + intCurrentTimeZoneUTC + ")";
            }
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 0, 2, 1, 1, BSerialLcdNetwork.lex.getText("sys.title")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("sys.ip")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("sys.date")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("sys.time")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[5], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("sys.zone")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 50, 2, 1, 3, this.strCurrentMonth));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 68, 2, 1, 3, "" + (this.intCurrentDay < 10 ? "0" + this.intCurrentDay : "" + this.intCurrentDay) + ","));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 84, 2, 1, 3, "" + this.intCurrentYear));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 50, 2, 1, 3, strCurrentTimeOfDay));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[5], 50, 2, 1, 3, strTimeZoneToDisplay));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 50, 2, 1, 3, strUTC_Offset));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button1Pressed(int presses) {
        this.boolIsInEditMode = false;
        this.intEditItem = 0;
        if (!this.getNetwork().getHideMainMenu()) {
            this.getNetwork().displayMenuPage();
        }
    }

    @Override
    public void button2Pressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.boolIsInEditMode) {
                block1 : switch (this.curRow) {
                    case 3: {
                        switch (this.intEditItem) {
                            case 0: {
                                this.intEditItem = 1;
                            }
                            case 2: {
                                this.intEditItem = 1;
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 68, 79));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 68, 2, 1, 3, (this.intCurrentDay < 10 ? "0" + this.intCurrentDay : "" + this.intCurrentDay) + ","));
                                this.strCurrentMonth = this.getCurrentMonth(this.intCurrentMonth);
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 50, 66));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 50, 2, 2, 3, this.strCurrentMonth));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
                                break block1;
                            }
                            case 3: {
                                this.intEditItem = 2;
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 84, 127));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 84, 2, 1, 3, "" + this.intCurrentYear));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 68, 79));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 68, 2, 2, 3, (this.intCurrentDay < 10 ? "0" + this.intCurrentDay : "" + this.intCurrentDay) + ","));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (this.intEditItem != 5) break;
                        this.intEditItem = 4;
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[4], 62, 127));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 62, 2, 1, 3, this.intCurrentMinute < 10 ? "0" + this.intCurrentMinute : "" + this.intCurrentMinute));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[4], 50, 59));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 50, 2, 2, 3, this.intCurrentHour < 10 ? "0" + this.intCurrentHour : "" + this.intCurrentHour));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
                        break;
                    }
                }
            }
        }
        catch (SerialLcdCommandException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void button3Pressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.boolIsInEditMode) {
                switch (this.curRow) {
                    case 3: {
                        switch (this.intEditItem) {
                            case 0: {
                                this.intEditItem = 1;
                            }
                            case 1: {
                                this.intEditItem = 2;
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 50, 66));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 50, 2, 1, 3, this.strCurrentMonth));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 68, 79));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 68, 2, 2, 3, (this.intCurrentDay < 10 ? "0" + this.intCurrentDay : "" + this.intCurrentDay) + ","));
                                break;
                            }
                            case 2: {
                                this.intEditItem = 3;
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 68, 79));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 68, 2, 1, 3, (this.intCurrentDay < 10 ? "0" + this.intCurrentDay : "" + this.intCurrentDay) + ","));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 84, 127));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 84, 2, 2, 3, "" + this.intCurrentYear));
                            }
                        }
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
                        break;
                    }
                    case 4: {
                        this.intEditItem = 5;
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[4], 50, 59));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 50, 2, 1, 3, this.intCurrentHour < 10 ? "0" + this.intCurrentHour : "" + this.intCurrentHour));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[4], 62, 127));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 62, 2, 2, 3, this.intCurrentMinute < 10 ? "0" + this.intCurrentMinute : "" + this.intCurrentMinute));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
                        break;
                    }
                }
            }
        }
        catch (SerialLcdCommandException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void button4Pressed(int presses) {
        this.intEditItem = 0;
        if (this.boolIsInEditMode) {
            this.boolIsInEditMode = false;
            this.getNetwork().displaySettingsPage();
        } else {
            this.boolIsInEditMode = false;
            this.getNetwork().displayMenuPage();
        }
    }

    @Override
    public void buttonDownPressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.boolIsInEditMode) {
                block1 : switch (this.curRow) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        switch (this.intEditItem) {
                            case 0: {
                                this.intEditItem = 1;
                            }
                            case 1: {
                                --this.intCurrentMonth;
                                if (this.intCurrentMonth < 1) {
                                    this.intCurrentMonth = 12;
                                }
                                this.writeMonth();
                                break block1;
                            }
                            case 2: {
                                --this.intCurrentDay;
                                if (this.intCurrentDay == 0) {
                                    this.intCurrentDay = BAbsTime.getDaysInMonth((int)this.intCurrentYear, (BMonth)BMonth.make((int)(this.intCurrentMonth - 1)));
                                }
                                this.writeDay(true);
                                break block1;
                            }
                            case 3: {
                                --this.intCurrentYear;
                                this.writeYear();
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (this.intEditItem) {
                            case 4: {
                                --this.intCurrentHour;
                                if (this.intCurrentHour < 0) {
                                    this.intCurrentHour = 23;
                                }
                                this.writeHour();
                                break block1;
                            }
                            case 5: {
                                --this.intCurrentMinute;
                                if (this.intCurrentMinute < 0) {
                                    this.intCurrentMinute = 59;
                                }
                                this.writeMinute();
                            }
                        }
                        break;
                    }
                }
            } else if (this.curRow < 5) {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(false));
                ++this.curRow;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
        }
        catch (Exception e) {
            System.err.println("Error getting next menu item - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void buttonUpPressed(int presses) {
        try {
            if (this.boolIsInEditMode) {
                block1 : switch (this.curRow) {
                    case 3: {
                        switch (this.intEditItem) {
                            case 0: {
                                this.intEditItem = 1;
                            }
                            case 1: {
                                ++this.intCurrentMonth;
                                if (this.intCurrentMonth > 12) {
                                    this.intCurrentMonth = 1;
                                }
                                this.writeMonth();
                                break block1;
                            }
                            case 2: {
                                ++this.intCurrentDay;
                                if (this.intCurrentDay > BAbsTime.getDaysInMonth((int)this.intCurrentYear, (BMonth)BMonth.make((int)(this.intCurrentMonth - 1)))) {
                                    this.intCurrentDay = 1;
                                }
                                this.writeDay(true);
                                break block1;
                            }
                            case 3: {
                                ++this.intCurrentYear;
                                this.writeYear();
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (this.intEditItem) {
                            case 4: {
                                ++this.intCurrentHour;
                                if (this.intCurrentHour > 23) {
                                    this.intCurrentHour = 0;
                                }
                                this.writeHour();
                                break block1;
                            }
                            case 5: {
                                ++this.intCurrentMinute;
                                if (this.intCurrentMinute > 59) {
                                    this.intCurrentMinute = 0;
                                }
                                this.writeMinute();
                            }
                        }
                        break;
                    }
                }
            } else if (this.curRow > 2) {
                Object[] commands = new SerialLcdCommand[]{};
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(false));
                --this.curRow;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
        }
        catch (Exception e) {
            System.err.println("Error getting next menu item - " + e.toString());
            e.printStackTrace();
        }
    }

    private void writeMonth() throws SerialLcdCommandException {
        Object[] commands = new SerialLcdCommand[]{};
        this.strCurrentMonth = this.getCurrentMonth(this.intCurrentMonth);
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 50, 66));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 50, 2, 2, 3, this.strCurrentMonth));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        this.checkDay();
    }

    private void writeDay(boolean selected) throws SerialLcdCommandException {
        Object[] commands = new SerialLcdCommand[]{};
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 68, 78));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 68, 2, selected ? 2 : 1, 3, (this.intCurrentDay < 10 ? "0" + this.intCurrentDay : "" + this.intCurrentDay) + ","));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    private void writeYear() throws SerialLcdCommandException {
        Object[] commands = new SerialLcdCommand[]{};
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 84, 127));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 84, 2, 2, 3, "" + this.intCurrentYear));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        this.checkDay();
    }

    private void checkDay() throws SerialLcdCommandException {
        int days = BAbsTime.getDaysInMonth((int)this.intCurrentYear, (BMonth)BMonth.make((int)(this.intCurrentMonth - 1)));
        if (this.intCurrentDay > days) {
            this.intCurrentDay = days;
            this.writeDay(false);
        }
    }

    private void writeHour() throws SerialLcdCommandException {
        Object[] commands = new SerialLcdCommand[]{};
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[4], 50, 59));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 50, 2, 2, 3, this.intCurrentHour < 10 ? "0" + this.intCurrentHour : "" + this.intCurrentHour));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    private void writeMinute() throws SerialLcdCommandException {
        Object[] commands = new SerialLcdCommand[]{};
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[4], 62, 127));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 62, 2, 2, 3, this.intCurrentMinute < 10 ? "0" + this.intCurrentMinute : "" + this.intCurrentMinute));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    @Override
    public void buttonEnterPressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            service.loadPlatformServiceProperties();
            switch (this.curRow) {
                case 2: {
                    this.getNetwork().displayIPSettingsPage();
                    return;
                }
                case 3: {
                    if (this.boolIsInEditMode) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 50, 127));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 50, 2, 1, 3, this.strCurrentMonth));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 68, 2, 1, 3, "" + (this.intCurrentDay < 10 ? "0" + this.intCurrentDay : "" + this.intCurrentDay) + ","));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 84, 2, 1, 3, "" + this.intCurrentYear));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                        service.setSystemTime(BAbsTime.make((int)this.intCurrentYear, (BMonth)BMonth.make((int)(this.intCurrentMonth - 1)), (int)this.intCurrentDay, (int)this.intCurrentHour, (int)this.intCurrentMinute));
                        service.savePlatformServiceProperties();
                        this.intEditItem = 0;
                        break;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 50, 66));
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 50, 2, 2, 3, this.strCurrentMonth));
                    break;
                }
                case 4: {
                    if (this.boolIsInEditMode) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[4], 0, 127));
                        String strCurrentTimeOfDay = (this.intCurrentHour < 10 ? "0" + this.intCurrentHour : "" + this.intCurrentHour) + ":" + (this.intCurrentMinute < 10 ? "0" + this.intCurrentMinute : "" + this.intCurrentMinute);
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("sys.time")));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 50, 2, 1, 3, strCurrentTimeOfDay));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                        service.setSystemTime(BAbsTime.make((int)this.intCurrentYear, (BMonth)BMonth.make((int)(this.intCurrentMonth - 1)), (int)this.intCurrentDay, (int)this.intCurrentHour, (int)this.intCurrentMinute));
                        service.savePlatformServiceProperties();
                        this.intEditItem = 0;
                        break;
                    }
                    this.intEditItem = 4;
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[4], 50, 59));
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 50, 2, 2, 3, this.intCurrentHour < 10 ? "0" + this.intCurrentHour : "" + this.intCurrentHour));
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                    break;
                }
                case 5: {
                    this.getNetwork().displaySettingsTimezonePage();
                    return;
                }
            }
            try {
                this.updateButton1(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.boolIsInEditMode = !this.boolIsInEditMode;
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (SerialLcdCommandException e) {
            e.printStackTrace();
        }
    }

    private SerialLcdCommand getUnderline(boolean on) throws SerialLcdCommandException {
        if (this.curRow > 2) {
            return new SerialLcdLineCommand(50, this.curRow * 8 + 7, 120, this.curRow * 8 + 7, on);
        }
        return new SerialLcdLineCommand(0, this.curRow * 8 + 7, 120, this.curRow * 8 + 7, on);
    }

    private SerialLcdCommand[] updateButton1(boolean send) throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, this.getRowIsSelected() || !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 57, 26, 57, this.getRowIsSelected() || !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 58, 26, 58, this.getRowIsSelected() || !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 59, 26, 59, this.getRowIsSelected() || !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 60, 26, 60, this.getRowIsSelected() || !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 61, 26, 61, this.getRowIsSelected() || !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 62, 26, 62, this.getRowIsSelected() || !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 63, 26, 63, this.getRowIsSelected() || !this.getNetwork().getHideMainMenu())});
        if (this.getRowIsSelected()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("null")));
        } else if (!this.getNetwork().getHideMainMenu()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("menu")));
        }
        if (send) {
            this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
        }
        return tmpCommands;
    }

    private SerialLcdCommand[] getSoftButtons() throws Exception {
        Object[] tmpCommands = this.updateButton1(false);
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(102, 56, 127, 56, true), new SerialLcdLineCommand(102, 57, 127, 57, true), new SerialLcdLineCommand(102, 58, 127, 58, true), new SerialLcdLineCommand(102, 59, 127, 59, true), new SerialLcdLineCommand(102, 60, 127, 60, true), new SerialLcdLineCommand(102, 61, 127, 61, true), new SerialLcdLineCommand(102, 62, 127, 62, true), new SerialLcdLineCommand(102, 63, 127, 63, true)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 105, 2, 2, 3, BSerialLcdNetwork.lex.getText("cancel")));
        return tmpCommands;
    }

    public boolean getRowIsSelected() {
        return this.rowIsSelected;
    }

    public BSerialLcdPointExtension getCurrentRow() {
        return this.exts[this.currentActiveRow];
    }

    public void addExtension(BSerialLcdPointExtension ext) {
        this.exts = (BSerialLcdPointExtension[])ArrayUtil.addOne((Object[])this.exts, (Object)((Object)ext));
    }

    public String getCurrentMonth(int intCurMonth) {
        String strCurMonth = BSerialLcdNetwork.lex.getText("jan");
        switch (intCurMonth) {
            case 1: {
                strCurMonth = BSerialLcdNetwork.lex.getText("jan");
                break;
            }
            case 2: {
                strCurMonth = BSerialLcdNetwork.lex.getText("feb");
                break;
            }
            case 3: {
                strCurMonth = BSerialLcdNetwork.lex.getText("mar");
                break;
            }
            case 4: {
                strCurMonth = BSerialLcdNetwork.lex.getText("apr");
                break;
            }
            case 5: {
                strCurMonth = BSerialLcdNetwork.lex.getText("may");
                break;
            }
            case 6: {
                strCurMonth = BSerialLcdNetwork.lex.getText("jun");
                break;
            }
            case 7: {
                strCurMonth = BSerialLcdNetwork.lex.getText("jul");
                break;
            }
            case 8: {
                strCurMonth = BSerialLcdNetwork.lex.getText("aug");
                break;
            }
            case 9: {
                strCurMonth = BSerialLcdNetwork.lex.getText("sep");
                break;
            }
            case 10: {
                strCurMonth = BSerialLcdNetwork.lex.getText("oct");
                break;
            }
            case 11: {
                strCurMonth = BSerialLcdNetwork.lex.getText("nov");
                break;
            }
            case 12: {
                strCurMonth = BSerialLcdNetwork.lex.getText("dec");
            }
        }
        return strCurMonth;
    }

    private void updateTime() {
        BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        service.loadPlatformServiceProperties();
        this.intCurrentHour = service.getSystemTime().getHour();
        this.intCurrentMinute = service.getSystemTime().getMinute();
        this.intCurrentMonth = service.getSystemTime().getMonth().getMonthOfYear();
        this.intCurrentDay = service.getSystemTime().getDay();
        this.intCurrentYear = service.getSystemTime().getYear();
    }
}

