/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import com.tridium.util.ArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class SerialLcdSettingsIPPage
extends SerialLcdPage {
    private boolean rowIsSelected = false;
    private int currentActiveRow = -1;
    private int currentActiveOctet = -1;
    private int currentSelectedChar = -1;
    int curRow = 3;
    int editingVal = -1;
    boolean boolIsInEditMode = false;
    boolean editingColumn = false;
    String subnetMask;
    String ipAddress;
    String gateway;
    String[] workingOctet = new String[3];
    String[] workingRow = new String[4];
    String[] brokeIPAddress;
    String[] brokeSubnet;
    String[] brokeGateway;

    public SerialLcdSettingsIPPage(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void displayPage() {
        BTcpIpPlatformService service = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        service.loadPlatformServiceProperties();
        BTcpIpHostSettings tcp = service.getSettings();
        SlotCursor cursor = tcp.getAdapters().loadSlots().getProperties();
        if (cursor.next()) {
            BTcpIpAdapterSettings tcpSettings = (BTcpIpAdapterSettings)cursor.get();
            this.ipAddress = tcpSettings.getIpAddress();
            this.subnetMask = tcpSettings.getSubnetMask();
            this.gateway = tcp.getDefaultGateway();
        }
        this.rowIsSelected = false;
        this.currentActiveRow = 3;
        this.currentActiveOctet = 1;
        this.currentSelectedChar = 2;
        this.brokeIPAddress = this.padIP(TextUtil.splitAndTrim((String)this.ipAddress, (char)'.'));
        this.brokeSubnet = this.padIP(TextUtil.splitAndTrim((String)this.subnetMask, (char)'.'));
        this.brokeGateway = this.padIP(TextUtil.splitAndTrim((String)this.gateway, (char)'.'));
        try {
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 0, 2, 1, 1, BSerialLcdNetwork.lex.getText("ip.title")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("ip.address")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("ip.subnet")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[5], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("ip.gateway")));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showIPtoEdit(3, this.ipAddress));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showIPtoEdit(4, this.subnetMask));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showIPtoEdit(5, this.gateway));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, this.currentActiveOctet, true));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error displaying page - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button1Pressed(int presses) {
        this.getNetwork().displaySettingsPage();
    }

    @Override
    public void button2Pressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.rowIsSelected) {
                if (this.currentSelectedChar > 0) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.clearSelectedOctet(this.currentActiveRow));
                    this.workingOctet[this.currentSelectedChar] = this.editingVal != 10 ? "" + this.editingVal : " ";
                    this.workingRow[this.currentActiveOctet - 1] = this.workingOctet[0] + this.workingOctet[1] + this.workingOctet[2];
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showEditingOctet(this.workingRow, false));
                    --this.currentSelectedChar;
                    this.editingVal = !this.workingOctet[this.currentSelectedChar].equals(" ") ? new Integer(this.workingOctet[this.currentSelectedChar]) : 10;
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showEditingOctet(this.workingRow, true));
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getCharUnderline(false));
                } else if (this.currentActiveOctet > 1) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.clearSelectedOctet(this.currentActiveRow));
                    this.workingOctet[this.currentSelectedChar] = this.editingVal != 10 ? "" + this.editingVal : " ";
                    this.workingRow[this.currentActiveOctet - 1] = this.workingOctet[0] + this.workingOctet[1] + this.workingOctet[2];
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showEditingOctet(this.workingRow, false));
                    this.currentSelectedChar = 2;
                    --this.currentActiveOctet;
                    for (int i = 0; i < 3; ++i) {
                        this.workingOctet[i] = "" + this.workingRow[this.currentActiveOctet - 1].charAt(i);
                    }
                    this.editingVal = !this.workingOctet[this.currentSelectedChar].equals(" ") ? new Integer(this.workingOctet[this.currentSelectedChar]) : 10;
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.clearSelectedOctet(this.currentActiveRow));
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showEditingOctet(this.workingRow, true));
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getCharUnderline(false));
                }
            } else if (this.currentActiveOctet >= 2) {
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, this.currentActiveOctet, false));
                --this.currentActiveOctet;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, this.currentActiveOctet, true));
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error selecting point - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button3Pressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.rowIsSelected) {
                if (this.currentSelectedChar < 2) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.clearSelectedOctet(this.currentActiveRow));
                    this.workingOctet[this.currentSelectedChar] = this.editingVal != 10 ? "" + this.editingVal : " ";
                    this.workingRow[this.currentActiveOctet - 1] = this.workingOctet[0] + this.workingOctet[1] + this.workingOctet[2];
                    ++this.currentSelectedChar;
                    this.editingVal = !this.workingOctet[this.currentSelectedChar].equals(" ") ? new Integer(this.workingOctet[this.currentSelectedChar]) : 10;
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showEditingOctet(this.workingRow, true));
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getCharUnderline(false));
                } else if (this.currentActiveOctet < 4) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.clearSelectedOctet(this.currentActiveRow));
                    this.workingOctet[this.currentSelectedChar] = this.editingVal != 10 ? "" + this.editingVal : " ";
                    this.workingRow[this.currentActiveOctet - 1] = this.workingOctet[0] + this.workingOctet[1] + this.workingOctet[2];
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showEditingOctet(this.workingRow, false));
                    this.currentSelectedChar = 0;
                    ++this.currentActiveOctet;
                    for (int i = 0; i < 3; ++i) {
                        this.workingOctet[i] = "" + this.workingRow[this.currentActiveOctet - 1].charAt(i);
                    }
                    this.editingVal = !this.workingOctet[this.currentSelectedChar].equals(" ") ? new Integer(this.workingOctet[this.currentSelectedChar]) : 10;
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.clearSelectedOctet(this.currentActiveRow));
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showEditingOctet(this.workingRow, true));
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getCharUnderline(false));
                }
            } else if (this.currentActiveOctet <= 3) {
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, this.currentActiveOctet, false));
                ++this.currentActiveOctet;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, this.currentActiveOctet, true));
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error selecting point - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button4Pressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        if (this.rowIsSelected) {
            this.rowIsSelected = false;
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.highlightOctet(this.currentActiveRow, this.currentActiveOctet, false));
            this.currentSelectedChar = 0;
        } else {
            this.getNetwork().openDialog(11, BSerialLcdNetwork.lex.getText("reboot"));
        }
        commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    @Override
    public void buttonEnterPressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            this.currentSelectedChar = 2;
            if (this.rowIsSelected) {
                this.workingOctet[this.currentSelectedChar] = this.editingVal != 10 ? "" + this.editingVal : " ";
                this.workingRow[this.currentActiveOctet - 1] = this.workingOctet[0] + this.workingOctet[1] + this.workingOctet[2];
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.highlightOctet(this.currentActiveRow, this.currentActiveOctet, false));
                switch (this.currentActiveRow) {
                    case 3: {
                        this.brokeIPAddress = this.workingRow;
                        break;
                    }
                    case 4: {
                        this.brokeSubnet = this.workingRow;
                        break;
                    }
                    case 5: {
                        this.brokeGateway = this.workingRow;
                        break;
                    }
                    default: {
                        System.out.println("Current Active Row is invalid: cannot set value.  Selected row:" + this.currentActiveRow);
                    }
                }
                this.rowIsSelected = false;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            } else {
                this.rowIsSelected = true;
                commands = this.highlightOctet(this.currentActiveRow, this.currentActiveOctet, true);
                switch (this.currentActiveRow) {
                    case 3: {
                        this.workingRow = this.brokeIPAddress;
                        break;
                    }
                    case 4: {
                        this.workingRow = this.brokeSubnet;
                        break;
                    }
                    case 5: {
                        this.workingRow = this.brokeGateway;
                        break;
                    }
                    default: {
                        System.out.println("CurrentActiveRow is invalid: cannot change value.  Selected row:" + this.currentActiveRow);
                        return;
                    }
                }
                for (int i = 0; i < 3; ++i) {
                    this.workingOctet[i] = "" + this.workingRow[this.currentActiveOctet - 1].charAt(i);
                }
                this.editingVal = !this.workingOctet[this.currentSelectedChar].equals(" ") ? new Integer(this.workingOctet[this.currentSelectedChar]) : 10;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.out.println("Error selecting point - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void buttonDownPressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.rowIsSelected) {
                String valueAsStr = "";
                if (this.editingVal > 0) {
                    --this.editingVal;
                    valueAsStr = "" + this.editingVal;
                } else if (this.editingVal == 32 || this.editingVal == 0) {
                    this.editingVal = 10;
                    valueAsStr = " ";
                } else {
                    System.out.println("Value is out of range.");
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[this.currentActiveRow], this.getCharLocation(), this.getCharLocation() + 4));
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow], this.getCharLocation(), 2, 2, 3, " "));
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow], this.getCharLocation(), 2, 2, 3, valueAsStr));
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getCharUnderline(false));
            } else if (this.currentActiveRow < 5) {
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, this.currentActiveOctet, false));
                ++this.currentActiveRow;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, this.currentActiveOctet, true));
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.out.println("Error selecting point - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void buttonUpPressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.rowIsSelected) {
                String valueAsStr = "";
                if (this.editingVal < 10 && this.editingVal != -1) {
                    ++this.editingVal;
                    valueAsStr = this.editingVal < 10 ? "" + this.editingVal : " ";
                } else if (this.editingVal == 32 || this.editingVal == 10) {
                    this.editingVal = 0;
                    valueAsStr = "0";
                } else {
                    System.out.println("Value is out of range:" + this.editingVal);
                    this.editingVal = 0;
                    valueAsStr = "0";
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[this.currentActiveRow], this.getCharLocation(), this.getCharLocation() + 4));
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow], this.getCharLocation(), 2, 2, 3, " "));
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow], this.getCharLocation(), 2, 2, 3, valueAsStr));
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getCharUnderline(false));
            } else if (this.currentActiveRow > 3) {
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, this.currentActiveOctet, false));
                --this.currentActiveRow;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, this.currentActiveOctet, true));
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.out.println("Error selecting point - " + e.toString());
            e.printStackTrace();
        }
    }

    private int getCharLocation() {
        int charLoc = -1;
        switch (this.currentActiveOctet) {
            case 1: {
                charLoc = 59;
                break;
            }
            case 2: {
                charLoc = 77;
                break;
            }
            case 3: {
                charLoc = 95;
                break;
            }
            case 4: {
                charLoc = 113;
                break;
            }
            default: {
                System.out.println("Cannot Return Character Location: Selected Octet out of range");
                return -1;
            }
        }
        return charLoc += this.currentSelectedChar * 5;
    }

    private int getStartOfOctetLocation() {
        int charLoc = -1;
        switch (this.currentActiveOctet) {
            case 1: {
                charLoc = 59;
                break;
            }
            case 2: {
                charLoc = 77;
                break;
            }
            case 3: {
                charLoc = 95;
                break;
            }
            case 4: {
                charLoc = 113;
                break;
            }
            default: {
                System.out.println("Cannot Return Character Location: Selected Octet out of range");
                return -1;
            }
        }
        return charLoc;
    }

    private SerialLcdCommand[] highlightOctet(int row, int column, boolean highlight) {
        Object[] commands = new SerialLcdCommand[]{};
        String[] octets = new String[1];
        switch (row) {
            case 3: {
                octets = this.brokeIPAddress;
                break;
            }
            case 4: {
                octets = this.brokeSubnet;
                break;
            }
            case 5: {
                octets = this.brokeGateway;
                break;
            }
            default: {
                octets = new String[1];
                System.out.println("Invalid Row Selected");
            }
        }
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.clearSelectedOctet(row));
        commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showEditingOctet(octets, highlight));
        if (highlight) {
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getCharUnderline(false));
        } else {
            try {
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, this.currentActiveOctet, true));
            }
            catch (Exception e) {
                System.out.println("Could not redraw underline for selected octet");
                e.printStackTrace();
            }
        }
        return commands;
    }

    private SerialLcdCommand clearSelectedOctet(int row) {
        try {
            if (this.getStartOfOctetLocation() + 15 > 127) {
                return new SerialLcdClearCommand(ROW[row], this.getStartOfOctetLocation(), 127);
            }
            return new SerialLcdClearCommand(ROW[row], this.getStartOfOctetLocation(), this.getStartOfOctetLocation() + 15);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SerialLcdCommand[] getUnderline(int row, int column, boolean on) throws SerialLcdCommandException {
        switch (column) {
            case 1: {
                return new SerialLcdCommand[]{new SerialLcdLineCommand(59, row * 8 + 7, 72, row * 8 + 7, on)};
            }
            case 2: {
                return new SerialLcdCommand[]{new SerialLcdLineCommand(77, row * 8 + 7, 90, row * 8 + 7, on)};
            }
            case 3: {
                return new SerialLcdCommand[]{new SerialLcdLineCommand(95, row * 8 + 7, 108, row * 8 + 7, on)};
            }
            case 4: {
                return new SerialLcdCommand[]{new SerialLcdLineCommand(113, row * 8 + 7, 127, row * 8 + 7, on)};
            }
        }
        System.out.println("Error: column passed to getUnderline out of range.");
        return null;
    }

    private SerialLcdCommand[] getCharUnderline(boolean positive) {
        try {
            return new SerialLcdCommand[]{new SerialLcdLineCommand(this.getCharLocation(), this.currentActiveRow * 8 + 7, this.getCharLocation() + 4, this.currentActiveRow * 8 + 7, positive)};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SerialLcdCommand[] showEditingOctet(String[] octet, boolean edit) {
        Object[] commands = new SerialLcdCommand[]{};
        int textType = edit ? 2 : 1;
        try {
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow], this.getStartOfOctetLocation(), 2, textType, 3, "   "));
            for (int i = 0; i < octet[this.currentActiveOctet - 1].length(); ++i) {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow], this.getStartOfOctetLocation() + i * 5, 2, textType, 3, "" + octet[this.currentActiveOctet - 1].charAt(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return commands;
    }

    private SerialLcdCommand[] showIPtoEdit(int rowNumber, String ipAddress) {
        Object[] commands = new SerialLcdCommand[]{};
        String[] brokeIP = this.breakIP(ipAddress);
        try {
            for (int i = 0; i < 12; ++i) {
                if (i < 3) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[rowNumber], 59 + i * 5, 2, 1, 3, brokeIP[i]));
                    continue;
                }
                if (i >= 3 && i < 6) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[rowNumber], 77 + (i - 3) * 5, 2, 1, 3, brokeIP[i]));
                    continue;
                }
                if (i >= 6 && i < 9) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[rowNumber], 95 + (i - 6) * 5, 2, 1, 3, brokeIP[i]));
                    continue;
                }
                if (i < 9) continue;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[rowNumber], 113 + (i - 9) * 5, 2, 1, 3, brokeIP[i]));
            }
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[rowNumber], 74, 2, 1, 3, "."));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[rowNumber], 92, 2, 1, 3, "."));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[rowNumber], 110, 2, 1, 3, "."));
        }
        catch (Exception e) {
            System.out.println("Error creating command array for ip Address(" + ipAddress + " to display");
            e.printStackTrace();
        }
        return commands;
    }

    private String[] breakIP(String ipAddress) {
        String[] ipNumbers = new String[12];
        String[] octets = TextUtil.split((String)ipAddress, (char)'.');
        int cntr = 0;
        for (int i = 0; i < 4; ++i) {
            int j;
            if (octets.length == 4) {
                for (j = 0; j < 3 - octets[i].length(); ++j) {
                    ipNumbers[cntr] = " ";
                    ++cntr;
                }
                for (j = 0; j < octets[i].length(); ++j) {
                    ipNumbers[cntr] = "" + octets[i].charAt(j);
                    ++cntr;
                }
                continue;
            }
            if (octets.length == 0) {
                for (j = 0; j < 3; ++j) {
                    ipNumbers[cntr] = " ";
                    ++cntr;
                }
                continue;
            }
            System.out.println("Error: IP address is wrong length - " + ipAddress + " length =" + octets.length);
            break;
        }
        return ipNumbers;
    }

    private String[] padIP(String[] brokenIP) {
        block6: for (int i = 0; i < 4; ++i) {
            switch (brokenIP[i].length()) {
                case 0: {
                    System.out.println("Error:" + this.ipAddress + "is an invalid IP address!");
                    continue block6;
                }
                case 1: {
                    brokenIP[i] = "  " + brokenIP[i];
                    continue block6;
                }
                case 2: {
                    brokenIP[i] = " " + brokenIP[i];
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
        return brokenIP;
    }

    private String reformIP(String[] brokenIP) {
        String reformedIP = "";
        String fixedOctet = "";
        for (int i = 0; i < brokenIP.length; ++i) {
            fixedOctet = "";
            for (int j = 0; j < 3; ++j) {
                if (("" + brokenIP[i].charAt(j)).equals(" ")) continue;
                fixedOctet = fixedOctet + brokenIP[i].charAt(j);
            }
            int valueCheck = -1;
            try {
                valueCheck = new Integer(fixedOctet);
                fixedOctet = "" + valueCheck;
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (Exception e) {
                System.out.println("Could not convert brokenIP[" + i + "] into an int");
                e.printStackTrace();
            }
            if (valueCheck > 255 || valueCheck < 0) {
                this.getNetwork().openDialog(0, BSerialLcdNetwork.lex.getText("ip.invalid"));
            }
            reformedIP = reformedIP + fixedOctet;
            if (i >= 3) continue;
            reformedIP = reformedIP + ".";
        }
        if (reformedIP.equals("...")) {
            reformedIP = "";
        }
        return reformedIP;
    }

    private SerialLcdCommand[] getSoftButtons() {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        try {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdClearCommand(ROW[7], 0, 127));
            if (this.rowIsSelected) {
                tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, true), new SerialLcdLineCommand(0, 57, 26, 57, true), new SerialLcdLineCommand(0, 58, 26, 58, true), new SerialLcdLineCommand(0, 59, 26, 59, true), new SerialLcdLineCommand(0, 60, 26, 60, true), new SerialLcdLineCommand(0, 61, 26, 61, true), new SerialLcdLineCommand(0, 62, 26, 62, true), new SerialLcdLineCommand(0, 63, 26, 63, true)});
                tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("menu")));
                tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(102, 56, 127, 56, true), new SerialLcdLineCommand(102, 57, 127, 57, true), new SerialLcdLineCommand(102, 58, 127, 58, true), new SerialLcdLineCommand(102, 59, 127, 59, true), new SerialLcdLineCommand(102, 60, 127, 60, true), new SerialLcdLineCommand(102, 61, 127, 61, true), new SerialLcdLineCommand(102, 62, 127, 62, true), new SerialLcdLineCommand(102, 63, 127, 63, true)});
                tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 105, 2, 2, 3, BSerialLcdNetwork.lex.getText("cancel")));
            } else {
                tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 57, 26, 57, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 58, 26, 58, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 59, 26, 59, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 60, 26, 60, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 61, 26, 61, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 62, 26, 62, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 63, 26, 63, !this.getNetwork().getHideMainMenu())});
                if (!this.getNetwork().getHideMainMenu()) {
                    tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("menu")));
                }
                tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(102, 56, 127, 56, true), new SerialLcdLineCommand(102, 57, 127, 57, true), new SerialLcdLineCommand(102, 58, 127, 58, true), new SerialLcdLineCommand(102, 59, 127, 59, true), new SerialLcdLineCommand(102, 60, 127, 60, true), new SerialLcdLineCommand(102, 61, 127, 61, true), new SerialLcdLineCommand(102, 62, 127, 62, true), new SerialLcdLineCommand(102, 63, 127, 63, true)});
                tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 105, 2, 2, 3, BSerialLcdNetwork.lex.getText("save")));
            }
        }
        catch (Exception e) {
            System.out.println("Could not draw soft buttons.");
            e.printStackTrace();
        }
        return tmpCommands;
    }

    @Override
    public void popupClosed(int popupReturn) {
        if (popupReturn == 2) {
            String ipToSave = this.reformIP(this.brokeIPAddress);
            String subnetToSave = this.reformIP(this.brokeSubnet);
            String gatewayToSave = this.reformIP(this.brokeGateway);
            BTcpIpPlatformService service = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
            service.loadPlatformServiceProperties();
            BTcpIpHostSettings tcp = service.getSettings();
            SlotCursor cursor = tcp.getAdapters().loadSlots().getProperties();
            BTcpIpAdapterSettings tcpSettings = null;
            if (cursor.next()) {
                tcpSettings = (BTcpIpAdapterSettings)cursor.get();
            }
            tcp.setDefaultGateway(gatewayToSave);
            if (tcpSettings != null) {
                tcpSettings.setIpAddress(ipToSave);
                tcpSettings.setSubnetMask(subnetToSave);
            }
            service.savePlatformServiceProperties();
            this.getNetwork().displayRebootPage();
            BSystemPlatformService platService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            platService.reboot();
        } else {
            this.displayPage();
        }
    }
}

