/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.util.ArrayUtil;

public class SerialLcdSecurityPage
extends SerialLcdPage {
    int curColumn = 0;
    char[] curPasscode = new char[]{'0', '0', '0', '0'};

    public SerialLcdSecurityPage(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void displayPage() {
        this.getNetwork().setStallOutput(false);
        this.curPasscode = new char[]{'0', '0', '0', '0'};
        this.curColumn = 0;
        try {
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 0, 0, 1, 1, BSerialLcdNetwork.lex.getText("jenesys")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 0, 2, 1, 1, BSerialLcdNetwork.lex.getText("provided")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 0, 2, 1, 1, BSerialLcdNetwork.lex.getText("passcode")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[5], 0, 4, 1, 1, "0000"));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button1Pressed(int presses) {
        if (this.curColumn != 0) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(false));
                this.curColumn = 0;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
            }
            catch (Exception e) {
                System.err.println("Error navigating columns - " + e.toString());
                e.printStackTrace();
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
    }

    @Override
    public void button2Pressed(int presses) {
        if (this.curColumn > 0) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(false));
                --this.curColumn;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
            }
            catch (Exception e) {
                System.err.println("Error navigating columns - " + e.toString());
                e.printStackTrace();
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
    }

    @Override
    public void button3Pressed(int presses) {
        if (this.curColumn < this.curPasscode.length - 1) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(false));
                ++this.curColumn;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
            }
            catch (Exception e) {
                System.err.println("Error navigating columns - " + e.toString());
                e.printStackTrace();
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
    }

    @Override
    public void button4Pressed(int presses) {
        if (this.curColumn != this.curPasscode.length - 1) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(false));
                this.curColumn = this.curPasscode.length - 1;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
            }
            catch (Exception e) {
                System.err.println("Error navigating columns - " + e.toString());
                e.printStackTrace();
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
    }

    @Override
    public void buttonDownPressed(int presses) {
        int value = new Integer("" + this.curPasscode[this.curColumn]) - 1;
        if (value > -1) {
            this.displayValue("" + value);
        } else {
            this.displayValue("9");
        }
    }

    @Override
    public void buttonUpPressed(int presses) {
        int value = new Integer("" + this.curPasscode[this.curColumn]) + 1;
        if (value < 10) {
            this.displayValue("" + value);
        } else {
            this.displayValue("0");
        }
    }

    private void displayValue(String value) {
        this.curPasscode[this.curColumn] = value.charAt(0);
        try {
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[5] + ROW[6], 44 + this.curColumn * 10, 52 + this.curColumn * 10));
            String passcode = "";
            for (int i = 0; i < this.curPasscode.length; ++i) {
                passcode = passcode + this.curPasscode[i];
            }
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[5], 0, 4, 1, 1, passcode));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[7], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error Changing Value - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void buttonEnterPressed(int presses) {
        try {
            String password = "";
            for (int i = 0; i < this.curPasscode.length; ++i) {
                password = password + this.curPasscode[i];
            }
            if (password.equals(this.getNetwork().getPasscode())) {
                this.getNetwork().setPasscodeVerified(true);
                this.getNetwork().displayMenuPage();
            } else {
                this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[7], 0, 2, 1, 1, BSerialLcdNetwork.lex.getText("invalidPasscode")));
            }
        }
        catch (Exception e) {
            System.err.println("Error Attempting Login - " + e.toString());
            e.printStackTrace();
        }
    }

    private SerialLcdCommand getUnderline(boolean on) throws SerialLcdCommandException {
        return new SerialLcdLineCommand(54 + this.curColumn * 6, 48, 58 + this.curColumn * 6, 48, on);
    }
}

