/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.lynxspring.lcd.ui.SerialLcdScheduleGrid;
import com.tridium.util.ArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;

public class SerialLcdScheduleSelectEvent
extends SerialLcdPage {
    private String[] optionsArray = new String[0];
    private int startHour;
    private SerialLcdScheduleGrid scheduleArray;
    private String pageName = BSerialLcdNetwork.lex.getText("selectEvent");
    private int topDisplayedRow = -1;
    private int currentActiveRow = -1;
    private boolean rowIsSelected = false;
    private int valueWidth;
    private final String edit = BSerialLcdNetwork.lex.getText("editEvent");
    private final String delete = BSerialLcdNetwork.lex.getText("deleteEvent");

    public SerialLcdScheduleSelectEvent(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void button4Pressed(int presses) {
        this.getNetwork().displaySchedDetailsPage((BComplex)this.scheduleArray.getSchedule());
    }

    @Override
    public void buttonDownPressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.currentActiveRow < 6 && this.currentActiveRow < this.optionsArray.length - 1) {
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline(false));
                ++this.currentActiveRow;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline(true));
            }
        }
        catch (Exception e) {
            System.out.println("Exception thrown on down button");
            e.printStackTrace();
        }
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    @Override
    public void buttonUpPressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.currentActiveRow > 0) {
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline(false));
                --this.currentActiveRow;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline(true));
            }
        }
        catch (Exception e) {
            System.out.println("Exception thrown on down button");
            e.printStackTrace();
        }
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    @Override
    public void buttonEnterPressed(int presses) {
        String[] temp = TextUtil.split((String)this.optionsArray[this.currentActiveRow], (char)'-');
        temp = TextUtil.split((String)temp[0].trim(), (char)' ');
        int eventNum = new Integer(temp[temp.length - 1]) - 1;
        if (this.optionsArray[this.currentActiveRow].indexOf(this.delete) > -1) {
            this.scheduleArray.removeEvent(this.scheduleArray.getEvents()[eventNum].getName());
            this.getNetwork().displaySchedDetailsPage((BComplex)this.scheduleArray.getSchedule());
        } else if (this.optionsArray[this.currentActiveRow].indexOf(this.edit) > -1) {
            this.getNetwork().displaySchedEventPage(this.scheduleArray, eventNum);
        } else {
            this.getNetwork().displaySchedEventPage(this.scheduleArray, -1);
        }
    }

    @Override
    public void displayPage() {
    }

    public void displayPage(SerialLcdScheduleGrid scheduleArray) {
        this.topDisplayedRow = 0;
        this.scheduleArray = scheduleArray;
        this.startHour = scheduleArray.getStartTime().getHour();
        this.currentActiveRow = 0;
        try {
            int i;
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            if (this.topDisplayedRow == -1) {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[0], 0, 2, 1, 1, this.pageName));
            }
            if (this.startHour > 12) {
                this.startHour %= 12;
            }
            int eventsInHour = scheduleArray.getEvents().length;
            this.optionsArray = new String[0];
            for (i = 0; i < eventsInHour; ++i) {
                this.optionsArray = (String[])ArrayUtil.addOne((Object[])this.optionsArray, (Object)(this.edit + " " + (i + 1) + " - " + scheduleArray.getEvents()[i].getStart()));
                this.optionsArray = (String[])ArrayUtil.addOne((Object[])this.optionsArray, (Object)(this.delete + " " + (i + 1)));
            }
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[0], 0, 2, 1, 1, this.pageName));
            for (i = 0; i < this.optionsArray.length && i <= 5; ++i) {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 1], 0, 2, 1, 0, this.optionsArray[i]));
            }
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline(true));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    private SerialLcdCommand[] getSoftButtons() throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(102, 56, 127, 56, true), new SerialLcdLineCommand(102, 57, 127, 57, true), new SerialLcdLineCommand(102, 58, 127, 58, true), new SerialLcdLineCommand(102, 59, 127, 59, true), new SerialLcdLineCommand(102, 60, 127, 60, true), new SerialLcdLineCommand(102, 61, 127, 61, true), new SerialLcdLineCommand(102, 62, 127, 62, true), new SerialLcdLineCommand(102, 63, 127, 63, true)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 105, 2, 2, 3, BSerialLcdNetwork.lex.getText("back")));
        return tmpCommands;
    }

    private SerialLcdCommand[] getSolidUnderline(int row, boolean on) throws SerialLcdCommandException {
        return new SerialLcdCommand[]{new SerialLcdLineCommand(0, row * 8 + 7, 127 - this.valueWidth - 1, row * 8 + 7, on)};
    }

    private SerialLcdCommand[] drawUnderline(boolean on) throws SerialLcdCommandException {
        return this.getSolidUnderline(this.currentActiveRow - this.topDisplayedRow + 1, on);
    }

    public boolean getRowIsSelected() {
        return this.rowIsSelected;
    }
}

