/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdBitmapCommand;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.point.BSerialLcdScheduleExtension;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.util.ArrayUtil;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.sys.BComplex;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;

public class SerialLcdSchedulePage
extends SerialLcdPage {
    private BSerialLcdScheduleExtension[] exts = new BSerialLcdScheduleExtension[0];
    private int currentActiveRow = -1;
    int intFirstArrayItemToDisplay = -1;
    private String pageName = "Schedule Menu";

    public SerialLcdSchedulePage(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void displayPage() {
        this.intFirstArrayItemToDisplay = -1;
        this.displayPage(0);
    }

    public void displayPageForFirstTime() {
        this.getNetwork().setStallOutput(false);
        try {
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[0], 0, 2, 1, 1, this.pageName));
            BOrd ordQuery = BOrd.make((String)"station:|slot:/|bql:select from lynxLCD:SerialLcdScheduleExtension");
            BITable result = (BITable)ordQuery.resolve((BObject)this.getNetwork()).get();
            TableCursor c = result.cursor();
            this.exts = new BSerialLcdScheduleExtension[0];
            while (c.next()) {
                this.exts = (BSerialLcdScheduleExtension[])ArrayUtil.addOne((Object[])this.exts, (Object)((Object)((BSerialLcdScheduleExtension)((Object)c.get()))));
            }
            String strDisplayName = "";
            for (int i = 0; i < this.exts.length && i < 6; ++i) {
                strDisplayName = this.exts[i].getParent().getDisplayName(null).length() > 25 ? this.exts[i].getParent().getDisplayName(null).substring(0, 24) : this.exts[i].getParent().getDisplayName(null);
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 1], 0, 2, 1, 0, strDisplayName));
            }
            this.currentActiveRow = 1;
            this.intFirstArrayItemToDisplay = 0;
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, true));
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    public void displayPage(int newTop) {
        this.getNetwork().setStallOutput(false);
        try {
            Object[] commands = new SerialLcdCommand[]{};
            if (this.intFirstArrayItemToDisplay == -1) {
                this.displayPageForFirstTime();
            } else {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[1] + ROW[2] + ROW[3] + ROW[4] + ROW[5] + ROW[6], 0, 127));
                this.intFirstArrayItemToDisplay = newTop + 5 > this.exts.length - 1 ? (this.exts.length >= 6 ? this.exts.length - 6 : 0) : (newTop <= 0 ? 0 : newTop - newTop % 6);
                for (int i = 1; i < 7; ++i) {
                    if (this.intFirstArrayItemToDisplay + i > this.exts.length) continue;
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i], 0, 2, 1, 0, this.exts[this.intFirstArrayItemToDisplay + (i - 1)].getParent().getDisplayName(null)));
                }
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow - this.intFirstArrayItemToDisplay, true));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button1Pressed(int presses) {
        if (!this.getNetwork().getHideMainMenu()) {
            this.getNetwork().displayMenuPage();
        }
    }

    @Override
    public void buttonDownPressed(int presses) {
        this.gotoNextRow(presses);
    }

    @Override
    public void buttonUpPressed(int presses) {
        this.gotoPreviousRow(presses);
    }

    @Override
    public void buttonEnterPressed(int presses) {
        int[] range;
        BComplex selected = this.exts[this.currentActiveRow - 1].getParent();
        if (selected instanceof BEnumSchedule && (range = ((BEnumRange)((BEnumSchedule)selected).getFacets().get("range")).getOrdinals()).length == 0) {
            this.getNetwork().openDialog(0, BSerialLcdNetwork.lex.getText("noRangeDefined"));
            return;
        }
        this.getNetwork().displaySchedDetailsPage(selected);
    }

    @Override
    public boolean pageChecksForRapidPresses() {
        return true;
    }

    private void gotoPreviousRow(int presses) {
        if (this.currentActiveRow > 1) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                if (this.currentActiveRow - (presses - 1) > this.intFirstArrayItemToDisplay + 1) {
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow - this.intFirstArrayItemToDisplay, false));
                    this.currentActiveRow -= presses;
                    if (this.currentActiveRow < 1) {
                        this.currentActiveRow = 1;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow - this.intFirstArrayItemToDisplay, true));
                } else {
                    this.currentActiveRow -= presses;
                    if (this.currentActiveRow < 1) {
                        this.currentActiveRow = 1;
                    }
                    this.displayPage(this.currentActiveRow - 1);
                }
            }
            catch (Exception e) {
                System.err.println("Error navigating rows (" + this.currentActiveRow + " : " + this.intFirstArrayItemToDisplay + " : " + presses + ") - " + e.toString());
                e.printStackTrace();
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
    }

    private void gotoNextRow(int presses) {
        if (this.currentActiveRow < this.exts.length) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                if (this.currentActiveRow + (presses - 1) < this.intFirstArrayItemToDisplay + 6) {
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow - this.intFirstArrayItemToDisplay, false));
                    this.currentActiveRow += presses;
                    if (this.currentActiveRow > this.exts.length) {
                        this.currentActiveRow = this.exts.length;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow - this.intFirstArrayItemToDisplay, true));
                } else {
                    this.currentActiveRow += presses;
                    if (this.currentActiveRow > this.exts.length) {
                        this.currentActiveRow = this.exts.length;
                    }
                    this.displayPage(this.currentActiveRow - 1);
                }
            }
            catch (Exception e) {
                System.err.println("Error navigating rows (" + this.currentActiveRow + " : " + this.intFirstArrayItemToDisplay + " : " + presses + ") - " + e.toString());
                e.printStackTrace();
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
    }

    private SerialLcdCommand[] getUnderline(int row, boolean on) throws SerialLcdCommandException {
        return new SerialLcdCommand[]{new SerialLcdLineCommand(0, row * 8 + 7, 80, row * 8 + 7, on)};
    }

    private SerialLcdCommand[] getSoftButtons() throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 57, 26, 57, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 58, 26, 58, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 59, 26, 59, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 60, 26, 60, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 61, 26, 61, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 62, 26, 62, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 63, 26, 63, !this.getNetwork().getHideMainMenu())});
        if (!this.getNetwork().getHideMainMenu()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, "menu"));
        }
        return tmpCommands;
    }

    private SerialLcdCommand[] getTopArrows() throws SerialLcdCommandException {
        if (this.intFirstArrayItemToDisplay > 0) {
            if (this.pageName.length() < 11) {
                return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 16, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 29, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 94, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 107, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 37, 4, true), new SerialLcdLineCommand(91, 4, 127, 4, true)};
            }
            if (this.pageName.length() < 16) {
                return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 16, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 107, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 24, 4, true), new SerialLcdLineCommand(104, 4, 127, 4, true)};
            }
            return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 11, 4, true), new SerialLcdLineCommand(117, 4, 127, 4, true)};
        }
        if (this.pageName.length() < 11) {
            return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 37), new SerialLcdClearCommand(ROW[0], 91, 127)};
        }
        if (this.pageName.length() < 16) {
            return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 24), new SerialLcdClearCommand(ROW[0], 104, 127)};
        }
        return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 11), new SerialLcdClearCommand(ROW[0], 117, 127)};
    }

    private SerialLcdCommand[] getBottomArrows() throws SerialLcdCommandException {
        if (this.intFirstArrayItemToDisplay < this.exts.length - 6) {
            return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[7], 29, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 42, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 55, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 68, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 81, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 94, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 107, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 120, "2060E06020"), new SerialLcdLineCommand(28, 58, 127, 58, true)};
        }
        return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[7], 28, 127)};
    }

    public void updateValues() {
        if (this.intFirstArrayItemToDisplay > -1) {
            try {
                SerialLcdCommand[] commands = new SerialLcdCommand[]{};
                this.getNetwork().sendCommands(commands);
            }
            catch (Exception e) {
                System.err.println("Error Displaying Page - " + e.toString());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void popupClosed(int popupReturn) {
        this.displayPageForFirstTime();
    }
}

