/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.tridium.util.ArrayUtil;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;

public class SerialLcdScheduleGrid {
    public String type = "";
    private BDaySchedule schedule;
    private int eventNumber;
    private BTime startTime;
    private boolean boolHasEvent;
    private BTimeSchedule[] eventSchedule;
    private static final String AM = BSerialLcdNetwork.lex.getText("am");

    public SerialLcdScheduleGrid(BDaySchedule schedule, BTime startTime) {
        this.schedule = schedule;
        this.startTime = startTime;
        this.setType();
        this.getEvents();
    }

    public BTimeSchedule[] getEvents() {
        this.eventSchedule = new BTimeSchedule[0];
        BTimeSchedule[] times = this.schedule.getTimesInOrder();
        for (int i = 0; i < times.length && !times[i].getStart().isAfter(this.getHourEnd()); ++i) {
            if (!this.eventInGrid(this.getHourStart(), this.getHourEnd(), times[i])) continue;
            this.boolHasEvent = true;
            this.eventSchedule = (BTimeSchedule[])ArrayUtil.addOne((Object[])this.eventSchedule, (Object)times[i]);
            this.eventNumber = i;
        }
        return this.eventSchedule;
    }

    public boolean eventInGrid(BTime startTime, BTime endTime, BTimeSchedule sched) {
        BTime schedStart = sched.getStart();
        BTime schedEnd = sched.getFinish();
        BTime midnightFix = BTime.make((int)23, (int)59, (int)59, (int)999);
        if (endTime.equals((Object)BTime.MIDNIGHT)) {
            endTime = midnightFix;
        }
        if (schedEnd.equals((Object)BTime.MIDNIGHT)) {
            schedEnd = midnightFix;
        }
        boolean eventIsDupe = false;
        boolean eventInMiddle = false;
        boolean eventOverlaps = false;
        if (!schedStart.isBefore(schedEnd)) {
            return false;
        }
        if ((startTime.isAfter(schedStart) || startTime.equals((Object)schedStart)) && startTime.isBefore(schedEnd) || (endTime.isBefore(schedEnd) || endTime.equals((Object)schedEnd)) && endTime.isAfter(schedStart)) {
            eventInMiddle = true;
        } else if (startTime.isBefore(schedStart) && endTime.isAfter(schedEnd)) {
            eventOverlaps = true;
        } else if (startTime.equals((Object)schedStart) && endTime.equals((Object)schedEnd)) {
            eventIsDupe = true;
        }
        return eventIsDupe || eventInMiddle || eventOverlaps;
    }

    public void removeEvent(String event) {
        this.schedule.remove(event);
    }

    public BTimeSchedule[] getEventsForDay() {
        Object[] dayEvents = new BTimeSchedule[]{};
        BTimeSchedule[] times = this.schedule.getTimesInOrder();
        for (int i = 0; i < times.length; ++i) {
            if (!(times[i].getStart().isBefore(this.getHourStart()) && times[i].getFinish().isAfter(this.getHourStart()) || times[i].getStart().equals((Object)this.getHourStart()) && times[i].getFinish().isAfter(this.getHourStart()) || times[i].getStart().isAfter(this.getHourStart()) && times[i].getStart().isBefore(this.getHourEnd())) && (!times[i].getStart().equals((Object)BTime.MIDNIGHT) || !times[i].getFinish().equals((Object)BTime.MIDNIGHT))) continue;
            dayEvents = (BTimeSchedule[])ArrayUtil.addOne((Object[])dayEvents, (Object)times[i]);
        }
        return dayEvents;
    }

    public SerialLcdCommand[] getCommands(int day, int posY) {
        SerialLcdCommand[] commands = new SerialLcdCommand[]{};
        BTimeSchedule[] times = this.schedule.getTimesInOrder();
        for (int i = 0; i < times.length && !times[i].getStart().isAfter(this.getEndTime()); ++i) {
            if (!times[i].getFinish().isBefore(this.startTime) && !(times[i].getFinish().isAfter(this.startTime) && (times[i].getStart().isBefore(this.startTime) || times[i].getStart().equals((Object)this.startTime)) ? times[i].getFinish().isBefore(this.getEndTime()) : !times[i].getStart().isAfter(this.startTime) || !times[i].getStart().isBefore(this.getEndTime()) || times[i].getFinish().isBefore(this.getEndTime()))) continue;
        }
        return commands;
    }

    public BDaySchedule getSchedule() {
        return this.schedule;
    }

    public BTime getStartTime() {
        if (!this.boolHasEvent) {
            return this.startTime;
        }
        BTimeSchedule[] times = this.schedule.getTimesInOrder();
        return times[this.eventNumber].getStart();
    }

    public BTime getEndTime() {
        if (!this.boolHasEvent) {
            return this.getHourEnd();
        }
        BTimeSchedule[] times = this.schedule.getTimesInOrder();
        return times[this.eventNumber].getFinish();
    }

    public String getStartDisplayTime() {
        if (!this.boolHasEvent) {
            return this.startTime.toString();
        }
        BTimeSchedule[] times = this.schedule.getTimesInOrder();
        if (times[this.eventNumber].getStart().getHour() != 0) {
            return times[this.eventNumber].getStart().toString();
        }
        return "12:" + times[this.eventNumber].getStart().getMinute() + AM;
    }

    public String getEndDisplayTime() {
        if (!this.boolHasEvent) {
            return this.startTime.add(BRelTime.makeSeconds((int)3599)).toString();
        }
        BTimeSchedule[] times = this.schedule.getTimesInOrder();
        if (times[this.eventNumber].getFinish().getHour() != 0) {
            return times[this.eventNumber].getFinish().toString();
        }
        return "12:" + times[this.eventNumber].getFinish().getMinute() + AM;
    }

    public BTime getHourStart() {
        return this.startTime;
    }

    private BTime getHourEnd() {
        return this.startTime.add(BRelTime.makeHours((int)1));
    }

    public boolean getCellContainsStart(BDaySchedule schedule) {
        boolean boolCellContainsStart = false;
        BTimeSchedule[] times = schedule.getTimesInOrder();
        for (int i = 0; i < times.length && !times[i].getStart().isAfter(this.getEndTime()); ++i) {
            if (times[i].getFinish().isBefore(this.startTime) || !times[i].getStart().isAfter(this.startTime) && !times[i].getStart().equals((Object)this.startTime) || !times[i].getStart().isBefore(this.getEndTime())) continue;
            boolCellContainsStart = true;
        }
        return boolCellContainsStart;
    }

    public boolean getCellContainsEnd(BDaySchedule schedule) {
        boolean boolCellContainsEnd = false;
        BTimeSchedule[] times = schedule.getTimesInOrder();
        for (int i = 0; i < times.length && !times[i].getStart().isAfter(this.getEndTime()); ++i) {
            if (times[i].getFinish().isBefore(this.startTime) || !times[i].getFinish().isAfter(this.startTime) || !times[i].getStart().isBefore(this.startTime) && !times[i].getStart().equals((Object)this.startTime)) continue;
            boolCellContainsEnd = true;
        }
        return boolCellContainsEnd;
    }

    public boolean getCellIsBlank(BDaySchedule schedule) {
        return !this.boolHasEvent;
    }

    public boolean getCellIsFilled(BDaySchedule schedule) {
        return this.boolHasEvent;
    }

    public int getStartMinutes(BDaySchedule schedule, int intTimeArraySlot) {
        int intScheduleMinutes = 0;
        BTimeSchedule[] times = schedule.getTimesInOrder();
        if (this.getCellContainsStart(schedule)) {
            intScheduleMinutes = times[intTimeArraySlot].getStart().getMinute();
        }
        return intScheduleMinutes;
    }

    public int getEndMinutes(BDaySchedule schedule, int intTimeArraySlot) {
        int intScheduleMinutes = 0;
        BTimeSchedule[] times = schedule.getTimesInOrder();
        if (this.getCellContainsStart(schedule)) {
            intScheduleMinutes = times[intTimeArraySlot].getFinish().getMinute();
        }
        return intScheduleMinutes;
    }

    public int getStartHours(BDaySchedule schedule, int intTimeArraySlot) {
        int intScheduleHours = 0;
        BTimeSchedule[] times = schedule.getTimesInOrder();
        if (this.getCellContainsStart(schedule)) {
            intScheduleHours = times[intTimeArraySlot].getStart().getHour();
        }
        return intScheduleHours;
    }

    public int getEndHours(BDaySchedule schedule, int intTimeArraySlot) {
        int intScheduleHours = 0;
        BTimeSchedule[] times = schedule.getTimesInOrder();
        if (this.getCellContainsStart(schedule)) {
            intScheduleHours = times[intTimeArraySlot].getFinish().getHour();
        }
        return intScheduleHours;
    }

    public void setType() {
        if (this.schedule.getParent().getParent().getParent().getParent() instanceof BBooleanSchedule) {
            this.type = "Boolean";
        } else if (this.schedule.getParent().getParent().getParent().getParent() instanceof BEnumSchedule) {
            this.type = "Enum";
        } else if (this.schedule.getParent().getParent().getParent().getParent() instanceof BNumericSchedule) {
            this.type = "Numeric";
        } else if (this.schedule.getParent().getParent().getParent().getParent() instanceof BStringSchedule) {
            this.type = "String";
        } else {
            System.out.println("Schedule Type not found");
            this.type = "";
        }
    }

    public String[] getFacetsArray() {
        String[] FACETVALUES;
        if (this.type.equals("Boolean")) {
            FACETVALUES = new String[]{this.getFacets().get("falseText").toString(), this.getFacets().get("trueText").toString()};
        } else if (this.type.equals("Enum")) {
            BEnumRange range = (BEnumRange)this.getFacets().get("range");
            int[] valueOrdinals = range.getOrdinals();
            FACETVALUES = new String[valueOrdinals.length];
            for (int i = 0; i < valueOrdinals.length; ++i) {
                FACETVALUES[i] = range.get(valueOrdinals[i]).toString();
            }
        } else {
            FACETVALUES = new String[]{};
        }
        return FACETVALUES;
    }

    public String getOut() {
        if (this.type.equals("Boolean")) {
            BBooleanSchedule sched = (BBooleanSchedule)this.schedule.getParent().getParent().getParent().getParent();
            String trueFalse = sched.getOut().getValueValue().toString();
            if (trueFalse.equals("true")) {
                return this.getFacetsArray()[1];
            }
            return this.getFacetsArray()[0];
        }
        if (this.type.equals("Enum")) {
            BEnumSchedule sched = (BEnumSchedule)this.schedule.getParent().getParent().getParent().getParent();
            try {
                return this.getFacetsArray()[new Integer(sched.getOut().getValueValue().toString())];
            }
            catch (Exception e) {
                return sched.getOut().getValueValue().toString();
            }
        }
        if (this.type.equals("Numeric")) {
            BNumericSchedule sched = (BNumericSchedule)this.schedule.getParent().getParent().getParent().getParent();
            return sched.getOut().isNull() ? "0.0" : sched.getOut().getValueValue().toString();
        }
        if (this.type.equals("String")) {
            BStringSchedule sched = (BStringSchedule)this.schedule.getParent().getParent().getParent().getParent();
            return sched.getOut().getValueValue().toString();
        }
        System.out.println("Schedule Type not found");
        return null;
    }

    public BFacets getFacets() {
        if (this.type.equals("Boolean")) {
            BBooleanSchedule sched = (BBooleanSchedule)this.schedule.getParent().getParent().getParent().getParent();
            return sched.getFacets();
        }
        if (this.type.equals("Enum")) {
            BEnumSchedule sched = (BEnumSchedule)this.schedule.getParent().getParent().getParent().getParent();
            return sched.getFacets();
        }
        if (this.type.equals("Numeric")) {
            BNumericSchedule sched = (BNumericSchedule)this.schedule.getParent().getParent().getParent().getParent();
            return sched.getFacets();
        }
        if (this.type.equals("String")) {
            BStringSchedule sched = (BStringSchedule)this.schedule.getParent().getParent().getParent().getParent();
            return sched.getFacets();
        }
        System.out.println("Schedule Type not found");
        return null;
    }

    public boolean isNewEventValid(BTime startTime, BTime endTime, int eventNum) {
        boolean isValid = true;
        BTimeSchedule[] scheds = this.schedule.getTimesInOrder();
        for (int i = 0; isValid && i < scheds.length; ++i) {
            if (eventNum > -1 && this.eventSchedule[eventNum].equals((Object)scheds[i])) continue;
            isValid = !this.eventInGrid(startTime, endTime, scheds[i]);
        }
        return isValid;
    }

    public int eventsInHour(int StartHour, boolean PM) {
        if (PM) {
            StartHour += 12;
        }
        BTime startTime = BTime.make((int)StartHour, (int)0, (int)0);
        BTime endTime = BTime.make((int)StartHour, (int)59, (int)59);
        int events = 0;
        for (int i = 0; i < this.eventSchedule.length; ++i) {
            if (this.eventSchedule[i].getStart() != startTime && (!this.eventSchedule[i].getStart().isAfter(startTime) || this.eventSchedule[i].getFinish() != endTime && !this.eventSchedule[i].getFinish().isBefore(endTime))) continue;
            ++events;
        }
        return events;
    }
}

