/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.point.BSerialLcdPointExtension;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.lynxspring.lcd.ui.SerialLcdScheduleGrid;
import com.tridium.util.ArrayUtil;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BTime;

public class SerialLcdScheduleEventPage
extends SerialLcdPage {
    private static final int START_ROW = 1;
    private static final int END_ROW = 2;
    private static final int VALUE_ROW = 3;
    private int underlinePosition = 1;
    private boolean changingValue = false;
    private int editColumn = 0;
    private int valueIndex;
    private int eventNumber;
    private String[] VALUES;
    private String[] facetArray;
    private int valueWidth;
    private int[] valueOrdinals;
    private boolean valueSelected = false;
    private String value;
    private String[] charArray = new String[0];
    private SerialLcdScheduleGrid scheduleArray;
    private BTimeSchedule[] eventSchedule;
    private BTimeSchedule workingEvent;
    private int startHour;
    private int startMins;
    private String startAmPm;
    private int endMins;
    private int endHour;
    private String endAmPm;
    private String daySelected;
    private String pageName;
    private static final String AM = BSerialLcdNetwork.lex.getText("am");
    private static final String PM = BSerialLcdNetwork.lex.getText("pm");

    public SerialLcdScheduleEventPage(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void displayPage() {
    }

    public void displayPage(SerialLcdScheduleGrid scheduleArray, int eventNumber) {
        this.scheduleArray = scheduleArray;
        this.eventNumber = eventNumber;
        this._displayPage();
    }

    public void _displayPage() {
        this.eventSchedule = this.scheduleArray.getEvents();
        this.daySelected = this.scheduleArray.getSchedule().getParent().getName();
        this.pageName = this.daySelected + " " + BSerialLcdNetwork.lex.getText("event");
        this.facetArray = this.scheduleArray.getFacetsArray();
        this.changingValue = false;
        this.underlinePosition = 1;
        this.workingEvent = this.eventNumber != -1 ? this.eventSchedule[this.eventNumber] : new BTimeSchedule(this.scheduleArray.getStartTime(), this.scheduleArray.getEndTime());
        try {
            this.valueWidth = BSerialLcdPointExtension.getPixelWidth(this.getValue());
            Object[] commands = new SerialLcdCommand[]{};
            this.clearPage();
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[0], 0, 2, 1, 1, this.pageName));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("startTime")));
            this.startHour = this.workingEvent.getStart().getHour();
            this.startMins = this.workingEvent.getStart().getMinute();
            this.startAmPm = this.startHour < 12 ? AM : PM;
            this.startHour %= 12;
            if (this.startHour == 0) {
                this.startHour = 12;
            }
            this.displayTime(1, "" + this.startHour + ":" + (this.startMins < 10 ? "0" : "") + this.startMins + " " + this.startAmPm);
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("endTime")));
            this.endHour = this.workingEvent.getFinish().getHour();
            this.endMins = this.workingEvent.getFinish().getMinute();
            this.endAmPm = this.endHour < 12 ? AM : PM;
            this.endHour %= 12;
            if (this.endHour == 0) {
                this.endHour = 12;
            }
            this.displayTime(2, "" + this.endHour + ":" + (this.endMins < 10 ? "0" : "") + this.endMins + " " + this.endAmPm);
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("value")));
            this.buildValueArray();
            if (this.eventSchedule.length > 0) {
                if (this.scheduleArray.type.equals("Boolean")) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value.equals("true") ? this.VALUES[1] : this.VALUES[0]));
                } else if (this.scheduleArray.type.equals("Enum")) {
                    try {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.VALUES[new Integer(this.value)]));
                    }
                    catch (Exception e) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.VALUES[this.valueIndex]));
                    }
                } else if (this.scheduleArray.type.equals("Numeric")) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value + (this.VALUES[0].equals("null") ? "" : this.VALUES[0])));
                } else if (this.scheduleArray.type.equals("String")) {
                    if (this.value.equals("")) {
                        this.value = " ";
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value));
                }
            } else if (this.scheduleArray.type.equals("String")) {
                if (this.value.equals("")) {
                    this.value = " ";
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value));
            } else {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.scheduleArray.getOut()));
            }
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 64, this.underlinePosition * 8 + 7, true));
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.out.println("Error Displaying Schedule Event Page - " + e.toString());
            e.printStackTrace();
        }
    }

    public void displayTime(int row, String time) throws Exception {
        Object[] commands = new SerialLcdCommand[]{};
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[row], 50, 127));
        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[row], 0, 2, 1, 2, time));
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    @Override
    public void button1Pressed(int presses) {
        this.getNetwork().displaySchedDetailsPage((BComplex)this.scheduleArray.getSchedule());
    }

    @Override
    public void button2Pressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.changingValue) {
                if (this.underlinePosition == 1) {
                    if (this.editColumn == 1) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 102, 2, 1, 3, this.startMins < 10 ? "0" + this.startMins : "" + this.startMins));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 89 + ((this.startHour < 10 || this.startHour > 12 && this.startHour < 22) && this.startHour != 0 ? 5 : 0), 2, 2, 3, this.startHour % 12 == 0 ? "12" : "" + this.startHour % 12));
                        --this.editColumn;
                    } else if (this.editColumn == 2) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 102, 2, 2, 3, this.startMins < 10 ? "0" + this.startMins : "" + this.startMins));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 117, 2, 1, 3, this.startAmPm));
                        --this.editColumn;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                } else if (this.underlinePosition == 2) {
                    if (this.editColumn == 1) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 102, 2, 1, 3, this.endMins < 10 ? "0" + this.endMins : "" + this.endMins));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 89 + ((this.endHour < 10 || this.endHour > 12 && this.endHour < 22) && this.endHour != 0 ? 5 : 0), 2, 2, 3, this.endHour % 12 == 0 ? "12" : "" + this.endHour % 12));
                        --this.editColumn;
                    } else if (this.editColumn == 2) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 102, 2, 2, 3, this.endMins < 10 ? "0" + this.endMins : "" + this.endMins));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 117, 2, 1, 3, this.endAmPm));
                        --this.editColumn;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                } else if (this.underlinePosition == 3 && (this.scheduleArray.type.equals("Numeric") || this.scheduleArray.type.equals("String")) && this.charArray.length < 26) {
                    if (this.editColumn + 2 > this.charArray.length) {
                        this.charArray = this.scheduleArray.type.equals("Numeric") ? (String[])ArrayUtil.addOne((Object[])this.charArray, (Object)"0") : (String[])ArrayUtil.addOne((Object[])this.charArray, (Object)"a");
                        this.value = "";
                        for (int i = 0; i < this.charArray.length; ++i) {
                            this.value = this.value + this.charArray[this.charArray.length - 1 - i];
                        }
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value));
                    }
                    ++this.editColumn;
                    if (this.charArray[this.editColumn].equals(".")) {
                        ++this.editColumn;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.updateCharUnderline());
                }
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            } else {
                int saveStartHour = this.startHour % 12;
                if (this.startAmPm.equals(PM)) {
                    saveStartHour += 12;
                }
                int saveEndHour = this.endHour % 12;
                if (this.endAmPm.equals(PM)) {
                    saveEndHour += 12;
                }
                BTime startTime = BTime.make((int)saveStartHour, (int)this.startMins, (int)0);
                BTime endTime = BTime.make((int)saveEndHour, (int)this.endMins, (int)0);
                if (!endTime.equals((Object)BTime.MIDNIGHT) && (startTime.isAfter(endTime) || startTime.equals((Object)endTime))) {
                    this.getNetwork().openDialog(0, BSerialLcdNetwork.lex.getText("formatError"));
                } else if (!this.scheduleArray.isNewEventValid(startTime, endTime, this.eventNumber)) {
                    this.getNetwork().openDialog(0, BSerialLcdNetwork.lex.getText("eventConflict"));
                } else if (this.eventNumber > -1) {
                    BTimeSchedule event = this.eventSchedule[this.eventNumber];
                    event.setStart(startTime);
                    event.setFinish(endTime);
                    if (this.scheduleArray.type.equals("Boolean")) {
                        event.setEffectiveValue((BStatusValue)new BStatusBoolean(this.valueIndex == 1));
                    } else if (this.scheduleArray.type.equals("Enum")) {
                        event.setEffectiveValue((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)this.valueIndex)));
                    } else if (this.scheduleArray.type.equals("Numeric")) {
                        try {
                            event.setEffectiveValue((BStatusValue)new BStatusNumeric(new Double(this.value).doubleValue()));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Could not save value.  Not a valid number: " + this.value);
                            e.printStackTrace();
                        }
                    } else if (this.scheduleArray.type.equals("String")) {
                        event.setEffectiveValue((BStatusValue)new BStatusString(this.value.trim()));
                    } else {
                        System.out.println("Error: Could not save, schedule type not found");
                    }
                    BAbstractSchedule parent = (BAbstractSchedule)event.getParent();
                    while (!parent.getType().is(BControlSchedule.TYPE) && parent.getParent().getType().is(BAbstractSchedule.TYPE)) {
                        parent = (BAbstractSchedule)parent.getParent();
                    }
                    if (parent.getType().is(BControlSchedule.TYPE)) {
                        ((BControlSchedule)parent).doExecute();
                    }
                    this.getNetwork().displaySchedDetailsPage(this.scheduleArray.getSchedule().getParent());
                } else {
                    BTimeSchedule newEvent;
                    if (this.scheduleArray.type.equals("Boolean")) {
                        BStatusBoolean boolVal = new BStatusBoolean();
                        boolVal.setValue(this.valueIndex == 1);
                        newEvent = new BTimeSchedule(startTime, endTime, (BStatusValue)boolVal);
                    } else if (this.scheduleArray.type.equals("Enum")) {
                        BStatusEnum enumVal = new BStatusEnum();
                        enumVal.setValue(BDynamicEnum.make((int)this.valueIndex));
                        newEvent = new BTimeSchedule(startTime, endTime, (BStatusValue)enumVal);
                    } else if (this.scheduleArray.type.equals("Numeric")) {
                        BStatusNumeric numVal = new BStatusNumeric();
                        numVal.setValue(new Double(this.value).doubleValue());
                        newEvent = new BTimeSchedule(startTime, endTime, (BStatusValue)numVal);
                    } else {
                        BStatusString stringVal = new BStatusString();
                        stringVal.setValue(this.value.trim());
                        newEvent = new BTimeSchedule(startTime, endTime, (BStatusValue)stringVal);
                    }
                    this.scheduleArray.getSchedule().add(newEvent);
                    this.getNetwork().displaySchedDetailsPage(this.scheduleArray.getSchedule().getParent());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void button3Pressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.changingValue) {
                if (this.underlinePosition == 1) {
                    if (this.editColumn == 0) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 89 + ((this.startHour < 10 || this.startHour > 12 && this.startHour < 22) && this.startHour != 0 ? 5 : 0), 2, 1, 3, (this.startHour % 12 == 0 ? "12" : "" + this.startHour % 12) + ":"));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 102, 2, 2, 3, this.startMins < 10 ? "0" + this.startMins : "" + this.startMins));
                        ++this.editColumn;
                    } else if (this.editColumn == 1) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 102, 2, 1, 3, this.startMins < 10 ? "0" + this.startMins : "" + this.startMins));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 117, 2, 2, 3, this.startAmPm));
                        ++this.editColumn;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                } else if (this.underlinePosition == 2) {
                    if (this.editColumn == 0) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 89 + ((this.endHour < 10 || this.endHour > 12 && this.endHour < 22) && this.endHour != 0 ? 5 : 0), 2, 1, 3, (this.endHour % 12 == 0 ? "12" : "" + this.endHour % 12) + ":"));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 102, 2, 2, 3, this.endMins < 10 ? "0" + this.endMins : "" + this.endMins));
                        ++this.editColumn;
                    } else if (this.editColumn == 1) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 102, 2, 1, 3, this.endMins < 10 ? "0" + this.endMins : "" + this.endMins));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 117, 2, 2, 3, this.endAmPm));
                        ++this.editColumn;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                } else if (this.underlinePosition == 3 && (this.scheduleArray.type.equals("Numeric") || this.scheduleArray.type.equals("String")) && this.editColumn > 0) {
                    --this.editColumn;
                    if (this.charArray[this.editColumn].equals(".") && this.editColumn > 0) {
                        --this.editColumn;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.updateCharUnderline());
                }
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void button4Pressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        if (this.changingValue) {
            this.changingValue = false;
            this.editColumn = 0;
            try {
                if (this.underlinePosition == 1) {
                    this.startHour = this.scheduleArray.getStartTime().getHour();
                    this.startMins = this.scheduleArray.getStartTime().getMinute();
                    this.startAmPm = this.startHour >= 12 ? PM : AM;
                    this.displayTime(1, "" + (this.startHour > 12 ? this.startHour - 12 : this.startHour) + ":" + (this.startMins < 10 ? "0" : "") + this.startMins + " " + this.startAmPm);
                } else if (this.underlinePosition == 2) {
                    this.endHour = this.scheduleArray.getEndTime().getHour();
                    this.endMins = this.scheduleArray.getEndTime().getMinute();
                    this.endAmPm = this.endHour >= 12 ? PM : AM;
                    this.displayTime(2, "" + (this.endHour > 12 ? this.endHour - 12 : this.endHour) + ":" + (this.endMins < 10 ? "0" : "") + this.endMins + " " + this.endAmPm);
                } else {
                    this.getValue();
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 64, 127));
                    if (this.scheduleArray.type.equals("Boolean")) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value.equals("true") ? this.VALUES[1] : this.VALUES[0]));
                    } else if (this.scheduleArray.type.equals("Enum")) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.VALUES[new Integer(this.valueIndex)]));
                    } else if (this.scheduleArray.type.equals("Numeric")) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value + (this.VALUES[0].toString().toLowerCase().equals("null") ? "" : " " + this.VALUES[0])));
                    } else if (this.scheduleArray.type.equals("String")) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value));
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(64, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, false));
                }
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.getNetwork().displaySchedDetailsPage((BComplex)this.scheduleArray.getSchedule());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void buttonDownPressed(int presses) {
        block46: {
            commands = new SerialLcdCommand[]{};
            try {
                block47: {
                    if (!this.changingValue) break block47;
                    block3 : switch (this.underlinePosition) {
                        case 1: {
                            switch (this.editColumn) {
                                case 0: {
                                    if (this.startHour > 12) {
                                        this.startHour %= 12;
                                    }
                                    this.startHour = this.startHour > 1 ? --this.startHour : 12;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(SerialLcdScheduleEventPage.ROW[1], 87, 94));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[1], 89 + (this.startHour < 10 && this.startHour != 0 ? 5 : 0), 2, 2, 3, "" + this.startHour));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                    break block3;
                                }
                                case 1: {
                                    this.startMins = this.startMins > 0 ? --this.startMins : 59;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[1], 102, 2, 2, 3, "" + (this.startMins < 10 ? "0" + this.startMins : "" + this.startMins)));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                    break block3;
                                }
                                case 2: {
                                    if (this.startAmPm.equals(SerialLcdScheduleEventPage.AM)) {
                                        this.startAmPm = SerialLcdScheduleEventPage.PM;
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[1], 117, 2, 2, 3, this.startAmPm));
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                        break block3;
                                    }
                                    this.startAmPm = SerialLcdScheduleEventPage.AM;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[1], 117, 2, 2, 3, this.startAmPm));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (this.editColumn) {
                                case 0: {
                                    if (this.endHour > 12) {
                                        this.endHour %= 12;
                                    }
                                    this.endHour = this.endHour > 1 ? --this.endHour : 12;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(SerialLcdScheduleEventPage.ROW[2], 87, 94));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[2], 89 + (this.endHour < 10 && this.endHour != 0 ? 5 : 0), 2, 2, 3, "" + this.endHour));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                    break block3;
                                }
                                case 1: {
                                    this.endMins = this.endMins > 0 ? --this.endMins : 59;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[2], 102, 2, 2, 3, "" + (this.endMins < 10 ? "0" + this.endMins : "" + this.endMins)));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                    break block3;
                                }
                                case 2: {
                                    if (this.endAmPm.equals(SerialLcdScheduleEventPage.AM)) {
                                        this.endAmPm = SerialLcdScheduleEventPage.PM;
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[2], 117, 2, 2, 3, this.endAmPm));
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                        break block3;
                                    }
                                    this.endAmPm = SerialLcdScheduleEventPage.AM;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[2], 117, 2, 2, 3, this.endAmPm));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                }
                            }
                            break;
                        }
                        case 3: {
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                            if (this.scheduleArray.type.equals("Boolean")) {
                                if (this.valueIndex == -1) {
                                    if (this.scheduleArray.getOut().equals("false") || this.scheduleArray.getOut().equals(this.scheduleArray.getFacetsArray()[0])) {
                                        this.valueIndex = 1;
                                        this.updateCurrentValue(this.facetArray[this.valueIndex]);
                                        break;
                                    }
                                    this.valueIndex = 0;
                                    this.updateCurrentValue(this.facetArray[this.valueIndex]);
                                    break;
                                }
                                if (this.valueIndex + 1 <= this.facetArray.length && this.valueIndex >= 0 && this.valueIndex < 1) {
                                    ++this.valueIndex;
                                }
                                this.updateCurrentValue(this.facetArray[this.valueIndex]);
                                break;
                            }
                            if (this.scheduleArray.type.equals("Enum")) {
                                if (this.eventNumber == -1) {
                                    if (this.valueIndex == -1) {
                                        try {
                                            this.valueIndex = new Integer(this.scheduleArray.getOut());
                                        }
                                        catch (NumberFormatException numE) {
                                            for (i = 0; i < this.facetArray.length; ++i) {
                                                if (!this.value.equals(this.facetArray[i])) continue;
                                                this.valueIndex = i;
                                            }
                                        }
                                    }
                                    if (this.valueIndex >= this.facetArray.length - 1) break;
                                    ++this.valueIndex;
                                    this.updateCurrentValue(this.facetArray[this.valueIndex]);
                                    break;
                                }
                                if (this.valueIndex + 1 <= this.facetArray.length - 1 && this.valueIndex >= 0) {
                                    ++this.valueIndex;
                                }
                                this.updateCurrentValue(this.facetArray[this.valueIndex]);
                                break;
                            }
                            if (!this.scheduleArray.type.equals("Numeric")) ** GOTO lbl113
                            newChar = "9";
                            if (this.charArray[this.editColumn] == ".") ** GOTO lbl103
                            try {
                                newChar = "" + (new Integer(this.charArray[this.editColumn]) - 1);
                                if (!newChar.equals("-1")) ** GOTO lbl104
                                if (this.editColumn == this.charArray.length - 1) ** GOTO lbl98
                                newChar = "9";
                                ** GOTO lbl104
lbl98:
                                // 1 sources

                                newChar = "-";
                            }
                            catch (NumberFormatException nfe) {
                                newChar = "9";
                            }
                            ** GOTO lbl104
lbl103:
                            // 1 sources

                            System.out.println("Cannot Edit.");
lbl104:
                            // 5 sources

                            this.charArray[this.editColumn] = newChar;
                            this.value = "";
                            for (i = 0; i < this.charArray.length; ++i) {
                                this.value = this.value + this.charArray[this.charArray.length - 1 - i];
                            }
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(SerialLcdScheduleEventPage.ROW[3], 55, 127));
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[3], 0, 2, 1, 2, this.value));
                            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.updateCharUnderline());
                            break;
lbl113:
                            // 1 sources

                            if (!this.scheduleArray.type.equals("String")) break;
                            newChar = "";
                            charValue = this.charArray[this.editColumn].charAt(0);
                            switch (charValue) {
                                case ' ': {
                                    newChar = "a";
                                    break;
                                }
                                case 'z': {
                                    newChar = "0";
                                    break;
                                }
                                case '9': {
                                    newChar = "!";
                                    break;
                                }
                                case '/': {
                                    newChar = ":";
                                    break;
                                }
                                case '@': {
                                    newChar = "[";
                                    break;
                                }
                                case '`': {
                                    newChar = "{";
                                    break;
                                }
                                case '~': {
                                    newChar = " ";
                                    break;
                                }
                                default: {
                                    newChar = "" + (char)(charValue + '\u0001');
                                }
                            }
                            this.charArray[this.editColumn] = newChar;
                            this.value = "";
                            for (i = 0; i < this.charArray.length; ++i) {
                                this.value = this.value + this.charArray[this.charArray.length - 1 - i];
                            }
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(SerialLcdScheduleEventPage.ROW[3], 55, 127));
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[3], 0, 2, 1, 2, this.value));
                            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.updateCharUnderline());
                        }
                    }
                    break block46;
                }
                if (this.underlinePosition < 3) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 64, this.underlinePosition * 8 + 7, false));
                    ++this.underlinePosition;
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 64, this.underlinePosition * 8 + 7, true));
            }
            catch (Exception e) {
                System.out.println("Error with Down Button");
                e.printStackTrace();
            }
        }
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    @Override
    public void buttonEnterPressed(int presses) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            switch (this.underlinePosition) {
                case 1: {
                    if (!this.changingValue) {
                        this.editColumn = 0;
                        this.changingValue = true;
                        int intStartHour = this.scheduleArray.getStartTime().getHour();
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 89 + ((intStartHour < 10 || intStartHour > 12 && intStartHour < 22) && intStartHour != 0 ? 5 : 0), 2, 2, 3, intStartHour % 12 == 0 ? "12" : "" + intStartHour % 12));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                        commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtonsEdit(this.scheduleArray.type));
                        break;
                    }
                    this.changingValue = false;
                    this.workingEvent.setStart(BTime.make((int)(this.startHour + (this.startAmPm.equals(PM) && this.startHour < 12 ? 12 : 0)), (int)this.startMins, (int)0));
                    this.displayTime(1, "" + this.startHour + ":" + (this.startMins < 10 ? "0" : "") + this.startMins + " " + this.startAmPm);
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
                    break;
                }
                case 2: {
                    if (!this.changingValue) {
                        this.editColumn = 0;
                        this.changingValue = true;
                        int intEndHour = this.scheduleArray.getEndTime().getHour();
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 89 + ((intEndHour < 10 || intEndHour > 12 && intEndHour < 22) && intEndHour != 0 ? 5 : 0), 2, 2, 3, intEndHour % 12 == 0 ? "12" : "" + intEndHour % 12));
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                        commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtonsEdit(this.scheduleArray.type));
                        break;
                    }
                    this.changingValue = false;
                    this.workingEvent.setFinish(BTime.make((int)(this.endHour + (this.endAmPm.equals(PM) && this.endHour < 12 ? 12 : 0)), (int)this.endMins, (int)0));
                    this.displayTime(2, "" + this.endHour + ":" + (this.endMins < 10 ? "0" : "") + this.endMins + " " + this.endAmPm);
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
                    break;
                }
                case 3: {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[this.underlinePosition], 0, 127));
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 0, "Value: "));
                    if (this.scheduleArray.type.equals("Boolean") && !this.changingValue) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value.equals("true") ? this.VALUES[1] : this.VALUES[0]));
                    } else if (this.scheduleArray.type.equals("Enum") && !this.changingValue) {
                        if (this.valueIndex == -1) {
                            try {
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.VALUES[new Integer(this.value)]));
                            }
                            catch (NumberFormatException nfe) {
                                System.out.println("Could not find:" + this.value + " in VALUES array and Could not convert it to an Integer passing 0");
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.VALUES[new Integer(0)]));
                            }
                        } else {
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.VALUES[this.valueIndex]));
                        }
                    } else if (this.scheduleArray.type.equals("Numeric") && !this.changingValue) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value + (this.VALUES[0].equals("null") ? "" : this.VALUES[0])));
                    } else if (this.scheduleArray.type.equals("String") && !this.changingValue) {
                        if (this.value == null) {
                            this.value = " ";
                        }
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value));
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                    if (!this.changingValue) {
                        this.changingValue = true;
                        if (this.scheduleArray.type.equals("Boolean")) {
                            String[] FACETVALUES = new String[]{this.scheduleArray.getFacets().get("falseText").toString(), this.scheduleArray.getFacets().get("trueText").toString()};
                        } else if (this.scheduleArray.type.equals("Enum")) {
                            if (this.eventSchedule.length < 1) {
                                BEnumRange range = (BEnumRange)this.scheduleArray.getFacets().get("range");
                                this.valueOrdinals = range.getOrdinals();
                                String[] FACETVALUES = new String[this.valueOrdinals.length];
                                for (int i = 0; i < this.valueOrdinals.length; ++i) {
                                    FACETVALUES[i] = range.get(this.valueOrdinals[i]).toString();
                                    if (!FACETVALUES[i].toLowerCase().equals(this.value != null ? this.value.toLowerCase() : "") || this.valueIndex != -1) continue;
                                    this.valueIndex = i;
                                }
                            }
                        } else if (this.scheduleArray.type.equals("Numeric")) {
                            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtonsEdit(this.scheduleArray.type));
                        } else if (this.scheduleArray.type.equals("String")) {
                            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtonsEdit(this.scheduleArray.type));
                            this.editColumn = 0;
                        }
                        if (!this.scheduleArray.type.equals("Numeric") && !this.scheduleArray.type.equals("String")) break;
                        this.editColumn = this.value.length() - 1;
                        commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.updateCharUnderline());
                        break;
                    }
                    if (this.scheduleArray.type.equals("Boolean")) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.valueIndex == 1 ? this.scheduleArray.getFacetsArray()[1] : this.scheduleArray.getFacetsArray()[0]));
                    } else if (this.scheduleArray.type.equals("Enum")) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.VALUES[new Integer(this.valueIndex)]));
                    } else if (this.scheduleArray.type.equals("Numeric")) {
                        this.editColumn = this.charArray.length - 1;
                        double temp = Double.NaN;
                        try {
                            temp = new Double(this.value);
                        }
                        catch (NumberFormatException nfe) {
                            this.getNetwork().openDialog(0, BSerialLcdNetwork.lex.getText("numberFormatError"));
                        }
                        if (temp != Double.NaN) {
                            double min = this.VALUES[2].equals("-inf") ? -9.223372036854776E18 : new Double(this.VALUES[2]);
                            double max = this.VALUES[3].equals("+inf") ? 9.223372036854776E18 : new Double(this.VALUES[3]);
                            if (temp < min || temp > max) {
                                this.getNetwork().openDialog(0, BSerialLcdNetwork.lex.getText("rangeError", (Object[])new String[]{"" + min, "" + max}));
                            }
                        }
                        this.editColumn = this.value.length() - 1;
                        commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.updateCharUnderline());
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value + (this.VALUES[0].equals("null") ? "" : this.VALUES[0])));
                    } else if (this.scheduleArray.type.equals("String")) {
                        this.editColumn = this.charArray.length - 1;
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, this.value));
                    }
                    this.changingValue = false;
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(65, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, false));
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error while pressing Enter button");
            e.printStackTrace();
        }
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void buttonUpPressed(int presses) {
        block48: {
            commands = new SerialLcdCommand[]{};
            try {
                block49: {
                    if (!this.changingValue) break block49;
                    try {
                        block4 : switch (this.underlinePosition) {
                            case 1: {
                                switch (this.editColumn) {
                                    case 0: {
                                        ++this.startHour;
                                        if (this.startHour > 12) {
                                            this.startHour %= 12;
                                        }
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(SerialLcdScheduleEventPage.ROW[1], 87, 94));
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[1], 89 + (this.startHour < 10 && this.startHour != 0 ? 5 : 0), 2, 2, 3, "" + this.startHour));
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                        break block4;
                                    }
                                    case 1: {
                                        this.startMins = this.startMins < 59 ? ++this.startMins : 0;
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[1], 102, 2, 2, 3, "" + (this.startMins < 10 ? "0" + this.startMins : "" + this.startMins)));
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                        break block4;
                                    }
                                    case 2: {
                                        if (this.startAmPm.equals(SerialLcdScheduleEventPage.AM)) {
                                            this.startAmPm = SerialLcdScheduleEventPage.PM;
                                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[1], 117, 2, 2, 3, this.startAmPm));
                                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                            break block4;
                                        }
                                        this.startAmPm = SerialLcdScheduleEventPage.AM;
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[1], 117, 2, 2, 3, this.startAmPm));
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                    }
                                }
                                break;
                            }
                            case 2: {
                                switch (this.editColumn) {
                                    case 0: {
                                        ++this.endHour;
                                        if (this.endHour > 12) {
                                            this.endHour %= 12;
                                        }
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(SerialLcdScheduleEventPage.ROW[2], 87, 94));
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[2], 89 + (this.endHour < 10 && this.endHour != 0 ? 5 : 0), 2, 2, 3, "" + this.endHour));
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                        break block4;
                                    }
                                    case 1: {
                                        this.endMins = this.endMins < 59 ? ++this.endMins : 0;
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[2], 102, 2, 2, 3, "" + (this.endMins < 10 ? "0" + this.endMins : "" + this.endMins)));
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                        break block4;
                                    }
                                    case 2: {
                                        if (this.endAmPm.equals(SerialLcdScheduleEventPage.AM)) {
                                            this.endAmPm = SerialLcdScheduleEventPage.PM;
                                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[2], 117, 2, 2, 3, this.endAmPm));
                                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                            break block4;
                                        }
                                        this.endAmPm = SerialLcdScheduleEventPage.AM;
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[2], 117, 2, 2, 3, this.endAmPm));
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                    }
                                }
                                break;
                            }
                            case 3: {
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 127, this.underlinePosition * 8 + 7, true));
                                if (this.scheduleArray.type.equals("Boolean")) {
                                    if (this.valueIndex == -1) {
                                        if (this.scheduleArray.getOut().equals("false") || this.scheduleArray.getOut().equals(this.scheduleArray.getFacetsArray()[0])) {
                                            this.valueIndex = 0;
                                            this.updateCurrentValue(this.facetArray[this.valueIndex]);
                                            break;
                                        }
                                        this.valueIndex = 1;
                                        this.updateCurrentValue(this.facetArray[this.valueIndex]);
                                        break;
                                    }
                                    if (this.valueIndex <= this.facetArray.length && this.valueIndex - 1 >= 0) {
                                        --this.valueIndex;
                                    }
                                    this.updateCurrentValue(this.facetArray[this.valueIndex]);
                                    break;
                                }
                                if (this.scheduleArray.type.equals("Enum")) {
                                    if (this.eventNumber == -1) {
                                        facetArray = this.scheduleArray.getFacetsArray();
                                        if (this.valueIndex == -1) {
                                            try {
                                                this.valueIndex = new Integer(this.scheduleArray.getOut());
                                            }
                                            catch (NumberFormatException numE) {
                                                for (i = 0; i < facetArray.length; ++i) {
                                                    if (!this.value.equals(facetArray[i])) continue;
                                                    this.valueIndex = i;
                                                }
                                            }
                                        }
                                        if (this.valueIndex > 0) {
                                            --this.valueIndex;
                                            this.updateCurrentValue(facetArray[this.valueIndex]);
                                            break;
                                        }
                                        break block48;
                                    }
                                    if (this.valueIndex > this.facetArray.length || this.valueIndex - 1 < 0) break;
                                    --this.valueIndex;
                                    this.updateCurrentValue(this.facetArray[this.valueIndex]);
                                    break;
                                }
                                if (!this.scheduleArray.type.equals("Numeric")) ** GOTO lbl116
                                newChar = "9";
                                if (this.charArray[this.editColumn] == ".") ** GOTO lbl106
                                try {
                                    newChar = "" + (new Integer(this.charArray[this.editColumn]) + 1);
                                    if (!newChar.equals("10")) ** GOTO lbl107
                                    if (this.editColumn == this.charArray.length - 1) ** GOTO lbl101
                                    newChar = "0";
                                    ** GOTO lbl107
lbl101:
                                    // 1 sources

                                    newChar = "-";
                                }
                                catch (NumberFormatException nfe) {
                                    newChar = "0";
                                }
                                ** GOTO lbl107
lbl106:
                                // 1 sources

                                System.out.println("Cannot Edit .");
lbl107:
                                // 5 sources

                                this.charArray[this.editColumn] = newChar;
                                this.value = "";
                                for (i = 0; i < this.charArray.length; ++i) {
                                    this.value = this.value + this.charArray[this.charArray.length - 1 - i];
                                }
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(SerialLcdScheduleEventPage.ROW[3], 55, 127));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[3], 0, 2, 1, 2, this.value));
                                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.updateCharUnderline());
                                break;
lbl116:
                                // 1 sources

                                if (!this.scheduleArray.type.equals("String")) break;
                                newChar = "";
                                charValue = this.charArray[this.editColumn].charAt(0);
                                switch (charValue) {
                                    case ' ': {
                                        newChar = "~";
                                        break;
                                    }
                                    case '{': {
                                        newChar = "`";
                                        break;
                                    }
                                    case '[': {
                                        newChar = "@";
                                        break;
                                    }
                                    case ':': {
                                        newChar = "/";
                                        break;
                                    }
                                    case '!': {
                                        newChar = "9";
                                        break;
                                    }
                                    case '0': {
                                        newChar = "z";
                                        break;
                                    }
                                    case 'a': {
                                        newChar = " ";
                                        break;
                                    }
                                    default: {
                                        newChar = "" + (char)(charValue - '\u0001');
                                    }
                                }
                                this.charArray[this.editColumn] = newChar;
                                this.value = "";
                                for (i = 0; i < this.charArray.length; ++i) {
                                    this.value = this.value + this.charArray[this.charArray.length - 1 - i];
                                }
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(SerialLcdScheduleEventPage.ROW[3], 55, 127));
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(SerialLcdScheduleEventPage.ROW[3], 0, 2, 1, 2, this.value));
                                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.updateCharUnderline());
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block48;
                }
                if (this.underlinePosition > 1) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 64, this.underlinePosition * 8 + 7, false));
                    --this.underlinePosition;
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, this.underlinePosition * 8 + 7, 64, this.underlinePosition * 8 + 7, true));
            }
            catch (Exception e) {
                System.out.println("Error with Up Button");
                e.printStackTrace();
            }
        }
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    private SerialLcdCommand[] getSoftButtons() throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, true), new SerialLcdLineCommand(0, 57, 26, 57, true), new SerialLcdLineCommand(0, 58, 26, 58, true), new SerialLcdLineCommand(0, 59, 26, 59, true), new SerialLcdLineCommand(0, 60, 26, 60, true), new SerialLcdLineCommand(0, 61, 26, 61, true), new SerialLcdLineCommand(0, 62, 26, 62, true), new SerialLcdLineCommand(0, 63, 26, 63, true)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("menu")));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(34, 56, 60, 56, true), new SerialLcdLineCommand(34, 57, 60, 57, true), new SerialLcdLineCommand(34, 58, 60, 58, true), new SerialLcdLineCommand(34, 59, 60, 59, true), new SerialLcdLineCommand(34, 60, 60, 60, true), new SerialLcdLineCommand(34, 61, 60, 61, true), new SerialLcdLineCommand(34, 62, 60, 62, true), new SerialLcdLineCommand(34, 63, 60, 63, true)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 37, 2, 2, 3, BSerialLcdNetwork.lex.getText("save")));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(68, 56, 94, 56, false), new SerialLcdLineCommand(68, 57, 94, 57, false), new SerialLcdLineCommand(68, 58, 94, 58, false), new SerialLcdLineCommand(68, 59, 94, 59, false), new SerialLcdLineCommand(68, 60, 94, 60, false), new SerialLcdLineCommand(68, 61, 94, 61, false), new SerialLcdLineCommand(68, 62, 94, 62, false), new SerialLcdLineCommand(68, 63, 94, 63, false)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(102, 56, 127, 56, true), new SerialLcdLineCommand(102, 57, 127, 57, true), new SerialLcdLineCommand(102, 58, 127, 58, true), new SerialLcdLineCommand(102, 59, 127, 59, true), new SerialLcdLineCommand(102, 60, 127, 60, true), new SerialLcdLineCommand(102, 61, 127, 61, true), new SerialLcdLineCommand(102, 62, 127, 62, true), new SerialLcdLineCommand(102, 63, 127, 63, true)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 105, 2, 2, 3, BSerialLcdNetwork.lex.getText("cancel")));
        return tmpCommands;
    }

    private SerialLcdCommand[] getSoftButtonsEdit(String type) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, false), new SerialLcdLineCommand(0, 57, 26, 57, false), new SerialLcdLineCommand(0, 58, 26, 58, false), new SerialLcdLineCommand(0, 59, 26, 59, false), new SerialLcdLineCommand(0, 60, 26, 60, false), new SerialLcdLineCommand(0, 61, 26, 61, false), new SerialLcdLineCommand(0, 62, 26, 62, false), new SerialLcdLineCommand(0, 63, 26, 63, false)});
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(34, 56, 60, 56, true), new SerialLcdLineCommand(34, 57, 60, 57, true), new SerialLcdLineCommand(34, 58, 60, 58, true), new SerialLcdLineCommand(34, 59, 60, 59, true), new SerialLcdLineCommand(34, 60, 60, 60, true), new SerialLcdLineCommand(34, 61, 60, 61, true), new SerialLcdLineCommand(34, 62, 60, 62, true), new SerialLcdLineCommand(34, 63, 60, 63, true)});
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[7], 46, 2, 2, 3, BSerialLcdNetwork.lex.getText("less")));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(68, 56, 94, 56, true), new SerialLcdLineCommand(68, 57, 94, 57, true), new SerialLcdLineCommand(68, 58, 94, 58, true), new SerialLcdLineCommand(68, 59, 94, 59, true), new SerialLcdLineCommand(68, 60, 94, 60, true), new SerialLcdLineCommand(68, 61, 94, 61, true), new SerialLcdLineCommand(68, 62, 94, 62, true), new SerialLcdLineCommand(68, 63, 94, 63, true)});
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[7], 81, 2, 2, 3, BSerialLcdNetwork.lex.getText("more")));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(102, 56, 127, 56, true), new SerialLcdLineCommand(102, 57, 127, 57, true), new SerialLcdLineCommand(102, 58, 127, 58, true), new SerialLcdLineCommand(102, 59, 127, 59, true), new SerialLcdLineCommand(102, 60, 127, 60, true), new SerialLcdLineCommand(102, 61, 127, 61, true), new SerialLcdLineCommand(102, 62, 127, 62, true), new SerialLcdLineCommand(102, 63, 127, 63, true)});
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[7], 105, 2, 2, 3, BSerialLcdNetwork.lex.getText("cancel")));
        }
        catch (Exception e) {
            System.out.println("Could not display Soft Keys for editing value");
            e.printStackTrace();
        }
        return commands;
    }

    public void clearPage() {
        try {
            this.getNetwork().setStallOutput(false);
            ((BSerialLcdNetwork)this.getNetwork().getNetwork()).sendCommand(new SerialLcdClearCommand(ROW[8], 0, 127));
        }
        catch (Exception e) {
            System.err.println("Error Clearing Page - " + e.toString());
            e.printStackTrace();
        }
    }

    public String getValue() {
        String value = "";
        if (this.eventSchedule.length > 0) {
            value = this.eventSchedule[this.eventNumber].getEffectiveValue().getValueValue().toString();
        } else {
            value = this.scheduleArray.getOut().toString();
            if (value.equals("")) {
                value = " ";
            }
        }
        if (this.scheduleArray.type.equals("Enum")) {
            this.valueIndex = this.eventSchedule.length > 0 ? ((BStatusEnum)this.eventSchedule[this.eventNumber].getEffectiveValue()).getEnum().getOrdinal() : ArrayUtil.indexOf((Object[])this.facetArray, (Object)this.scheduleArray.getOut());
        } else if (this.scheduleArray.type.equals("Boolean")) {
            this.valueIndex = this.eventSchedule.length > 0 ? (((BStatusBoolean)this.eventSchedule[this.eventNumber].getEffectiveValue()).getBoolean() ? 1 : 0) : -1;
        } else if (this.scheduleArray.type.equals("String") || this.scheduleArray.type.equals("Numeric")) {
            if (this.valueSelected && this.scheduleArray.type.equals("Numeric") && value.indexOf(" ") > -1) {
                value = value.substring(0, value.indexOf(" "));
            }
            this.charArray = new String[0];
            for (int i = 0; i < value.length(); ++i) {
                this.charArray = (String[])ArrayUtil.addOne((Object[])this.charArray, (Object)("" + value.charAt(value.length() - 1 - i)));
            }
        }
        this.value = value;
        return this.value;
    }

    public void buildValueArray() {
        this.getValue();
        if (this.scheduleArray.type.equals("Boolean")) {
            this.VALUES = new String[2];
            this.valueOrdinals = new int[0];
            this.VALUES[0] = this.scheduleArray.getFacets().gets("falseText", "false");
            this.VALUES[1] = this.scheduleArray.getFacets().gets("trueText", "true");
            this.valueIndex = this.VALUES[1].toLowerCase().equals(this.value != null ? this.value.toLowerCase() : "") ? 1 : 0;
        } else if (this.scheduleArray.type.equals("Numeric")) {
            this.valueIndex = -1;
            this.VALUES = new String[4];
            this.valueOrdinals = new int[0];
            this.VALUES[0] = this.scheduleArray.getFacets().get("units").toString();
            this.VALUES[1] = this.scheduleArray.getFacets().get("precision").toString();
            this.VALUES[2] = this.scheduleArray.getFacets().get("min").toString();
            this.VALUES[3] = this.scheduleArray.getFacets().get("max").toString();
        } else if (this.scheduleArray.type.equals("Enum")) {
            this.valueIndex = -1;
            BEnumRange range = (BEnumRange)this.scheduleArray.getFacets().get("range");
            this.valueOrdinals = range.getOrdinals();
            this.VALUES = new String[this.valueOrdinals.length];
            if (this.eventNumber > -1) {
                if (this.eventSchedule.length > 0) {
                    try {
                        this.valueIndex = new Integer(this.eventSchedule[this.eventNumber].getEffectiveValue().getValueValue().toString());
                    }
                    catch (Exception e) {
                        this.valueIndex = ArrayUtil.indexOf((Object[])this.facetArray, (Object)this.eventSchedule[this.eventNumber].getEffectiveValue().getValueValue().toString());
                    }
                } else {
                    this.valueIndex = ArrayUtil.indexOf((Object[])this.facetArray, (Object)this.scheduleArray.getOut());
                }
            }
            for (int i = 0; i < this.valueOrdinals.length; ++i) {
                this.VALUES[i] = range.get(this.valueOrdinals[i]).toString();
                if (!this.VALUES[i].toLowerCase().equals(this.value != null ? this.value.toLowerCase() : "")) continue;
                this.valueIndex = i;
            }
        } else if (this.scheduleArray.type.equals("String")) {
            this.valueIndex = 0;
            this.valueOrdinals = new int[0];
            this.VALUES = new String[1];
            this.VALUES[0] = this.value;
        }
    }

    protected void updateCurrentValue(String value) {
        try {
            int tmpWidth = BSerialLcdPointExtension.getPixelWidth(value);
            if (64 > tmpWidth) {
                tmpWidth = 64;
            }
            if (tmpWidth <= this.getNetwork().getMaxValueWidth() && tmpWidth > this.valueWidth) {
                this.valueWidth = tmpWidth;
            }
            Object[] tmpCommands = new SerialLcdCommand[]{};
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdClearCommand(ROW[3], 127 - tmpWidth, 127));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 2, value));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])this.getPointUnderline(3, true));
            this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
        }
        catch (Exception e) {
            System.err.println("Error getting next value - " + e.toString());
            e.printStackTrace();
        }
    }

    private SerialLcdCommand[] getPointUnderline(int row, boolean on) throws SerialLcdCommandException {
        Object[] s = new SerialLcdCommand[]{new SerialLcdLineCommand(64, row * 8 + 7, 127, row * 8 + 7, on)};
        if (on && this.scheduleArray.type.equals("String") || this.scheduleArray.type.equals("Numeric")) {
            int start = 122;
            int stop = 125;
            if (start < 127) {
                if (stop > 127) {
                    stop = 127;
                }
                s = (SerialLcdCommand[])ArrayUtil.addOne((Object[])s, (Object)new SerialLcdLineCommand(start, row * 8 + 7, stop, row * 8 + 7, false));
            }
        }
        return s;
    }

    private SerialLcdCommand[] updateCharUnderline() {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, 31, 127, 31, true));
            int start = 0;
            int stop = 0;
            try {
                stop = 131 - BSerialLcdPointExtension.getPixelWidth(this.value.substring(this.value.length() - this.editColumn));
                start = stop - BSerialLcdPointExtension.getCharWidth(this.charArray[this.editColumn].charAt(0));
            }
            catch (StringIndexOutOfBoundsException sobe) {
                sobe.printStackTrace();
            }
            if (start < 127) {
                if (stop > 127) {
                    stop = 127;
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(start, 31, stop, 31, false));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return commands;
    }

    @Override
    public void popupClosed(int popupReturn) {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(255, 0, 127));
        }
        catch (Exception e) {
            System.out.println("Could not clear page when closing popup.");
            e.printStackTrace();
        }
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        this._displayPage();
    }
}

