/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdBoxCommand;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPixelCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.messages.SerialLcdMessage;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.lynxspring.lcd.ui.SerialLcdScheduleGrid;
import com.tridium.basicdriver.message.Message;
import com.tridium.util.ArrayUtil;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;

public class SerialLcdSchedDetailsPage
extends SerialLcdPage {
    int intFirstArrayItemToDisplay = -1;
    String[] arrAlarmTitles = new String[1];
    private String pageName = BSerialLcdNetwork.lex.getText("schedDetails");
    private byte[] bytes;
    BWeeklySchedule schedule;
    private SerialLcdScheduleGrid[][] scheduleGrid = new SerialLcdScheduleGrid[7][24];
    private int UIGridDay = ARRAY_SUNDAY;
    private int UIGridRow = 1;
    private int intSchedArrayDay = 0;
    private int intSchedArrayHour = 0;
    private int intFirstArrayItemOnPage = 0;
    private int intEditItem = 0;
    private boolean boolInEditMode = false;
    private EditMode editWindow = new EditMode();
    boolean[][] dayFilled = new boolean[7][4];
    boolean dayFilledInitialized = false;
    public static int SUNDAY = 40;
    public static int MONDAY = 52;
    public static int TUESDAY = 64;
    public static int WEDNESDAY = 76;
    public static int THURSDAY = 88;
    public static int FRIDAY = 100;
    public static int SATURDAY = 112;
    public static int GRIDROW1 = 15;
    public static int GRIDROW2 = 23;
    public static int GRIDROW3 = 31;
    public static int GRIDROW4 = 39;
    public static int ARRAY_SUNDAY = 0;
    public static int ARRAY_MONDAY = 1;
    public static int ARRAY_TUESDAY = 2;
    public static int ARRAY_WEDNESDAY = 3;
    public static int ARRAY_THURSDAY = 4;
    public static int ARRAY_FRIDAY = 5;
    public static int ARRAY_SATURDAY = 6;
    private static final String AM = BSerialLcdNetwork.lex.getText("am");
    private static final String PM = BSerialLcdNetwork.lex.getText("pm");
    private DrawGrid drawGrid;

    public SerialLcdSchedDetailsPage(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void displayPage() {
    }

    public void displayPage(BComplex schSchedule) {
        this.intFirstArrayItemToDisplay = -1;
        if (schSchedule instanceof BBooleanSchedule) {
            this.schedule = (BBooleanSchedule)schSchedule;
        } else if (schSchedule instanceof BEnumSchedule) {
            this.schedule = (BEnumSchedule)schSchedule;
        } else if (schSchedule instanceof BNumericSchedule) {
            this.schedule = (BNumericSchedule)schSchedule;
        } else if (schSchedule instanceof BStringSchedule) {
            this.schedule = (BStringSchedule)schSchedule;
        }
        if (this.schedule != null) {
            for (int i = 0; i < 7; ++i) {
                this.populateDay(i);
            }
        }
        this.displayPageForFirstTime();
    }

    public void populateDay(int day) {
        for (int j = 0; j < 24; ++j) {
            BDaySchedule daySchedule = ((BWeekSchedule)this.schedule.getSchedule().get("week")).get(BWeekday.make((int)day));
            this.scheduleGrid[day][j] = new SerialLcdScheduleGrid(daySchedule, BTime.make((int)j, (int)0, (int)0));
        }
    }

    public void displayPageForFirstTime() {
        try {
            this.dayFilled = new boolean[7][4];
            this.dayFilledInitialized = false;
            this.boolInEditMode = false;
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[0], 0, 2, 1, 1, this.pageName));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showHours(8));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("setting")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 3, 2, 1, 3, BSerialLcdNetwork.lex.getText("times")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 44, 2, 1, 3, BSerialLcdNetwork.lex.getText("abbrSun")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 56, 2, 1, 3, BSerialLcdNetwork.lex.getText("abbrMon")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 69, 2, 1, 3, BSerialLcdNetwork.lex.getText("abbrTue")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 80, 2, 1, 3, BSerialLcdNetwork.lex.getText("abbrWed")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 92, 2, 1, 3, BSerialLcdNetwork.lex.getText("abbrThu")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 104, 2, 1, 3, BSerialLcdNetwork.lex.getText("abbrFri")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 116, 2, 1, 3, BSerialLcdNetwork.lex.getText("abbrSat")));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getGrid());
            this.UIGridRow = 1;
            this.UIGridDay = ARRAY_SUNDAY;
            this.intSchedArrayDay = 0;
            this.intSchedArrayHour = 8;
            this.intFirstArrayItemOnPage = 8;
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.drawSelectionBar(0, 1, this.barType(this.UIGridDay, this.UIGridRow)));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            String strCellTimeExtents = this.getFormattedTime(this.scheduleGrid[0][this.intSchedArrayHour].getStartTime()) + "-" + this.getFormattedTime(this.scheduleGrid[0][this.intSchedArrayHour].getEndTime());
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 40, 2, 1, 3, strCellTimeExtents));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.drawSelectionBar(this.UIGridDay, this.UIGridRow, !this.barType(this.UIGridDay, this.UIGridRow)));
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            if (this.drawGrid != null) {
                this.drawGrid.stopRunning();
            }
            this.drawGrid = new DrawGrid();
            this.drawGrid.start();
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    public SerialLcdCommand[] getGrid() throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdBoxCommand(0, 15, 124, 47, true));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdBoxCommand(0, 23, 124, 39, true));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdLineCommand(0, 31, 124, 31, true));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdBoxCommand(40, 15, 52, 47, true));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdBoxCommand(64, 15, 76, 47, true));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdBoxCommand(88, 15, 100, 47, true));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdLineCommand(112, 15, 112, 47, true));
        return tmpCommands;
    }

    @Override
    public void button1Pressed(int presses) {
        if (this.drawGrid != null) {
            this.drawGrid.stopRunning();
        }
        if (this.boolInEditMode) {
            this.editWindow.button1Pressed(presses);
        } else if (!this.getNetwork().getHideMainMenu()) {
            this.getNetwork().displayMenuPage();
        }
    }

    @Override
    public void button2Pressed(int presses) {
        if (!this.boolInEditMode) {
            try {
                Object[] commands = new SerialLcdCommand[]{};
                if (this.UIGridDay != ARRAY_SUNDAY) {
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.drawSelectionBar(this.UIGridDay, this.UIGridRow, this.barType(this.UIGridDay, this.UIGridRow)));
                    this.UIGridDay -= presses;
                    if (this.UIGridDay < ARRAY_SUNDAY) {
                        this.UIGridDay = ARRAY_SUNDAY;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.drawSelectionBar(this.UIGridDay, this.UIGridRow, !this.barType(this.UIGridDay, this.UIGridRow)));
                    this.intSchedArrayDay -= presses;
                    if (this.intSchedArrayDay < ARRAY_SUNDAY) {
                        this.intSchedArrayDay = ARRAY_SUNDAY;
                    }
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[6], 40, 127));
                String strCellTimeExtents = this.getFormattedTime(this.scheduleGrid[this.intSchedArrayDay][this.intSchedArrayHour].getStartTime()) + "-" + this.getFormattedTime(this.scheduleGrid[this.intSchedArrayDay][this.intSchedArrayHour].getEndTime());
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 40, 2, 1, 3, strCellTimeExtents));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.editWindow.button2Pressed(presses);
        }
    }

    @Override
    public void button3Pressed(int presses) {
        if (!this.boolInEditMode) {
            try {
                Object[] commands = new SerialLcdCommand[]{};
                if (this.UIGridDay != ARRAY_SATURDAY) {
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.drawSelectionBar(this.UIGridDay, this.UIGridRow, this.barType(this.UIGridDay, this.UIGridRow)));
                    this.UIGridDay += presses;
                    if (this.UIGridDay > ARRAY_SATURDAY) {
                        this.UIGridDay = ARRAY_SATURDAY;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.drawSelectionBar(this.UIGridDay, this.UIGridRow, !this.barType(this.UIGridDay, this.UIGridRow)));
                    this.intSchedArrayDay += presses;
                    if (this.intSchedArrayDay > ARRAY_SATURDAY) {
                        this.intSchedArrayDay = ARRAY_SATURDAY;
                    }
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[6], 40, 127));
                String strCellTimeExtents = this.getFormattedTime(this.scheduleGrid[this.intSchedArrayDay][this.intSchedArrayHour].getStartTime()) + "-" + this.getFormattedTime(this.scheduleGrid[this.intSchedArrayDay][this.intSchedArrayHour].getEndTime());
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 40, 2, 1, 3, strCellTimeExtents));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.editWindow.button3Pressed(presses);
        }
    }

    @Override
    public void button4Pressed(int presses) {
        if (this.drawGrid != null) {
            this.drawGrid.stopRunning();
        }
        if (!this.boolInEditMode) {
            this.getNetwork().displaySchedulePage();
        } else {
            this.editWindow.button4Pressed(presses);
        }
    }

    @Override
    public void buttonDownPressed(int presses) {
        if (!this.boolInEditMode && this.intSchedArrayHour < 23) {
            try {
                Object[] commands = new SerialLcdCommand[]{};
                int curSchedArrayHour = this.intSchedArrayHour;
                this.intSchedArrayHour += presses;
                if (this.intSchedArrayHour > 23) {
                    this.intSchedArrayHour = 23;
                }
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.drawSelectionBar(this.UIGridDay, this.UIGridRow, this.barType(this.UIGridDay, this.UIGridRow)));
                if (curSchedArrayHour + (4 - this.UIGridRow) < this.intSchedArrayHour) {
                    this.UIGridRow = 4;
                    this.intFirstArrayItemOnPage = this.intSchedArrayHour - 3;
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showHours(this.intFirstArrayItemOnPage));
                    this.showGrid2(this.intFirstArrayItemOnPage);
                } else {
                    this.UIGridRow += presses;
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.drawSelectionBar(this.UIGridDay, this.UIGridRow, !this.barType(this.UIGridDay, this.UIGridRow)));
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[6], 40, 127));
                String strCellTimeExtents = this.getFormattedTime(this.scheduleGrid[this.intSchedArrayDay][this.intSchedArrayHour].getStartTime()) + "-" + this.getFormattedTime(this.scheduleGrid[this.intSchedArrayDay][this.intSchedArrayHour].getEndTime());
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 40, 2, 1, 3, strCellTimeExtents));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.boolInEditMode) {
            this.editWindow.buttonDownPressed(presses);
        }
    }

    @Override
    public void buttonUpPressed(int presses) {
        if (!this.boolInEditMode && this.intSchedArrayHour > 0) {
            try {
                Object[] commands = new SerialLcdCommand[]{};
                int curSchedArrayHour = this.intSchedArrayHour;
                this.intSchedArrayHour -= presses;
                if (this.intSchedArrayHour < 0) {
                    this.intSchedArrayHour = 0;
                }
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.drawSelectionBar(this.UIGridDay, this.UIGridRow, this.barType(this.UIGridDay, this.UIGridRow)));
                if (curSchedArrayHour - this.intSchedArrayHour >= this.UIGridRow) {
                    this.UIGridRow = 1;
                    this.intFirstArrayItemOnPage = this.intSchedArrayHour;
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.showHours(this.intFirstArrayItemOnPage));
                    this.showGrid2(this.intFirstArrayItemOnPage);
                } else {
                    this.UIGridRow -= presses;
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.drawSelectionBar(this.UIGridDay, this.UIGridRow, !this.barType(this.UIGridDay, this.UIGridRow)));
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[6], 40, 127));
                String strCellTimeExtents = this.getFormattedTime(this.scheduleGrid[this.intSchedArrayDay][this.intSchedArrayHour].getStartTime()) + "-" + this.getFormattedTime(this.scheduleGrid[this.intSchedArrayDay][this.intSchedArrayHour].getEndTime());
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 40, 2, 1, 3, strCellTimeExtents));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.boolInEditMode) {
            this.editWindow.buttonUpPressed(presses);
        }
    }

    @Override
    public void buttonEnterPressed(int presses) {
        try {
            if (this.drawGrid != null) {
                this.drawGrid.stopRunning();
            }
            if (!this.boolInEditMode) {
                this.boolInEditMode = true;
                if (this.scheduleGrid[this.UIGridDay][this.intSchedArrayHour].getEvents().length > 0) {
                    this.getNetwork().displaySchedSelectPage(this.scheduleGrid[this.UIGridDay][this.intSchedArrayHour]);
                } else {
                    this.getNetwork().displaySchedEventPage(this.scheduleGrid[this.UIGridDay][this.intSchedArrayHour], -1);
                }
            } else {
                this.editWindow.buttonEnterPressed(presses);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean pageChecksForRapidPresses() {
        return true;
    }

    private SerialLcdCommand[] getSoftButtons() throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 57, 26, 57, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 58, 26, 58, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 59, 26, 59, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 60, 26, 60, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 61, 26, 61, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 62, 26, 62, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 63, 26, 63, !this.getNetwork().getHideMainMenu())});
        if (!this.getNetwork().getHideMainMenu()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("menu")));
        }
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(102, 56, 127, 56, true), new SerialLcdLineCommand(102, 57, 127, 57, true), new SerialLcdLineCommand(102, 58, 127, 58, true), new SerialLcdLineCommand(102, 59, 127, 59, true), new SerialLcdLineCommand(102, 60, 127, 60, true), new SerialLcdLineCommand(102, 61, 127, 61, true), new SerialLcdLineCommand(102, 62, 127, 62, true), new SerialLcdLineCommand(102, 63, 127, 63, true)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 105, 2, 2, 3, BSerialLcdNetwork.lex.getText("cancel")));
        return tmpCommands;
    }

    public byte[] getCommand() {
        return this.bytes;
    }

    public static SerialLcdCommand[] drawSelectionBar(int dayOfWeek, int UIRow, boolean drawBar) throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        int x = 0;
        int y = 0;
        if (dayOfWeek == ARRAY_SUNDAY) {
            x = SUNDAY;
        } else if (dayOfWeek == ARRAY_MONDAY) {
            x = MONDAY;
        } else if (dayOfWeek == ARRAY_TUESDAY) {
            x = TUESDAY;
        } else if (dayOfWeek == ARRAY_WEDNESDAY) {
            x = WEDNESDAY;
        } else if (dayOfWeek == ARRAY_THURSDAY) {
            x = THURSDAY;
        } else if (dayOfWeek == ARRAY_FRIDAY) {
            x = FRIDAY;
        } else if (dayOfWeek == ARRAY_SATURDAY) {
            x = SATURDAY;
        }
        if (UIRow == 1) {
            y = GRIDROW1;
        } else if (UIRow == 2) {
            y = GRIDROW2;
        } else if (UIRow == 3) {
            y = GRIDROW3;
        } else if (UIRow == 4) {
            y = GRIDROW4;
        }
        if (x > 0 && y > 0) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdLineCommand(x + 2, y + 6, x + 10, y + 6, drawBar));
            return tmpCommands;
        }
        return null;
    }

    private boolean barType(int day, int hourRow) {
        return this.dayFilled[day][hourRow - 1];
    }

    private SerialLcdCommand[] showHours(int intFirstArrayItemOnPage) throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdClearCommand(ROW[2] + ROW[3] + ROW[4] + ROW[5], 3, 41));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdClearCommand(ROW[6], 40, 127));
        int intTargetRow = 2;
        for (int i = intFirstArrayItemOnPage; i < intFirstArrayItemOnPage + 4; ++i) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[intTargetRow], 3, 2, 1, 3, this.scheduleGrid[0][i].getHourStart().toString()));
            ++intTargetRow;
        }
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdBoxCommand(0, 23, 40, 39, true));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdBoxCommand(0, 31, 40, 47, true));
        return tmpCommands;
    }

    private SerialLcdCommand[] displayArrow(int xCoord, int yCoord, int pointDirection, boolean displayOn) throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        int y = pointDirection == 1 ? 1 : -1;
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPixelCommand(xCoord, yCoord, displayOn));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdLineCommand(xCoord - 1, yCoord + y, xCoord + 1, yCoord + y, displayOn));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdLineCommand(xCoord - 2, yCoord + y * 2, xCoord + 2, yCoord + y * 2, displayOn));
        return tmpCommands;
    }

    private void showGrid2(int intFirstArrayItemOnPage) throws Exception {
        if (this.drawGrid != null && this.drawGrid.isAlive()) {
            this.drawGrid.stopRunning();
        }
        this.drawGrid = new DrawGrid();
        this.drawGrid.start();
    }

    private String getFormattedTime(BTime myTime) throws Exception {
        String t = "";
        String strAMPM = AM;
        int hour = myTime.getHour();
        if (hour > 11) {
            strAMPM = PM;
        }
        if (hour > 12) {
            hour -= 12;
        }
        if (hour == 0) {
            hour = 12;
        }
        t = "" + hour + ":";
        int min = myTime.getMinute();
        if (min < 10) {
            t = t + "0";
            t = t + min;
        } else {
            t = t + min;
        }
        t = t + strAMPM;
        return t;
    }

    private class EditMode
    extends SerialLcdPage {
        private static final int PREV_ROW = 1;
        private static final int DAY_ROW = 2;
        private static final int START_ROW = 3;
        private static final int END_ROW = 4;
        private static final int DEL_ROW = 5;
        private static final int NEXT_ROW = 6;
        boolean inEditMode = false;
        private static final int xs = 21;
        private static final int ys = 7;
        private static final int ye = 56;
        private int underlinePosition = 2;
        private int gridIndex = 0;
        private boolean hasPrevious;
        private boolean hasNext;
        private BTimeSchedule newEvent = null;
        private int intStartHour = 0;
        private int intStartMins = 0;
        private String strStartAmPm;
        private int intFinishHour = 0;
        private int intFinishMins = 0;
        private String strFinishAmPm;
        private boolean boolNewEvent = false;

        @Override
        public void displayPage() {
        }

        @Override
        public void button1Pressed(int presses) {
            SerialLcdSchedDetailsPage.this.boolInEditMode = false;
            SerialLcdSchedDetailsPage.this.populateDay(SerialLcdSchedDetailsPage.this.UIGridDay);
            SerialLcdSchedDetailsPage.this.displayPageForFirstTime();
        }

        @Override
        public void button2Pressed(int presses) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                if (this.inEditMode) {
                    if (this.underlinePosition == 3) {
                        if (SerialLcdSchedDetailsPage.this.intEditItem == 1) {
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 77, 2, 1, 3, this.intStartMins < 10 ? "0" + this.intStartMins : "" + this.intStartMins));
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 64 + ((this.intStartHour < 10 || this.intStartHour > 12 && this.intStartHour < 22) && this.intStartHour != 0 ? 5 : 0), 2, 2, 3, this.intStartHour % 12 == 0 ? "12" : "" + this.intStartHour % 12));
                            SerialLcdSchedDetailsPage.this.intEditItem--;
                        } else if (SerialLcdSchedDetailsPage.this.intEditItem == 2) {
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 77, 2, 2, 3, this.intStartMins < 10 ? "0" + this.intStartMins : "" + this.intStartMins));
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 92, 2, 1, 3, this.strStartAmPm));
                            SerialLcdSchedDetailsPage.this.intEditItem--;
                        }
                    } else if (this.underlinePosition == 4) {
                        if (SerialLcdSchedDetailsPage.this.intEditItem == 1) {
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 77, 2, 1, 3, this.intFinishMins < 10 ? "0" + this.intFinishMins : "" + this.intFinishMins));
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 64 + ((this.intFinishHour < 10 || this.intFinishHour > 12 && this.intFinishHour < 22) && this.intFinishHour != 0 ? 5 : 0), 2, 2, 3, this.intFinishHour % 12 == 0 ? "12" : "" + this.intFinishHour % 12));
                            SerialLcdSchedDetailsPage.this.intEditItem--;
                        } else if (SerialLcdSchedDetailsPage.this.intEditItem == 2) {
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 77, 2, 2, 3, this.intFinishMins < 10 ? "0" + this.intFinishMins : "" + this.intFinishMins));
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 92, 2, 1, 3, this.strFinishAmPm));
                            SerialLcdSchedDetailsPage.this.intEditItem--;
                        }
                    }
                    if (this.underlinePosition == 5 && SerialLcdSchedDetailsPage.this.intEditItem == 1) {
                        SerialLcdSchedDetailsPage.this.intEditItem--;
                        this.displayNew(true);
                        this.displayDelete(false);
                        this.drawUnderline();
                    }
                }
                this.drawUnderline();
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void button3Pressed(int presses) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                if (this.inEditMode) {
                    if (this.underlinePosition == 3) {
                        if (SerialLcdSchedDetailsPage.this.intEditItem == 0) {
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 64 + ((this.intStartHour < 10 || this.intStartHour > 12 && this.intStartHour < 22) && this.intStartHour != 0 ? 5 : 0), 2, 1, 3, (this.intStartHour % 12 == 0 ? "12" : "" + this.intStartHour % 12) + ":"));
                            if (!this.boolNewEvent) {
                                this.intStartMins = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getStart().getMinute();
                            }
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 77, 2, 2, 3, this.intStartMins < 10 ? "0" + this.intStartMins : "" + this.intStartMins));
                            SerialLcdSchedDetailsPage.this.intEditItem++;
                        } else if (SerialLcdSchedDetailsPage.this.intEditItem == 1) {
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 77, 2, 1, 3, this.intStartMins < 10 ? "0" + this.intStartMins : "" + this.intStartMins));
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 92, 2, 2, 3, this.strStartAmPm));
                            SerialLcdSchedDetailsPage.this.intEditItem++;
                        }
                    } else if (this.underlinePosition == 4) {
                        if (SerialLcdSchedDetailsPage.this.intEditItem == 0) {
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 64 + ((this.intFinishHour < 10 || this.intFinishHour > 12 && this.intFinishHour < 22) && this.intFinishHour != 0 ? 5 : 0), 2, 1, 3, (this.intFinishHour % 12 == 0 ? "12" : "" + this.intFinishHour % 12) + ":"));
                            if (!this.boolNewEvent) {
                                this.intFinishMins = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getFinish().getMinute();
                            }
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 77, 2, 2, 3, this.intFinishMins < 10 ? "0" + this.intFinishMins : "" + this.intFinishMins));
                            SerialLcdSchedDetailsPage.this.intEditItem++;
                        } else if (SerialLcdSchedDetailsPage.this.intEditItem == 1) {
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 77, 2, 1, 3, this.intFinishMins < 10 ? "0" + this.intFinishMins : "" + this.intFinishMins));
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 92, 2, 2, 3, this.strFinishAmPm));
                            SerialLcdSchedDetailsPage.this.intEditItem++;
                        }
                    } else if (this.underlinePosition == 5 && SerialLcdSchedDetailsPage.this.intEditItem == 0) {
                        SerialLcdSchedDetailsPage.this.intEditItem++;
                        this.displayNew(false);
                        this.displayDelete(true);
                        this.drawUnderline();
                    }
                }
                this.drawUnderline();
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void button4Pressed(int presses) {
            if (this.inEditMode) {
                try {
                    if (this.underlinePosition == 3) {
                        this.intStartMins = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getStart().getMinute();
                        this.intStartHour = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getStart().getHour();
                        this.strStartAmPm = this.intStartHour >= 12 ? PM : AM;
                        this.displayTime(3, this.intStartHour, this.intStartMins, this.strStartAmPm);
                    } else if (this.underlinePosition == 4) {
                        this.intFinishMins = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getFinish().getMinute();
                        this.intFinishHour = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getFinish().getHour();
                        this.strFinishAmPm = this.intFinishHour >= 12 ? PM : AM;
                        this.displayTime(4, this.intFinishHour, this.intFinishMins, this.strFinishAmPm);
                    } else if (this.underlinePosition == 5) {
                        this.displayNew(false);
                        this.displayDelete(false);
                    }
                    this.drawUnderline();
                    this.inEditMode = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                SerialLcdSchedDetailsPage.this.boolInEditMode = false;
                SerialLcdSchedDetailsPage.this.displayPageForFirstTime();
            }
        }

        @Override
        public void buttonEnterPressed(int presses) {
            Object[] commands = new SerialLcdCommand[]{};
            if (!this.inEditMode) {
                SerialLcdSchedDetailsPage.this.intEditItem = 0;
            }
            try {
                switch (this.underlinePosition) {
                    case 1: {
                        if (--this.gridIndex == 0) {
                            this.hasPrevious = false;
                            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.this.displayArrow(27, 9, 1, false));
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 33, 2, 1, 3, "                    "));
                        }
                        this.displayNextCommand();
                        this.goToLine(3);
                        this.displayInfo();
                        break;
                    }
                    case 3: {
                        if (!this.inEditMode) {
                            this.inEditMode = true;
                            if (!this.boolNewEvent) {
                                this.intStartMins = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getStart().getMinute();
                                this.intStartHour = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getStart().getHour();
                            }
                            this.strStartAmPm = this.intStartHour >= 12 ? PM : AM;
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 64 + ((this.intStartHour < 10 || this.intStartHour > 12 && this.intStartHour < 22) && this.intStartHour != 0 ? 5 : 0), 2, 2, 3, this.intStartHour % 12 == 0 ? "12" : "" + this.intStartHour % 12));
                            break;
                        }
                        this.inEditMode = false;
                        if (!this.boolNewEvent) {
                            SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].setStart(BTime.make((int)(this.intStartHour + (this.strStartAmPm.equals(PM) && this.intStartHour < 12 ? 12 : 0)), (int)this.intStartMins, (int)0));
                            this.displayTime(3, SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getStart().toString());
                        } else {
                            if (this.newEvent == null) {
                                this.newEvent = new BTimeSchedule(BTime.make((int)(this.intStartHour + (this.strStartAmPm.equals(AM) ? 0 : 12)), (int)this.intStartMins, (int)0), BTime.make((int)(this.intFinishHour + (this.strFinishAmPm.equals(PM) ? 12 : 0)), (int)this.intFinishMins, (int)0), (BStatusValue)new BStatusBoolean(true));
                                SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getSchedule().add(this.newEvent);
                            } else {
                                this.newEvent.setStart(BTime.make((int)this.intStartHour, (int)this.intStartMins, (int)0));
                            }
                            this.displayTime(3, this.intStartHour, this.intStartMins, this.strStartAmPm);
                        }
                        this.drawUnderline();
                        break;
                    }
                    case 4: {
                        if (!this.inEditMode) {
                            this.inEditMode = true;
                            if (!this.boolNewEvent) {
                                this.intFinishMins = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getFinish().getMinute();
                                this.intFinishHour = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getFinish().getHour();
                            }
                            this.strFinishAmPm = this.intFinishHour >= 12 ? PM : AM;
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 64 + ((this.intFinishHour < 10 || this.intFinishHour > 12 && this.intFinishHour < 22) && this.intFinishHour != 0 ? 5 : 0), 2, 2, 3, this.intFinishHour % 12 == 0 ? "12" : "" + this.intFinishHour % 12));
                            break;
                        }
                        this.inEditMode = false;
                        if (!this.boolNewEvent) {
                            SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].setFinish(BTime.make((int)(this.intFinishHour + (this.strFinishAmPm.equals(PM) && this.intFinishHour < 12 ? 12 : 0)), (int)this.intFinishMins, (int)0));
                            this.displayTime(4, SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getFinish().toString());
                        } else {
                            if (this.newEvent == null) {
                                this.newEvent = new BTimeSchedule(BTime.make((int)(this.intStartHour + (this.strStartAmPm.equals(AM) ? 0 : 12)), (int)this.intStartMins, (int)0), BTime.make((int)(this.intFinishHour + (this.strFinishAmPm.equals(AM) ? 0 : 12)), (int)this.intFinishMins, (int)0), (BStatusValue)new BStatusBoolean(true));
                                SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getSchedule().add(this.newEvent);
                            } else {
                                this.newEvent.setFinish(BTime.make((int)(this.intFinishHour + (this.strFinishAmPm.equals(AM) ? 0 : 12)), (int)this.intFinishMins, (int)0));
                            }
                            this.displayTime(4, this.intFinishHour, this.intFinishMins, this.strFinishAmPm);
                        }
                        this.drawUnderline();
                        break;
                    }
                    case 5: {
                        if (this.inEditMode) {
                            this.inEditMode = false;
                            if (SerialLcdSchedDetailsPage.this.intEditItem == 0) {
                                this.boolNewEvent = true;
                                this.displayInfo();
                                this.goToLine(3);
                                break;
                            }
                            if (SerialLcdSchedDetailsPage.this.intEditItem <= 0 || SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents().length <= 0) break;
                            SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getSchedule().remove(SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getName());
                            SerialLcdSchedDetailsPage.this.boolInEditMode = false;
                            SerialLcdSchedDetailsPage.this.populateDay(SerialLcdSchedDetailsPage.this.UIGridDay);
                            SerialLcdSchedDetailsPage.this.displayPageForFirstTime();
                            break;
                        }
                        if (this.inEditMode) break;
                        this.inEditMode = true;
                        this.displayNew(true);
                        break;
                    }
                    case 6: {
                        if (++this.gridIndex == SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents().length - 1) {
                            this.hasNext = false;
                            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])SerialLcdSchedDetailsPage.this.displayArrow(27, 54, 2, false));
                            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 33, 2, 1, 3, "                    "));
                        }
                        this.displayInfo();
                        this.goToLine(3);
                        this.displayPreviousCommand();
                    }
                }
                this.drawUnderline();
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void buttonUpPressed(int presses) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                if (!this.inEditMode) {
                    this.moveUp();
                } else {
                    block1 : switch (this.underlinePosition) {
                        case 3: {
                            switch (SerialLcdSchedDetailsPage.this.intEditItem) {
                                case 0: {
                                    if (this.intStartHour > 12) {
                                        this.intStartHour %= 12;
                                    }
                                    this.intStartHour = this.intStartHour < 12 ? ++this.intStartHour : 1;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 63, 68));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 64 + (this.intStartHour < 10 && this.intStartHour != 0 ? 5 : 0), 2, 2, 3, "" + this.intStartHour));
                                    break;
                                }
                                case 1: {
                                    this.intStartMins = this.intStartMins < 59 ? ++this.intStartMins : 0;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 77, 2, 2, 3, "" + (this.intStartMins < 10 ? "0" + this.intStartMins : "" + this.intStartMins)));
                                    break;
                                }
                                case 2: {
                                    if (this.strStartAmPm.equals(AM)) {
                                        this.strStartAmPm = PM;
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 92, 2, 2, 3, this.strStartAmPm));
                                        break;
                                    }
                                    this.strStartAmPm = AM;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 92, 2, 2, 3, this.strStartAmPm));
                                }
                            }
                            break;
                        }
                        case 4: {
                            switch (SerialLcdSchedDetailsPage.this.intEditItem) {
                                case 0: {
                                    if (this.intFinishHour > 12) {
                                        this.intFinishHour %= 12;
                                    }
                                    this.intFinishHour = this.intFinishHour < 12 ? ++this.intFinishHour : 1;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[4], 63, 68));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 64 + (this.intFinishHour < 10 && this.intFinishHour != 0 ? 5 : 0), 2, 2, 3, "" + this.intFinishHour));
                                    break block1;
                                }
                                case 1: {
                                    this.intFinishMins = this.intFinishMins < 59 ? ++this.intFinishMins : 0;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 77, 2, 2, 3, "" + (this.intFinishMins < 10 ? "0" + this.intFinishMins : "" + this.intFinishMins)));
                                    break block1;
                                }
                                case 2: {
                                    if (this.strFinishAmPm.equals(AM)) {
                                        this.strFinishAmPm = PM;
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 92, 2, 2, 3, this.strFinishAmPm));
                                        break block1;
                                    }
                                    this.strFinishAmPm = AM;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 92, 2, 2, 3, this.strFinishAmPm));
                                }
                            }
                        }
                    }
                }
                this.drawUnderline();
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void buttonDownPressed(int presses) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                if (!this.inEditMode) {
                    this.moveDown();
                } else {
                    block1 : switch (this.underlinePosition) {
                        case 3: {
                            switch (SerialLcdSchedDetailsPage.this.intEditItem) {
                                case 0: {
                                    if (this.intStartHour < 12) {
                                        this.intStartHour %= 12;
                                    }
                                    this.intStartHour = this.intStartHour > 1 ? --this.intStartHour : 12;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3], 63, 68));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 64 + (this.intStartHour < 10 && this.intStartHour != 0 ? 5 : 0), 2, 2, 3, "" + this.intStartHour));
                                    break;
                                }
                                case 1: {
                                    this.intStartMins = this.intStartMins > 0 ? --this.intStartMins : 59;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 77, 2, 2, 3, "" + (this.intStartMins < 10 ? "0" + this.intStartMins : "" + this.intStartMins)));
                                    break;
                                }
                                case 2: {
                                    if (this.strStartAmPm.equals(AM)) {
                                        this.strStartAmPm = PM;
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 92, 2, 2, 3, this.strStartAmPm));
                                        break;
                                    }
                                    this.strStartAmPm = AM;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 92, 2, 2, 3, this.strStartAmPm));
                                }
                            }
                            break;
                        }
                        case 4: {
                            switch (SerialLcdSchedDetailsPage.this.intEditItem) {
                                case 0: {
                                    if (this.intFinishHour > 12) {
                                        this.intFinishHour %= 12;
                                    }
                                    this.intFinishHour = this.intFinishHour > 1 ? --this.intFinishHour : 12;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[4], 63, 68));
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 64 + (this.intFinishHour < 10 && this.intFinishHour != 0 ? 5 : 0), 2, 2, 3, "" + this.intFinishHour));
                                    break block1;
                                }
                                case 1: {
                                    this.intFinishMins = this.intFinishMins > 0 ? --this.intFinishMins : 59;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 77, 2, 2, 3, "" + (this.intFinishMins < 10 ? "0" + this.intFinishMins : "" + this.intFinishMins)));
                                    break block1;
                                }
                                case 2: {
                                    if (this.strFinishAmPm.equals(AM)) {
                                        this.strFinishAmPm = PM;
                                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 92, 2, 2, 3, this.strFinishAmPm));
                                        break block1;
                                    }
                                    this.strFinishAmPm = AM;
                                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 92, 2, 2, 3, this.strFinishAmPm));
                                }
                            }
                        }
                    }
                    this.drawUnderline();
                    this.getNetwork().sendCommands((SerialLcdCommand[])commands);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void goToLine(int underlinePosition) {
            this.clearUnderline();
            this.underlinePosition = underlinePosition;
            this.drawUnderline();
        }

        public void moveUp() {
            if (this.underlinePosition > 3) {
                this.goToLine(this.underlinePosition - 1);
            } else if (this.underlinePosition == 3 && this.hasPrevious) {
                this.goToLine(1);
            }
        }

        public void moveDown() {
            if (this.underlinePosition == 1) {
                this.goToLine(3);
            } else if (this.underlinePosition < 5 || this.underlinePosition == 5 && this.hasNext) {
                this.goToLine(this.underlinePosition + 1);
            }
        }

        public void drawUnderline() {
            this.drawUnderline(true);
        }

        public void clearUnderline() {
            this.drawUnderline(false);
        }

        public void drawUnderline(boolean background) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                switch (this.underlinePosition) {
                    case 1: {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(31, 14, 100, 14, background));
                        break;
                    }
                    case 3: {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(31, 30, 100, 30, background));
                        break;
                    }
                    case 4: {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(31, 38, 100, 38, background));
                        break;
                    }
                    case 5: {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(31, 46, 100, 46, background));
                        break;
                    }
                    case 6: {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(31, 54, 100, 54, background));
                    }
                }
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                System.out.println("Draw Underline: " + e);
                e.printStackTrace();
            }
        }

        public void displayTime(int row, int hours, int minutes, String AmPm) throws Exception {
            this.displayTime(row, "" + (hours > 12 ? hours % 12 : hours) + ":" + (minutes < 10 ? "0" : "") + minutes + " " + AmPm);
        }

        public void displayTime(int row, String time) throws Exception {
            this.getNetwork().sendCommand(new SerialLcdClearCommand(ROW[row], 64, 86));
            this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[row], 64 + (time.length() == 7 ? 5 : 0), 2, 1, 3, time));
        }

        public void displayInfo() throws Exception {
            this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[2], 33, 2, 1, 3, "" + ((BDailySchedule)SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getSchedule().getParent()).getName()));
            if (!this.boolNewEvent) {
                String strStartTime = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getStart().toString();
                String strFinishTime = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEvents()[this.gridIndex].getFinish().toString();
                this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[3], 33, 2, 1, 3, BSerialLcdNetwork.lex.getText("start")));
                this.displayTime(3, strStartTime);
                this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[4], 33, 2, 1, 3, BSerialLcdNetwork.lex.getText("end")));
                this.displayTime(4, strFinishTime);
            } else {
                this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[3], 33, 2, 1, 3, BSerialLcdNetwork.lex.getText("start")));
                this.intStartHour = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getStartTime().getHour();
                if (this.intStartHour > 12) {
                    this.intStartHour -= 12;
                }
                this.intStartMins = 0;
                this.strStartAmPm = this.intStartHour < 12 ? AM : PM;
                this.displayTime(3, "" + this.intStartHour + ":" + (this.intStartMins < 10 ? "0" : "") + this.intStartMins + " " + this.strStartAmPm);
                this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[4], 33, 2, 1, 3, BSerialLcdNetwork.lex.getText("end")));
                this.intFinishHour = this.intStartHour;
                if (this.intFinishHour > 12) {
                    this.intFinishHour -= 12;
                }
                this.intFinishMins = SerialLcdSchedDetailsPage.this.scheduleGrid[SerialLcdSchedDetailsPage.this.UIGridDay][SerialLcdSchedDetailsPage.this.intSchedArrayHour].getEndTime().getMinute();
                this.strFinishAmPm = this.intStartHour < 12 ? AM : PM;
                this.displayTime(4, "" + this.intFinishHour + ":" + (this.intFinishMins < 10 ? "0" : "") + this.intFinishMins + " " + this.strFinishAmPm);
            }
            this.displayNew(false);
            this.displayDelete(false);
            this.drawUnderline();
        }

        public void displayNew(boolean highlighted) throws Exception {
            this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[5], 35, 2, highlighted ? 2 : 1, 3, BSerialLcdNetwork.lex.getText("new")));
        }

        public void displayDelete(boolean highlighted) throws Exception {
            this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[5], 61, 2, highlighted ? 2 : 1, 3, BSerialLcdNetwork.lex.getText("delete")));
        }

        public void displayPreviousCommand() throws Exception {
            this.getNetwork().sendCommands(SerialLcdSchedDetailsPage.this.displayArrow(27, 9, 1, true));
            this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[1], 31, 2, 1, 3, BSerialLcdNetwork.lex.getText("prevPeriod")));
            this.hasPrevious = true;
        }

        public void displayNextCommand() throws Exception {
            this.getNetwork().sendCommands(SerialLcdSchedDetailsPage.this.displayArrow(27, 54, 2, true));
            this.getNetwork().sendCommand(new SerialLcdPrintCommand(ROW[6], 33, 2, 1, 3, BSerialLcdNetwork.lex.getText("nextPeriod")));
            this.hasNext = true;
        }

        @Override
        public void popupClosed(int popupReturn) {
        }
    }

    private class DrawGrid
    extends Thread {
        boolean stop = false;

        public void stopRunning() {
            this.stop = true;
            this.stop = true;
        }

        @Override
        public void run() {
            try {
                int x = 0;
                int y = 0;
                int intDay = 0;
                int intHour = SerialLcdSchedDetailsPage.this.intFirstArrayItemOnPage;
                for (x = 40; x < 115; ++x) {
                    for (y = 15; y < 46; ++y) {
                        if (this.stop) {
                            return;
                        }
                        int dayGridLoc = (x - 40) / 12;
                        int hourGridLoc = (y - 15) / 8;
                        if (SerialLcdSchedDetailsPage.this.dayFilled[dayGridLoc][hourGridLoc] != SerialLcdSchedDetailsPage.this.scheduleGrid[intDay][intHour].getCellIsFilled(SerialLcdSchedDetailsPage.this.scheduleGrid[intDay][intHour].getSchedule()) || !SerialLcdSchedDetailsPage.this.dayFilledInitialized) {
                            if (SerialLcdSchedDetailsPage.this.scheduleGrid[intDay][intHour].getCellIsFilled(SerialLcdSchedDetailsPage.this.scheduleGrid[intDay][intHour].getSchedule())) {
                                SerialLcdSchedDetailsPage.this.getNetwork().getComm().transmitNoResponse((Message)new SerialLcdMessage(this.fillDayBox(x, y, false, 60)));
                            } else {
                                SerialLcdSchedDetailsPage.this.getNetwork().getComm().transmitNoResponse((Message)new SerialLcdMessage(this.clearDayBox(x, y)));
                            }
                            DrawGrid.sleep(80L);
                        }
                        y += 7;
                        ++intHour;
                        if (this.stop) continue;
                        SerialLcdSchedDetailsPage.this.getNetwork().getComm().transmitNoResponse((Message)new SerialLcdMessage(SerialLcdSchedDetailsPage.drawSelectionBar(SerialLcdSchedDetailsPage.this.UIGridDay, SerialLcdSchedDetailsPage.this.UIGridRow, !SerialLcdSchedDetailsPage.this.barType(SerialLcdSchedDetailsPage.this.UIGridDay, SerialLcdSchedDetailsPage.this.UIGridRow))));
                    }
                    x += 11;
                    y = 15;
                    ++intDay;
                    intHour = SerialLcdSchedDetailsPage.this.intFirstArrayItemOnPage;
                }
                SerialLcdSchedDetailsPage.this.dayFilledInitialized = true;
            }
            catch (Exception e) {
                System.out.println("DrawGrid Thread Exception: " + e);
                e.printStackTrace();
            }
        }

        private SerialLcdCommand[] getDayBox(int day, int row, boolean filledIn) throws Exception {
            Object[] tmpCommands = new SerialLcdCommand[]{};
            int dayGridLoc = (day - 40) / 12;
            int hourGridLoc = (row - 15) / 8;
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdLineCommand(day + 4, row + 4, day + 9, row + 4, filledIn));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdBoxCommand(day + 3, row + 3, day + 10, row + 5, filledIn));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdBoxCommand(day + 2, row + 2, day + 11, row + 6, filledIn));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdBoxCommand(day + 1, row + 1, day + 11, row + 7, filledIn));
            SerialLcdSchedDetailsPage.this.dayFilled[dayGridLoc][hourGridLoc] = filledIn;
            return tmpCommands;
        }

        private SerialLcdCommand[] clearDayBox(int day, int row) throws Exception {
            return this.getDayBox(day, row, false);
        }

        private SerialLcdCommand[] fillDayBox(int day, int row, boolean startOfSchedule, int filledMinutes) throws Exception {
            return this.getDayBox(day, row, true);
        }
    }
}

