/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class SerialLcdPage {
    private static RapidPress lastThread;
    private static int requiredPresses;
    private static int lastButtonPressed;
    private static long lastPressTime;
    private static int rapidButtonPresses;
    public static final int[] ROW;
    public static final int BUTTON_1 = 1;
    public static final int BUTTON_2 = 2;
    public static final int BUTTON_3 = 3;
    public static final int BUTTON_4 = 4;
    public static final int BUTTON_UP = 5;
    public static final int BUTTON_DOWN = 6;
    public static final int BUTTON_ENTER = 7;
    BSerialLcdNetwork network;

    public abstract void displayPage();

    public void button1Pressed(int presses) {
    }

    public void button2Pressed(int presses) {
    }

    public void button3Pressed(int presses) {
    }

    public void button4Pressed(int presses) {
    }

    public void buttonUpPressed(int presses) {
    }

    public void buttonDownPressed(int presses) {
    }

    public void buttonEnterPressed(int presses) {
    }

    public void popupClosed(int popupReturn) {
    }

    public boolean pageChecksForRapidPresses() {
        return false;
    }

    public void buttonPressed(int button) {
        this.buttonPressed(button, true);
    }

    public void buttonPressed(int button, boolean checkRapidPresses) {
        if (checkRapidPresses && this.rapidPressDetected(button)) {
            ++rapidButtonPresses;
            if (lastThread != null) {
                SerialLcdPage.lastThread.execute = false;
            }
            lastThread = new RapidPress();
            SerialLcdPage.lastThread.button = button;
            lastThread.start();
            return;
        }
        if (rapidButtonPresses > 1 && button != lastButtonPressed) {
            return;
        }
        if (!checkRapidPresses) {
            --rapidButtonPresses;
        }
        switch (button) {
            case 1: {
                this.button1Pressed(rapidButtonPresses);
                break;
            }
            case 2: {
                this.button2Pressed(rapidButtonPresses);
                break;
            }
            case 3: {
                this.button3Pressed(rapidButtonPresses);
                break;
            }
            case 4: {
                this.button4Pressed(rapidButtonPresses);
                break;
            }
            case 5: {
                this.buttonUpPressed(rapidButtonPresses);
                break;
            }
            case 6: {
                this.buttonDownPressed(rapidButtonPresses);
                break;
            }
            case 7: {
                this.buttonEnterPressed(rapidButtonPresses);
            }
        }
    }

    private boolean rapidPressDetected(int button) {
        if (!this.pageChecksForRapidPresses() || this.getNetwork().getRapidPressTime().getMillis() <= 0L) {
            return false;
        }
        long now = BAbsTime.now().getMillis();
        if (lastButtonPressed == button && now - lastPressTime > -1L && now - lastPressTime < this.getNetwork().getRapidPressTime().getMillis()) {
            lastPressTime = now;
            return ++requiredPresses >= this.getNetwork().getRapidPressCount();
        }
        requiredPresses = 0;
        lastPressTime = now;
        lastButtonPressed = button;
        rapidButtonPresses = 1;
        return false;
    }

    public BSerialLcdNetwork getNetwork() {
        if (this.network == null) {
            this.network = (BSerialLcdNetwork)Sys.getService((Type)BSerialLcdNetwork.TYPE);
        }
        return this.network;
    }

    public static void resetRapidButtonPresses() {
        rapidButtonPresses = 1;
    }

    static {
        requiredPresses = 0;
        lastButtonPressed = -1;
        lastPressTime = -1L;
        rapidButtonPresses = 1;
        ROW = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 255};
    }

    private class RapidPress
    extends Thread {
        int button;
        boolean execute = true;

        private RapidPress() {
        }

        @Override
        public void run() {
            try {
                RapidPress.sleep(SerialLcdPage.this.getNetwork().getRapidPressTime().getMillis() + 250L);
            }
            catch (Exception e) {
                System.out.println("LCD Error sleeping on RapidPress Thread");
                e.printStackTrace();
            }
            if (this.execute) {
                SerialLcdPage.this.buttonPressed(this.button, false);
            }
        }
    }
}

