/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.point.BSerialLcdPointExtension;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.util.ArrayUtil;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;

public class SerialLcdMainMenuPage
extends SerialLcdPage {
    private static String[] arMenuItems = new String[0];
    int curRow = 0;
    boolean hasAlarms = false;
    boolean hasSchedules = false;
    boolean hasSettings = false;

    public SerialLcdMainMenuPage(BSerialLcdNetwork network) {
        this.network = network;
    }

    public void updateMenu() {
        this.hasAlarms = false;
        this.hasSchedules = false;
        this.hasSettings = false;
        arMenuItems = new String[0];
        BOrd ordQuery = BOrd.make((String)"station:|slot:/|bql:select from lynxLCD:SerialLcdPointExtension");
        BITable result = (BITable)ordQuery.resolve((BObject)this.getNetwork()).get();
        TableCursor c = result.cursor();
        if (c.next()) {
            arMenuItems = (String[])ArrayUtil.addOne((Object[])arMenuItems, (Object)"points");
        }
        if ((c = (result = (BITable)(ordQuery = BOrd.make((String)"station:|slot:/|bql:select from lynxLCD:SerialLcdAlarmExtension")).resolve((BObject)this.getNetwork()).get()).cursor()).next()) {
            this.hasAlarms = true;
            arMenuItems = (String[])ArrayUtil.addOne((Object[])arMenuItems, (Object)"alarms");
        }
        if ((c = (result = (BITable)(ordQuery = BOrd.make((String)"station:|slot:/|bql:select from lynxLCD:SerialLcdScheduleExtension")).resolve((BObject)this.getNetwork()).get()).cursor()).next()) {
            this.hasSchedules = true;
            arMenuItems = (String[])ArrayUtil.addOne((Object[])arMenuItems, (Object)"scheduling");
        }
        if (this.getNetwork().getDisplaySystemSettings()) {
            this.hasSettings = true;
            arMenuItems = (String[])ArrayUtil.addOne((Object[])arMenuItems, (Object)"system");
        }
    }

    @Override
    public void displayPage() {
        this.getNetwork().setStallOutput(false);
        this.curRow = 0;
        try {
            if (arMenuItems.length == 0) {
                this.updateMenu();
            }
            if (arMenuItems.length == 1) {
                this.getNetwork().setHideMainMenu(true);
                if (this.hasAlarms) {
                    this.getNetwork().displayAlarmPage();
                } else if (this.hasSchedules) {
                    this.getNetwork().displaySchedulePage();
                } else if (this.hasSettings) {
                    this.getNetwork().displaySettingsPage();
                } else {
                    this.getNetwork().displayPage(0);
                }
                return;
            }
            this.getNetwork().setHideMainMenu(false);
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 0, 0, 1, 1, this.getNetwork().getMenuText()));
            for (int i = 0; i < arMenuItems.length; ++i) {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 3], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText(arMenuItems[i])));
            }
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void buttonDownPressed(int presses) {
        if (this.curRow < arMenuItems.length - 1) {
            try {
                Object[] commands = new SerialLcdCommand[]{};
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(false));
                ++this.curRow;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                System.err.println("Error getting next menu item - " + e.toString());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void buttonUpPressed(int presses) {
        if (this.curRow > 0) {
            try {
                Object[] commands = new SerialLcdCommand[]{};
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(false));
                --this.curRow;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)this.getUnderline(true));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                System.err.println("Error getting next menu item - " + e.toString());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void buttonEnterPressed(int presses) {
        if (arMenuItems[this.curRow].equals("points")) {
            this.getNetwork().displayPage(0);
        } else if (arMenuItems[this.curRow].equals("alarms")) {
            this.getNetwork().displayAlarmPage();
        } else if (arMenuItems[this.curRow].equals("scheduling")) {
            this.getNetwork().displaySchedulePage();
        } else if (this.getNetwork().getDisplaySystemSettings() && arMenuItems[this.curRow].equals("system")) {
            this.getNetwork().displaySettingsPage();
        }
    }

    private SerialLcdCommand getUnderline(boolean on) throws SerialLcdCommandException {
        if (this.curRow < 0) {
            this.curRow = 0;
        }
        if (this.curRow >= arMenuItems.length) {
            this.curRow = arMenuItems.length - 1;
        }
        return new SerialLcdLineCommand(0, (this.curRow + 3) * 8 + 7, BSerialLcdPointExtension.getPixelWidth(arMenuItems[this.curRow]), (this.curRow + 3) * 8 + 7, on);
    }
}

