/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdBoxCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.util.ArrayUtil;

public class SerialLcdDialogBox
extends SerialLcdPage {
    static final int OK = 0;
    static final int CANCEL = 1;
    static final int YES = 2;
    static final int NO = 3;
    static final int OK_CANCEL = 10;
    static final int YES_NO = 11;
    private int returnInt = -1;
    private int selectedOption = -1;
    private String[] options = new String[0];
    private String[] outputText = new String[0];
    SerialLcdPage prevPage;

    public SerialLcdDialogBox(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void button2Pressed(int presses) {
        if (this.options.length > 1 && this.selectedOption > 0) {
            try {
                Object[] commands = new SerialLcdCommand[]{};
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 70, 2, 1, 3, this.getLabel(this.options[this.selectedOption])));
                --this.selectedOption;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 45, 2, 2, 3, this.getLabel(this.options[this.selectedOption])));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                System.out.println("Could not select option:" + this.options[this.selectedOption]);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void button3Pressed(int presses) {
        if (this.options.length > 1 && this.selectedOption < this.options.length) {
            try {
                Object[] commands = new SerialLcdCommand[]{};
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 45, 2, 1, 3, this.getLabel(this.options[this.selectedOption])));
                ++this.selectedOption;
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 70, 2, 2, 3, this.getLabel(this.options[this.selectedOption])));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                System.out.println("Could not select option:" + this.options[this.selectedOption]);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void buttonEnterPressed(int presses) {
        this.prevPage.popupClosed(this.getReturnInt());
        this.getNetwork().setPageViaPopup(this.prevPage);
    }

    @Override
    public void displayPage() {
    }

    public void displayPage(int outputOptions, String[] outputText, SerialLcdPage prevPage) {
        this.setOptions(outputOptions);
        this.outputText = outputText;
        this.prevPage = prevPage;
        try {
            this.displayPopup();
        }
        catch (Exception e) {
            System.out.println("Cannot open PopUp Page");
            e.printStackTrace();
        }
    }

    public void displayPopup() throws Exception {
        Object[] commands = new SerialLcdCommand[]{};
        int x = 64;
        int y = 31;
        int w = 19;
        for (int n = 1; n < 24; ++n) {
            this.getNetwork().sendCommand(new SerialLcdLineCommand(63 - w, 31, 63 + w + 1, 31, false));
            this.getNetwork().sendCommand(new SerialLcdBoxCommand(x - n - w, y - n, x + n + w, y + n, false));
        }
        this.getNetwork().sendCommand(new SerialLcdLineCommand(0, 56, 26, 56, true));
        this.getNetwork().sendCommand(new SerialLcdLineCommand(0, 57, 26, 57, true));
        this.getNetwork().sendCommand(new SerialLcdLineCommand(0, 58, 26, 58, true));
        this.getNetwork().sendCommand(new SerialLcdLineCommand(0, 59, 26, 59, true));
        this.getNetwork().sendCommand(new SerialLcdLineCommand(0, 60, 26, 60, true));
        this.getNetwork().sendCommand(new SerialLcdLineCommand(0, 61, 26, 61, true));
        this.getNetwork().sendCommand(new SerialLcdLineCommand(0, 62, 26, 62, true));
        this.getNetwork().sendCommand(new SerialLcdLineCommand(0, 63, 26, 63, true));
        this.getNetwork().sendCommand(new SerialLcdBoxCommand(21, 7, 107, 56, true));
        this.selectedOption = 0;
        for (int i = 0; i < this.outputText.length; ++i) {
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 1], 25, 2, 1, 1, this.outputText[i]));
        }
        if (this.options.length > 1) {
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 45, 2, 2, 3, this.getLabel(this.options[0])));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 70, 2, 1, 3, this.getLabel(this.options[1])));
        } else {
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 0, 2, 2, 1, this.getLabel(this.options[0])));
        }
        this.getNetwork().sendCommands((SerialLcdCommand[])commands);
    }

    private String getLabel(String option) {
        return BSerialLcdNetwork.lex.getText(option);
    }

    public int getReturnInt() {
        if (this.options[this.selectedOption].equals("ok")) {
            this.returnInt = 0;
        } else if (this.options[this.selectedOption].equals("canc")) {
            this.returnInt = 1;
        } else if (this.options[this.selectedOption].equals("yes")) {
            this.returnInt = 2;
        } else if (this.options[this.selectedOption].equals("no")) {
            this.returnInt = 3;
        }
        return this.returnInt;
    }

    public void setOptions(int optionsSet) {
        this.options = new String[0];
        switch (optionsSet) {
            case 0: {
                this.options = (String[])ArrayUtil.addOne((Object[])this.options, (Object)"ok");
                break;
            }
            case 10: {
                this.options = (String[])ArrayUtil.addOne((Object[])this.options, (Object)"ok");
                this.options = (String[])ArrayUtil.addOne((Object[])this.options, (Object)"canc");
                break;
            }
            case 11: {
                this.options = (String[])ArrayUtil.addOne((Object[])this.options, (Object)"yes");
                this.options = (String[])ArrayUtil.addOne((Object[])this.options, (Object)"no");
                break;
            }
            default: {
                System.out.println("Invalid option passed to the Dialog Box");
                System.out.println("Option set to OK");
                this.options = (String[])ArrayUtil.addOne((Object[])this.options, (Object)"ok");
            }
        }
    }
}

