/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdBitmapCommand;
import com.lynxspring.lcd.command.SerialLcdBoxCommand;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.point.BSerialLcdPointExtension;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.util.ArrayUtil;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringWritable;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BEnumRange;

public class SerialLcdBasicPage
extends SerialLcdPage {
    private BSerialLcdPointExtension[] exts = new BSerialLcdPointExtension[0];
    private String pageName = BSerialLcdNetwork.lex.getText("page") + " #";
    private int topDisplayedRow = -1;
    private int currentActiveRow = -1;
    private boolean rowIsSelected = false;
    private boolean topArrowsDisplayed = false;
    private boolean bottomArrowsDisplayed = false;
    private int valueWidth;
    private final int CombinedRows6 = ROW[1] + ROW[2] + ROW[3] + ROW[4] + ROW[5] + ROW[6];

    public SerialLcdBasicPage(BSerialLcdNetwork network, String pageName) {
        this.network = network;
        this.pageName = pageName;
        this.valueWidth = this.getNetwork().getMaxValueWidth();
    }

    @Override
    public void displayPage() {
        this.topDisplayedRow = -1;
        this.bottomArrowsDisplayed = false;
        this.topArrowsDisplayed = false;
        this.displayPage(0);
    }

    private void displayPage(int newTop) {
        this.getNetwork().setStallOutput(false);
        if (newTop > this.exts.length - 6) {
            newTop = this.exts.length - 6;
        }
        if (newTop < 0) {
            newTop = 0;
        }
        try {
            Object[] commands = new SerialLcdCommand[]{};
            if (this.topDisplayedRow == -1) {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[0], 0, 2, 1, 1, this.pageName));
            }
            if (!this.topArrowsDisplayed && newTop != 0 || this.topArrowsDisplayed && newTop == 0) {
                this.topArrowsDisplayed = !this.topArrowsDisplayed;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
            }
            if (!this.bottomArrowsDisplayed && this.exts.length > 6 || this.bottomArrowsDisplayed && this.exts.length == newTop + 6) {
                this.bottomArrowsDisplayed = !this.bottomArrowsDisplayed;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
            }
            if (this.topDisplayedRow != -1) {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(this.CombinedRows6, 0, 127 - this.valueWidth));
            }
            for (int i = 0; i < (this.exts.length > 6 ? 6 : this.exts.length); ++i) {
                String labelName = this.exts[i + newTop].getLabelText();
                if (labelName.equals("$FRIENDLY_PARENT_NAME$")) {
                    labelName = TextUtil.toFriendly((String)this.exts[i + newTop].getParent().getParentComponent().getName());
                } else if (labelName.equals("$FRIENDLY_NAME$")) {
                    labelName = TextUtil.toFriendly((String)this.exts[i + newTop].getName());
                } else if (labelName.equals("$PARENT_DISPLAY_NAME$")) {
                    labelName = this.exts[i + newTop].getParent().getParentComponent().getDisplayName(null);
                } else if (labelName.equals("$DISPLAY_NAME$")) {
                    labelName = this.exts[i + newTop].getDisplayName(null);
                }
                if (labelName.length() > 25) {
                    labelName = labelName.substring(0, 25);
                }
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 1], 0, 2, 1, 0, labelName));
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[i + 1], 127 - this.valueWidth, 127));
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 1], 0, 2, 1, 2, this.exts[i + newTop].getValue()));
            }
            if (this.topDisplayedRow == -1) {
                this.currentActiveRow = 0;
                this.topDisplayedRow = 0;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
                this.rowIsSelected = false;
            }
            this.topDisplayedRow = newTop;
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            this.sendSoftButtons();
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    public void updateValues() {
        if (!this.rowIsSelected && this.topDisplayedRow > -1) {
            try {
                int i;
                Object[] commands = new SerialLcdCommand[]{};
                if (this.valueWidth < this.getNetwork().getMaxValueWidth()) {
                    for (i = 0; i < (this.exts.length > 6 ? 6 : this.exts.length); ++i) {
                        int tmpWidth = BSerialLcdPointExtension.getPixelWidth(this.exts[i + this.topDisplayedRow].getValue());
                        if (tmpWidth <= this.valueWidth) continue;
                        this.valueWidth = tmpWidth;
                    }
                }
                for (i = 0; i < (this.exts.length > 6 ? 6 : this.exts.length); ++i) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[i + 1], 127 - this.valueWidth, 127));
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 1], 0, 2, 1, 2, this.exts[i + this.topDisplayedRow].getValue()));
                }
                while (this.getNetwork().getStallOutput()) {
                    Thread.sleep(5L);
                }
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
            catch (Exception e) {
                System.err.println("Error Displaying Page - " + e.toString());
                e.printStackTrace();
            }
        }
    }

    public void clearPage() {
        try {
            this.getNetwork().setStallOutput(false);
            ((BSerialLcdNetwork)this.getNetwork().getNetwork()).sendCommand(new SerialLcdClearCommand(ROW[8], 0, 127));
        }
        catch (Exception e) {
            System.err.println("Error Clearing Page - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void buttonDownPressed(int presses) {
        if (this.getRowIsSelected()) {
            this.getNextValue();
        } else {
            this.gotoNextRow(presses);
        }
    }

    private void getNextValue() {
        this.updateCurrentValue(this.getCurrentRow().getNextValue());
    }

    private void gotoNextRow(int presses) {
        if (this.currentActiveRow < this.exts.length - 1) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                if (!this.bottomArrowsDisplayed || this.bottomArrowsDisplayed && this.currentActiveRow + (presses - 1) < this.topDisplayedRow + 5) {
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSolidUnderline(this.currentActiveRow - this.topDisplayedRow + 1, false));
                    this.currentActiveRow += presses;
                    if (this.currentActiveRow > this.exts.length - 1) {
                        this.currentActiveRow = this.exts.length - 1;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
                } else {
                    this.displayPage(this.topDisplayedRow + presses);
                    this.currentActiveRow += presses;
                    if (this.currentActiveRow > this.exts.length - 1) {
                        this.currentActiveRow = this.exts.length - 1;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
                }
            }
            catch (Exception e) {
                System.err.println("Error navigating rows (" + this.currentActiveRow + " : " + this.topDisplayedRow + " : " + presses + ") - " + e.toString());
                e.printStackTrace();
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
    }

    @Override
    public void buttonUpPressed(int presses) {
        if (this.getRowIsSelected()) {
            this.getPrevValue();
        } else {
            this.gotoPrevRow(presses);
        }
    }

    private void getPrevValue() {
        this.updateCurrentValue(this.getCurrentRow().getPrevValue());
    }

    private void gotoPrevRow(int presses) {
        if (this.currentActiveRow > 0) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                if (this.currentActiveRow - (presses - 1) > this.topDisplayedRow) {
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSolidUnderline(this.currentActiveRow - this.topDisplayedRow + 1, false));
                    this.currentActiveRow -= presses;
                    if (this.currentActiveRow < 0) {
                        this.currentActiveRow = 0;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
                } else {
                    this.displayPage(this.topDisplayedRow - presses);
                    this.currentActiveRow -= presses;
                    if (this.currentActiveRow < 0) {
                        this.currentActiveRow = 0;
                    }
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
                }
            }
            catch (Exception e) {
                System.err.println("Error navigating rows (" + this.currentActiveRow + " : " + this.topDisplayedRow + " : " + presses + ") - " + e.toString());
                e.printStackTrace();
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
    }

    @Override
    public void buttonEnterPressed(int presses) {
        if (this.getRowIsSelected()) {
            this.saveValue();
        } else {
            this.selectPoint();
        }
    }

    private void saveValue() {
        try {
            boolean outOfRange = this.getCurrentRow().setValue();
            if (outOfRange) {
                String[] minMax = this.getCurrentRow().getMinMax();
                this.getNetwork().openDialog(0, BSerialLcdNetwork.lex.getText("rangeError", (Object[])new String[]{minMax[0], minMax[1]}));
            }
            Object[] tmpCommands = new SerialLcdCommand[]{};
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdClearCommand(ROW[this.currentActiveRow - this.topDisplayedRow + 1], 127 - this.getCurrentRow().getValueWidth(), 127));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow - this.topDisplayedRow + 1], 0, 2, 1, 2, this.getCurrentRow().getValue()));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])this.getPointUnderline(this.currentActiveRow - this.topDisplayedRow + 1, false));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdLineCommand(0, (this.currentActiveRow - this.topDisplayedRow + 1) * 8 + 7, 127 - this.valueWidth, (this.currentActiveRow - this.topDisplayedRow + 1) * 8 + 7, true));
            this.rowIsSelected = false;
            this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
            this.sendSoftButtons();
        }
        catch (Exception e) {
            System.err.println("Error saving value - " + e.toString());
            e.printStackTrace();
        }
    }

    private void selectPoint() {
        if (!(!this.getCurrentRow().getWritable() || this.getCurrentRow().getParent().getParentComponent() instanceof BEnumWritable && ((BEnumRange)((BControlPoint)this.getCurrentRow().getParent().getParentComponent()).getFacets().get("range")).isNull())) {
            try {
                this.getCurrentRow().selected();
                Object[] tmpCommands = new SerialLcdCommand[]{};
                tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdClearCommand(ROW[this.currentActiveRow - this.topDisplayedRow + 1], 127 - this.getCurrentRow().getValueWidth(), 127));
                tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow - this.topDisplayedRow + 1], 0, 2, 1, 2, this.getCurrentRow().getValue()));
                tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])this.getPointUnderline(this.currentActiveRow - this.topDisplayedRow + 1, true));
                this.rowIsSelected = true;
                this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
                this.sendSoftButtons();
            }
            catch (Exception e) {
                System.err.println("Error selecting point - " + e.toString());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void button1Pressed(int presses) {
        if (this.getRowIsSelected()) {
            if (this.getCurrentRow().getAllowNull()) {
                this.saveValueNull();
            }
        } else if (!this.getNetwork().getHideMainMenu()) {
            this.getNetwork().displayMenuPage();
        }
    }

    private void saveValueNull() {
        try {
            this.getCurrentRow().setNull();
            Object[] tmpCommands = new SerialLcdCommand[]{};
            tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])this.getPointUnderline(this.currentActiveRow - this.topDisplayedRow + 1, false));
            this.rowIsSelected = false;
            this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
            this.sendSoftButtons();
            this.updateValues();
        }
        catch (Exception e) {
            System.err.println("Error saving value to null - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button2Pressed(int presses) {
        if (this.getRowIsSelected()) {
            this.moveCursorLeft();
        } else {
            this.getNetwork().gotoPrevPage(presses);
        }
    }

    private void moveCursorLeft() {
        try {
            if (!this.getCurrentRow().getCurrentValue().equals(this.getCurrentRow().moveCharLeft())) {
                this.updateCurrentValue(this.getCurrentRow().getCurrentValue());
            } else {
                this.getNetwork().sendCommands(this.getPointUnderline(this.currentActiveRow - this.topDisplayedRow + 1, true));
            }
        }
        catch (Exception e) {
            System.err.println("Error moving cursor left - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button3Pressed(int presses) {
        if (this.getRowIsSelected()) {
            this.moveCursorRight();
        } else {
            this.getNetwork().gotoNextPage(presses);
        }
    }

    private void moveCursorRight() {
        try {
            if (!this.getCurrentRow().getCurrentValue().equals(this.getCurrentRow().moveCharRight())) {
                this.updateCurrentValue(this.getCurrentRow().getCurrentValue());
            } else {
                this.getNetwork().sendCommands(this.getPointUnderline(this.currentActiveRow - this.topDisplayedRow + 1, true));
            }
        }
        catch (Exception e) {
            System.err.println("Error moving cursor right - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button4Pressed(int presses) {
        if (this.getRowIsSelected()) {
            this.cancelSelection();
        } else {
            this.getNetwork().gotoLastPage();
        }
    }

    @Override
    public boolean pageChecksForRapidPresses() {
        return true;
    }

    private void cancelSelection() {
        try {
            this.getCurrentRow().canceled();
            Object[] tmpCommands = new SerialLcdCommand[]{};
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdClearCommand(ROW[this.currentActiveRow - this.topDisplayedRow + 1], 127 - this.valueWidth, 127));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow - this.topDisplayedRow + 1], 0, 2, 1, 2, this.getCurrentRow().getValue()));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])this.getPointUnderline(this.currentActiveRow - this.topDisplayedRow + 1, false));
            this.rowIsSelected = false;
            this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
            this.sendSoftButtons();
        }
        catch (Exception e) {
            System.err.println("Error saving value - " + e.toString());
            e.printStackTrace();
        }
    }

    private void sendSoftButtons() throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        boolean buttons2And3 = true;
        if (this.getRowIsSelected() && !(this.getCurrentRow().getParent().getParentComponent() instanceof BNumericWritable) && !(this.getCurrentRow().getParent().getParentComponent() instanceof BStringWritable)) {
            buttons2And3 = false;
        }
        boolean display = this.getRowIsSelected() ? this.getCurrentRow().getAllowNull() : !this.getNetwork().getHideMainMenu();
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, display), new SerialLcdLineCommand(0, 57, 26, 57, display), new SerialLcdLineCommand(0, 58, 26, 58, display), new SerialLcdLineCommand(0, 59, 26, 59, display), new SerialLcdLineCommand(0, 60, 26, 60, display), new SerialLcdLineCommand(0, 61, 26, 61, display), new SerialLcdLineCommand(0, 62, 26, 62, display), new SerialLcdLineCommand(0, 63, 26, 63, display)});
        if (this.getRowIsSelected() && this.getCurrentRow().getAllowNull()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("null")));
        } else if (!this.getNetwork().getHideMainMenu() && !this.getRowIsSelected()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("menu")));
        }
        this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
        tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(34, 56, 60, 56, buttons2And3), new SerialLcdLineCommand(34, 57, 60, 57, buttons2And3), new SerialLcdLineCommand(34, 58, 60, 58, buttons2And3), new SerialLcdLineCommand(34, 59, 60, 59, buttons2And3), new SerialLcdLineCommand(34, 60, 60, 60, buttons2And3), new SerialLcdLineCommand(34, 61, 60, 61, buttons2And3), new SerialLcdLineCommand(34, 62, 60, 62, buttons2And3), new SerialLcdLineCommand(34, 63, 60, 63, buttons2And3)});
        if (this.getRowIsSelected() && (this.getCurrentRow().getParent().getParentComponent() instanceof BNumericWritable || this.getCurrentRow().getParent().getParentComponent() instanceof BStringWritable)) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 46, 2, 2, 3, BSerialLcdNetwork.lex.getText("less")));
        } else if (!this.getRowIsSelected()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 37, 2, 2, 3, BSerialLcdNetwork.lex.getText("prev")));
        }
        this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
        tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(68, 56, 94, 56, buttons2And3), new SerialLcdLineCommand(68, 57, 94, 57, buttons2And3), new SerialLcdLineCommand(68, 58, 94, 58, buttons2And3), new SerialLcdLineCommand(68, 59, 94, 59, buttons2And3), new SerialLcdLineCommand(68, 60, 94, 60, buttons2And3), new SerialLcdLineCommand(68, 61, 94, 61, buttons2And3), new SerialLcdLineCommand(68, 62, 94, 62, buttons2And3), new SerialLcdLineCommand(68, 63, 94, 63, buttons2And3)});
        if (this.getRowIsSelected() && (this.getCurrentRow().getParent().getParentComponent() instanceof BNumericWritable || this.getCurrentRow().getParent().getParentComponent() instanceof BStringWritable)) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 81, 2, 2, 3, BSerialLcdNetwork.lex.getText("more")));
        } else if (!this.getRowIsSelected()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 71, 2, 2, 3, BSerialLcdNetwork.lex.getText("next")));
        }
        this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
        tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(102, 56, 127, 56, true), new SerialLcdLineCommand(102, 57, 127, 57, true), new SerialLcdLineCommand(102, 58, 127, 58, true), new SerialLcdLineCommand(102, 59, 127, 59, true), new SerialLcdLineCommand(102, 60, 127, 60, true), new SerialLcdLineCommand(102, 61, 127, 61, true), new SerialLcdLineCommand(102, 62, 127, 62, true), new SerialLcdLineCommand(102, 63, 127, 63, true)});
        tmpCommands = this.getRowIsSelected() ? (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 105, 2, 2, 3, BSerialLcdNetwork.lex.getText("cancel"))) : (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 106, 2, 2, 3, BSerialLcdNetwork.lex.getText("last")));
        this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
    }

    protected void updateCurrentValue(String value) {
        try {
            int tmpWidth = BSerialLcdPointExtension.getPixelWidth(value);
            if (tmpWidth <= this.getNetwork().getMaxValueWidth() && tmpWidth > this.valueWidth) {
                this.valueWidth = tmpWidth;
            }
            Object[] tmpCommands = new SerialLcdCommand[]{};
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdClearCommand(ROW[this.currentActiveRow - this.topDisplayedRow + 1], 127 - this.valueWidth, 127));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow - this.topDisplayedRow + 1], 0, 2, 1, 2, value));
            tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])this.getPointUnderline(this.currentActiveRow - this.topDisplayedRow + 1, true));
            this.getNetwork().sendCommands((SerialLcdCommand[])tmpCommands);
        }
        catch (Exception e) {
            System.err.println("Error getting next value - " + e.toString());
            e.printStackTrace();
        }
    }

    private boolean isPointWritable() {
        return this.getCurrentRow().getWritable() && (!(this.getCurrentRow().getParent().getParentComponent() instanceof BEnumWritable) || !((BEnumRange)((BControlPoint)this.getCurrentRow().getParent().getParentComponent()).getFacets().get("range")).isNull());
    }

    private SerialLcdCommand[] drawUnderline() throws SerialLcdCommandException {
        if (this.isPointWritable()) {
            return this.getSolidUnderline(this.currentActiveRow - this.topDisplayedRow + 1, true);
        }
        return this.getDottedUnderline(this.currentActiveRow - this.topDisplayedRow + 1, true);
    }

    private SerialLcdCommand[] getPointUnderline(int row, boolean on) throws SerialLcdCommandException {
        Object[] s = new SerialLcdCommand[]{new SerialLcdLineCommand(0, row * 8 + 7, 127, row * 8 + 7, on)};
        if (on && (this.getCurrentRow().getParent().getParentComponent() instanceof BStringWritable || this.getCurrentRow().getParent().getParentComponent() instanceof BNumericWritable)) {
            int start = 122;
            int stop = 125;
            if (!(this.getCurrentRow().getParent().getParentComponent() instanceof BStringWritable) || this.getCurrentRow().getCharIndex() >= 0) {
                start = 131 - BSerialLcdPointExtension.getPixelWidth(this.getCurrentRow().getCurrentValue().substring(this.getCurrentRow().getCharIndex()));
                stop = start + BSerialLcdPointExtension.getCharWidth(this.getCurrentRow().getCurrentValue().charAt(this.getCurrentRow().getCharIndex())) - 2;
            }
            if (start < 127) {
                if (stop > 127) {
                    stop = 127;
                }
                s = (SerialLcdCommand[])ArrayUtil.addOne((Object[])s, (Object)new SerialLcdLineCommand(start, row * 8 + 7, stop, row * 8 + 7, false));
            }
        }
        return s;
    }

    private SerialLcdCommand[] getSolidUnderline(int row, boolean on) throws SerialLcdCommandException {
        return new SerialLcdCommand[]{new SerialLcdLineCommand(0, row * 8 + 7, 127 - this.valueWidth - 1, row * 8 + 7, on)};
    }

    private SerialLcdCommand[] getDottedUnderline(int row, boolean on) throws SerialLcdCommandException {
        Object[] command = new SerialLcdCommand[]{new SerialLcdLineCommand(4, row * 8 + 7, 7, row * 8 + 7, on), new SerialLcdLineCommand(12, row * 8 + 7, 15, row * 8 + 7, on), new SerialLcdLineCommand(20, row * 8 + 7, 23, row * 8 + 7, on), new SerialLcdLineCommand(28, row * 8 + 7, 31, row * 8 + 7, on), new SerialLcdLineCommand(36, row * 8 + 7, 39, row * 8 + 7, on), new SerialLcdLineCommand(44, row * 8 + 7, 47, row * 8 + 7, on), new SerialLcdLineCommand(52, row * 8 + 7, 55, row * 8 + 7, on)};
        if (this.valueWidth < 64) {
            command = (SerialLcdCommand[])ArrayUtil.addOne((Object[])command, (Object)new SerialLcdLineCommand(60, row * 8 + 7, 63, row * 8 + 7, on));
        }
        if (this.valueWidth < 56) {
            command = (SerialLcdCommand[])ArrayUtil.addOne((Object[])command, (Object)new SerialLcdLineCommand(68, row * 8 + 7, 71, row * 8 + 7, on));
        }
        if (this.valueWidth < 48) {
            command = (SerialLcdCommand[])ArrayUtil.addOne((Object[])command, (Object)new SerialLcdLineCommand(76, row * 8 + 7, 79, row * 8 + 7, on));
        }
        if (this.valueWidth < 40) {
            command = (SerialLcdCommand[])ArrayUtil.addOne((Object[])command, (Object)new SerialLcdLineCommand(84, row * 8 + 7, 87, row * 8 + 7, on));
        }
        if (this.valueWidth < 32) {
            command = (SerialLcdCommand[])ArrayUtil.addOne((Object[])command, (Object)new SerialLcdLineCommand(92, row * 8 + 7, 95, row * 8 + 7, on));
        }
        if (this.valueWidth < 24) {
            command = (SerialLcdCommand[])ArrayUtil.addOne((Object[])command, (Object)new SerialLcdLineCommand(100, row * 8 + 7, 103, row * 8 + 7, on));
        }
        return command;
    }

    private SerialLcdCommand[] getTopArrows() throws SerialLcdCommandException {
        if (this.topArrowsDisplayed) {
            if (this.pageName.length() < 11) {
                return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 16, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 29, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 94, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 107, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 37, 4, true), new SerialLcdLineCommand(91, 4, 127, 4, true)};
            }
            if (this.pageName.length() < 16) {
                return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 16, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 107, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 24, 4, true), new SerialLcdLineCommand(104, 4, 127, 4, true)};
            }
            return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 11, 4, true), new SerialLcdLineCommand(117, 4, 127, 4, true)};
        }
        if (this.pageName.length() < 11) {
            return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 37), new SerialLcdClearCommand(ROW[0], 91, 127), new SerialLcdLineCommand(0, 4, 37, 4, false), new SerialLcdLineCommand(91, 4, 127, 4, false)};
        }
        if (this.pageName.length() < 16) {
            return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 24), new SerialLcdClearCommand(ROW[0], 104, 127), new SerialLcdLineCommand(0, 4, 24, 4, false), new SerialLcdLineCommand(104, 4, 127, 4, false)};
        }
        return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 11), new SerialLcdClearCommand(ROW[0], 117, 127), new SerialLcdLineCommand(0, 4, 11, 4, false), new SerialLcdLineCommand(117, 4, 127, 4, false)};
    }

    private SerialLcdCommand[] getBottomArrows() throws SerialLcdCommandException {
        if (this.bottomArrowsDisplayed) {
            return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[7], 28, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 62, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 96, "2060E06020")};
        }
        return new SerialLcdCommand[]{new SerialLcdBoxCommand(28, 56, 32, 63, false), new SerialLcdBoxCommand(29, 57, 31, 62, false), new SerialLcdLineCommand(30, 58, 30, 61, false), new SerialLcdBoxCommand(62, 56, 66, 63, false), new SerialLcdBoxCommand(63, 57, 65, 62, false), new SerialLcdLineCommand(64, 58, 64, 61, false), new SerialLcdBoxCommand(96, 56, 99, 63, false), new SerialLcdBoxCommand(97, 57, 100, 62, false), new SerialLcdLineCommand(98, 58, 98, 61, false)};
    }

    public boolean getRowIsSelected() {
        return this.rowIsSelected;
    }

    public BSerialLcdPointExtension getCurrentRow() {
        return this.exts[this.currentActiveRow];
    }

    public void addExtension(BSerialLcdPointExtension ext) {
        this.exts = (BSerialLcdPointExtension[])ArrayUtil.addOne((Object[])this.exts, (Object)((Object)ext));
    }

    public void setValueWidth(int value) {
        this.valueWidth = value;
    }

    @Override
    public void popupClosed(int popupReturn) {
        int topRow = this.topDisplayedRow;
        this.displayPage(topRow);
    }
}

