/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdBitmapCommand;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.point.BSerialLcdAlarmExtension;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.util.ArrayUtil;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;

public class SerialLcdAlarmPage
extends SerialLcdPage {
    private BSerialLcdAlarmExtension[] exts = new BSerialLcdAlarmExtension[0];
    private int currentActiveRow = -1;
    int intFirstArrayItemToDisplay = -1;
    int intArrayItemDisplayedOnCurrentRow = -1;
    private boolean rowIsSelected = false;
    private String pageName = BSerialLcdNetwork.lex.getText("alarmMenu");

    public SerialLcdAlarmPage(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void displayPage() {
        this.intFirstArrayItemToDisplay = -1;
        this.displayPage(0);
    }

    public void displayPageForFirstTime() {
        this.getNetwork().setStallOutput(false);
        try {
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[0], 0, 2, 1, 1, this.pageName));
            BOrd ordQuery = BOrd.make((String)"station:|slot:/|bql:select from lynxLCD:SerialLcdAlarmExtension");
            BITable result = (BITable)ordQuery.resolve((BObject)this.network).get();
            TableCursor c = result.cursor();
            this.exts = new BSerialLcdAlarmExtension[0];
            while (c.next()) {
                this.exts = (BSerialLcdAlarmExtension[])ArrayUtil.addOne((Object[])this.exts, (Object)((Object)((BSerialLcdAlarmExtension)((Object)c.get()))));
            }
            String strDisplayName = "";
            if (this.exts.length > 6) {
                for (int i = 0; i < 6; ++i) {
                    strDisplayName = this.exts[i].getParent().getDisplayName(null).length() > 25 ? this.exts[i].getParent().getDisplayName(null).substring(0, 24) : this.exts[i].getParent().getDisplayName(null);
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 1], 0, 2, 1, 0, strDisplayName));
                }
            } else {
                for (int i = 0; i < this.exts.length; ++i) {
                    strDisplayName = this.exts[i].getParent().getDisplayName(null).length() > 25 ? this.exts[i].getParent().getDisplayName(null).substring(0, 24) : this.exts[i].getParent().getDisplayName(null);
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 1], 0, 2, 1, 0, strDisplayName));
                }
            }
            this.currentActiveRow = 1;
            this.intFirstArrayItemToDisplay = 0;
            this.intArrayItemDisplayedOnCurrentRow = 0;
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
            this.rowIsSelected = false;
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(1, true));
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    public void displayPage(int newTop) {
        this.getNetwork().setStallOutput(false);
        try {
            Object[] commands = new SerialLcdCommand[]{};
            if (this.intFirstArrayItemToDisplay == -1) {
                this.displayPageForFirstTime();
            } else {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[1] + ROW[2] + ROW[3] + ROW[4] + ROW[5] + ROW[6], 0, 127));
                this.intFirstArrayItemToDisplay = this.intFirstArrayItemToDisplay > this.exts.length - 1 ? this.exts.length - 6 : newTop;
                this.currentActiveRow = 1;
                this.intArrayItemDisplayedOnCurrentRow = this.intFirstArrayItemToDisplay;
                for (int i = this.intFirstArrayItemToDisplay; i < this.intFirstArrayItemToDisplay + 6; ++i) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow], 0, 2, 1, 0, this.exts[i].getParent().getDisplayName(null)));
                    ++this.currentActiveRow;
                    ++this.intArrayItemDisplayedOnCurrentRow;
                }
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, true));
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button1Pressed(int presses) {
        if (!this.getNetwork().getHideMainMenu()) {
            this.getNetwork().displayMenuPage();
        }
    }

    @Override
    public void button4Pressed(int presses) {
        this.getNetwork().displaySchedDetailsPage(this.exts[this.intArrayItemDisplayedOnCurrentRow].getParent());
    }

    @Override
    public void buttonDownPressed(int presses) {
        try {
            if (this.getRowIsSelected()) {
                this.getNextValue();
            } else if (this.intArrayItemDisplayedOnCurrentRow < this.exts.length - 1) {
                if (this.currentActiveRow > 5) {
                    this.redrawList("Down");
                } else {
                    this.gotoNextRow();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error getting next menu item - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void buttonUpPressed(int presses) {
        try {
            if (this.currentActiveRow <= 1 && this.intFirstArrayItemToDisplay > 0) {
                this.redrawList("up");
            } else if (this.currentActiveRow > 1) {
                this.gotoPreviousRow();
            }
        }
        catch (Exception e) {
            System.err.println("Error getting next menu item - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void buttonEnterPressed(int presses) {
        this.getNetwork().displayAlarmConsolePage((BConsoleRecipient)this.exts[this.intArrayItemDisplayedOnCurrentRow].getParent());
    }

    private void gotoPreviousRow() {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.currentActiveRow > 1) {
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, false));
                --this.currentActiveRow;
                --this.intArrayItemDisplayedOnCurrentRow;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, true));
            } else {
                this.displayPage(this.intFirstArrayItemToDisplay - 1);
                this.currentActiveRow = 1;
                --this.intArrayItemDisplayedOnCurrentRow;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, true));
            }
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error navigating rows - " + e.toString());
            e.printStackTrace();
        }
    }

    private void gotoNextRow() {
        Object[] commands = new SerialLcdCommand[]{};
        try {
            if (this.currentActiveRow < 6) {
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, false));
                ++this.currentActiveRow;
                ++this.intArrayItemDisplayedOnCurrentRow;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, true));
            } else {
                ++this.intFirstArrayItemToDisplay;
                this.displayPage(this.intFirstArrayItemToDisplay);
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, true));
            }
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error navigating rows - " + e.toString());
            e.printStackTrace();
        }
    }

    private void redrawList(String strDirection) {
        try {
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[1] + ROW[2] + ROW[3] + ROW[4] + ROW[5] + ROW[6], 0, 127));
            if (strDirection.equals("up")) {
                if (this.intFirstArrayItemToDisplay > 0) {
                    --this.intFirstArrayItemToDisplay;
                }
            } else if (this.intFirstArrayItemToDisplay < this.exts.length - 6) {
                ++this.intFirstArrayItemToDisplay;
            }
            this.currentActiveRow = 1;
            this.intArrayItemDisplayedOnCurrentRow = this.intFirstArrayItemToDisplay;
            for (int i = this.intFirstArrayItemToDisplay; i < this.intFirstArrayItemToDisplay + 6; ++i) {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow], 0, 2, 1, 0, this.exts[i].getParent().getDisplayName(null)));
                ++this.currentActiveRow;
                ++this.intArrayItemDisplayedOnCurrentRow;
            }
            if (strDirection.equals("up")) {
                this.currentActiveRow = 1;
                this.intArrayItemDisplayedOnCurrentRow = this.intFirstArrayItemToDisplay;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, true));
            } else {
                this.currentActiveRow = 6;
                this.intArrayItemDisplayedOnCurrentRow = this.intFirstArrayItemToDisplay + 5;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, true));
            }
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error navigating rows - " + e.toString());
            e.printStackTrace();
        }
    }

    private void getNextValue() {
    }

    private SerialLcdCommand[] getUnderline(int row, boolean on) throws SerialLcdCommandException {
        return new SerialLcdCommand[]{new SerialLcdLineCommand(0, row * 8 + 7, 80, row * 8 + 7, on)};
    }

    private SerialLcdCommand[] getSoftButtons() throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 57, 26, 57, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 58, 26, 58, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 59, 26, 59, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 60, 26, 60, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 61, 26, 61, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 62, 26, 62, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 63, 26, 63, !this.getNetwork().getHideMainMenu())});
        if (!this.getNetwork().getHideMainMenu()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("menu")));
        }
        return tmpCommands;
    }

    private SerialLcdCommand[] getTopArrows() throws SerialLcdCommandException {
        if (this.intFirstArrayItemToDisplay > 0) {
            if (this.pageName.length() < 11) {
                return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 16, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 29, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 94, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 107, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 37, 4, true), new SerialLcdLineCommand(91, 4, 127, 4, true)};
            }
            if (this.pageName.length() < 16) {
                return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 16, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 107, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 24, 4, true), new SerialLcdLineCommand(104, 4, 127, 4, true)};
            }
            return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 11, 4, true), new SerialLcdLineCommand(117, 4, 127, 4, true)};
        }
        if (this.pageName.length() < 11) {
            return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 37), new SerialLcdClearCommand(ROW[0], 91, 127)};
        }
        if (this.pageName.length() < 16) {
            return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 24), new SerialLcdClearCommand(ROW[0], 104, 127)};
        }
        return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 11), new SerialLcdClearCommand(ROW[0], 117, 127)};
    }

    private SerialLcdCommand[] getBottomArrows() throws SerialLcdCommandException {
        if (this.intFirstArrayItemToDisplay < this.exts.length - 6) {
            return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[7], 29, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 42, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 55, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 68, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 81, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 94, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 107, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 120, "2060E06020"), new SerialLcdLineCommand(28, 58, 127, 58, true)};
        }
        return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[7], 28, 127)};
    }

    public boolean getRowIsSelected() {
        return this.rowIsSelected;
    }

    public void updateValues() {
        if (!this.rowIsSelected && this.intFirstArrayItemToDisplay > -1) {
            try {
                SerialLcdCommand[] commands = new SerialLcdCommand[]{};
                this.getNetwork().sendCommands(commands);
            }
            catch (Exception e) {
                System.err.println("Error Displaying Page - " + e.toString());
                e.printStackTrace();
            }
        }
    }
}

