/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.util.ArrayUtil;
import java.io.IOException;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class SerialLcdAlarmDetailsPage
extends SerialLcdPage {
    int intFirstArrayItemToDisplay = -1;
    String[] arrAlarmTitles = new String[1];
    private String pageName = BSerialLcdNetwork.lex.getText("alarmDetails");
    private BAlarmRecord almAlarm;
    BConsoleRecipient consoleRecipient;

    public SerialLcdAlarmDetailsPage(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void displayPage() {
    }

    public void displayPage(BAlarmRecord alarm, BConsoleRecipient consoleRecipient) {
        this.intFirstArrayItemToDisplay = -1;
        this.almAlarm = alarm;
        this.consoleRecipient = consoleRecipient;
        this.displayPageForFirstTime();
    }

    public void displayPageForFirstTime() {
        try {
            String strAckState;
            String strMessage;
            String strTimeStamp;
            String strSourceState;
            String strSource;
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[0], 0, 2, 1, 1, this.pageName));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("source")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("state")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("time")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[5], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("message")));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 0, 2, 1, 0, BSerialLcdNetwork.lex.getText("ackInfor")));
            String string = strSource = this.almAlarm.getAlarmData().get("sourceName") != null ? this.almAlarm.getAlarmData().get("sourceName").toString() : BSerialLcdNetwork.lex.getText("noSource");
            if (strSource.length() > 17) {
                strSource = strSource.substring(0, 17);
            }
            String string2 = strSourceState = this.almAlarm.getSourceState().toString() != null ? this.almAlarm.getSourceState().toString() : BSerialLcdNetwork.lex.getText("noState");
            if (strSourceState.length() > 17) {
                strSourceState = strSourceState.substring(0, 17);
            }
            String string3 = strTimeStamp = this.almAlarm.getTimestamp().toString() != null ? this.almAlarm.getTimestamp().toString() : BSerialLcdNetwork.lex.getText("noTime");
            if (strTimeStamp.length() > 17) {
                strTimeStamp = strTimeStamp.substring(0, 17);
            }
            String string4 = strMessage = this.almAlarm.getAlarmData().get("msgText") != null && this.almAlarm.getAlarmData().get("msgText").toString().length() > 0 ? this.almAlarm.getAlarmData().get("msgText").toString() : BSerialLcdNetwork.lex.getText("none");
            if (strMessage.length() > 17) {
                strMessage = strMessage.substring(0, 17);
            }
            String string5 = strAckState = this.almAlarm.getAckState().toString() != null ? this.almAlarm.getAckState().toString() : BSerialLcdNetwork.lex.getText("none");
            if (strAckState.length() > 17) {
                strAckState = strAckState.substring(0, 17);
            }
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[2], 43, 2, 1, 3, strSource));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 43, 2, 1, 3, strSourceState));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 43, 2, 1, 3, strTimeStamp));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[5], 43, 2, 1, 3, strMessage));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[6], 43, 2, 1, 3, strAckState));
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button1Pressed(int presses) {
        if (!this.getNetwork().getHideMainMenu()) {
            this.getNetwork().displayMenuPage();
        }
    }

    @Override
    public void button2Pressed(int presses) {
        if (this.almAlarm.getAckRequired() && !this.almAlarm.getAckState().toString().equals("Acked")) {
            try {
                BAbsTime time = Clock.time();
                this.almAlarm.ackAlarm("LCD");
                this.almAlarm.setAckTime(time);
                this.almAlarm.setLastUpdate(time);
                ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).getAlarmDb().getDbConnection(null).update(this.almAlarm);
                ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).ackAlarm(this.almAlarm);
            }
            catch (AlarmException e) {
                e.printStackTrace();
            }
            catch (ServiceNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getNetwork().displayAlarmConsolePage(this.consoleRecipient);
        }
    }

    @Override
    public void button3Pressed(int presses) {
        try {
            BAbsTime time = Clock.time();
            this.almAlarm.ackAlarm("LCD");
            this.almAlarm.setAckTime(time);
            this.almAlarm.setLastUpdate(time);
            this.almAlarm.setSourceState(BSourceState.normal);
            ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).getAlarmDb().getDbConnection(null).update(this.almAlarm);
            ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).ackAlarm(this.almAlarm);
        }
        catch (AlarmException e) {
            e.printStackTrace();
        }
        catch (ServiceNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getNetwork().displayAlarmConsolePage(this.consoleRecipient);
    }

    @Override
    public void button4Pressed(int presses) {
        this.getNetwork().displayAlarmConsolePage(this.consoleRecipient);
    }

    private SerialLcdCommand[] getSoftButtons() throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 57, 26, 57, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 58, 26, 58, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 59, 26, 59, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 60, 26, 60, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 61, 26, 61, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 62, 26, 62, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 63, 26, 63, !this.getNetwork().getHideMainMenu())});
        if (!this.getNetwork().getHideMainMenu()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("menu")));
        }
        if (this.almAlarm.getAckRequired() && !this.almAlarm.getAckState().toString().equals("Acked")) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(34, 56, 60, 56, true), new SerialLcdLineCommand(34, 57, 60, 57, true), new SerialLcdLineCommand(34, 58, 60, 58, true), new SerialLcdLineCommand(34, 59, 60, 59, true), new SerialLcdLineCommand(34, 60, 60, 60, true), new SerialLcdLineCommand(34, 61, 60, 61, true), new SerialLcdLineCommand(34, 62, 60, 62, true), new SerialLcdLineCommand(34, 63, 60, 63, true)});
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 40, 2, 2, 3, BSerialLcdNetwork.lex.getText("ack")));
        }
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(68, 56, 94, 56, true), new SerialLcdLineCommand(68, 57, 94, 57, true), new SerialLcdLineCommand(68, 58, 94, 58, true), new SerialLcdLineCommand(68, 59, 94, 59, true), new SerialLcdLineCommand(68, 60, 94, 60, true), new SerialLcdLineCommand(68, 61, 94, 61, true), new SerialLcdLineCommand(68, 62, 94, 62, true), new SerialLcdLineCommand(68, 63, 94, 63, true)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 70, 2, 2, 3, BSerialLcdNetwork.lex.getText("clear")));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(102, 56, 127, 56, true), new SerialLcdLineCommand(102, 57, 127, 57, true), new SerialLcdLineCommand(102, 58, 127, 58, true), new SerialLcdLineCommand(102, 59, 127, 59, true), new SerialLcdLineCommand(102, 60, 127, 60, true), new SerialLcdLineCommand(102, 61, 127, 61, true), new SerialLcdLineCommand(102, 62, 127, 62, true), new SerialLcdLineCommand(102, 63, 127, 63, true)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 105, 2, 2, 3, BSerialLcdNetwork.lex.getText("cancel")));
        return tmpCommands;
    }
}

