/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdBitmapCommand;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.util.ArrayUtil;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;

public class SerialLcdAlarmConsolePage
extends SerialLcdPage {
    BConsoleRecipient consoleRecipient;
    private int currentActiveRow = -1;
    int intFirstArrayItemToDisplay = -1;
    int intArrayItemDisplayedOnCurrentRow = -1;
    private String pageName = BSerialLcdNetwork.lex.getText("alarms");
    BAlarmRecord[] arrAlarms;

    public SerialLcdAlarmConsolePage(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void displayPage() {
    }

    public void displayPage(BConsoleRecipient consoleRecipient) {
        this.consoleRecipient = consoleRecipient;
        this.intFirstArrayItemToDisplay = -1;
        this.displayPage(0);
    }

    public void displayPageForFirstTime() {
        try {
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[0], 0, 2, 1, 1, this.pageName));
            this.arrAlarms = this.getAlarmRecords(this.consoleRecipient);
            if (this.arrAlarms.length > 6) {
                for (int i = 0; i < 6; ++i) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 1], 0, 2, 1, 0, this.retAlarmLabel(this.arrAlarms[i])));
                }
            } else {
                for (int i = 0; i < this.arrAlarms.length; ++i) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[i + 1], 0, 2, 1, 0, this.retAlarmLabel(this.arrAlarms[i])));
                }
            }
            this.currentActiveRow = 1;
            this.intArrayItemDisplayedOnCurrentRow = 0;
            this.intFirstArrayItemToDisplay = 0;
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            if (this.arrAlarms.length > 0) {
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(1, true));
            }
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    public void displayPage(int newTop) {
        this.getNetwork().setStallOutput(false);
        try {
            Object[] commands = new SerialLcdCommand[]{};
            if (this.intFirstArrayItemToDisplay == -1) {
                this.displayPageForFirstTime();
            } else {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[1] + ROW[2] + ROW[3] + ROW[4] + ROW[5] + ROW[6], 0, 127));
                this.intFirstArrayItemToDisplay = this.intFirstArrayItemToDisplay > this.arrAlarms.length - 1 ? this.arrAlarms.length - 6 : newTop;
                this.currentActiveRow = 1;
                this.intArrayItemDisplayedOnCurrentRow = this.intFirstArrayItemToDisplay;
                for (int i = this.intFirstArrayItemToDisplay; i < this.intFirstArrayItemToDisplay + 6; ++i) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow], 0, 2, 1, 0, this.retAlarmLabel(this.arrAlarms[i])));
                    ++this.currentActiveRow;
                    ++this.intArrayItemDisplayedOnCurrentRow;
                }
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, true));
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
                this.getNetwork().sendCommands((SerialLcdCommand[])commands);
            }
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button1Pressed(int presses) {
        if (!this.getNetwork().getHideMainMenu()) {
            this.getNetwork().displayMenuPage();
        }
    }

    @Override
    public void buttonDownPressed(int presses) {
        try {
            if (this.intArrayItemDisplayedOnCurrentRow < this.arrAlarms.length - 1) {
                if (this.currentActiveRow > 5) {
                    this.redrawList("Down");
                } else {
                    this.gotoNextRow();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error getting next menu item - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void buttonUpPressed(int presses) {
        try {
            if (this.currentActiveRow <= 1 && this.intFirstArrayItemToDisplay > 0) {
                this.redrawList("up");
            } else if (this.currentActiveRow > 1) {
                this.gotoPreviousRow();
            }
        }
        catch (Exception e) {
            System.err.println("Error getting next menu item - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void buttonEnterPressed(int presses) {
        if (this.arrAlarms.length > 0) {
            this.getNetwork().displayAlarmDetailsPage(this.arrAlarms[this.intArrayItemDisplayedOnCurrentRow], this.consoleRecipient);
        }
    }

    private void gotoPreviousRow() {
        if (this.currentActiveRow > 1 || this.currentActiveRow == 1 && this.intFirstArrayItemToDisplay != 0) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                if (this.currentActiveRow > 1) {
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, false));
                    --this.currentActiveRow;
                    --this.intArrayItemDisplayedOnCurrentRow;
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
                } else {
                    this.displayPage(this.intFirstArrayItemToDisplay - 1);
                    this.currentActiveRow = 1;
                    --this.intArrayItemDisplayedOnCurrentRow;
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
                }
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
            }
            catch (Exception e) {
                System.err.println("Error navigating rows - " + e.toString());
                e.printStackTrace();
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
    }

    private void gotoNextRow() {
        if (this.currentActiveRow < 6 || this.intFirstArrayItemToDisplay < this.arrAlarms.length - 1) {
            Object[] commands = new SerialLcdCommand[]{};
            try {
                if (this.currentActiveRow < 6) {
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getUnderline(this.currentActiveRow, false));
                    ++this.currentActiveRow;
                    ++this.intArrayItemDisplayedOnCurrentRow;
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
                } else {
                    this.displayPage(this.intFirstArrayItemToDisplay + 1);
                    commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
                }
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
            }
            catch (Exception e) {
                System.err.println("Error navigating rows - " + e.toString());
                e.printStackTrace();
            }
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
    }

    private void redrawList(String strDirection) {
        try {
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[1] + ROW[2] + ROW[3] + ROW[4] + ROW[5] + ROW[6], 0, 127));
            if (strDirection.equals("up")) {
                if (this.intFirstArrayItemToDisplay > 0) {
                    --this.intFirstArrayItemToDisplay;
                }
            } else if (this.intFirstArrayItemToDisplay < this.arrAlarms.length - 6) {
                ++this.intFirstArrayItemToDisplay;
            }
            this.currentActiveRow = 1;
            this.intArrayItemDisplayedOnCurrentRow = this.intFirstArrayItemToDisplay;
            for (int i = this.intFirstArrayItemToDisplay; i < this.intFirstArrayItemToDisplay + 6; ++i) {
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[this.currentActiveRow], 0, 2, 1, 0, this.retAlarmLabel(this.arrAlarms[i])));
                ++this.currentActiveRow;
                ++this.intArrayItemDisplayedOnCurrentRow;
            }
            if (strDirection.equals("up")) {
                this.currentActiveRow = 1;
                this.intArrayItemDisplayedOnCurrentRow = this.intFirstArrayItemToDisplay;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
            } else {
                this.currentActiveRow = 6;
                this.intArrayItemDisplayedOnCurrentRow = this.intFirstArrayItemToDisplay + 5;
                commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.drawUnderline());
            }
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getBottomArrows());
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getTopArrows());
            this.getNetwork().sendCommands((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error navigating rows - " + e.toString());
            e.printStackTrace();
        }
    }

    private SerialLcdCommand[] getUnderline(int row, boolean on) throws SerialLcdCommandException {
        return new SerialLcdCommand[]{new SerialLcdLineCommand(0, row * 8 + 7, 127, row * 8 + 7, on)};
    }

    private SerialLcdCommand[] getSoftButtons() throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 57, 26, 57, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 58, 26, 58, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 59, 26, 59, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 60, 26, 60, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 61, 26, 61, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 62, 26, 62, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 63, 26, 63, !this.getNetwork().getHideMainMenu())});
        if (!this.getNetwork().getHideMainMenu()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, BSerialLcdNetwork.lex.getText("menu")));
        }
        return tmpCommands;
    }

    private SerialLcdCommand[] getTopArrows() throws SerialLcdCommandException {
        if (this.intFirstArrayItemToDisplay > 0) {
            if (this.pageName.length() < 11) {
                return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 16, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 29, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 94, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 107, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 37, 4, true), new SerialLcdLineCommand(91, 4, 127, 4, true)};
            }
            if (this.pageName.length() < 16) {
                return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 16, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 107, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 24, 4, true), new SerialLcdLineCommand(104, 4, 127, 4, true)};
            }
            return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[0], 3, "0406070604"), new SerialLcdBitmapCommand(ROW[0], 120, "0406070604"), new SerialLcdLineCommand(0, 4, 11, 4, true), new SerialLcdLineCommand(117, 4, 127, 4, true)};
        }
        if (this.pageName.length() < 11) {
            return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 37), new SerialLcdClearCommand(ROW[0], 91, 127)};
        }
        if (this.pageName.length() < 16) {
            return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 24), new SerialLcdClearCommand(ROW[0], 104, 127)};
        }
        return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[0], 0, 11), new SerialLcdClearCommand(ROW[0], 117, 127)};
    }

    private SerialLcdCommand[] getBottomArrows() throws SerialLcdCommandException {
        if (this.intFirstArrayItemToDisplay < this.arrAlarms.length - 6) {
            return new SerialLcdCommand[]{new SerialLcdBitmapCommand(ROW[7], 29, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 42, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 55, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 68, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 81, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 94, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 107, "2060E06020"), new SerialLcdBitmapCommand(ROW[7], 120, "2060E06020"), new SerialLcdLineCommand(28, 58, 127, 58, true)};
        }
        return new SerialLcdCommand[]{new SerialLcdClearCommand(ROW[7], 28, 127)};
    }

    private SerialLcdCommand[] drawUnderline() throws SerialLcdCommandException {
        return this.getUnderline(this.currentActiveRow, true);
    }

    public BAlarmRecord[] getAlarmRecords(BConsoleRecipient recipient) throws Exception {
        String alarmClasses = "";
        String[] tmpClassNames = recipient.getSubscribedAlarmClasses();
        for (int i = 0; i < tmpClassNames.length; ++i) {
            if (i > 0) {
                alarmClasses = alarmClasses + " or ";
            }
            alarmClasses = alarmClasses + "(alarmClass='" + tmpClassNames[i] + "')";
        }
        BOrd bord = BOrd.make((BOrd)recipient.getAbsoluteOrd(), (BOrd)BOrd.make((String)("alarm:|bql:select * from openAlarms where " + alarmClasses)));
        BITable bicollection = (BITable)bord.resolve((BObject)recipient).get();
        TableCursor cursor = bicollection.cursor();
        this.arrAlarms = new BAlarmRecord[0];
        while (cursor.next()) {
            this.arrAlarms = (BAlarmRecord[])ArrayUtil.addOne((Object[])this.arrAlarms, (Object)((BAlarmRecord)((BComplex)cursor.get()).newCopy()));
        }
        return this.arrAlarms;
    }

    private String retAlarmLabel(BAlarmRecord alarmRecord) {
        String alarmLabel;
        String string = alarmLabel = alarmRecord.getAlarmData().get("sourceName") != null ? alarmRecord.getAlarmData().get("sourceName").toString() : BSerialLcdNetwork.lex.getText("noSourceProvided");
        if (alarmLabel.length() > 25) {
            alarmLabel = alarmLabel.substring(0, 24);
        }
        return alarmLabel;
    }

    @Override
    public void popupClosed(int popupReturn) {
    }
}

