/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.point;

import com.lynxspring.lcd.enums.BBooleanWritableEnum;
import com.lynxspring.lcd.enums.BNonWritableEnum;
import com.lynxspring.lcd.enums.BSerialLcdEnum;
import com.lynxspring.lcd.enums.BWritableEnum;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="labelText", type="String", defaultValue="$PARENT_DISPLAY_NAME$", facets={@Facet(value="BFacets.make(\"max\", BInteger.make(25))")}), @NiagaraProperty(name="page", type="int", defaultValue="1", facets={@Facet(value="BFacets.make(\"min\", BInteger.make(1))")}), @NiagaraProperty(name="sortOrder", type="int", defaultValue="0", facets={@Facet(value="BFacets.make(\"min\", BInteger.make(0))")}), @NiagaraProperty(name="writable", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"Writable\", \"Not Writable\")")}), @NiagaraProperty(name="slot", type="BSerialLcdEnum", defaultValue="BNonWritableEnum.make(0)"), @NiagaraProperty(name="allowNull", type="boolean", defaultValue="true")})
public class BSerialLcdPointExtension
extends BAbstractProxyExt {
    public static final Property labelText = BSerialLcdPointExtension.newProperty((int)0, (String)"$PARENT_DISPLAY_NAME$", (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)25)));
    public static final Property page = BSerialLcdPointExtension.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property sortOrder = BSerialLcdPointExtension.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property writable = BSerialLcdPointExtension.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"Writable", (String)"Not Writable"));
    public static final Property slot = BSerialLcdPointExtension.newProperty((int)0, (BValue)BNonWritableEnum.make(0), null);
    public static final Property allowNull = BSerialLcdPointExtension.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BSerialLcdPointExtension.class);
    private String value;
    private int valueIndex;
    private int[] valueOrdinals;
    private String[] VALUES;
    private int curCharSelected = 1;
    private boolean selected = false;
    private NumberFormat format;
    private Locale locale;
    private BControlPoint parent;
    public static final BSerialLcdPointExtension NON_WRITABLE = BSerialLcdPointExtension.nonWritable();
    public static final BSerialLcdPointExtension BOOLEAN_WRITABLE = BSerialLcdPointExtension.booleanWritable();
    public static final BSerialLcdPointExtension WRITABLE = BSerialLcdPointExtension.writable();

    public String getLabelText() {
        return this.getString(labelText);
    }

    public void setLabelText(String v) {
        this.setString(labelText, v, null);
    }

    public int getPage() {
        return this.getInt(page);
    }

    public void setPage(int v) {
        this.setInt(page, v, null);
    }

    public int getSortOrder() {
        return this.getInt(sortOrder);
    }

    public void setSortOrder(int v) {
        this.setInt(sortOrder, v, null);
    }

    public boolean getWritable() {
        return this.getBoolean(writable);
    }

    public void setWritable(boolean v) {
        this.setBoolean(writable, v, null);
    }

    public BSerialLcdEnum getSlot() {
        return (BSerialLcdEnum)this.get(slot);
    }

    public void setSlot(BSerialLcdEnum v) {
        this.set(slot, (BValue)v, null);
    }

    public boolean getAllowNull() {
        return this.getBoolean(allowNull);
    }

    public void setAllowNull(boolean v) {
        this.setBoolean(allowNull, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(writable) && !(this.getSlot() instanceof BNonWritableEnum)) {
            if (this.getWritable() && this.getSlot().getOrdinal() == 0) {
                if (this.getSlot() instanceof BBooleanWritableEnum) {
                    this.setSlot(BBooleanWritableEnum.fallback);
                } else {
                    this.setSlot(BWritableEnum.fallback);
                }
            }
            if (!this.getWritable()) {
                if (this.getSlot() instanceof BWritableEnum && this.getSlot().equals((Object)BWritableEnum.fallback)) {
                    this.setSlot(BWritableEnum.out);
                } else if (this.getSlot() instanceof BBooleanWritableEnum && this.getSlot().equals((Object)BBooleanWritableEnum.fallback)) {
                    this.setSlot(BBooleanWritableEnum.out);
                }
            }
        } else if (property.equals(slot) && this.getSlot().getOrdinal() == 0 && this.getWritable()) {
            this.setWritable(false);
        }
    }

    public void started() throws Exception {
        if (this.isRunning() && this.getParent().getParentComponent() instanceof BControlPoint) {
            this.parent = (BControlPoint)this.getParent().getParentComponent();
        }
        this.locale = new Locale(Sys.getLanguage());
        this.format = NumberFormat.getInstance(this.locale);
        super.started();
    }

    public boolean isParentLegal(BComponent parent) {
        if (parent instanceof BControlPoint) {
            if (parent.isMounted()) {
                if (parent instanceof BBooleanWritable) {
                    this.setSlot(BBooleanWritableEnum.fallback);
                    this.setWritable(true);
                } else if (parent instanceof BIWritablePoint) {
                    this.setSlot(BWritableEnum.fallback);
                    this.setWritable(true);
                } else {
                    this.setSlot(BNonWritableEnum.out);
                    this.setFlags((Slot)writable, 1);
                    this.setFlags((Slot)slot, 1);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isSiblingLegal(BComponent sibling) {
        return true;
    }

    public String getValue() {
        if (this.parent == null) {
            return "";
        }
        String value = this.parent.get("out").asComplex().get("value").toString((Context)this.parent.getFacets());
        if (this.selected && this.parent instanceof BNumericWritable && value.contains(" ")) {
            value = value.substring(0, value.indexOf(" "));
        }
        if (!this.selected) {
            BStatus status = (BStatus)this.parent.get("out").asComplex().get("status");
            if (status.isNull()) {
                value = "{null}";
            }
            if (status.isAlarm()) {
                value = value + " alm";
            } else if (status.isFault()) {
                value = value + " flt";
            } else if (status.isDown()) {
                value = value + " dwn";
            } else if (status.isStale()) {
                value = value + " stl";
            } else if (status.isDisabled()) {
                value = value + " dis";
            }
        }
        this.value = value;
        return this.value;
    }

    public void buildValueArray() {
        this.getValue();
        if (this.parent instanceof BBooleanWritable || this.parent instanceof BBooleanPoint) {
            this.VALUES = new String[2];
            this.valueOrdinals = new int[0];
            this.VALUES[0] = this.parent.getFacets().get("falseText").toString();
            this.VALUES[1] = this.parent.getFacets().get("trueText").toString();
            this.valueIndex = this.VALUES[1].toLowerCase().equals(this.value != null ? this.value.toLowerCase() : "") ? 1 : 0;
        } else if (this.parent instanceof BNumericWritable || this.parent instanceof BNumericPoint) {
            this.valueIndex = -1;
            this.VALUES = new String[4];
            this.valueOrdinals = new int[0];
            this.VALUES[0] = this.parent.getFacets().get("units").toString();
            this.VALUES[1] = this.parent.getFacets().get("precision").toString();
            this.VALUES[2] = this.parent.getFacets().get("min").toString();
            this.VALUES[3] = this.parent.getFacets().get("max").toString();
        } else if (this.parent instanceof BEnumWritable || this.parent instanceof BEnumPoint) {
            this.valueIndex = -1;
            BEnumRange range = (BEnumRange)this.parent.getFacets().get("range");
            this.valueOrdinals = range.getOrdinals();
            this.VALUES = new String[this.valueOrdinals.length];
            for (int i = 0; i < this.valueOrdinals.length; ++i) {
                this.VALUES[i] = range.get(this.valueOrdinals[i]).toString();
                if (!this.VALUES[i].toLowerCase().equals(this.value != null ? this.value.toLowerCase() : "")) continue;
                this.valueIndex = i;
            }
        } else if (this.parent instanceof BStringWritable || this.parent instanceof BStringPoint) {
            this.valueIndex = 0;
            this.valueOrdinals = new int[0];
            this.VALUES = new String[1];
            this.VALUES[0] = this.value;
        }
    }

    public boolean setValue() {
        this.selected = false;
        BBoolean bvalue = null;
        if (this.parent instanceof BBooleanWritable) {
            bvalue = BBoolean.make((this.valueIndex == 1 ? 1 : 0) != 0);
        } else if (this.parent instanceof BNumericWritable) {
            double max;
            double min;
            double valAsDouble;
            block19: {
                block18: {
                    if (this.value.contains(" ")) {
                        this.value = this.value.substring(0, this.value.indexOf(" "));
                    }
                    valAsDouble = this.format.parse(this.value, new ParsePosition(0)).doubleValue();
                    bvalue = BDouble.make((double)valAsDouble);
                    min = -1.0;
                    max = -1.0;
                    try {
                        min = new Double(this.VALUES[2]);
                    }
                    catch (NumberFormatException nfe) {
                        if (!this.VALUES[2].equals("-inf")) break block18;
                        min = -9.223372036854776E18;
                    }
                }
                try {
                    max = new Double(this.VALUES[3]);
                }
                catch (NumberFormatException nfe) {
                    if (!this.VALUES[3].equals("+inf")) break block19;
                    max = 9.223372036854776E18;
                }
            }
            if (bvalue != null && (valAsDouble > max || valAsDouble < min)) {
                return true;
            }
        } else if (this.parent instanceof BEnumWritable) {
            if (this.valueIndex > -1) {
                bvalue = ((BEnumWritable)this.parent).getEnum().getRange().get(this.valueOrdinals[this.valueIndex]);
            }
        } else if (this.parent instanceof BStringWritable) {
            this.value = this.value.toLowerCase();
            String newValue = "";
            boolean lastCharSpace = true;
            for (int i = 0; i < this.value.length(); ++i) {
                newValue = lastCharSpace ? newValue + this.value.substring(i, i + 1).toUpperCase() : newValue + this.value.substring(i, i + 1).toLowerCase();
                lastCharSpace = this.value.charAt(i) == ' ';
            }
            this.value = newValue;
            bvalue = BString.make((String)this.value);
        }
        if (bvalue != null) {
            if (((BStatusValue)this.parent.get(this.getSlot().getName())).getStatus().isNull()) {
                ((BStatusValue)this.parent.get(this.getSlot().getName())).setStatusNull(false);
            }
            if (bvalue instanceof BEnum && !(bvalue instanceof BBoolean)) {
                bvalue = BDynamicEnum.make((BEnum)((BEnum)bvalue));
            }
            this.parent.get(this.getSlot().getName()).asStruct().set("value", (BValue)bvalue);
        }
        return false;
    }

    public String[] getMinMax() {
        String[] out = new String[]{this.VALUES[2], this.VALUES[3]};
        return out;
    }

    public void setNull() {
        ((BStatusValue)this.parent.get(this.getSlot().getName())).setStatusNull(true);
        this.selected = false;
        this.buildValueArray();
    }

    public void selected() {
        this.selected = true;
        this.buildValueArray();
        this.curCharSelected = 1;
    }

    public void canceled() {
        this.selected = false;
        this.buildValueArray();
    }

    public String moveCharRight() {
        if (this.curCharSelected > 1 || this.parent instanceof BStringWritable) {
            --this.curCharSelected;
        }
        if (this.parent instanceof BNumericWritable && this.value.charAt(this.getCharIndex()) == '.') {
            --this.curCharSelected;
        }
        if (this.parent instanceof BStringWritable && this.curCharSelected == 0) {
            this.value = this.value + " ";
            this.curCharSelected = 1;
        }
        return this.value;
    }

    public String moveCharLeft() {
        ++this.curCharSelected;
        if (this.parent instanceof BNumericWritable && this.getCharIndex() < 0) {
            this.value = this.value.charAt(0) == '-' ? "-0" + this.value.substring(1) : "0" + this.value;
        } else if (this.parent instanceof BStringWritable && this.getCharIndex() < 0) {
            this.value = " " + this.value;
        }
        if (this.parent instanceof BNumericWritable && this.value.charAt(this.getCharIndex()) == '.') {
            ++this.curCharSelected;
        }
        return this.value;
    }

    public int getCharIndex() {
        return this.value.length() - this.curCharSelected;
    }

    public String getCurrentValue() {
        return this.value;
    }

    public String getNextValue() {
        if (this.parent instanceof BNumericWritable || this.parent instanceof BStringWritable) {
            String newChar = " ";
            if (this.parent instanceof BNumericWritable) {
                newChar = "9";
                if (this.value.charAt(this.getCharIndex()) != '-' && (newChar = "" + (new Integer(this.value.substring(this.getCharIndex(), this.getCharIndex() + 1)) - 1)).equals("-1")) {
                    newChar = this.getCharIndex() > 0 ? "9" : "-";
                }
            } else if (this.parent instanceof BStringWritable) {
                if (this.getCharIndex() < 0) {
                    this.value = " " + this.value;
                } else if (this.curCharSelected < 1) {
                    this.value = this.value + " ";
                    this.curCharSelected = 1;
                }
                char charValue = this.value.charAt(this.getCharIndex());
                switch (charValue) {
                    case ' ': {
                        newChar = "~";
                        break;
                    }
                    case '{': {
                        newChar = "`";
                        break;
                    }
                    case '[': {
                        newChar = "@";
                        break;
                    }
                    case ':': {
                        newChar = "/";
                        break;
                    }
                    case '!': {
                        newChar = "9";
                        break;
                    }
                    case '0': {
                        newChar = "z";
                        break;
                    }
                    case 'a': {
                        newChar = " ";
                        break;
                    }
                    default: {
                        newChar = "" + (char)(charValue - '\u0001');
                    }
                }
            }
            String newValue = "";
            for (int i = 0; i < this.value.length(); ++i) {
                newValue = this.getCharIndex() == i ? newValue + newChar : newValue + this.value.charAt(i);
            }
            boolean updateValue = true;
            if (updateValue) {
                this.value = "" + newValue;
            }
            if (this.getCharIndex() < 0) {
                this.curCharSelected = this.value.length();
            }
        } else {
            if (this.valueIndex < this.VALUES.length - 1) {
                ++this.valueIndex;
            }
            this.value = this.VALUES[this.valueIndex];
        }
        return this.value;
    }

    public String getPrevValue() {
        if (this.parent instanceof BNumericWritable || this.parent instanceof BStringWritable) {
            String newChar = " ";
            if (this.parent instanceof BNumericWritable) {
                newChar = "0";
                if (this.value.charAt(this.getCharIndex()) != '-' && (newChar = "" + (new Integer(this.value.substring(this.getCharIndex(), this.getCharIndex() + 1)) + 1)).equals("10")) {
                    newChar = this.getCharIndex() > 0 ? "0" : "-";
                }
            } else {
                if (this.getCharIndex() < 0) {
                    this.value = " " + this.value;
                } else if (this.curCharSelected < 1) {
                    this.value = this.value + " ";
                    this.curCharSelected = 1;
                }
                char charValue = this.value.charAt(this.getCharIndex());
                switch (charValue) {
                    case ' ': {
                        newChar = "a";
                        break;
                    }
                    case 'z': {
                        newChar = "0";
                        break;
                    }
                    case '9': {
                        newChar = "!";
                        break;
                    }
                    case '/': {
                        newChar = ":";
                        break;
                    }
                    case '@': {
                        newChar = "[";
                        break;
                    }
                    case '`': {
                        newChar = "{";
                        break;
                    }
                    case '~': {
                        newChar = " ";
                        break;
                    }
                    default: {
                        newChar = "" + (char)(charValue + '\u0001');
                    }
                }
            }
            String newValue = "";
            for (int i = 0; i < this.value.length(); ++i) {
                newValue = this.getCharIndex() == i ? newValue + newChar : newValue + this.value.charAt(i);
            }
            this.value = "" + newValue;
            if (this.getCharIndex() < 0) {
                this.curCharSelected = this.value.length();
            }
        } else {
            if (this.valueIndex > 0) {
                --this.valueIndex;
            }
            this.value = this.VALUES[this.valueIndex];
        }
        return this.value;
    }

    public int getValueWidth() {
        int tmpWidth = 20;
        if (this.getParent().getParentComponent() instanceof BEnumWritable) {
            BEnumRange range = (BEnumRange)((BControlPoint)this.getParent().getParentComponent()).getFacets().get("range");
            int[] valueOrdinals = range.getOrdinals();
            for (int i = 0; i < valueOrdinals.length; ++i) {
                int tmpWidth2 = BSerialLcdPointExtension.getPixelWidth(range.get(valueOrdinals[i]).toString());
                if (tmpWidth2 <= tmpWidth) continue;
                tmpWidth = tmpWidth2;
            }
        } else {
            tmpWidth = this.parent instanceof BNumericWritable || this.parent instanceof BNumericPoint ? BSerialLcdPointExtension.getPixelWidth(this.getValue()) + 10 : BSerialLcdPointExtension.getPixelWidth(this.getValue());
        }
        if (this.getParent().getParentComponent() instanceof BControlPoint) {
            if (((BStatus)this.getParent().getParentComponent().get("out").asComplex().get("status")).isAlarm()) {
                tmpWidth += 30;
            } else if (((BStatus)this.getParent().getParentComponent().get("out").asComplex().get("status")).isNull()) {
                tmpWidth = 40;
            }
        }
        return tmpWidth;
    }

    public static int getPixelWidth(String s) {
        int width = 0;
        for (int i = 0; i < s.length(); ++i) {
            width += BSerialLcdPointExtension.getCharWidth(s.toLowerCase().charAt(i));
        }
        return width += 4;
    }

    public static int getCharWidth(char c) {
        switch (c) {
            case '!': 
            case '\'': 
            case '`': 
            case '|': {
                return 2;
            }
            case ' ': 
            case '(': 
            case ')': 
            case ',': 
            case '.': 
            case ':': 
            case ';': 
            case '[': 
            case ']': {
                return 3;
            }
            case '\"': 
            case '+': 
            case '-': 
            case '1': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case 'i': 
            case 't': 
            case '{': 
            case '}': {
                return 4;
            }
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '*': 
            case '/': 
            case '\\': 
            case 'm': 
            case 'n': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': 
            case '~': {
                return 6;
            }
            case '@': {
                return 9;
            }
        }
        return 5;
    }

    public String getDisplayedLabelText() {
        String labelName = this.getLabelText();
        if (labelName.equals("$PARENT_DISPLAY_NAME$")) {
            labelName = this.getParent().getParentComponent().getDisplayName(null);
        } else if (labelName.equals("$DISPLAY_NAME$")) {
            labelName = this.getDisplayName(null);
        } else if (labelName.equals("$FRIENDLY_PARENT_NAME$")) {
            labelName = TextUtil.toFriendly((String)this.getParent().getParentComponent().getName());
        } else if (labelName.equals("$FRIENDLY_NAME$")) {
            labelName = TextUtil.toFriendly((String)this.getName());
        }
        return labelName;
    }

    public boolean requiresPointSubscription() {
        return true;
    }

    private static final BSerialLcdPointExtension nonWritable() {
        BSerialLcdPointExtension ext = new BSerialLcdPointExtension();
        ext.setSlot(BNonWritableEnum.out);
        ext.setFlags((Slot)writable, 1);
        ext.setFlags((Slot)slot, 1);
        return ext;
    }

    private static final BSerialLcdPointExtension booleanWritable() {
        BSerialLcdPointExtension ext = new BSerialLcdPointExtension();
        ext.setSlot(BBooleanWritableEnum.fallback);
        ext.setWritable(true);
        return ext;
    }

    private static final BSerialLcdPointExtension writable() {
        BSerialLcdPointExtension ext = new BSerialLcdPointExtension();
        ext.setSlot(BWritableEnum.fallback);
        ext.setWritable(true);
        return ext;
    }
}

