/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;

public class SerialLcdUnPrintCommand
extends SerialLcdCommand {
    private String row;
    private String col;
    private String font;
    private String type;
    private String just;
    private String message;

    private SerialLcdUnPrintCommand() {
    }

    public SerialLcdUnPrintCommand(int row, int col, String message) throws SerialLcdCommandException {
        SerialLcdUnPrintCommand.getUnPrintCommand(row, col, 0, 1, 0, message);
    }

    public SerialLcdUnPrintCommand(int row, int col, boolean inverted, String message) throws SerialLcdCommandException {
        SerialLcdUnPrintCommand.getUnPrintCommand(row, col, 0, inverted ? 2 : 1, 0, message);
    }

    public SerialLcdUnPrintCommand(int row, int col, int font, int type, int just, String message) throws SerialLcdCommandException {
        SerialLcdUnPrintCommand.getUnPrintCommand(row, col, font, type, just, message);
    }

    private static SerialLcdUnPrintCommand getUnPrintCommand(int row, int col, int font, int type, int just, String message) throws SerialLcdCommandException {
        if (row < 0 || col < 0 || font < 0 || type < 0 || just < 0) {
            throw new SerialLcdCommandException("Invalid command parameters - All int parameters must be positive.");
        }
        if (row > 255) {
            throw new SerialLcdCommandException("Invalid command parameters - row parameter must be less than 256.");
        }
        if (col > 127) {
            throw new SerialLcdCommandException("Invalid command parameters - col parameter must be less than 128.");
        }
        if (font > 4) {
            throw new SerialLcdCommandException("Invalid command parameters - font parameter must be less than 5.");
        }
        if (type != 1 && type != 2 && type != 4 && type != 8) {
            throw new SerialLcdCommandException("Invalid command parameters - type parameter must be 1, 2, 4, or 8.");
        }
        if (just > 3) {
            throw new SerialLcdCommandException("Invalid command parameters - just parameter must be less than 4.");
        }
        if (message == null) {
            throw new SerialLcdCommandException("Invalid command parameters - message parameter must not be null.");
        }
        if (message.length() > 25) {
            throw new SerialLcdCommandException("Invalid command parameters - message parameter can accept up to 25 characters.");
        }
        SerialLcdUnPrintCommand unprintCommand = new SerialLcdUnPrintCommand();
        unprintCommand.row = SerialLcdUnPrintCommand.getHexValue(row, 2);
        unprintCommand.col = SerialLcdUnPrintCommand.getHexValue(col, 2);
        unprintCommand.font = SerialLcdUnPrintCommand.getHexValue(font, 1);
        unprintCommand.type = SerialLcdUnPrintCommand.getHexValue(type, 1);
        unprintCommand.just = SerialLcdUnPrintCommand.getHexValue(just, 1);
        unprintCommand.message = message;
        return unprintCommand;
    }

    @Override
    public byte[] getCommand() {
        return this.doGetCommand("U" + this.row + this.col + this.font + this.type + this.just + this.message);
    }
}

