/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;

public class SerialLcdToneCommand
extends SerialLcdCommand {
    private String freq;
    private String dur;

    public SerialLcdToneCommand(int freq, int dur) throws SerialLcdCommandException {
        if (freq != 0 && (freq < 26 || freq > 4095)) {
            throw new SerialLcdCommandException("Invalid command parameters - freq must be 0 or between 26 and 4095Hz.");
        }
        if (dur < 0 || dur > 255) {
            throw new SerialLcdCommandException("Invalid command parameters - dur must be between 0 and 255.");
        }
        this.freq = SerialLcdToneCommand.getHexValue(freq, 3);
        this.dur = SerialLcdToneCommand.getHexValue(dur, 2);
    }

    @Override
    public byte[] getCommand() {
        return this.doGetCommand("T" + this.freq + this.dur);
    }
}

