/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdBoxCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.command.SerialLcdLineCommand;

public class SerialLcdScheduleBoxCommand
extends SerialLcdCommand {
    private byte[] bytes;

    public SerialLcdScheduleBoxCommand(int startX, int startY, boolean filled, boolean selected) throws SerialLcdCommandException {
        byte[] tmpBytes;
        if (startX < 0 || startX > 117) {
            throw new SerialLcdCommandException("Invalid command parameters - X coordinate must be between 0 and 117.");
        }
        if (startY < 0 || startY > 54) {
            throw new SerialLcdCommandException("Invalid command parameters - Y coordinate must be between 0 and 54.");
        }
        this.bytes = new byte[0];
        if (filled) {
            tmpBytes = new SerialLcdLineCommand(startX, startY, startX + 12, startY, true).getCommand();
            this.bytes = new byte[tmpBytes.length * 9];
            for (int i = 0; i < 9; ++i) {
                tmpBytes = new SerialLcdLineCommand(startX, startY + i, startX + 12, startY + i, true).getCommand();
                System.arraycopy(tmpBytes, 0, this.bytes, tmpBytes.length * i, tmpBytes.length);
            }
        } else {
            this.bytes = new SerialLcdBoxCommand(startX, startY, startX + 12, startY + 8, true).getCommand();
        }
        if (selected) {
            tmpBytes = new SerialLcdLineCommand(startX + 2, startY + 6, startX + 10, startY + 6, !filled).getCommand();
            byte[] curBytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, curBytes, 0, this.bytes.length);
            this.bytes = new byte[tmpBytes.length + curBytes.length];
            System.arraycopy(curBytes, 0, this.bytes, 0, curBytes.length);
            System.arraycopy(tmpBytes, 0, this.bytes, curBytes.length, tmpBytes.length);
        }
    }

    @Override
    public byte[] getCommand() {
        return this.bytes;
    }
}

