/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdBoxCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;
import com.lynxspring.lcd.point.BSerialLcdPointExtension;

public class SerialLcdPrintCommand
extends SerialLcdCommand {
    private String row;
    private String col;
    private String font;
    private String type;
    private String just;
    private String message;

    public SerialLcdPrintCommand(int row, int col, String message) throws SerialLcdCommandException {
        this.getPrintCommand(row, col, 0, 1, 3, message);
    }

    public SerialLcdPrintCommand(int row, int col, int type, String message) throws SerialLcdCommandException {
        this.getPrintCommand(row, col, 0, type, 3, message);
    }

    public SerialLcdPrintCommand(int row, int col, int font, int type, int just, String message) throws SerialLcdCommandException {
        this.getPrintCommand(row, col, font, type, just, message);
    }

    private void getPrintCommand(int row, int col, int font, int type, int just, String message) throws SerialLcdCommandException {
        if (row < 0 || col < 0 || font < 0 || type < 0 || just < 0) {
            throw new SerialLcdCommandException("Invalid command parameters - All int parameters must be positive.");
        }
        if (row > 255) {
            throw new SerialLcdCommandException("Invalid command parameters - row parameter must be less than 256.");
        }
        if (col > 127) {
            throw new SerialLcdCommandException("Invalid command parameters - col parameter must be less than 128.");
        }
        if (font > 4) {
            throw new SerialLcdCommandException("Invalid command parameters - font parameter must be less than 5.");
        }
        if (type != 1 && type != 2 && type != 4 && type != 8) {
            throw new SerialLcdCommandException("Invalid command parameters - type parameter must be 1, 2, 4, or 8.");
        }
        if (just > 3) {
            throw new SerialLcdCommandException("Invalid command parameters - just parameter must be less than 4.");
        }
        if (message == null) {
            throw new SerialLcdCommandException("Invalid command parameters - message parameter must not be null.");
        }
        if (message.length() > 25) {
            throw new SerialLcdCommandException("Invalid command parameters - message parameter can accept up to 25 characters.");
        }
        this.row = SerialLcdPrintCommand.getHexValue(row, 2);
        this.col = SerialLcdPrintCommand.getHexValue(col, 2);
        this.font = SerialLcdPrintCommand.getHexValue(font, 1);
        this.type = SerialLcdPrintCommand.getHexValue(type, 1);
        this.just = SerialLcdPrintCommand.getHexValue(just, 1);
        this.message = message;
    }

    public boolean isValid() {
        return this.message.length() > 0;
    }

    @Override
    public byte[] getCommand() {
        StringBuffer buf = new StringBuffer();
        byte[] mes = this.message.getBytes();
        int trailingMessageWidth = 0;
        boolean degreeSignFound = false;
        for (int i = 0; i < mes.length; ++i) {
            if (mes[i] == -62 && mes[i + 1] == -70) {
                ++i;
                degreeSignFound = true;
                trailingMessageWidth = 0;
                continue;
            }
            if (mes[i] <= -1) continue;
            buf.append((char)mes[i]);
            trailingMessageWidth += BSerialLcdPointExtension.getCharWidth(("" + (char)mes[i]).toLowerCase().charAt(0));
        }
        byte[] begin = this.doGetCommand("P" + this.row + this.col + this.font + this.type + this.just + buf.toString());
        byte[] degree = new byte[]{};
        byte[] fixed = begin;
        if (degreeSignFound) {
            try {
                Double d = new Double(Math.floor(Math.log(Integer.parseInt(this.row, 16)) / Math.log(2.0)));
                degree = new SerialLcdBoxCommand(124 - trailingMessageWidth, d.intValue() * 8 + 1, 125 - trailingMessageWidth, d.intValue() * 8 + 2, true).getCommand();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fixed = new byte[begin.length + degree.length];
            for (int i = 0; i < fixed.length; ++i) {
                fixed[i] = i < begin.length ? begin[i] : degree[i - begin.length];
            }
        }
        return fixed;
    }
}

