/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;

public class SerialLcdPixelCommand
extends SerialLcdCommand {
    private String X;
    private String Y;
    private String displayOn;

    public SerialLcdPixelCommand(int X, int Y, boolean displayOn) throws SerialLcdCommandException {
        if (X < 0 || Y < 0) {
            throw new SerialLcdCommandException("Invalid command parameters - X and Y coordinates must be greater than 0.");
        }
        if (X > 127) {
            throw new SerialLcdCommandException("Invalid command parameters - X coordinate must be less than 128.");
        }
        if (Y > 63) {
            throw new SerialLcdCommandException("Invalid command parameters - Y coordinate must be less than 64.");
        }
        this.X = SerialLcdPixelCommand.getHexValue(X, 2);
        this.Y = SerialLcdPixelCommand.getHexValue(Y, 2);
        this.displayOn = SerialLcdPixelCommand.getHexValue(displayOn ? 1 : 0, 1);
    }

    @Override
    public byte[] getCommand() {
        return this.doGetCommand("X" + this.X + this.Y + this.displayOn);
    }
}

