/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;

public class SerialLcdLineCommand
extends SerialLcdCommand {
    private String startX;
    private String startY;
    private String endX;
    private String endY;
    private String displayOn;

    public SerialLcdLineCommand(int startX, int startY, int endX, int endY, boolean displayOn) throws SerialLcdCommandException {
        if (startX < 0 || startY < 0 || endX < 0 || endY < 0) {
            throw new SerialLcdCommandException("Invalid command parameters - X and Y coordinates must be greater than 0.");
        }
        if (startX > 127 || endX > 127) {
            throw new SerialLcdCommandException("Invalid command parameters - X coordinates must be less than 128.");
        }
        if (startY > 63 || endY > 63) {
            throw new SerialLcdCommandException("Invalid command parameters - Y coordinates must be less than 64.");
        }
        if (startX >= endX && startY >= endY) {
            throw new SerialLcdCommandException("Invalid command parameters - end coordinates must be greater than the starting coordinates.");
        }
        this.startX = SerialLcdLineCommand.getHexValue(startX, 2);
        this.startY = SerialLcdLineCommand.getHexValue(startY, 2);
        this.endX = SerialLcdLineCommand.getHexValue(endX, 2);
        this.endY = SerialLcdLineCommand.getHexValue(endY, 2);
        this.displayOn = SerialLcdLineCommand.getHexValue(displayOn ? 1 : 0, 1);
    }

    @Override
    public byte[] getCommand() {
        return this.doGetCommand("L" + this.startX + this.startY + this.endX + this.endY + this.displayOn);
    }
}

