/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;

public class SerialLcdGraphicCommand
extends SerialLcdCommand {
    private String row;
    private String col;
    private String data;

    public SerialLcdGraphicCommand(int row, int col, int data) throws SerialLcdCommandException {
        if (row < 0 || col < 0 || data < 0) {
            throw new SerialLcdCommandException("Invalid command parameters - All int parameters must be positive.");
        }
        if (row > 255) {
            throw new SerialLcdCommandException("Invalid command parameters - row parameter must be less than 256.");
        }
        if (col > 127) {
            throw new SerialLcdCommandException("Invalid command parameters - col parameter must be less than 128.");
        }
        if (data > 255) {
            throw new SerialLcdCommandException("Invalid command parameters - data parameter must be less than 256.");
        }
        this.row = SerialLcdGraphicCommand.getHexValue(row, 2);
        this.col = SerialLcdGraphicCommand.getHexValue(col, 2);
        this.data = SerialLcdGraphicCommand.getHexValue(data, 2);
    }

    @Override
    public byte[] getCommand() {
        return this.doGetCommand("G" + this.row + this.col + this.data);
    }
}

