/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

public abstract class SerialLcdCommand {
    public static final int SOH = 1;
    public static final int ETX = 3;

    public abstract byte[] getCommand();

    protected static String getHexValue(int value, int length) {
        String hexString = Integer.toHexString(value);
        while (hexString.length() < length) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    protected byte[] doGetCommand(String commandText) {
        if (commandText != null && commandText.length() > 0) {
            byte[] command = new byte[commandText.length() + 2];
            command[0] = 1;
            for (int i = 0; i < commandText.length(); ++i) {
                command[i + 1] = commandText.getBytes()[i];
            }
            command[commandText.length() + 1] = 3;
            return command;
        }
        return new byte[0];
    }

    public String toString() {
        String string = "No Value";
        if (this.getCommand()[0] == 1) {
            string = "<soh>";
            for (int i = 1; i < this.getCommand().length - 1; ++i) {
                String code = Integer.toHexString(this.getCommand()[i]);
                while (code.length() < 2) {
                    code = "0" + code;
                }
                string = string + "<" + code + ">";
            }
            string = this.getCommand()[this.getCommand().length - 1] == 3 ? string + "<etx>" : "";
        }
        return string;
    }
}

