/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;

public class SerialLcdClearCommand
extends SerialLcdCommand {
    private String row;
    private String colStart;
    private String colEnd;

    public SerialLcdClearCommand(int row, int colStart, int colEnd) throws SerialLcdCommandException {
        if (row < 0 || colStart < 0 || colEnd < 0) {
            throw new SerialLcdCommandException("Invalid command parameters - All parameters must be positive.");
        }
        if (row > 255) {
            throw new SerialLcdCommandException("Invalid command parameters - row value must be less than 256.");
        }
        if (colStart > 127 || colEnd > 127) {
            throw new SerialLcdCommandException("Invalid command parameters - column values must be less than 128.");
        }
        if (colEnd < colStart) {
            throw new SerialLcdCommandException("Invalid command parameters - colEnd must not be less than colStart.");
        }
        this.row = SerialLcdClearCommand.getHexValue(row, 2);
        this.colStart = SerialLcdClearCommand.getHexValue(colStart, 2);
        this.colEnd = SerialLcdClearCommand.getHexValue(colEnd, 2);
    }

    @Override
    public byte[] getCommand() {
        return this.doGetCommand("C" + this.row + this.colStart + this.colEnd);
    }
}

