/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;

public class SerialLcdCircleCommand
extends SerialLcdCommand {
    private String X;
    private String Y;
    private String radius;
    private String displayOn;

    public SerialLcdCircleCommand(int X, int Y, int radius, boolean displayOn) throws SerialLcdCommandException {
        if (X < 0 || Y < 0) {
            throw new SerialLcdCommandException("Invalid command parameters - X and Y coordinates must be positive.");
        }
        if (radius < 1) {
            throw new SerialLcdCommandException("Invalid command parameters - radius must be greater than 0.");
        }
        if (X > 127 || radius > 127) {
            throw new SerialLcdCommandException("Invalid command parameters - X and radius must be less than 128.");
        }
        if (Y > 63) {
            throw new SerialLcdCommandException("Invalid command parameters - Y coordinate must be less than 64.");
        }
        this.X = SerialLcdCircleCommand.getHexValue(X, 2);
        this.Y = SerialLcdCircleCommand.getHexValue(Y, 2);
        this.radius = SerialLcdCircleCommand.getHexValue(radius, 2);
        this.displayOn = SerialLcdCircleCommand.getHexValue(displayOn ? 1 : 0, 1);
    }

    @Override
    public byte[] getCommand() {
        return this.doGetCommand("l" + this.X + this.Y + this.radius + this.displayOn);
    }
}

