/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;

public class SerialLcdBitmapCommand
extends SerialLcdCommand {
    private String row;
    private String col;
    private String length;
    private String data;

    public SerialLcdBitmapCommand(int row, int col, String data) throws SerialLcdCommandException {
        if (row < 0 || col < 0) {
            throw new SerialLcdCommandException("Invalid command parameters - All int parameters must be positive.");
        }
        if (row > 255) {
            throw new SerialLcdCommandException("Invalid command parameters - row parameter must be less than 256.");
        }
        if (col > 127) {
            throw new SerialLcdCommandException("Invalid command parameters - col parameter must be less than 128.");
        }
        if (col > 128) {
            throw new SerialLcdCommandException("Invalid command parameters - col parameter must be less than 128.");
        }
        this.row = SerialLcdBitmapCommand.getHexValue(row, 2);
        this.col = SerialLcdBitmapCommand.getHexValue(col, 2);
        this.length = SerialLcdBitmapCommand.getHexValue(data.length() / 2, 2);
        this.data = data;
    }

    @Override
    public byte[] getCommand() {
        return this.doGetCommand("H" + this.row + this.col + this.length + this.data);
    }
}

