/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.command;

import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdCommandException;

public class SerialLcdBacklightCommand
extends SerialLcdCommand {
    private String value;
    public static final int DURATION_NULL = 0;
    public static final int DURATION_HALF_SECOND = 0;
    public static final int DURATION_ONE_SECOND = 1;
    public static final int DURATION_ONE_AND_A_HALF_SECOND = 2;
    public static final int DURATION_TWO_SECONDS = 3;
    public static final int DURATION_TWO_AND_A_HALF_SECONDS = 4;
    public static final int DURATION_THREE_SECONDS = 5;
    public static final int DURATION_THREE_AND_A_HALF_SECONDS = 6;
    public static final int DURATION_FOUR_SECONDS = 7;

    private SerialLcdBacklightCommand(boolean on, boolean blink, int onDuration, int offDuration) throws SerialLcdCommandException {
        int value = (offDuration %= 8) | (onDuration %= 8) << 3;
        if (blink && !on) {
            value |= 0x40;
        } else if (!blink & !on) {
            value |= 0x80;
        } else if (!blink & on) {
            value |= 0xC0;
        }
        this.value = "" + (char)value;
    }

    public static SerialLcdBacklightCommand makeOn() throws SerialLcdCommandException {
        return new SerialLcdBacklightCommand(true, false, 0, 0);
    }

    public static SerialLcdBacklightCommand makeOff() throws SerialLcdCommandException {
        return new SerialLcdBacklightCommand(false, false, 0, 0);
    }

    public static SerialLcdBacklightCommand makeBlinkOff() throws SerialLcdCommandException {
        return new SerialLcdBacklightCommand(false, true, 0, 0);
    }

    public static SerialLcdBacklightCommand makeBlinkOn(int on, int off) throws SerialLcdCommandException {
        return new SerialLcdBacklightCommand(true, true, on, off);
    }

    @Override
    public byte[] getCommand() {
        return this.doGetCommand("b" + this.value);
    }
}

