/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.comm;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.messages.SerialLcdReceivedMessage;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteBuffer;

public class SerialLcdCommReceiver
extends CommReceiver {
    private static final int READ_SOH = 1;
    private static final int READ_COMMAND = 2;
    private static final int READ_DATA = 3;
    private static final int READ_ETX = 4;
    private static final int READ_DATE_CODE = 5;
    private int state = 1;
    private ByteBuffer rcvBuffer = new ByteBuffer();
    private SerialLcdReceivedMessage msg = null;

    public void initReceiveState(Message msg) {
        this.resetReceiveBuffer();
    }

    protected ReceivedMessage receive() throws Exception {
        BSerialLcdNetwork network = (BSerialLcdNetwork)this.getComm().getNetwork();
        this.state = 1;
        boolean done = false;
        int command = 0;
        int keyCode = 0;
        while (!done) {
            if (this.state == 1) {
                network.setStallOutput(false);
            }
            int charIn = this.getInputStream().read();
            network.setStallOutput(true);
            boolean newChar = charIn != -1;
            charIn &= 0xFF;
            if (!newChar) continue;
            switch (this.state) {
                case 1: {
                    if (charIn != 1) break;
                    this.state = 2;
                    break;
                }
                case 2: {
                    command = charIn;
                    ((BSerialLcdNetwork)this.getComm().getNetwork()).setLastCommand(command);
                    if (command == 75 || command == 107) {
                        this.state = 3;
                        break;
                    }
                    if (command == 82 || command == 80 || command == 112) {
                        this.state = 4;
                        break;
                    }
                    if (command == 48) {
                        this.state = 5;
                        break;
                    }
                    if (this.isTraceOn()) {
                        this.getLog().trace("Invalid command byte " + charIn + " received");
                    }
                    this.state = 1;
                    break;
                }
                case 3: {
                    charIn = this.getInputStream().read();
                    keyCode = Integer.parseInt("" + (char)charIn) + 1;
                    this.state = 4;
                    break;
                }
                case 4: {
                    if (charIn == 3) {
                        done = true;
                        break;
                    }
                    if (this.isTraceOn()) {
                        this.getLog().trace("Invalid final byte " + charIn + " received, expected " + 4);
                    }
                    this.state = 1;
                    break;
                }
                case 5: {
                    String tmpString = "" + charIn;
                    while (tmpString.length() < 2) {
                        tmpString = "0" + tmpString;
                    }
                    String dateCode = "" + tmpString;
                    String lotNumber = "";
                    for (int i = 0; i < 4; ++i) {
                        charIn = this.getInputStream().read();
                        charIn &= 0xFF;
                        if (i == 0) {
                            tmpString = "" + charIn;
                            while (tmpString.length() < 2) {
                                tmpString = "0" + tmpString;
                            }
                            dateCode = dateCode + tmpString;
                        } else {
                            tmpString = Integer.toHexString(charIn);
                            while (tmpString.length() < 2) {
                                tmpString = "0" + tmpString;
                            }
                            lotNumber = lotNumber + tmpString;
                        }
                        this.rcvBuffer.write((int)((byte)charIn));
                    }
                    network.setDeviceDateCode(dateCode);
                    try {
                        network.setDeviceLotNumber(Integer.parseInt(lotNumber, 16));
                    }
                    catch (Exception e) {
                        network.setDeviceLotNumber(-1);
                    }
                    this.state = 4;
                }
            }
            this.rcvBuffer.write((int)((byte)charIn));
        }
        if (this.msg == null) {
            this.msg = new SerialLcdReceivedMessage(this.rcvBuffer.getBytes(), this.rcvBuffer.getLength());
        } else {
            this.msg.setBytes(this.rcvBuffer.getBytes());
            this.msg.setLength(this.rcvBuffer.getLength());
        }
        this.msg.setKeyCode(keyCode);
        this.msg.setCommand(command);
        this.resetReceiveBuffer();
        if (this.isTraceOn()) {
            this.getLog().trace("Complete message received: Command=" + this.msg.getCommand() + ", Key Code=" + this.msg.getKeyCode() + ", Data=" + this.msg.toDebugString());
        }
        return this.msg;
    }

    public synchronized void resetReceiveBuffer() {
        this.rcvBuffer.reset();
    }

    private Log getLog() {
        return this.getComm().getNetwork().getLog();
    }

    private boolean isTraceOn() {
        return this.getLog().isTraceOn();
    }
}

