/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.comm;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.messages.SerialLcdReceivedMessage;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BBasicUnsolicitedReceive;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSerialLcdUnsolicitedReceive
extends BBasicUnsolicitedReceive {
    public static final Type TYPE = Sys.loadType(BSerialLcdUnsolicitedReceive.class);
    public static final int KEYPAD_CLOSE = 75;
    public static final int KEYPAD_OPEN = 107;
    public static final int POWER_UP_RESET = 82;
    public static final int POWER_PRESS = 112;
    public static final int POWER_HOLD = 80;

    public Type getType() {
        return TYPE;
    }

    BSerialLcdNetwork getNetwork() {
        return (BSerialLcdNetwork)this.getParent();
    }

    protected void processUnsolicitedMessage(ReceivedMessage unsolicitedMsg) {
        SerialLcdPage page = this.getNetwork().getCurrentPage();
        SerialLcdReceivedMessage rcvMsg = (SerialLcdReceivedMessage)unsolicitedMsg;
        if (!this.getNetwork().isOn()) {
            this.getNetwork().refreshDevice();
        } else {
            switch (rcvMsg.getCommand()) {
                case 75: {
                    switch (rcvMsg.getKeyCode()) {
                        case 1: {
                            if (this.getNetwork().getLog().isTraceOn()) {
                                this.getNetwork().getLog().trace("Button 1 detected");
                            }
                            if (page == null) break;
                            page.buttonPressed(1);
                            break;
                        }
                        case 2: {
                            if (this.getNetwork().getLog().isTraceOn()) {
                                this.getNetwork().getLog().trace("Button 2 detected");
                            }
                            if (page == null) break;
                            page.buttonPressed(2);
                            break;
                        }
                        case 3: {
                            if (this.getNetwork().getLog().isTraceOn()) {
                                this.getNetwork().getLog().trace("Button 3 detected");
                            }
                            if (page == null) break;
                            page.buttonPressed(3);
                            break;
                        }
                        case 4: {
                            if (this.getNetwork().getLog().isTraceOn()) {
                                this.getNetwork().getLog().trace("Button 4 detected");
                            }
                            if (page == null) break;
                            page.buttonPressed(4);
                            break;
                        }
                        case 5: {
                            if (this.getNetwork().getLog().isTraceOn()) {
                                this.getNetwork().getLog().trace("Button Down detected");
                            }
                            if (page == null) break;
                            page.buttonPressed(6);
                            break;
                        }
                        case 6: {
                            if (this.getNetwork().getLog().isTraceOn()) {
                                this.getNetwork().getLog().trace("Button Up detected");
                            }
                            if (page == null) break;
                            page.buttonPressed(5);
                            break;
                        }
                        case 7: {
                            if (this.getNetwork().getLog().isTraceOn()) {
                                this.getNetwork().getLog().trace("Button Enter detected");
                            }
                            if (page == null) break;
                            page.buttonPressed(7);
                        }
                    }
                    this.getNetwork().setLastInputTime();
                    break;
                }
                case 107: {
                    if (!this.getNetwork().getLog().isTraceOn()) break;
                    this.getNetwork().getLog().trace("Keypad open detected");
                    break;
                }
                case 82: {
                    this.getNetwork().setPasscodeVerified(!this.getNetwork().getSecurityEnabled());
                    this.getNetwork().rebuildSplashPage();
                    if (!this.getNetwork().getLog().isTraceOn()) break;
                    this.getNetwork().getLog().trace("Power up reset detected");
                    break;
                }
                case 112: {
                    if (!this.getNetwork().getLog().isTraceOn()) break;
                    this.getNetwork().getLog().trace("Power press detected");
                    break;
                }
                case 80: {
                    this.getNetwork().setPasscodeVerified(!this.getNetwork().getSecurityEnabled());
                    this.getNetwork().rebuildSplashPage();
                    if (!this.getNetwork().getLog().isTraceOn()) break;
                    this.getNetwork().getLog().trace("Power hold detected");
                }
            }
        }
        this.getNetwork().setStallOutput(false);
    }
}

