/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd;

import com.lynxspring.lcd.comm.BSerialLcdUnsolicitedReceive;
import com.lynxspring.lcd.comm.SerialLcdComm;
import com.lynxspring.lcd.comm.SerialLcdCommReceiver;
import com.lynxspring.lcd.command.SerialLcdBacklightCommand;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.command.SerialLcdRestorePageCommand;
import com.lynxspring.lcd.messages.SerialLcdMessage;
import com.lynxspring.lcd.messages.SerialLcdVerifyMessage;
import com.lynxspring.lcd.point.BSerialLcdPointExtension;
import com.lynxspring.lcd.ui.SerialLcdAlarmConsolePage;
import com.lynxspring.lcd.ui.SerialLcdAlarmDetailsPage;
import com.lynxspring.lcd.ui.SerialLcdAlarmPage;
import com.lynxspring.lcd.ui.SerialLcdBasicPage;
import com.lynxspring.lcd.ui.SerialLcdDialogBox;
import com.lynxspring.lcd.ui.SerialLcdInvalidDevicePage;
import com.lynxspring.lcd.ui.SerialLcdMainMenuPage;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.lynxspring.lcd.ui.SerialLcdRebootPage;
import com.lynxspring.lcd.ui.SerialLcdSchedDetailsPage;
import com.lynxspring.lcd.ui.SerialLcdScheduleEventPage;
import com.lynxspring.lcd.ui.SerialLcdScheduleGrid;
import com.lynxspring.lcd.ui.SerialLcdSchedulePage;
import com.lynxspring.lcd.ui.SerialLcdScheduleSelectEvent;
import com.lynxspring.lcd.ui.SerialLcdSecurityPage;
import com.lynxspring.lcd.ui.SerialLcdSettingsIPPage;
import com.lynxspring.lcd.ui.SerialLcdSettingsPage;
import com.lynxspring.lcd.ui.SerialLcdSettingsTimezonePage;
import com.lynxspring.lcd.ui.SerialLcdSplashPage;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.util.ArrayUtil;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceFolder;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="menuText", type="String", defaultValue="JENEsys LCD Interface", facets={@Facet(value="BFacets.make(\"fieldWidth\", BInteger.make(21))")}), @NiagaraProperty(name="unsolicitedReceiveHandler", type="BSerialLcdUnsolicitedReceive", defaultValue="new BSerialLcdUnsolicitedReceive()"), @NiagaraProperty(name="securityEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="passcode", type="String", defaultValue="\"5969\"", facets={@Facet(value="BFacets.make(\"min\", BInteger.make(4), \"max\", BInteger.make(4), \"fieldWidth\", BInteger.make(5))")}), @NiagaraProperty(name="displaySystemSettings", type="boolean", defaultValue="true"), @NiagaraProperty(name="deviceTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(2)", facets={@Facet(value="BFacets.make(\"min\", BRelTime.makeSeconds(30), \"max\", BRelTime.makeHours(1))")}), @NiagaraProperty(name="startupDelay", type="BRelTime", defaultValue="BRelTime.make(0) ", facets={@Facet(value="BFacets.make(\"min\", BRelTime.make(0), \"max\", BRelTime.makeMinutes(30))")}), @NiagaraProperty(name="pageNames", type="BEnumRange", defaultValue="BEnumRange.make(new int[] { 1, 2, 3 }, new String[] { \"Page$201\", \"Page$202\", \"Page$203\" } )"), @NiagaraProperty(name="maxValueWidth", type="int", defaultValue="50", facets={@Facet(value="BFacets.make(\"min\", BInteger.make(20), \"max\", BInteger.make(60))")}), @NiagaraProperty(name="rapidPressCount", type="int", defaultValue="2", facets={@Facet(value="BFacets.make(\"min\", BInteger.make(1), \"max\", BInteger.make(5))")}), @NiagaraProperty(name="rapidPressTime", type="BRelTime", defaultValue="BRelTime.make(1000)", facets={@Facet(value="BFacets.make(\"min\", BRelTime.make(0), \"max\", BRelTime.make(3000), BFacets.SHOW_MILLISECONDS, BBoolean.TRUE)")}), @NiagaraProperty(name="splashTime", type="BRelTime", defaultValue="BRelTime.makeSeconds(3)", facets={@Facet(value="BFacets.make(\"min\", BRelTime.makeSeconds(1), \"max\", BRelTime.makeSeconds(10))")}, flags=4), @NiagaraProperty(name="lcdPointExtenstions", type="BOrd", defaultValue="BOrd.make(bqlExtensions) ", flags=1), @NiagaraProperty(name="lcdAlarmExtenstions", type="BOrd", defaultValue="BOrd.make(bqlAlarmExtensions)", flags=1), @NiagaraProperty(name="lcdScheduleExtenstions", type="BOrd", defaultValue="BOrd.make(bqlSchedExtensions)", flags=1), @NiagaraProperty(name="deviceDateCode", type="String", defaultValue="", flags=3), @NiagaraProperty(name="deviceLotNumber", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="lastCommand", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="burnLogoAtSteadyState", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="logoRowValues", type="String", defaultValue="rows[0] + \",\" + rows[1] + \",\" + rows[2] + \",\" + rows[3] + \",\" + rows[4] + \",\" + rows[5] + \",\" + rows[6] + \",\" + rows[7]", flags=4), @NiagaraProperty(name="logoColumnValues", type="String", defaultValue="cols[0] + \",\" + cols[1] + \",\" + cols[2] + \",\" + cols[3] + \",\" + cols[4] + \",\" + cols[5] + \",\" + cols[6] + \",\" + cols[7]", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="updateInterface", flags=16), @NiagaraAction(name="rebuildSplashPage", flags=16), @NiagaraAction(name="checkStatus", flags=20), @NiagaraAction(name="interfaceBurnIn", flags=4), @NiagaraAction(name="restoreDefaultSplashImage")})
public class BSerialLcdNetwork
extends BSerialNetwork {
    public static final Lexicon lex = Lexicon.make(BSerialLcdNetwork.class);
    private static final String bqlExtensions = "station:|slot:/|bql:select page, sortOrder, labelText, slot, writable, parent, parent.slotPath as 'Parent Slot Path' from lynxLCD:SerialLcdPointExtension";
    private static final String bqlAlarmExtensions = "station:|slot:/|bql:select labelText, parent, parent.slotPath as 'Parent Slot Path' from lynxLCD:SerialLcdAlarmExtension";
    private static final String bqlSchedExtensions = "station:|slot:/|bql:select labelText, parent, parent.slotPath as 'Parent Slot Path' from lynxLCD:SerialLcdScheduleExtension";
    public static final String[] rows = new String[]{"80C0C0E06070303818181C0C0C0C0C0C0C0C0C0C0C0C0C0C0C1818193A32367CFCF8F8F0F0E0C08000000000000000E0800010C0", "C0701C0E07030100000000000000000000C0E090C8ECE4E46626040400000000000000000000010307FFFFFFFFFFFCF08080E0F0FFFFFEFCFF3E", "FCFCFCFCFCFCFCFC00000000FCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFC000000FCFCFCFCFCFCFCFCFCFCF0C000000000FCFCFCFCFCFCFCFC000000FCFCFCFCFEFFFCFCFCFCFCFCFCFCFCFCFC000000003FFFFFFFFFFFFFFEF8F0E0E0C0C0C0C0C0C0E0E0E0F0F8FCFFFFFFFFFFFFFFFFFFFFFFFF7F3F1F0F01", "FFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFF1F1F1F1F1F1F1F100000000FFFFFFFFFFFFFFFFFFFFFFFFFFFCF0C0FFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFF1F1F1F1F1F1F1F1000000000000000103070F0F1F1F3F3F3F3F7F7F7F7F7F5F1F1F1F1F1F1F1F1F0F0F0F0707030301", "80808080FFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF878787878787878780000000FFFFFFFFFFFFFF00030F3FFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFF878787878787878780000000F0F8F8BC1C1C1C1C1C1C0000000C7CFCFCF08000000000C0F8FCFC3C0C00C0F0F8F8BC1C1C0C0C1C1C", "3F3F3F3F3F3F3F3F1F0F0703000000003F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F1F0000003F3F3F3F3F3F3F0000000000071F3F3F3F3F3F3F3F3F3F3F0000003F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F1F0000000103070F0F0E1EFEFCF8F000000000031F7FFFF8E0F0FEFF3F0701000000000307070F0F1E9EFCFCF8F0", "068EEEEE8E8E0E8E8E0E0E8E8E0E0E0E0E8EEE6E0E0E0E8E8E0E0E8E8E0E8E8E0E8E8E0E8E8E0E8E8E0E8E8E8E0E0E8E8E8E8E0E0E0E8E8E0E8E0E8EAE2E0E8E8E0E8E8E0E0E0E8E8E8E8E0E0E0E0E0E0E0E0E0E0E0E0E0E0F070707030100000000000080F3FFFF3F07010000000000000007070606070707070301", "1C1F13180F0740437F380E03000000001C1F1310101040437F380E03001C1F031D1F0310190F1F19081B171E0D617E1F11180F07001C1F0301001C1F03001C1F031D1F03004E5F51783F070000000000000000000000000000000000000000060F0E0F07070301"};
    public static final int[] cols = new int[]{75, 70, 6, 6, 2, 2, 2, 2};
    public static final Property menuText = BSerialLcdNetwork.newProperty((int)0, (String)"JENEsys LCD Interface", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)21)));
    public static final Property unsolicitedReceiveHandler = BSerialLcdNetwork.newProperty((int)0, (BValue)new BSerialLcdUnsolicitedReceive(), null);
    public static final Property securityEnabled = BSerialLcdNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property passcode = BSerialLcdNetwork.newProperty((int)0, (String)"5969", (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)4), (String)"max", (BIDataValue)BInteger.make((int)4), (String)"fieldWidth", (BIDataValue)BInteger.make((int)5)));
    public static final Property displaySystemSettings = BSerialLcdNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property deviceTimeout = BSerialLcdNetwork.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)30), (String)"max", (BIDataValue)BRelTime.makeHours((int)1)));
    public static final Property startupDelay = BSerialLcdNetwork.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)30)));
    public static final Property pageNames = BSerialLcdNetwork.newProperty((int)0, (BValue)BEnumRange.make((int[])new int[]{1, 2, 3}, (String[])new String[]{"Page$201", "Page$202", "Page$203"}), null);
    public static final Property maxValueWidth = BSerialLcdNetwork.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)20), (String)"max", (BIDataValue)BInteger.make((int)60)));
    public static final Property rapidPressCount = BSerialLcdNetwork.newProperty((int)0, (int)2, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)5)));
    public static final Property rapidPressTime = BSerialLcdNetwork.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.make((long)3000L), (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property splashTime = BSerialLcdNetwork.newProperty((int)4, (BValue)BRelTime.makeSeconds((int)3), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1), (String)"max", (BIDataValue)BRelTime.makeSeconds((int)10)));
    public static final Property lcdPointExtenstions = BSerialLcdNetwork.newProperty((int)1, (BValue)BOrd.make((String)"station:|slot:/|bql:select page, sortOrder, labelText, slot, writable, parent, parent.slotPath as 'Parent Slot Path' from lynxLCD:SerialLcdPointExtension"), null);
    public static final Property lcdAlarmExtenstions = BSerialLcdNetwork.newProperty((int)1, (BValue)BOrd.make((String)"station:|slot:/|bql:select labelText, parent, parent.slotPath as 'Parent Slot Path' from lynxLCD:SerialLcdAlarmExtension"), null);
    public static final Property lcdScheduleExtenstions = BSerialLcdNetwork.newProperty((int)1, (BValue)BOrd.make((String)"station:|slot:/|bql:select labelText, parent, parent.slotPath as 'Parent Slot Path' from lynxLCD:SerialLcdScheduleExtension"), null);
    public static final Property deviceDateCode = BSerialLcdNetwork.newProperty((int)3, (String)"", null);
    public static final Property deviceLotNumber = BSerialLcdNetwork.newProperty((int)3, (int)-1, null);
    public static final Property lastCommand = BSerialLcdNetwork.newProperty((int)3, (int)-1, null);
    public static final Property burnLogoAtSteadyState = BSerialLcdNetwork.newProperty((int)4, (boolean)true, null);
    public static final Property logoRowValues = BSerialLcdNetwork.newProperty((int)4, (String)(rows[0] + "," + rows[1] + "," + rows[2] + "," + rows[3] + "," + rows[4] + "," + rows[5] + "," + rows[6] + "," + rows[7]), null);
    public static final Property logoColumnValues = BSerialLcdNetwork.newProperty((int)4, (String)(cols[0] + "," + cols[1] + "," + cols[2] + "," + cols[3] + "," + cols[4] + "," + cols[5] + "," + cols[6] + "," + cols[7]), null);
    public static final Action updateInterface = BSerialLcdNetwork.newAction((int)16, null);
    public static final Action rebuildSplashPage = BSerialLcdNetwork.newAction((int)16, null);
    public static final Action checkStatus = BSerialLcdNetwork.newAction((int)20, null);
    public static final Action interfaceBurnIn = BSerialLcdNetwork.newAction((int)4, null);
    public static final Action restoreDefaultSplashImage = BSerialLcdNetwork.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSerialLcdNetwork.class);
    public static final int[] ROW = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 255};
    private SerialLcdBasicPage[] page = new SerialLcdBasicPage[0];
    private SerialLcdInvalidDevicePage invalidPage = new SerialLcdInvalidDevicePage(this);
    private SerialLcdSecurityPage secPage = new SerialLcdSecurityPage(this);
    private SerialLcdMainMenuPage mainMenuPage = new SerialLcdMainMenuPage(this);
    private SerialLcdRebootPage rebootPage = new SerialLcdRebootPage(this);
    private SerialLcdSettingsPage settingsPage = new SerialLcdSettingsPage(this);
    private SerialLcdSettingsTimezonePage settingsTZPage = new SerialLcdSettingsTimezonePage(this);
    private SerialLcdSchedulePage schedulePage = new SerialLcdSchedulePage(this);
    private SerialLcdSchedDetailsPage schedDetailsPage = new SerialLcdSchedDetailsPage(this);
    private SerialLcdScheduleEventPage schedEventPage = new SerialLcdScheduleEventPage(this);
    private SerialLcdScheduleSelectEvent schedSelectPage = new SerialLcdScheduleSelectEvent(this);
    private SerialLcdAlarmPage alarmPage = new SerialLcdAlarmPage(this);
    private SerialLcdAlarmConsolePage alarmConsolePage = new SerialLcdAlarmConsolePage(this);
    private SerialLcdAlarmDetailsPage alarmDetailsPage = new SerialLcdAlarmDetailsPage(this);
    private SerialLcdSettingsIPPage ipSettingsPage = new SerialLcdSettingsIPPage(this);
    private SerialLcdSplashPage splashPage = new SerialLcdSplashPage(this);
    private SerialLcdDialogBox dialogBox = new SerialLcdDialogBox(this);
    private int curPage;
    private boolean stallOutput;
    private boolean passcodeVerified;
    private BAbsTime lastInputTime = null;
    private Clock.Ticket checkStatusTicket;
    private SerialLcdPage curLcdPage;
    BurnInThread burnIn;
    private boolean hideMainMenu = false;

    public String getMenuText() {
        return this.getString(menuText);
    }

    public void setMenuText(String v) {
        this.setString(menuText, v, null);
    }

    public BSerialLcdUnsolicitedReceive getUnsolicitedReceiveHandler() {
        return (BSerialLcdUnsolicitedReceive)this.get(unsolicitedReceiveHandler);
    }

    public void setUnsolicitedReceiveHandler(BSerialLcdUnsolicitedReceive v) {
        this.set(unsolicitedReceiveHandler, (BValue)v, null);
    }

    public boolean getSecurityEnabled() {
        return this.getBoolean(securityEnabled);
    }

    public void setSecurityEnabled(boolean v) {
        this.setBoolean(securityEnabled, v, null);
    }

    public String getPasscode() {
        return this.getString(passcode);
    }

    public void setPasscode(String v) {
        this.setString(passcode, v, null);
    }

    public boolean getDisplaySystemSettings() {
        return this.getBoolean(displaySystemSettings);
    }

    public void setDisplaySystemSettings(boolean v) {
        this.setBoolean(displaySystemSettings, v, null);
    }

    public BRelTime getDeviceTimeout() {
        return (BRelTime)this.get(deviceTimeout);
    }

    public void setDeviceTimeout(BRelTime v) {
        this.set(deviceTimeout, (BValue)v, null);
    }

    public BRelTime getStartupDelay() {
        return (BRelTime)this.get(startupDelay);
    }

    public void setStartupDelay(BRelTime v) {
        this.set(startupDelay, (BValue)v, null);
    }

    public BEnumRange getPageNames() {
        return (BEnumRange)this.get(pageNames);
    }

    public void setPageNames(BEnumRange v) {
        this.set(pageNames, (BValue)v, null);
    }

    public int getMaxValueWidth() {
        return this.getInt(maxValueWidth);
    }

    public void setMaxValueWidth(int v) {
        this.setInt(maxValueWidth, v, null);
    }

    public int getRapidPressCount() {
        return this.getInt(rapidPressCount);
    }

    public void setRapidPressCount(int v) {
        this.setInt(rapidPressCount, v, null);
    }

    public BRelTime getRapidPressTime() {
        return (BRelTime)this.get(rapidPressTime);
    }

    public void setRapidPressTime(BRelTime v) {
        this.set(rapidPressTime, (BValue)v, null);
    }

    public BRelTime getSplashTime() {
        return (BRelTime)this.get(splashTime);
    }

    public void setSplashTime(BRelTime v) {
        this.set(splashTime, (BValue)v, null);
    }

    public BOrd getLcdPointExtenstions() {
        return (BOrd)this.get(lcdPointExtenstions);
    }

    public void setLcdPointExtenstions(BOrd v) {
        this.set(lcdPointExtenstions, (BValue)v, null);
    }

    public BOrd getLcdAlarmExtenstions() {
        return (BOrd)this.get(lcdAlarmExtenstions);
    }

    public void setLcdAlarmExtenstions(BOrd v) {
        this.set(lcdAlarmExtenstions, (BValue)v, null);
    }

    public BOrd getLcdScheduleExtenstions() {
        return (BOrd)this.get(lcdScheduleExtenstions);
    }

    public void setLcdScheduleExtenstions(BOrd v) {
        this.set(lcdScheduleExtenstions, (BValue)v, null);
    }

    public String getDeviceDateCode() {
        return this.getString(deviceDateCode);
    }

    public void setDeviceDateCode(String v) {
        this.setString(deviceDateCode, v, null);
    }

    public int getDeviceLotNumber() {
        return this.getInt(deviceLotNumber);
    }

    public void setDeviceLotNumber(int v) {
        this.setInt(deviceLotNumber, v, null);
    }

    public int getLastCommand() {
        return this.getInt(lastCommand);
    }

    public void setLastCommand(int v) {
        this.setInt(lastCommand, v, null);
    }

    public boolean getBurnLogoAtSteadyState() {
        return this.getBoolean(burnLogoAtSteadyState);
    }

    public void setBurnLogoAtSteadyState(boolean v) {
        this.setBoolean(burnLogoAtSteadyState, v, null);
    }

    public String getLogoRowValues() {
        return this.getString(logoRowValues);
    }

    public void setLogoRowValues(String v) {
        this.setString(logoRowValues, v, null);
    }

    public String getLogoColumnValues() {
        return this.getString(logoColumnValues);
    }

    public void setLogoColumnValues(String v) {
        this.setString(logoColumnValues, v, null);
    }

    public void updateInterface() {
        this.invoke(updateInterface, null, null);
    }

    public void rebuildSplashPage() {
        this.invoke(rebuildSplashPage, null, null);
    }

    public void checkStatus() {
        this.invoke(checkStatus, null, null);
    }

    public void interfaceBurnIn() {
        this.invoke(interfaceBurnIn, null, null);
    }

    public void restoreDefaultSplashImage() {
        this.invoke(restoreDefaultSplashImage, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public final Type getDeviceType() {
        return BDevice.TYPE;
    }

    public final Type getDeviceFolderType() {
        return BDeviceFolder.TYPE;
    }

    public void changed(Property p, Context c) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(securityEnabled)) {
            this.passcodeVerified = !this.getSecurityEnabled();
            try {
                this.doUpdateInterface();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void started() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.started();
    }

    public final void atSteadyState() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                if (BSerialLcdNetwork.this.getStartupDelay().getMillis() > 0L) {
                    try {
                        1.sleep(BSerialLcdNetwork.this.getStartupDelay().getMillis());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (BSerialLcdNetwork.this.getBurnLogoAtSteadyState()) {
                    BSerialLcdNetwork.this.splashPage.displayPage();
                }
                try {
                    1.sleep(BSerialLcdNetwork.this.getSplashTime().getMillis());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BSerialLcdNetwork.this.updateInterface();
            }
        }.start();
        super.atSteadyState();
    }

    public void stopped() {
        this.displayRebootPage();
        try {
            super.stopped();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doRebuildSplashPage() {
        this.splashPage.displayPage();
        if (this.getPasscodeVerified() && this.curPage > -1) {
            this.displayMenuPage();
        } else {
            this.displaySecurityPage();
        }
    }

    public final void doUpdateInterface() throws Exception {
        new UpdateInterface().start();
    }

    public boolean isParentLegal(BComponent parent) {
        if (parent.isMounted()) {
            this.getSerialPortConfig().setPortName("COM1");
        }
        return true;
    }

    public final AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        AgentInfo[] agents = list.list();
        for (int i = 0; i < agents.length; ++i) {
            if (agents[i].getAgentType().is(Sys.getType((String)"wiresheet:WireSheet"))) {
                list.remove(agents[i]);
            }
            try {
                if (!agents[i].getAgentType().is(Sys.getType((String)"driver:DeviceManager"))) continue;
                list.remove(agents[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    protected final Comm makeComm() {
        return new SerialLcdComm(this, new SerialLcdCommReceiver());
    }

    public final void sendCommand(SerialLcdCommand command) {
        this.getComm().transmitNoResponse((Message)new SerialLcdMessage(command));
    }

    public final void sendCommands(SerialLcdCommand[] commands) {
        this.getComm().transmitNoResponse((Message)new SerialLcdMessage(commands));
    }

    public final boolean isChildLegal(BComponent child) {
        return false;
    }

    public final void doInterfaceBurnIn() {
        if (this.burnIn == null) {
            this.burnIn = new BurnInThread(false);
            this.burnIn.start();
        } else {
            this.burnIn = null;
            this.burnIn.stop = true;
        }
    }

    public final void restorePage(int page) {
        try {
            this.sendCommand(new SerialLcdRestorePageCommand(page));
        }
        catch (Exception e) {
            System.err.println("Error Restoring Page - " + e.toString());
            e.printStackTrace();
        }
    }

    public final void clearPage() {
        if (this.page.length > 0) {
            this.page[this.curPage].clearPage();
        }
    }

    public final void gotoFirstPage() {
        if (this.curPage > 0) {
            this.displayPage(0);
        }
    }

    public final void gotoPrevPage(int pages) {
        if (this.curPage - pages >= 0) {
            this.displayPage(this.curPage - pages);
        } else {
            this.gotoFirstPage();
        }
    }

    public final void gotoLastPage() {
        if (this.curPage < this.page.length - 1) {
            this.displayPage(this.page.length - 1);
        }
    }

    public final void gotoNextPage(int pages) {
        if (this.curPage + pages < this.page.length) {
            this.displayPage(this.curPage + pages);
        } else {
            this.gotoLastPage();
        }
    }

    public final void displaySecurityPage() {
        this.curLcdPage = this.secPage;
        this.displayPage();
    }

    public final void displayMenuPage() {
        this.curLcdPage = this.mainMenuPage;
        this.displayPage();
    }

    public final void displayRebootPage() {
        this.curLcdPage = this.rebootPage;
        this.rebootPage.displayPage();
    }

    public final void displaySettingsPage() {
        this.curLcdPage = this.settingsPage;
        this.displayPage();
    }

    public final void displaySettingsTimezonePage() {
        this.curLcdPage = this.settingsTZPage;
        this.displayPage();
    }

    public final void displaySchedulePage() {
        this.curLcdPage = this.schedulePage;
        this.displayPage();
    }

    public final void displaySchedDetailsPage(BComplex schedule) {
        this.curLcdPage = this.schedDetailsPage;
        try {
            this.schedDetailsPage.displayPage(schedule);
        }
        catch (Exception e) {
            System.err.println("BSerialLcdNetwork.displaySchedDetailsPage(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void displaySchedEventPage(SerialLcdScheduleGrid scheduleArray, int eventNumber) {
        this.curLcdPage = this.schedEventPage;
        try {
            this.schedEventPage.displayPage(scheduleArray, eventNumber);
        }
        catch (Exception e) {
            System.err.println("BSerialLcdNetwork.displaySchedEventPage(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void displaySchedSelectPage(SerialLcdScheduleGrid scheduleArray) {
        this.curLcdPage = this.schedSelectPage;
        try {
            this.schedSelectPage.displayPage(scheduleArray);
        }
        catch (Exception e) {
            System.err.println("BSerialLcdNetwork.displaySchedSelectPage(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void displayAlarmPage() {
        this.curLcdPage = this.alarmPage;
        this.displayPage();
    }

    public final void displayAlarmConsolePage(BConsoleRecipient consoleRecipient) {
        this.curLcdPage = this.alarmConsolePage;
        try {
            this.alarmConsolePage.displayPage(consoleRecipient);
        }
        catch (Exception e) {
            System.err.println("BSerialLcdNetwork.displayAlarmConsolePage(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void displayAlarmDetailsPage(BAlarmRecord alarm, BConsoleRecipient consoleRecipient) {
        this.curLcdPage = this.alarmDetailsPage;
        try {
            this.alarmDetailsPage.displayPage(alarm, consoleRecipient);
        }
        catch (Exception e) {
            System.err.println("BSerialLcdNetwork.displayAlarmDetailsPage(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void displayIPSettingsPage() {
        this.curLcdPage = this.ipSettingsPage;
        this.displayPage();
    }

    public final void displayInvalidDevicePage() {
        this.curLcdPage = this.invalidPage;
        this.displayPage();
    }

    public final void displayPage() {
        try {
            this.curLcdPage.displayPage();
        }
        catch (Exception e) {
            System.err.println("BSerialLcdNetwork.displayPage(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void displayPage(int pageNumber) {
        this.curPage = pageNumber;
        if (this.curPage > -1) {
            this.curLcdPage = this.page[this.curPage];
            this.displayPage();
        }
    }

    public final void openDialog(int outputOptions, String outputText) {
        SerialLcdPage prevPage = this.curLcdPage;
        this.curLcdPage = this.dialogBox;
        String[] outText = TextUtil.split((String)outputText, (char)'\n');
        this.dialogBox.displayPage(outputOptions, outText, prevPage);
    }

    public final void updatePageValues() {
        if (this.curPage > -1 && this.curLcdPage instanceof SerialLcdBasicPage) {
            this.page[this.curPage].updateValues();
        }
    }

    public final boolean isOn() {
        if (this.checkStatusTicket == null) {
            return false;
        }
        return !this.checkStatusTicket.isExpired();
    }

    public final boolean getStallOutput() {
        return this.stallOutput;
    }

    public final void setStallOutput(boolean stallOutput) {
        this.stallOutput = stallOutput;
    }

    public final void setLastInputTime() {
        this.lastInputTime = BAbsTime.now();
    }

    public final SerialLcdPage getCurrentPage() {
        return this.curLcdPage;
    }

    public final boolean getPasscodeVerified() {
        return this.passcodeVerified;
    }

    public final void setPasscodeVerified(boolean verified) {
        this.passcodeVerified = verified;
    }

    public void setPageViaPopup(SerialLcdPage page) {
        this.curLcdPage = page;
    }

    public boolean getHideMainMenu() {
        return this.hideMainMenu;
    }

    public void setHideMainMenu(boolean b) {
        this.hideMainMenu = b;
    }

    public final void doCheckStatus() throws Exception {
        if (BAbsTime.now().isAfter(this.lastInputTime.add(this.getDeviceTimeout()))) {
            this.clearPage();
            SerialLcdPage.resetRapidButtonPresses();
            try {
                this.sendCommand(SerialLcdBacklightCommand.makeOff());
            }
            catch (Exception e) {
                System.err.println("Error Turning Off Device - " + e.toString());
                e.printStackTrace();
            }
            this.setPasscodeVerified(!this.getSecurityEnabled());
            if (this.checkStatusTicket != null) {
                this.checkStatusTicket.cancel();
            }
        } else if (this.getPasscodeVerified()) {
            this.updatePageValues();
        }
    }

    public void refreshDevice() {
        this.getComm().transmit((Message)new SerialLcdVerifyMessage());
        System.out.println();
        System.out.println(lex.getText("validLCD"));
        System.out.println(lex.getText("dateCode") + ": " + this.getDeviceDateCode());
        System.out.println(lex.getText("lotNumber") + ": " + this.getDeviceLotNumber());
        System.out.println();
        this.restorePage(0);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(BSerialLcdNetwork.this.getSplashTime().getMillis());
                    BSerialLcdNetwork.this.sendCommand(new SerialLcdClearCommand(ROW[8], 0, 127));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (BSerialLcdNetwork.this.getSecurityEnabled()) {
                    BSerialLcdNetwork.this.displaySecurityPage();
                } else {
                    BSerialLcdNetwork.this.displayMenuPage();
                }
            }
        }.start();
        this.setLastInputTime();
        if (this.checkStatusTicket != null) {
            this.checkStatusTicket.cancel();
        }
        this.checkStatusTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)5), (Action)checkStatus, null);
    }

    public void doRestoreDefaultSplashImage() throws Exception {
        this.setLogoRowValues(rows[0] + "," + rows[1] + "," + rows[2] + "," + rows[3] + "," + rows[4] + "," + rows[5] + "," + rows[6] + "," + rows[7]);
        this.setLogoColumnValues(cols[0] + "," + cols[1] + "," + cols[2] + "," + cols[3] + "," + cols[4] + "," + cols[5] + "," + cols[6] + "," + cols[7]);
    }

    static /* synthetic */ SerialLcdBasicPage[] access$102(BSerialLcdNetwork x0, SerialLcdBasicPage[] x1) {
        x0.page = x1;
        return x1;
    }

    private class UpdateInterface
    extends Thread {
        UpdateInterface() {
        }

        @Override
        public void run() {
            BSerialLcdNetwork.access$102(BSerialLcdNetwork.this, new SerialLcdBasicPage[0]);
            BSerialLcdNetwork.this.curPage = 0;
            BSerialLcdNetwork.this.passcodeVerified = !BSerialLcdNetwork.this.getSecurityEnabled();
            BSerialLcdNetwork.this.mainMenuPage.updateMenu();
            BOrd ordQuery = BOrd.make((String)"station:|slot:/|bql:select from lynxLCD:SerialLcdPointExtension");
            BITable result = (BITable)ordQuery.resolve((BObject)BSerialLcdNetwork.this).get();
            TableCursor c = result.cursor();
            BSerialLcdPointExtension[] exts = new BSerialLcdPointExtension[]{};
            while (c.next()) {
                exts = (BSerialLcdPointExtension[])ArrayUtil.addOne((Object[])exts, (Object)((Object)((BSerialLcdPointExtension)((Object)c.get()))));
            }
            BSerialLcdPointExtension[] numericSortExts = new BSerialLcdPointExtension[]{};
            Object[] numericSortOrders = new Integer[]{};
            BSerialLcdPointExtension[] alphSortExts = new BSerialLcdPointExtension[]{};
            Object[] alphaSortOrders = new String[]{};
            numericSortOrders = new Integer[]{};
            for (int i = 0; i < exts.length; ++i) {
                numericSortOrders = (Integer[])ArrayUtil.addOne((Object[])numericSortOrders, (Object)new Integer(exts[i].getPage()));
            }
            if (exts.length > 0) {
                SortUtil.sort((Object[])numericSortOrders, (Object[])exts);
            }
            int curPage = -1;
            BSerialLcdPointExtension[] sortedExts = new BSerialLcdPointExtension[]{};
            for (int i = 0; i < exts.length; ++i) {
                if (curPage != exts[i].getPage()) {
                    curPage = exts[i].getPage();
                    if (numericSortExts.length > 0) {
                        SortUtil.sort((Object[])numericSortOrders, (Object[])numericSortExts);
                        sortedExts = (BSerialLcdPointExtension[])ArrayUtil.add((Object[])sortedExts, (Object[])numericSortExts);
                    }
                    if (alphSortExts.length > 0) {
                        SortUtil.sort((Object[])alphaSortOrders, (Object[])alphSortExts);
                        sortedExts = (BSerialLcdPointExtension[])ArrayUtil.add((Object[])sortedExts, (Object[])alphSortExts);
                    }
                    numericSortExts = new BSerialLcdPointExtension[]{};
                    numericSortOrders = new Integer[]{};
                    alphSortExts = new BSerialLcdPointExtension[]{};
                    alphaSortOrders = new String[]{};
                }
                if (exts[i].getSortOrder() > 0) {
                    numericSortExts = (BSerialLcdPointExtension[])ArrayUtil.addOne((Object[])numericSortExts, (Object)((Object)exts[i]));
                    numericSortOrders = (Integer[])ArrayUtil.addOne((Object[])numericSortOrders, (Object)new Integer(exts[i].getSortOrder()));
                    continue;
                }
                alphSortExts = (BSerialLcdPointExtension[])ArrayUtil.addOne((Object[])alphSortExts, (Object)((Object)exts[i]));
                alphaSortOrders = (String[])ArrayUtil.addOne((Object[])alphaSortOrders, (Object)exts[i].getDisplayedLabelText());
            }
            if (numericSortExts.length > 0) {
                SortUtil.sort((Object[])numericSortOrders, (Object[])numericSortExts);
                sortedExts = (BSerialLcdPointExtension[])ArrayUtil.add((Object[])sortedExts, (Object[])numericSortExts);
            }
            if (alphSortExts.length > 0) {
                SortUtil.sort((Object[])alphaSortOrders, (Object[])alphSortExts);
                sortedExts = (BSerialLcdPointExtension[])ArrayUtil.add((Object[])sortedExts, (Object[])alphSortExts);
            }
            exts = sortedExts;
            int curExtPage = -1;
            curPage = -1;
            int curValueWidth = 20;
            for (int i = 0; i < exts.length; ++i) {
                int tmpWidth;
                if (curExtPage != exts[i].getPage()) {
                    String pageName = lex.getText("page") + " " + exts[i].getPage();
                    int test = -1;
                    try {
                        test = Integer.parseInt(BSerialLcdNetwork.this.getPageNames().getDisplayTag(exts[i].getPage(), null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (test == -1) {
                        pageName = TextUtil.toFriendly((String)BSerialLcdNetwork.this.getPageNames().getDisplayTag(exts[i].getPage(), null));
                    }
                    if (pageName.length() > 20) {
                        pageName = pageName.substring(0, 20);
                    }
                    BSerialLcdNetwork.access$102(BSerialLcdNetwork.this, (SerialLcdBasicPage[])ArrayUtil.addOne((Object[])BSerialLcdNetwork.this.page, (Object)new SerialLcdBasicPage(BSerialLcdNetwork.this, pageName)));
                    curPage = BSerialLcdNetwork.this.page.length - 1;
                    curExtPage = exts[i].getPage();
                    curValueWidth = 20;
                }
                if ((tmpWidth = exts[i].getValueWidth()) > BSerialLcdNetwork.this.getMaxValueWidth()) {
                    tmpWidth = BSerialLcdNetwork.this.getMaxValueWidth();
                }
                if (tmpWidth > curValueWidth) {
                    curValueWidth = tmpWidth;
                    BSerialLcdNetwork.this.page[curPage].setValueWidth(curValueWidth);
                }
                BSerialLcdNetwork.this.page[curPage].addExtension(exts[i]);
            }
            if (BSerialLcdNetwork.this.page.length > 0) {
                curPage = 0;
            }
            BSerialLcdNetwork.this.refreshDevice();
        }
    }

    private class BurnInThread
    extends Thread
    implements Runnable {
        boolean stop;

        public BurnInThread(boolean stop) {
            this.stop = stop;
        }

        @Override
        public final void run() {
            char c = ' ';
            int charWidth = 0;
            int a = 0;
            try {
                int pixY;
                Object[] commands = new SerialLcdCommand[]{};
                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
                for (pixY = 0; pixY < 64; ++pixY) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, pixY, 127, pixY, true));
                }
                BSerialLcdNetwork.this.sendCommands((SerialLcdCommand[])commands);
                commands = new SerialLcdCommand[]{};
                for (pixY = 0; pixY < 64; ++pixY) {
                    commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdLineCommand(0, pixY, 127, pixY, false));
                }
                BSerialLcdNetwork.this.sendCommands((SerialLcdCommand[])commands);
                Thread.sleep(1500L);
                commands = new SerialLcdCommand[]{};
                while (!this.stop) {
                    c = ' ';
                    for (int j = 0; j < 15; ++j) {
                        commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
                        for (int row = 0; row < 8; ++row) {
                            a = 0;
                            for (int i = 0; i < 30 && a + BSerialLcdPointExtension.getCharWidth(c) < 128; ++i) {
                                commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[row], a, "" + c));
                                charWidth = BSerialLcdPointExtension.getCharWidth(c);
                                a += charWidth + 1;
                            }
                            BSerialLcdNetwork.this.sendCommands((SerialLcdCommand[])commands);
                            commands = new SerialLcdCommand[]{};
                            c = (char)(c + '\u0001');
                        }
                        Thread.sleep(1500L);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error Displaying Page - " + e.toString());
                e.printStackTrace();
            }
        }
    }
}

