/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.sysmon.BAbstractAlarmMonitor;
import java.io.StringWriter;
import java.io.Writer;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.BSpy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
public final class BSocketStateMonitor
extends BAbstractAlarmMonitor {
    @Generated
    public static final Type TYPE = Sys.loadType(BSocketStateMonitor.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:socketStateToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:socketStateToOffnormal)%";
    }

    @Override
    public void doRunCheck() {
        this.checkNetstatStates();
    }

    private void checkNetstatStates() {
        try {
            if (PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
                StringWriter strWtr = new StringWriter();
                SpyWriter writer = new SpyWriter((Writer)strWtr, new FilePath("/"));
                ((BSpy)BOrd.make((String)"spy:/platform diagnostics/netstat -A").get((BObject)this)).get().write(writer);
                String[] lines = TextUtil.splitAndTrim((String)strWtr.toString(), (char)'\n');
                String closeWaitLine = null;
                for (String line : lines) {
                    if (!line.contains("CLOSE_WAIT")) continue;
                    closeWaitLine = line;
                    break;
                }
                if (closeWaitLine != null) {
                    BFormat msg = BFormat.make((String)(this.getToOffnormalText() + ": " + closeWaitLine));
                    this.getLog().warning(msg.format((Object)this));
                    this.raiseAlarm(msg, true);
                } else {
                    this.raiseAlarm(false);
                }
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking Socket State", (Throwable)e);
        }
    }
}

