/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.sysmon.BAbstractCPUMonitor;
import com.tridium.sysmon.BSystemMonitorService;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="targetCPU", type="int", defaultValue="-1"), @NiagaraProperty(name="lastInterval", type="long", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastIntervalPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="sinceStartPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="lastMinute", type="long", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastMinutePercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="lastHour", type="long", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastHourPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="lastDay", type="long", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastDayPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")})})
@NiagaraActions(value={@NiagaraAction(name="pollMinute", flags=4), @NiagaraAction(name="pollHour", flags=4), @NiagaraAction(name="pollDay", flags=4)})
public final class BIdleCPUMonitor
extends BAbstractCPUMonitor {
    @Generated
    public static final Property targetCPU = BIdleCPUMonitor.newProperty((int)0, (int)-1, null);
    @Generated
    public static final Property lastInterval = BIdleCPUMonitor.newProperty((int)3, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Property lastIntervalPercent = BIdleCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    @Generated
    public static final Property sinceStartPercent = BIdleCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    @Generated
    public static final Property lastMinute = BIdleCPUMonitor.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Property lastMinutePercent = BIdleCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    @Generated
    public static final Property lastHour = BIdleCPUMonitor.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Property lastHourPercent = BIdleCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    @Generated
    public static final Property lastDay = BIdleCPUMonitor.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Property lastDayPercent = BIdleCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    @Generated
    public static final Action pollMinute = BIdleCPUMonitor.newAction((int)4, null);
    @Generated
    public static final Action pollHour = BIdleCPUMonitor.newAction((int)4, null);
    @Generated
    public static final Action pollDay = BIdleCPUMonitor.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIdleCPUMonitor.class);
    Clock.Ticket pollMinuteTicket = null;
    Clock.Ticket pollHourTicket = null;
    Clock.Ticket pollDayTicket = null;
    long idleMillisecondsAtStart = 0L;
    long timeAtStart = 0L;
    long lastTriggerTimeMillis = 0L;
    long idleMillisAtPreviousInterval = 0L;
    long idleMillisAtPreviousMinute = 0L;
    long idleMillisAtPreviousHour = 0L;
    long idleMillisAtPreviousDay = 0L;

    @Generated
    public int getTargetCPU() {
        return this.getInt(targetCPU);
    }

    @Generated
    public void setTargetCPU(int v) {
        this.setInt(targetCPU, v, null);
    }

    @Generated
    public long getLastInterval() {
        return this.getLong(lastInterval);
    }

    @Generated
    public void setLastInterval(long v) {
        this.setLong(lastInterval, v, null);
    }

    @Generated
    public double getLastIntervalPercent() {
        return this.getDouble(lastIntervalPercent);
    }

    @Generated
    public void setLastIntervalPercent(double v) {
        this.setDouble(lastIntervalPercent, v, null);
    }

    @Generated
    public double getSinceStartPercent() {
        return this.getDouble(sinceStartPercent);
    }

    @Generated
    public void setSinceStartPercent(double v) {
        this.setDouble(sinceStartPercent, v, null);
    }

    @Generated
    public long getLastMinute() {
        return this.getLong(lastMinute);
    }

    @Generated
    public void setLastMinute(long v) {
        this.setLong(lastMinute, v, null);
    }

    @Generated
    public double getLastMinutePercent() {
        return this.getDouble(lastMinutePercent);
    }

    @Generated
    public void setLastMinutePercent(double v) {
        this.setDouble(lastMinutePercent, v, null);
    }

    @Generated
    public long getLastHour() {
        return this.getLong(lastHour);
    }

    @Generated
    public void setLastHour(long v) {
        this.setLong(lastHour, v, null);
    }

    @Generated
    public double getLastHourPercent() {
        return this.getDouble(lastHourPercent);
    }

    @Generated
    public void setLastHourPercent(double v) {
        this.setDouble(lastHourPercent, v, null);
    }

    @Generated
    public long getLastDay() {
        return this.getLong(lastDay);
    }

    @Generated
    public void setLastDay(long v) {
        this.setLong(lastDay, v, null);
    }

    @Generated
    public double getLastDayPercent() {
        return this.getDouble(lastDayPercent);
    }

    @Generated
    public void setLastDayPercent(double v) {
        this.setDouble(lastDayPercent, v, null);
    }

    @Generated
    public void pollMinute() {
        this.invoke(pollMinute, null, null);
    }

    @Generated
    public void pollHour() {
        this.invoke(pollHour, null, null);
    }

    @Generated
    public void pollDay() {
        this.invoke(pollDay, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String getHistoryName() {
        return "idleCPUTime";
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:idleCPUCyclesToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:idleCPUCyclesToOffnormal)%";
    }

    @Override
    protected long checkCPU() {
        long idleThisInterval = 0L;
        try {
            long idleNow = BSystemMonitorService.PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getIdleTime(this.getTargetCPU());
            idleThisInterval = idleNow - this.idleMillisAtPreviousInterval;
            long timeNow = System.currentTimeMillis();
            long timeElapsedMillis = timeNow - this.lastTriggerTimeMillis;
            if (this.getTargetCPU() == -1) {
                timeElapsedMillis *= (long)Runtime.getRuntime().availableProcessors();
            }
            this.lastTriggerTimeMillis = timeNow;
            double percent = (double)idleThisInterval * 100.0 / (double)timeElapsedMillis;
            this.setLastInterval(idleThisInterval);
            this.setLastIntervalPercent(percent);
            this.idleMillisAtPreviousInterval = idleNow;
            long idleMillisSinceStart = idleNow - this.idleMillisecondsAtStart;
            timeElapsedMillis = System.currentTimeMillis() - this.timeAtStart;
            if (this.getTargetCPU() == -1) {
                timeElapsedMillis *= (long)Runtime.getRuntime().availableProcessors();
            }
            double sinceStartPercent = (double)idleMillisSinceStart * 100.0 / (double)timeElapsedMillis;
            this.setSinceStartPercent(sinceStartPercent);
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Idle milliseconds in last interval: " + idleThisInterval + " (" + percent + "%)");
                this.getLog().trace("Idle milliseconds since started: " + idleMillisSinceStart + " (" + sinceStartPercent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking CPU idle cycles", (Throwable)e);
        }
        return idleThisInterval;
    }

    public void doPollMinute() {
        try {
            long idleNow = BSystemMonitorService.PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getIdleTime(this.getTargetCPU());
            long idleThisMinute = idleNow - this.idleMillisAtPreviousMinute;
            long elapsed = 60000L;
            if (this.getTargetCPU() == -1) {
                elapsed *= (long)Runtime.getRuntime().availableProcessors();
            }
            double percent = (double)idleThisMinute * 100.0 / (double)elapsed;
            this.setLastMinute(idleThisMinute);
            this.setLastMinutePercent(percent);
            this.idleMillisAtPreviousMinute = idleNow;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Idle milliseconds in last minute: " + idleThisMinute + " (" + percent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking minutely CPU idle cycles", (Throwable)e);
        }
    }

    public void doPollHour() {
        try {
            long idleNow = BSystemMonitorService.PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getIdleTime(this.getTargetCPU());
            long idleThisHour = idleNow - this.idleMillisAtPreviousHour;
            long elapsed = 3600000L;
            if (this.getTargetCPU() == -1) {
                elapsed *= (long)Runtime.getRuntime().availableProcessors();
            }
            double percent = (double)idleThisHour * 100.0 / (double)elapsed;
            this.setLastHour(idleThisHour);
            this.setLastHourPercent(percent);
            this.idleMillisAtPreviousHour = idleNow;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Idle milliseconds in last hour: " + idleThisHour + " (" + percent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking hourly CPU idle cycles", (Throwable)e);
        }
    }

    public void doPollDay() {
        try {
            long idleNow = BSystemMonitorService.PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getIdleTime(this.getTargetCPU());
            long idleThisDay = idleNow - this.idleMillisAtPreviousDay;
            long elapsed = 86400000L;
            if (this.getTargetCPU() == -1) {
                elapsed *= (long)Runtime.getRuntime().availableProcessors();
            }
            double percent = (double)idleThisDay * 100.0 / (double)elapsed;
            this.setLastDay(idleThisDay);
            this.setLastDayPercent(percent);
            this.idleMillisAtPreviousDay = idleNow;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Idle milliseconds in last day: " + idleThisDay + " (" + percent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking daily CPU idle cycles", (Throwable)e);
        }
    }

    @Override
    public void doStarted() throws Exception {
        this.idleMillisecondsAtStart = BSystemMonitorService.PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getIdleTime(this.getTargetCPU());
        this.lastTriggerTimeMillis = this.timeAtStart = System.currentTimeMillis();
        this.idleMillisAtPreviousMinute = this.idleMillisecondsAtStart;
        this.idleMillisAtPreviousInterval = this.idleMillisecondsAtStart;
        this.idleMillisAtPreviousHour = this.idleMillisecondsAtStart;
        this.idleMillisAtPreviousDay = this.idleMillisecondsAtStart;
        if (this.pollMinuteTicket != null) {
            this.pollMinuteTicket.cancel();
        }
        if (this.pollHourTicket != null) {
            this.pollHourTicket.cancel();
        }
        if (this.pollDayTicket != null) {
            this.pollDayTicket.cancel();
        }
        Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.MINUTE, (Action)pollMinute, null);
        Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.HOUR, (Action)pollHour, null);
        Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.DAY, (Action)pollDay, null);
        super.doStarted();
    }

    public void stopped() {
        if (this.pollMinuteTicket != null) {
            this.pollMinuteTicket.cancel();
        }
        if (this.pollHourTicket != null) {
            this.pollHourTicket.cancel();
        }
        if (this.pollDayTicket != null) {
            this.pollDayTicket.cancel();
        }
    }
}

