/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.sysmon.BAbstractAlarmMonitor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="logMemoryToHistory", type="boolean", defaultValue="false"), @NiagaraProperty(name="memoryHistoryConfig", type="BHistoryConfig", defaultValue="new BHistoryConfig()")})
public abstract class BAbstractMemoryMonitor
extends BAbstractAlarmMonitor {
    @Generated
    public static final Property logMemoryToHistory = BAbstractMemoryMonitor.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property memoryHistoryConfig = BAbstractMemoryMonitor.newProperty((int)0, (BValue)new BHistoryConfig(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractMemoryMonitor.class);
    protected static final BFacets KB_UNITS = BFacets.makeInt((BUnit)BUnit.make((String)"KB", (String)"KB", (BDimension)BDimension.DEFAULT));

    @Generated
    public boolean getLogMemoryToHistory() {
        return this.getBoolean(logMemoryToHistory);
    }

    @Generated
    public void setLogMemoryToHistory(boolean v) {
        this.setBoolean(logMemoryToHistory, v, null);
    }

    @Generated
    public BHistoryConfig getMemoryHistoryConfig() {
        return (BHistoryConfig)this.get(memoryHistoryConfig);
    }

    @Generated
    public void setMemoryHistoryConfig(BHistoryConfig v) {
        this.set(memoryHistoryConfig, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doStarted() {
        BHistoryConfig config = this.getMemoryHistoryConfig();
        config.setId(BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.getHistoryName()));
        config.setRecordType(BTypeSpec.make((Type)BNumericTrendRecord.TYPE));
    }

    protected abstract long checkMemory();

    protected abstract String getHistoryName();

    @Override
    public final void doRunCheck() {
        long mem = this.checkMemory();
        if (this.getLogMemoryToHistory()) {
            this.logMemory(this.getMemoryHistoryConfig(), mem);
        }
    }

    protected void logMemory(BHistoryConfig config, long mem) {
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (db == null) {
                this.getLog().error("Local history database not available.");
                return;
            }
            config.setTimeZone(BTimeZone.getLocal());
            BHistoryId id = config.getId();
            if (id.getDeviceName().equals("^")) {
                config.setId(BHistoryId.make((String)Sys.getStation().getStationName(), (String)id.getHistoryName()));
            }
            try (HistorySpaceConnection conn = db.getConnection(null);){
                if (!conn.exists(id)) {
                    conn.createHistory(config);
                } else {
                    HistoryDatabaseConnection dbConn = db.getDbConnection(null);
                    dbConn.reconfigureHistory(config);
                }
                BIHistory history = conn.getHistory(id);
                BNumericTrendRecord rec = new BNumericTrendRecord();
                rec.set(BAbsTime.now(), (double)mem, BStatus.ok);
                conn.append(history, (BIHistoryRecordSet)rec);
            }
        }
        catch (Exception e) {
            this.getLog().error("Error creating the memory history", (Throwable)e);
        }
    }
}

