/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfSerial.comm;

import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddfSerial.comm.BDdfSerialCommunicator;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="maxRetryCount", type="int", defaultValue="2", facets={@Facet(value="BFacets.make(BFacets.MIN,BInteger.make(0))")}, override=true)
public class BDdfSerialTransmitter
extends BDdfTransmitter {
    @Generated
    public static final Property maxRetryCount = BDdfSerialTransmitter.newProperty((int)0, (int)2, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfSerialTransmitter.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void forceTransmit(BIDdfRequest ddfRequest) throws Exception {
        byte[] out = ddfRequest.toByteArray();
        if (this.getDdfCommunicator().getLog().isTraceOn()) {
            this.trace(out);
        }
        this.getSerialCommunicator().getSerialOutputStream().write(out);
    }

    public BDdfSerialCommunicator getSerialCommunicator() {
        return (BDdfSerialCommunicator)this.getDdfCommunicator();
    }

    private void trace(byte[] out) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("TX:");
        ByteArrayUtil.hexDump((PrintWriter)pw, (byte[])out, (int)0, (int)out.length);
        pw.flush();
        pw.close();
        this.getDdfCommunicator().getLog().trace(sw.toString());
    }
}

