/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.oracle;

import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.rdb.BEncryptableTransportRdbms;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.oracle.BOracleConnectionPool;
import com.tridium.rdb.oracle.history.BOracleHistoryDeviceExt;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import org.apache.commons.dbcp2.DelegatingConnection;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="port", type="int", defaultValue="1521"), @NiagaraProperty(name="serviceName", type="String", defaultValue=""), @NiagaraProperty(name="histories", type="BOracleHistoryDeviceExt", defaultValue="new BOracleHistoryDeviceExt()"), @NiagaraProperty(name="connectionPool", type="BOracleConnectionPool", defaultValue="new BOracleConnectionPool()", flags=4), @NiagaraProperty(name="serverCertificate", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:UserTrustCertificateAliasFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:CertificateAliasEditor\"))"), @Facet(value="BFacets.make(\"storeId\", BString.make(\"USER_TRUST_STORE\"))"), @Facet(value="BFacets.make(\"purposeId\", BString.make(\"\"))")})})
public class BOracleDatabase
extends BEncryptableTransportRdbms {
    @Generated
    public static final Property port = BOracleDatabase.newProperty((int)0, (int)1521, null);
    @Generated
    public static final Property serviceName = BOracleDatabase.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property histories = BOracleDatabase.newProperty((int)0, (BValue)new BOracleHistoryDeviceExt(), null);
    @Generated
    public static final Property connectionPool = BOracleDatabase.newProperty((int)4, (BValue)new BOracleConnectionPool(), null);
    @Generated
    public static final Property serverCertificate = BOracleDatabase.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:UserTrustCertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"storeId", (BIDataValue)BString.make((String)"USER_TRUST_STORE"))), (BFacets)BFacets.make((String)"purposeId", (BIDataValue)BString.make((String)""))));
    @Generated
    public static final Type TYPE = Sys.loadType(BOracleDatabase.class);
    private final RdbmsDialect DIALECT = new RdbmsDialect(){
        private static final String SEQUENCE_SUFFIX = "SQ";
        private static final int MAX_SEQUENCE_LEN = 128;

        public String getValidationQuery() {
            return "select 1 from dual";
        }

        public void issueCheckpoint(Connection conn) throws SQLException {
        }

        public boolean supportsBatchInsert() {
            return true;
        }

        public boolean supportsBatchUpdate() {
            return true;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 0;
        }

        public String getIdentityCreation() {
            throw new UnsupportedOperationException();
        }

        public String getIdentityLookup() {
            throw new UnsupportedOperationException();
        }

        public String getSequenceName(String tableName) {
            return this.makeSuffixName(tableName, SEQUENCE_SUFFIX, 128);
        }

        private String makeSuffixName(String tableName, String suffix, int max) {
            int slen;
            int tlen = tableName.length();
            if (tlen + (slen = suffix.length()) <= max) {
                return tableName + suffix;
            }
            return tableName.substring(0, max - slen) + suffix;
        }

        public String getSequenceLookup(String tableName) {
            return "SELECT " + this.getSequenceName(tableName) + ".NEXTVAL FROM DUAL";
        }

        public String getAlterColumn() {
            return "MODIFY";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return true;
        }

        public String getStringLengthFunctionName() {
            return "LENGTH";
        }

        public int getMaxTableName() {
            return 128;
        }

        public int getMaxIndexName() {
            return 128;
        }

        public int getMaxConstraintName() {
            return 128;
        }

        public int getMaxColumnName() {
            return 128;
        }

        public boolean allowsUnicodeNames() {
            return false;
        }

        public String getColumnIdentifier(String schemaName, String tableName, String columnName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName + ".\"" + columnName + "\"";
            }
            return tableName + ".\"" + columnName + "\"";
        }

        public String getTableIdentifier(String schemaName, String tableName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName;
            }
            return tableName;
        }

        public String getDropIndex(String tableName, String indexName) {
            return "DROP INDEX " + indexName;
        }

        public String getDropConstraint(String tableName, Constraint constraint) {
            return "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraint.getName();
        }

        public String getIntType() {
            return "INT";
        }

        public String getLongType() {
            return "INT";
        }

        public String getFloatType() {
            return "REAL";
        }

        public String getDoubleType() {
            return "FLOAT";
        }

        public String getCharType() {
            return BOracleDatabase.this.getUseUnicodeEncodingScheme() ? "NCHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BOracleDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR2" : "VARCHAR2";
        }

        public String getUuidType() {
            return "RAW(16)";
        }

        public String getTimestampType() {
            return "TIMESTAMP";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            throw new UnsupportedOperationException();
        }

        public boolean supportsBooleanType() {
            return false;
        }

        public boolean supportsDateType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return !BOracleDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcMillis);
        }

        public boolean useUtcTimestamps() {
            return BOracleDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public String getBlobType() {
            return "BLOB";
        }

        public boolean usesDefaultBlobTranslator() {
            return false;
        }

        public void setBlobValue(RdbmsPreparedStatement rdbPrep, int index, byte[] bytes) {
            try {
                Connection conn = rdbPrep.getConnection();
                PreparedStatement prep = rdbPrep.getStatement();
                Connection oracleConnection = conn;
                if (oracleConnection instanceof DelegatingConnection) {
                    oracleConnection = ((DelegatingConnection)oracleConnection).getInnermostDelegate();
                }
                Blob blob = oracleConnection.createBlob();
                try (BufferedOutputStream out = new BufferedOutputStream(blob.setBinaryStream(1L));){
                    ((OutputStream)out).write(bytes);
                    ((OutputStream)out).flush();
                    prep.setBlob(index, blob);
                }
            }
            catch (IOException | SQLException e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public String getClobType() {
            return BOracleDatabase.this.getUseUnicodeEncodingScheme() ? "NCLOB" : "CLOB";
        }

        public boolean usesDefaultClobTranslator() {
            return false;
        }

        public void setClobValue(RdbmsPreparedStatement rdbPrep, int index, String str) {
            try {
                Connection conn = rdbPrep.getConnection();
                PreparedStatement prep = rdbPrep.getStatement();
                Connection oracleConnection = conn;
                if (oracleConnection instanceof DelegatingConnection) {
                    oracleConnection = ((DelegatingConnection)oracleConnection).getInnermostDelegate();
                }
                Clob clob = oracleConnection.createClob();
                try (Writer writer = clob.setCharacterStream(0L);){
                    writer.write(str.toCharArray());
                    writer.flush();
                    prep.setClob(index, clob);
                }
            }
            catch (IOException | SQLException e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public AesSysKeyEncoder getSysEncoder() {
            return BOracleDatabase.this.getEncoder();
        }

        public String getOnDelete(int onDelete) {
            switch (onDelete) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "SET NULL";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return false;
        }

        public int getJdbcTypeBlob() {
            return 2004;
        }

        public int getJdbcTypeBoolean() {
            return 1;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return 2005;
        }

        public int getJdbcTypeDouble() {
            return 2;
        }

        public int getJdbcTypeFloat() {
            return 2;
        }

        public int getJdbcTypeInt() {
            return 2;
        }

        public int getJdbcTypeLong() {
            return 2;
        }

        public int getJdbcTypeTimestamp() {
            return 93;
        }

        public int getJdbcTypeUuid() {
            return -3;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return 91;
        }
    };
    private static final File ORACLE_RDB_DIR = new File(Sys.getProtectedStationHome(), Objects.requireNonNull(TYPE.getModule().getModuleName()));
    private final File trustStore = new File(ORACLE_RDB_DIR, BUuid.make() + "." + this.getTrustStoreType());
    private static final String TRUST_STORE_PASSWORD_KEYRING_ALIAS = "rdbOracle.trustStore";
    private static final int ORACLE_FETCH_SIZE = 1000;

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public String getServiceName() {
        return this.getString(serviceName);
    }

    @Generated
    public void setServiceName(String v) {
        this.setString(serviceName, v, null);
    }

    @Generated
    public BOracleHistoryDeviceExt getHistories() {
        return (BOracleHistoryDeviceExt)this.get(histories);
    }

    @Generated
    public void setHistories(BOracleHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    @Generated
    public BOracleConnectionPool getConnectionPool() {
        return (BOracleConnectionPool)this.get(connectionPool);
    }

    @Generated
    public void setConnectionPool(BOracleConnectionPool v) {
        this.set(connectionPool, (BValue)v, null);
    }

    @Generated
    public String getServerCertificate() {
        return this.getString(serverCertificate);
    }

    @Generated
    public void setServerCertificate(String v) {
        this.setString(serverCertificate, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOracleDatabase() {
    }

    public BOracleDatabase(BOrd address, int port, String serviceName) {
        this.setHostAddress(address);
        this.setPort(port);
        this.setServiceName(serviceName);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbOracle");
    }

    public Connection getConnection(String userName, BPassword password) throws SQLException {
        BStatus status = this.getStatus();
        if (status.isFault()) {
            return null;
        }
        return this.getConnectionPool().getConnection(userName, AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
    }

    public RdbmsContext getRdbmsContext() {
        return this.DIALECT;
    }

    public int getResultSetFetchSize() {
        return 1000;
    }

    protected void initializeTrustStore() throws IOException {
        block3: {
            try {
                AccessController.doPrivileged(() -> {
                    if (!this.trustStore.getParentFile().exists() && !this.trustStore.getParentFile().mkdirs()) {
                        throw new IOException("Unable to create rdbOracle directory for Oracle Database: " + this.getDisplayName(Context.NULL));
                    }
                    this.trustStore.deleteOnExit();
                    if (this.getUseEncryptedConnection()) {
                        this.updateCertificateInTrustStore(this.getServerCertificate(), Context.NULL);
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                if (!(e.getCause() instanceof SecurityException)) break block3;
                throw (SecurityException)e.getCause();
            }
        }
    }

    protected void loadTrustStore(KeyStore keyStore, Context context) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                try (InputStream is = this.trustStore.exists() ? Files.newInputStream(this.getTrustStorePath(), new OpenOption[0]) : null;
                     SecretChars trustStorePassword = this.getTrustStorePassword();){
                    keyStore.load(is, trustStorePassword.get());
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new BajaRuntimeException(String.format("Unable to load KeyStore for Oracle database: %s", this.getDisplayName(context)), (Throwable)e);
        }
    }

    protected void saveTrustStore(KeyStore keyStore, Context context) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                try (OutputStream os = Files.newOutputStream(this.getTrustStorePath(), new OpenOption[0]);
                     SecretChars trustStorePassword = this.getTrustStorePassword();){
                    keyStore.store(os, trustStorePassword.get());
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new BajaRuntimeException(String.format("Unable to store KeyStore for Oracle database: %s", this.getDisplayName(context)), (Throwable)e);
        }
    }

    public String getServerCertificateSubjectIdentifier() {
        if (this.getVerifySubjectInCertificate() && this.getServerCertificate().isEmpty()) {
            return String.format("CN=%s", this.getHostname());
        }
        try {
            X509Certificate serverCertificate = this.getServerCertificateFromSource(this.getServerCertificate());
            return serverCertificate == null ? "" : serverCertificate.getSubjectX500Principal().getName();
        }
        catch (GeneralSecurityException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected Property getServerCertificateProperty() {
        return serverCertificate;
    }

    public Path getTrustStorePath() {
        return this.trustStore.toPath();
    }

    SecretChars getTrustStorePassword() {
        try {
            return AccessController.doPrivileged(() -> {
                byte[] trustStorePassword = BOracleDatabase.getTrustStorePasswordFromKeyRing((String)TRUST_STORE_PASSWORD_KEYRING_ALIAS);
                try (SecretBytes passwordBytes = new SecretBytes(trustStorePassword, true);){
                    SecretChars secretChars = SecretChars.fromSecretBytes((SecretBytes)passwordBytes);
                    return secretChars;
                }
            });
        }
        catch (PrivilegedActionException e) {
            String exceptionMessageFormat = "Could not acquire Trust Store password from Key Ring for Oracle Database: %s";
            String exceptionMessage = String.format(exceptionMessageFormat, this.getDisplayName(Context.NULL));
            if (Logger.getLogger("rdb").isLoggable(Level.WARNING)) {
                Logger.getLogger("rdb").log(Level.WARNING, exceptionMessage, e);
            }
            throw new SecurityException(e.getException());
        }
    }
}

