/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.backup.ui;

import com.tridium.backup.BBackupRecord;
import com.tridium.backup.BFoxBackupJob;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.ui.theme.Theme;
import com.tridium.util.TimeFormat;
import com.tridium.workbench.job.BJobBar;
import java.util.logging.Level;
import javax.baja.backup.BBackupService;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"backup:BackupService"})})
public class BBackupManager
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BBackupManager.class);
    static final Lexicon lex = Lexicon.make(BBackupManager.class);
    static final BImage icon = BImage.make((String)"module://icons/x16/backup.png");
    static BOrd defaultDir = null;
    static JobCompleteSubscriber jobCompleteSubscriber;
    public static final String DEFAULT_BACKUPS_DIR_PATH = "~backups";
    BJobBar jobBar;
    BTable table;
    Command cmdBackup = new Backup((BWidget)this);
    BBackupService backupService;
    BBackupRecord[] recs = new BBackupRecord[0];

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBackupManager() {
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.none, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.none, BInsets.DEFAULT);
        this.table = new BTable((TableModel)new Model());
        BTitlePane tablePane = BTitlePane.makePane((String)lex.getText("backups"), (BTable)this.table);
        BGridPane buttonPane = new BGridPane();
        buttonPane.add(null, (BValue)new BButton(this.cmdBackup));
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0)));
        edge.setCenter((BWidget)tablePane);
        edge.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 10.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)edge);
    }

    public void doLoadValue(BObject object, Context cx) {
        this.backupService = (BBackupService)object;
        this.reload();
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        this.reload();
    }

    public void reload() {
        this.recs = BBackupRecord.list((BBackupService)this.backupService);
        this.table.getModel().updateTable();
    }

    public static void stationBackupCommand(BWidget owner, BObject base) throws Exception {
        try {
            BBackupService service = (BBackupService)BOrd.make((String)"service:backup:BackupService").get(base);
            BBackupManager.promptAndSubmit(owner, service);
        }
        catch (ServiceNotFoundException snfe) {
            throw new LocalizableRuntimeException("backup", "BackupManager.error.noBackupService");
        }
    }

    public static BOrd promptAndSubmit(BWidget owner, BBackupService backupService) throws Exception {
        BFoxSession session = (BFoxSession)BOrd.toSession((BObject)backupService);
        BFileSystem fs = BFileSystem.INSTANCE;
        if (defaultDir == null) {
            FilePath dirPath = new FilePath(DEFAULT_BACKUPS_DIR_PATH);
            fs.makeDir(dirPath);
            defaultDir = BOrd.make((OrdQuery)dirPath);
        }
        String name = BBackupManager.makeDefaultBackupFileName(session.getStationName());
        BFileChooser chooser = BFileChooser.makeSave((BWidget)owner);
        chooser.setCurrentDirectory(defaultDir);
        chooser.setDefaultFileName(name);
        chooser.addFilter((IFileFilter)new ExtFileFilter(BDistributionFile.TYPE.getDisplayName(null), "dist"));
        BOrd ord = chooser.show();
        if (ord == null) {
            return null;
        }
        defaultDir = chooser.getCurrentDirectory();
        String filePath = BBackupManager.toFilePath(ord).getBody();
        return BBackupManager.submitBackupJob(filePath, session);
    }

    public static String makeDefaultBackupFileName(String stationName) {
        String timestamp = TimeFormat.format((BAbsTime)Clock.time(), (String)"YYMMDD_HHmm");
        return "backup_" + stationName + "_" + timestamp + ".dist";
    }

    public static BOrd submitBackupJob(String filePath, BFoxSession session) {
        String remoteId = session.getConnection().session().getRemoteId();
        BFoxBackupJob job = new BFoxBackupJob();
        job.setPostSessionId(remoteId);
        job.setPostPath(filePath);
        session.getConnection().getChannels().getFileChannel().fw(901, (Object)filePath, null, null, null);
        BJobService jobService = (BJobService)BOrd.make((String)"service:baja:JobService").get((BObject)session);
        BOrd jobOrd = jobService.submit((BJob)job, null);
        BBackupManager.finishFoxBackupJob(jobOrd, (BComponent)jobService);
        return jobOrd;
    }

    public static void finishFoxBackupJob(BOrd jobOrd, BComponent base) {
        try {
            ((BComponentSpace)base.getSpace()).sync();
            BFoxBackupJob backupJob = (BFoxBackupJob)BOrd.make((String)("station:|" + jobOrd)).get((BObject)base);
            if (jobCompleteSubscriber == null) {
                jobCompleteSubscriber = new JobCompleteSubscriber();
            }
            jobCompleteSubscriber.subscribe((BComponent)backupJob);
        }
        catch (Exception e) {
            BBackupService.log.log(Level.SEVERE, "Cannot finish cleaning up backup job", e);
        }
    }

    static FilePath toFilePath(BOrd ord) {
        OrdQuery[] q = ord.parse();
        for (int i = 0; i < q.length; ++i) {
            if (!(q[i] instanceof FilePath)) continue;
            return (FilePath)q[i];
        }
        throw new IllegalStateException();
    }

    private static class JobCompleteSubscriber
    extends Subscriber {
        private JobCompleteSubscriber() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(BComponentEvent event) {
            if (event.getSourceComponent() instanceof BFoxBackupJob) {
                BFoxBackupJob job = (BFoxBackupJob)event.getSourceComponent();
                if (event.getId() == 0 && event.getSlot().equals((Object)BJob.jobState) && ((BJobState)event.getValue()).isComplete()) {
                    try {
                        BFoxSession session = (BFoxSession)BOrd.toSession((BObject)job);
                        FilePath filePath = new FilePath(job.getPostPath());
                        session.getConnection().getChannels().getFileChannel().fw(902, (Object)filePath, null, null, null);
                    }
                    catch (Exception e) {
                        BBackupService.log.log(Level.SEVERE, "Cannot finish cleaning up backup job", e);
                    }
                    finally {
                        this.unsubscribe((BComponent)job);
                    }
                }
            }
        }
    }

    class Backup
    extends Command {
        Backup(BWidget owner) {
            super(owner, lex, "backup");
        }

        public CommandArtifact doInvoke() throws Exception {
            BOrd jobOrd = BBackupManager.promptAndSubmit(this.getOwner(), BBackupManager.this.backupService);
            if (jobOrd == null) {
                return null;
            }
            BBackupManager.this.backupService.getComponentSpace().sync();
            BFoxBackupJob job = (BFoxBackupJob)jobOrd.get((BObject)BBackupManager.this.backupService);
            BBackupManager.this.registerForComponentEvents((BComponent)job);
            BBackupManager.this.jobBar.load((BJob)job);
            return null;
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BBackupManager.this.recs.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BBackupRecord.timestamp.getDefaultDisplayName(null);
                }
                case 1: {
                    return BBackupRecord.host.getDefaultDisplayName(null);
                }
                case 2: {
                    return BBackupRecord.path.getDefaultDisplayName(null);
                }
                case 3: {
                    return BBackupRecord.user.getDefaultDisplayName(null);
                }
            }
            return "???";
        }

        public Object getSubject(int row) {
            return BBackupManager.this.recs[row];
        }

        public Object getValueAt(int row, int col) {
            BBackupRecord rec = BBackupManager.this.recs[row];
            switch (col) {
                case 0: {
                    return rec.getTimestamp();
                }
                case 1: {
                    return rec.getHost();
                }
                case 2: {
                    return rec.getPath();
                }
                case 3: {
                    return rec.getUser();
                }
            }
            return "???";
        }

        public BImage getRowIcon(int row) {
            return icon;
        }
    }
}

