/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScanNpm;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BEthernetPort;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.BHardwareRef;
import com.tridium.sys.Nre;
import java.util.Vector;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="LAN1", type="BEthernetPort", defaultValue="new BEthernetPort(\"en0\")", flags=1), @NiagaraProperty(name="LAN2", type="BEthernetPort", defaultValue="new BEthernetPort(\"en1\")", flags=1), @NiagaraProperty(name="COM1", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs232, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="COM2", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs485, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="NDIO", type="BPort", defaultValue="new BPort(BPortTypeEnum.ndio, \"tridium:ndio\")", flags=1), @NiagaraProperty(name="optionSlot1", type="BOptionSlot", defaultValue="new BOptionSlot(1)", flags=1), @NiagaraProperty(name="optionSlot2", type="BOptionSlot", defaultValue="new BOptionSlot(2)", flags=1)})
public class BNpmBoard
extends BBaseBoard {
    @Generated
    public static final Property LAN1 = BNpmBoard.newProperty((int)1, (BValue)new BEthernetPort("en0"), null);
    @Generated
    public static final Property LAN2 = BNpmBoard.newProperty((int)1, (BValue)new BEthernetPort("en1"), null);
    @Generated
    public static final Property COM1 = BNpmBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs232, "tridium:serial", "COM"), null);
    @Generated
    public static final Property COM2 = BNpmBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    @Generated
    public static final Property NDIO = BNpmBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.ndio, "tridium:ndio"), null);
    @Generated
    public static final Property optionSlot1 = BNpmBoard.newProperty((int)1, (BValue)new BOptionSlot(1), null);
    @Generated
    public static final Property optionSlot2 = BNpmBoard.newProperty((int)1, (BValue)new BOptionSlot(2), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNpmBoard.class);
    private static final Lexicon LEX = Lexicon.make(BNpmBoard.class);
    private static final String BASE_BOARD_CODE = "01";
    private static final String VIEW = "pxView";
    private static final String IMAGES_DIR = "imageDir";
    private static final int BASE_LAN_PORT = 3;
    private static final int BASE_LON_PORT = 1;
    private static final int BASE_SERIAL_PORT = 3;
    private static final int HARDWARE_REF_COUNT = 10;

    @Generated
    public BEthernetPort getLAN1() {
        return (BEthernetPort)this.get(LAN1);
    }

    @Generated
    public void setLAN1(BEthernetPort v) {
        this.set(LAN1, (BValue)v, null);
    }

    @Generated
    public BEthernetPort getLAN2() {
        return (BEthernetPort)this.get(LAN2);
    }

    @Generated
    public void setLAN2(BEthernetPort v) {
        this.set(LAN2, (BValue)v, null);
    }

    @Generated
    public BPort getCOM1() {
        return (BPort)this.get(COM1);
    }

    @Generated
    public void setCOM1(BPort v) {
        this.set(COM1, (BValue)v, null);
    }

    @Generated
    public BPort getCOM2() {
        return (BPort)this.get(COM2);
    }

    @Generated
    public void setCOM2(BPort v) {
        this.set(COM2, (BValue)v, null);
    }

    @Generated
    public BPort getNDIO() {
        return (BPort)this.get(NDIO);
    }

    @Generated
    public void setNDIO(BPort v) {
        this.set(NDIO, (BValue)v, null);
    }

    @Generated
    public BOptionSlot getOptionSlot1() {
        return (BOptionSlot)this.get(optionSlot1);
    }

    @Generated
    public void setOptionSlot1(BOptionSlot v) {
        this.set(optionSlot1, (BValue)v, null);
    }

    @Generated
    public BOptionSlot getOptionSlot2() {
        return (BOptionSlot)this.get(optionSlot2);
    }

    @Generated
    public void setOptionSlot2(BOptionSlot v) {
        this.set(optionSlot2, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void autoConfig(Array<String> optCardCodes, boolean simulation) {
        this.setSimulation(simulation);
        this.setProductModel(LEX.getText(Nre.getHostModel().toUpperCase()));
        this.initializeStandardPorts();
        this.nextSerialPort = 3;
        this.nextLonPort = 1;
        this.nextLanPort = 3;
        this.configureOptionSlot(this.getOptionSlot1(), (String)optCardCodes.get(0), (String)optCardCodes.get(1));
        this.configureOptionSlot(this.getOptionSlot2(), (String)optCardCodes.get(2), (String)optCardCodes.get(3));
    }

    public String getBoardCode() {
        return BASE_BOARD_CODE;
    }

    public Vector<BHardwareRef> getHardwareRefs() {
        Vector<BHardwareRef> v = new Vector<BHardwareRef>();
        block11: for (int i = 1; i <= 10; ++i) {
            switch (i) {
                case 1: 
                case 2: {
                    BOptionSlot slot = i == 1 ? this.getOptionSlot1() : this.getOptionSlot2();
                    v.addElement(this.makeSlotRef(i, slot));
                    if (slot.isEmpty()) continue block11;
                    BOptionCard optionCard = (BOptionCard)slot.getContents();
                    optionCard.lease(1);
                    BPort[] cardPorts = (BPort[])optionCard.getChildren(BPort.class);
                    for (int j = 0; j < cardPorts.length; ++j) {
                        v.addElement(this.makePortRef(i, j + 1, cardPorts[j]));
                    }
                    continue block11;
                }
                case 3: {
                    v.addElement(this.makeJumperRef(i));
                    continue block11;
                }
                case 4: {
                    BPort port = this.getNDIO();
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), LEX.getText("HardwareRef.IoAndPowerModules"), port.getPortType(), port.getStatus()));
                    continue block11;
                }
                case 5: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getLAN2()));
                    continue block11;
                }
                case 6: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getLAN1()));
                    continue block11;
                }
                case 7: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM1()));
                    continue block11;
                }
                case 8: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM2()));
                    continue block11;
                }
                case 9: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), LEX.getText("HardwareRef.powerConnector")));
                    continue block11;
                }
                case 10: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), LEX.getText("HardwareRef.electricalGround")));
                }
            }
        }
        return v;
    }

    public String getImagesDirectory() {
        return LEX.getText(IMAGES_DIR);
    }

    public String getView(BObject v) {
        return LEX.getText(VIEW);
    }

    public void configureOptionSlot(BOptionSlot slot, String functionCode1, String functionCode2) {
        slot.removeAll();
        if (!functionCode1.equalsIgnoreCase("FF") || !functionCode2.equalsIgnoreCase("FF")) {
            BOptionCard cardTemplate = BOptionCard.lookup((String)(functionCode1 + " " + functionCode2));
            if (cardTemplate == null) {
                slot.addCard(new BOptionCard(BHardwareScanService.LEX.getText("unknownOptionCard", new Object[]{functionCode1, functionCode2}), functionCode1 + " " + functionCode2));
            } else {
                BOptionCard optionCard = (BOptionCard)cardTemplate.newCopy(true);
                slot.addCard(optionCard);
                BPort[] ports = optionCard.getPorts();
                for (int i = 0; i < ports.length; ++i) {
                    if (ports[i] == null) continue;
                    BPort port = ports[i];
                    if (optionCard.getUsesCom()) {
                        optionCard.rename(optionCard.getProperty(port.getName()), port.getPrefix() + slot.getSlotNumber(), null);
                        if (slot.getSlotNumber() == 1) {
                            if (this.getCOM1().getStatus().equals((Object)BHwScanStatusEnum.serialShell)) {
                                port.setStatus(BHwScanStatusEnum.unavailable);
                                continue;
                            }
                            this.getCOM1().setStatus(BHwScanStatusEnum.unavailable);
                            if (this.simulation) continue;
                            port.initOwnerAndStatus();
                            continue;
                        }
                        this.getCOM2().setStatus(BHwScanStatusEnum.unavailable);
                        if (functionCode1.equals("81")) {
                            port.setStatus(BHwScanStatusEnum.incompatible);
                            continue;
                        }
                        if (this.simulation) continue;
                        port.initOwnerAndStatus();
                        continue;
                    }
                    optionCard.rename(optionCard.getProperty(port.getName()), this.makePortName(i + 1, port.getPrefix()), null);
                    if (this.simulation) continue;
                    port.initOwnerAndStatus();
                }
            }
        }
        if (slot.isEmpty()) {
            slot.add("Contents", (BValue)BHwScanStatusEnum.empty, 3);
        }
    }

    private void initializeStandardPorts() {
        this.setDisplayName(COM1, BFormat.make((String)("COM".toUpperCase() + "1")), null);
        this.setDisplayName(COM2, BFormat.make((String)("COM".toUpperCase() + "2")), null);
        this.setDisplayName(LAN1, BFormat.make((String)("LAN".toUpperCase() + "1")), null);
        this.setDisplayName(LAN2, BFormat.make((String)("LAN".toUpperCase() + "2")), null);
        this.setDisplayName(NDIO, BFormat.make((String)"NDIO".toUpperCase()), null);
        if (!this.simulation) {
            this.getCOM1().initOwnerAndStatus();
            this.getCOM2().initOwnerAndStatus();
            this.getLAN1().initStatus();
            this.getLAN2().initStatus();
        }
    }
}

