/*
 * Decompiled with CFR 0.152.
 */
package obix.ui.views;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import obix.Obj;
import obix.Uri;
import obix.net.SessionWatch;
import obix.ui.Command;
import obix.ui.Form;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.Utils;
import obix.ui.View;

public class WatchView
extends View {
    SessionWatch watch;
    JTable table;
    Model model;

    public WatchView(Shell shell, UiSession.Response resp, SessionWatch watch) {
        super(shell, watch.getName(), resp);
        this.watch = watch;
        this.model = new Model();
        this.table = new JTable(this.model);
        this.table.addMouseListener(new Controller());
        JPanel actions = new JPanel(new FlowLayout());
        actions.add(new JButton(new Command(shell, "Add"){

            @Override
            public void doInvoke() throws Exception {
                WatchView.this.doAdd();
            }
        }));
        actions.add(new JButton(new Command(shell, "Remove"){

            @Override
            public void doInvoke() throws Exception {
                WatchView.this.doRemove();
            }
        }));
        actions.add(new JButton(new Command(shell, "Poll Changes"){

            @Override
            public void doInvoke() throws Exception {
                WatchView.this.doPollChanges();
            }
        }));
        actions.add(new JButton(new Command(shell, "Poll Refresh"){

            @Override
            public void doInvoke() throws Exception {
                WatchView.this.doPollRefresh();
            }
        }));
        actions.add(new JButton(new Command(shell, "Dispose"){

            @Override
            public void doInvoke() throws Exception {
                WatchView.this.doDispose();
            }
        }));
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)actions, "South");
    }

    @Override
    public void animate() {
        this.table.repaint();
    }

    public void doAdd() throws Exception {
        AddPrompt p = new AddPrompt();
        p.href = "";
        if ((p = (AddPrompt)Form.prompt(this, "Add Href to Watch", p)) == null) {
            return;
        }
        Uri uri = new Uri(p.href);
        this.watch.add(new Uri[]{uri});
        this.model.fireTableDataChanged();
    }

    public void doRemove() throws Exception {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        this.watch.remove(rows);
        this.model.fireTableDataChanged();
    }

    public void doPollChanges() throws Exception {
        this.watch.pollChanges();
        this.animate();
    }

    public void doPollRefresh() throws Exception {
        this.watch.pollRefresh();
        this.animate();
    }

    public void doDispose() {
        this.watch.delete();
        this.shell.refresh();
    }

    public static class AddPrompt {
        public String href;
    }

    class Model
    extends AbstractTableModel {
        Model() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return WatchView.this.watch.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Href";
                }
                case 1: {
                    return "Contract";
                }
                case 2: {
                    return "Display";
                }
                case 3: {
                    return "Last Update";
                }
            }
            return "?";
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return WatchView.this.watch.get(row).getHref();
                }
                case 1: {
                    return this.doContractsStr(WatchView.this.watch.get(row));
                }
                case 2: {
                    return WatchView.this.watch.get(row).toDisplayString();
                }
                case 3: {
                    return Utils.millisAgo(WatchView.this.watch.getLastUpdate(row));
                }
            }
            return "?";
        }

        private String doContractsStr(Obj obj) {
            String s = "obix:" + obj.getElement();
            if (obj.getIs() != null) {
                s = s + " " + obj.getIs();
            }
            return s;
        }
    }

    class Controller
    extends MouseAdapter {
        Controller() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            int row;
            if (event.getClickCount() != 2 || (row = WatchView.this.table.rowAtPoint(event.getPoint())) != -1) {
                // empty if block
            }
        }
    }
}

