/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import obix.List;
import obix.Obj;
import obix.Ref;
import obix.Uri;
import obix.ui.Command;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.Utils;

public class Tree
extends JTree {
    Shell shell;
    Node root;
    DefaultTreeModel model;

    public Tree(Shell shell) {
        this.shell = shell;
        this.root = Tree.makeRoot();
        this.model = new DefaultTreeModel(this.root);
        this.setModel(this.model);
        this.setCellRenderer(new Renderer());
        this.enableEvents(64L);
    }

    @Override
    public void processMouseEvent(MouseEvent event) {
        TreePath selPath;
        if (event.isPopupTrigger()) {
            Node node;
            TreePath selPath2 = this.getPathForLocation(event.getX(), event.getY());
            if (selPath2 != null && (node = (Node)selPath2.getLastPathComponent()) != null) {
                event.consume();
                this.popup(event, node);
                return;
            }
        } else if (event.getID() == 501 && (selPath = this.getPathForLocation(event.getX(), event.getY())) != null) {
            Node node = (Node)selPath.getLastPathComponent();
            if (node != null) {
                this.setSelectionPath(selPath);
                event.consume();
                if (event.getClickCount() == 1) {
                    this.singleClick(node);
                } else if (event.getClickCount() == 2) {
                    this.doubleClick(node);
                }
            }
            return;
        }
        super.processMouseEvent(event);
    }

    void sessionCreated(UiSession session) {
        this.root.kids.add(new Node(this.root, session));
        this.model.reload();
    }

    public void singleClick(Node node) {
    }

    public void doubleClick(Node node) {
        if (node.href == null) {
            return;
        }
        this.shell.hyperlink(node.href);
    }

    public void popup(MouseEvent e, Node node) {
        if (node.obj == null) {
            return;
        }
        JPopupMenu menu = this.shell.commands.makePopup(node.obj);
        if (menu == null) {
            menu = new JPopupMenu();
        }
        menu.add(new Refresh(node));
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    static Node makeRoot() {
        Node root = new Node();
        root.kids = new Vector();
        return root;
    }

    public class Refresh
    extends Command {
        Node node;

        Refresh(Node node) {
            super(Tree.this.shell, "Refresh", "x16/refresh.png", null);
            this.node = node;
        }

        @Override
        public void doInvoke() {
            this.node.refresh(Tree.this);
        }
    }

    static class Node
    implements TreeNode {
        Node parent;
        UiSession session;
        Obj obj;
        String name;
        Uri href;
        Vector<Node> kids;
        boolean leaf;
        Icon icon;

        Node() {
            this.name = "Sessions";
            this.href = new Uri("spy:sessions");
            this.session = null;
            this.leaf = false;
            this.icon = Utils.icon("x16/cloud.png");
        }

        Node(Node parent, UiSession session) {
            this.parent = parent;
            this.session = session;
            this.name = session.getLobbyUri().toString();
            this.href = session.getLobbyUri();
            this.leaf = false;
            this.icon = Utils.icon("x16/host.png");
        }

        Node(Node parent, Obj obj) {
            this.parent = parent;
            this.session = parent.session;
            this.obj = obj;
            this.name = obj.toDisplayName();
            if (this.name == null) {
                this.name = obj.getElement();
            }
            this.href = obj.getNormalizedHref();
            this.leaf = obj.size() == 0 && !(obj instanceof Ref) && !(obj instanceof List);
            this.icon = this.session.loadIcon(obj);
        }

        public Enumeration<Node> children() {
            return this.kids().elements();
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int index) {
            return this.kids().get(index);
        }

        @Override
        public int getChildCount() {
            return this.kids().size();
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.kids().indexOf(node);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.leaf;
        }

        public String toString() {
            return this.name;
        }

        public TreePath getPath() {
            ArrayList<Node> acc = new ArrayList<Node>();
            Node n = this;
            while (n != null) {
                acc.add(0, n);
                n = n.parent;
            }
            return new TreePath(acc.toArray());
        }

        public void refresh(Tree tree) {
            this.kids = null;
            tree.collapsePath(this.getPath());
            tree.model.reload(this);
            tree.expandPath(this.getPath());
        }

        Vector<Node> kids() {
            if (this.kids == null) {
                System.out.println("Tree.expand: " + this.name + " [" + this.href + "]");
                this.kids = new Vector();
                try {
                    this.obj = this.session.read(this.href);
                    Obj[] list = this.obj.list();
                    for (int i = 0; i < list.length; ++i) {
                        Obj kid = list[i];
                        if (kid.getHref() == null || !kid.isRef() && !kid.isList()) continue;
                        this.kids.add(new Node(this, kid));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.kids;
        }
    }

    class Renderer
    extends DefaultTreeCellRenderer {
        Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Icon icon;
            if (value instanceof Node && (icon = ((Node)value).icon) != null) {
                this.setOpenIcon(icon);
                this.setClosedIcon(icon);
                this.setLeafIcon(icon);
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }
}

