/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import obix.ui.Shell;
import obix.ui.Utils;

public abstract class Command
extends AbstractAction {
    private String name;
    private Shell shell;
    private ArrayList<JComponent> bindings = new ArrayList();

    public Command(Shell shell, String name, String icon, String accelerator) {
        super(name);
        this.shell = shell;
        this.name = name;
        if (icon != null) {
            this.putValue("SmallIcon", Utils.icon(icon));
        }
        if (accelerator != null) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelerator));
        }
    }

    public Command(Shell shell, String name) {
        this(shell, name, null, null);
    }

    public Shell shell() {
        return this.shell;
    }

    public void invoke() {
        try {
            this.shell().setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.doInvoke();
            }
            finally {
                this.shell().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            String msg = "Error invoking \"" + this.name + "\" command (see console for stack trace)\n" + e;
            JOptionPane.showMessageDialog(this.shell(), msg, "Error", 0);
        }
    }

    public abstract void doInvoke() throws Exception;

    @Override
    public void actionPerformed(ActionEvent event) {
        this.invoke();
    }

    public void bind(JComponent c) {
        this.bindings.add(c);
    }

    public void unbind(JComponent c) {
        this.bindings.remove(c);
    }

    public JComponent[] bindings() {
        return this.bindings.toArray(new JComponent[0]);
    }
}

