/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.tagdictionary.BTagDictionaryExportJob;
import com.tridium.tagdictionary.BTagDictionaryImportJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BRelationInfoList;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="namespace", type="String", defaultValue=""), @NiagaraProperty(name="version", type="String", defaultValue="Undefined"), @NiagaraProperty(name="neqlizeExcludedTags", type="String", defaultValue="", facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="neqlizeExcludedRelations", type="String", defaultValue="", facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="frozen", type="boolean", defaultValue="false", flags=65536), @NiagaraProperty(name="maxImportFileSize", type="int", defaultValue="1024", flags=4, facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"kilobyte\")"), @Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="BInteger.MAX")}), @NiagaraProperty(name="tagDefinitions", type="BTagInfoList", defaultValue="new BTagInfoList()"), @NiagaraProperty(name="tagGroupDefinitions", type="BTagGroupInfoList", defaultValue="new BTagGroupInfoList()"), @NiagaraProperty(name="relationDefinitions", type="BRelationInfoList", defaultValue="new BRelationInfoList()"), @NiagaraProperty(name="importDictionaryOrd", type="BOrd", defaultValue="BOrd.make(\"local:|file:~shared\")", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="importDictionary", parameterType="BOrd", defaultValue="BOrd.make(\"local:|file:~shared\")", flags=4), @NiagaraAction(name="exportDictionary", parameterType="BOrd", defaultValue="BOrd.make(\"local:|file:~shared\")")})
public class BTagDictionary
extends BComponent
implements TagDictionary,
BIStatus {
    @Generated
    public static final Property status = BTagDictionary.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BTagDictionary.newProperty((int)67, (String)"", null);
    @Generated
    public static final Property namespace = BTagDictionary.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property version = BTagDictionary.newProperty((int)0, (String)"Undefined", null);
    @Generated
    public static final Property neqlizeExcludedTags = BTagDictionary.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property neqlizeExcludedRelations = BTagDictionary.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property enabled = BTagDictionary.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property frozen = BTagDictionary.newProperty((int)65536, (boolean)false, null);
    @Generated
    public static final Property maxImportFileSize = BTagDictionary.newProperty((int)4, (int)1024, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"kilobyte")), (BFacets)BFacets.make((String)"min", (int)1)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.MAX)));
    @Generated
    public static final Property tagDefinitions = BTagDictionary.newProperty((int)0, (BValue)new BTagInfoList(), null);
    @Generated
    public static final Property tagGroupDefinitions = BTagDictionary.newProperty((int)0, (BValue)new BTagGroupInfoList(), null);
    @Generated
    public static final Property relationDefinitions = BTagDictionary.newProperty((int)0, (BValue)new BRelationInfoList(), null);
    @Generated
    public static final Property importDictionaryOrd = BTagDictionary.newProperty((int)4, (BValue)BOrd.make((String)"local:|file:~shared"), null);
    @Generated
    public static final Action importDictionary = BTagDictionary.newAction((int)4, (BValue)BOrd.make((String)"local:|file:~shared"), null);
    @Generated
    public static final Action exportDictionary = BTagDictionary.newAction((int)0, (BValue)BOrd.make((String)"local:|file:~shared"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTagDictionary.class);
    private static final BIcon icon = BIcon.std((String)"tag.png");
    public static Context importContext = new BasicContext();
    public static Logger logger = Logger.getLogger("tagdictionary");
    public static final Lexicon lex = Lexicon.make((String)TYPE.getModule().getModuleName());
    private boolean fatalFault;
    private boolean namespaceFault;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public String getNamespace() {
        return this.getString(namespace);
    }

    @Generated
    public void setNamespace(String v) {
        this.setString(namespace, v, null);
    }

    @Generated
    public String getVersion() {
        return this.getString(version);
    }

    @Generated
    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    @Generated
    public String getNeqlizeExcludedTags() {
        return this.getString(neqlizeExcludedTags);
    }

    @Generated
    public void setNeqlizeExcludedTags(String v) {
        this.setString(neqlizeExcludedTags, v, null);
    }

    @Generated
    public String getNeqlizeExcludedRelations() {
        return this.getString(neqlizeExcludedRelations);
    }

    @Generated
    public void setNeqlizeExcludedRelations(String v) {
        this.setString(neqlizeExcludedRelations, v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public boolean getFrozen() {
        return this.getBoolean(frozen);
    }

    @Generated
    public void setFrozen(boolean v) {
        this.setBoolean(frozen, v, null);
    }

    @Generated
    public int getMaxImportFileSize() {
        return this.getInt(maxImportFileSize);
    }

    @Generated
    public void setMaxImportFileSize(int v) {
        this.setInt(maxImportFileSize, v, null);
    }

    @Generated
    public BTagInfoList getTagDefinitions() {
        return (BTagInfoList)this.get(tagDefinitions);
    }

    @Generated
    public void setTagDefinitions(BTagInfoList v) {
        this.set(tagDefinitions, (BValue)v, null);
    }

    @Generated
    public BTagGroupInfoList getTagGroupDefinitions() {
        return (BTagGroupInfoList)this.get(tagGroupDefinitions);
    }

    @Generated
    public void setTagGroupDefinitions(BTagGroupInfoList v) {
        this.set(tagGroupDefinitions, (BValue)v, null);
    }

    @Generated
    public BRelationInfoList getRelationDefinitions() {
        return (BRelationInfoList)this.get(relationDefinitions);
    }

    @Generated
    public void setRelationDefinitions(BRelationInfoList v) {
        this.set(relationDefinitions, (BValue)v, null);
    }

    @Generated
    public BOrd getImportDictionaryOrd() {
        return (BOrd)this.get(importDictionaryOrd);
    }

    @Generated
    public void setImportDictionaryOrd(BOrd v) {
        this.set(importDictionaryOrd, (BValue)v, null);
    }

    @Generated
    public void importDictionary(BOrd parameter) {
        this.invoke(importDictionary, (BValue)parameter, null);
    }

    @Generated
    public void exportDictionary(BOrd parameter) {
        this.invoke(exportDictionary, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTagDictionary() {
    }

    public BTagDictionary(String namespace) {
        this.setNamespace(namespace);
    }

    public void started() throws Exception {
        super.started();
        this.setVersionReadonlyFlag();
        if (!Flags.isReadonly((BComplex)this, (Slot)status)) {
            this.setFlags((Slot)status, this.getFlags((Slot)status) | 1);
        }
        this.setFaultCause("");
        BTagDictionaryService service = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        String dictionaryLimitFault = (String)service.fw(501, "dictionary.limit", null, null, null);
        if (dictionaryLimitFault != null || service.isFault()) {
            this.fatalFault = true;
            this.setFaultCause(dictionaryLimitFault != null ? dictionaryLimitFault : service.getFaultCause());
        } else if (this.getNamespace().isEmpty()) {
            this.namespaceFault = true;
            if (!this.fatalFault) {
                this.setFaultCause("namespace cannot be empty");
            }
        } else {
            BTagDictionary duplicate = this.getDuplicateNamespace();
            if (duplicate != null) {
                this.namespaceFault = true;
                if (!this.fatalFault) {
                    this.setFaultCause("namespace: " + this.getNamespace() + " must be unique.  See: " + duplicate.getSlotPath());
                }
            }
        }
        this.updateStatus();
        if (this.isImportRequired() && !this.getImportDictionaryOrd().equivalent((Object)importDictionary.getParameterDefault())) {
            try {
                new BTagDictionaryImportJob(this, this.getImportDictionaryOrd()).submit(importContext);
            }
            catch (Exception e) {
                this.setStatus(BStatus.fault);
                this.setFaultCause(e.getLocalizedMessage());
                this.setVersion("Undefined");
            }
        }
    }

    private boolean isImportRequired() {
        if (this.getTagDefinitions().iterator().hasNext() && this.getTagGroupDefinitions().iterator().hasNext() && this.getRelationDefinitions().iterator().hasNext()) {
            return false;
        }
        return !(this instanceof BSmartTagDictionary) || !((BSmartTagDictionary)this).getTagRules().iterator().hasNext();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled)) {
            this.updateStatus();
        } else if (p.equals(status)) {
            if (this.fatalFault && !this.getStatus().isFault()) {
                this.updateStatus();
            }
        } else if (p.equals(namespace)) {
            if (this.getNamespace().isEmpty()) {
                this.namespaceFault = true;
                if (!this.fatalFault) {
                    this.setFaultCause("namespace cannot be empty");
                }
            } else {
                BTagDictionary duplicate = this.getDuplicateNamespace();
                boolean bl = this.namespaceFault = duplicate != null;
                if (this.namespaceFault) {
                    if (!this.fatalFault) {
                        this.setFaultCause("namespace: " + this.getNamespace() + " must be unique.  See: " + duplicate.getSlotPath());
                    }
                } else if (!this.fatalFault) {
                    this.setFaultCause("");
                }
            }
            this.updateStatus();
        } else if (p.equals(frozen)) {
            this.setVersionReadonlyFlag();
        }
    }

    private void setVersionReadonlyFlag() {
        if (this.getFrozen()) {
            this.setFlags((Slot)version, this.getFlags((Slot)version) | 1);
        } else {
            this.setFlags((Slot)version, this.getFlags((Slot)version) & 0xFFFFFFFE);
        }
    }

    public void checkImportFileSize(BIFile importFile) {
        if (importFile.getSize() / 1024L > (long)this.getMaxImportFileSize()) {
            String unitsSymbol = "KB";
            BUnit units = (BUnit)this.getSlotFacets((Slot)maxImportFileSize).get("units");
            if (units != null) {
                unitsSymbol = units.getSymbol();
            }
            logger.log(Level.WARNING, "Dictionary import failed because " + importFile.getFileName() + " is larger than the maximum import file size.");
            throw new LocalizableRuntimeException("tagdictionary", "import.fileTooLarge", new Object[]{importFile.getFileName(), this.getMaxImportFileSize(), unitsSymbol});
        }
    }

    public void checkSetFlags(Slot slot, int flags, Context context) {
        super.checkSetFlags(slot, flags, context);
        if (context != Context.decoding && (slot.equals((Object)status) || slot.equals((Object)faultCause)) && (flags & 1) != 1) {
            throw new LocalizableRuntimeException("baja", "cannotChangeReadOnly", new Object[]{slot.getName()});
        }
    }

    static Optional<TagDictionary> getParentDictionary(BComponent component) {
        BComplex parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof TagDictionary); parent = parent.getParent()) {
        }
        if (parent != null) {
            return Optional.of((TagDictionary)parent);
        }
        return Optional.empty();
    }

    public BTagDictionary getStandardDictionary() {
        return null;
    }

    private BTagDictionary getDuplicateNamespace() {
        BTagDictionary comp;
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BTagDictionaryService service = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        Optional<TagDictionary> optional = service.getTagDictionary(this.getNamespace());
        if (optional.isPresent() && !(comp = (BTagDictionary)optional.get()).getName().equals(this.getName())) {
            return comp;
        }
        return null;
    }

    public String toString(Context cx) {
        String name = this.getDisplayName(cx);
        if (name != null) {
            return lex.getText("tag.dictionary.shortName", new Object[]{name});
        }
        return super.toString(cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof TagDictionaryService;
    }

    public Iterator<TagInfo> getTags() {
        if (!this.isOperational()) {
            throw new NotRunningException(String.format("TagDictionary: %s is not operational", this.getName()));
        }
        return this.getTagDefinitions().iterator();
    }

    public Iterator<TagGroupInfo> getTagGroups() {
        if (!this.isOperational()) {
            throw new NotRunningException(String.format("TagDictionary: %s is not operational", this.getName()));
        }
        return this.getTagGroupDefinitions().iterator();
    }

    public Iterator<RelationInfo> getRelations() {
        if (!this.isOperational()) {
            throw new NotRunningException(String.format("TagDictionary: %s is not operational", this.getName()));
        }
        return this.getRelationDefinitions().iterator();
    }

    public Collection<TagInfo> getValidTags(Entity entity) {
        ArrayList<TagInfo> result = new ArrayList<TagInfo>();
        Iterator<TagInfo> i = this.getTags();
        while (i.hasNext()) {
            TagInfo tag = i.next();
            if (!tag.isValidFor(entity)) continue;
            result.add(tag);
        }
        return result;
    }

    public Collection<TagGroupInfo> getValidTagGroups(Entity entity) {
        ArrayList<TagGroupInfo> result = new ArrayList<TagGroupInfo>();
        Iterator<TagGroupInfo> i = this.getTagGroups();
        while (i.hasNext()) {
            TagGroupInfo group = i.next();
            if (!group.isValidFor(entity)) continue;
            result.add(group);
        }
        return result;
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final boolean isOperational() {
        BStatus status = this.getStatus();
        return !this.fatalFault && !status.isDisabled() && !status.isFault();
    }

    public final void updateStatus() {
        int oldStatus = this.getStatus().getBits();
        int newStatus = 0;
        newStatus = !this.getEnabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.fatalFault || this.namespaceFault ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    public boolean isImportable() {
        return true;
    }

    public void doImportDictionary(BOrd file) {
        this.setImportDictionaryOrd(file);
        new BTagDictionaryImportJob(this, file).submit(importContext);
    }

    public void doExportDictionary(BOrd file) throws Exception {
        new BTagDictionaryExportJob(this, file).submit(null);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(importDictionary)) {
            return this.getImportDictionaryOrd();
        }
        return super.getActionParameterDefault(action);
    }

    public void encodeToJson(JSONWriter writer) {
        writer.key("namespace").value((Object)this.getNamespace());
        writer.key("version").value((Object)this.getVersion());
        writer.key(frozen.getName()).value(this.getFrozen());
        writer.key(neqlizeExcludedTags.getName()).value((Object)this.getNeqlizeExcludedTags());
        writer.key(neqlizeExcludedRelations.getName()).value((Object)this.getNeqlizeExcludedRelations());
        writer.key("tags");
        this.getTagDefinitions().encodeToJson(writer);
        writer.key("tagGroups");
        this.getTagGroupDefinitions().encodeToJson(writer);
        writer.key("relations");
        this.getRelationDefinitions().encodeToJson(writer);
    }

    public void decodeFromJson(JSONObject dictionaryJson) {
        this.setNamespace(dictionaryJson.getString("namespace"));
        this.setVersion(dictionaryJson.getString("version"));
        this.setFrozen(dictionaryJson.getBoolean(frozen.getName()));
        this.setNeqlizeExcludedTags(dictionaryJson.getString(neqlizeExcludedTags.getName()));
        this.setNeqlizeExcludedRelations(dictionaryJson.getString(neqlizeExcludedRelations.getName()));
        BTagInfoList tagInfoList = new BTagInfoList();
        tagInfoList.decodeFromJson(dictionaryJson.getJSONArray("tags"));
        this.setTagDefinitions(tagInfoList);
        BTagGroupInfoList tagGroupInfoList = new BTagGroupInfoList();
        tagGroupInfoList.decodeFromJson(dictionaryJson.getJSONArray("tagGroups"));
        this.setTagGroupDefinitions(tagGroupInfoList);
        BRelationInfoList relationInfoList = new BRelationInfoList();
        relationInfoList.decodeFromJson(dictionaryJson.getJSONArray("relations"));
        this.setRelationDefinitions(relationInfoList);
    }

    public BIcon getIcon() {
        return icon;
    }
}

