/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.util;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.sys.tag.ComponentRelations;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.tagdictionary.condition.BAnd;
import com.tridium.tagdictionary.condition.BBooleanFilter;
import com.tridium.tagdictionary.condition.BHasAncestor;
import com.tridium.tagdictionary.condition.BHasRelation;
import com.tridium.tagdictionary.condition.BIsTypeCondition;
import com.tridium.tagdictionary.condition.BOr;
import com.tridium.tagdictionary.util.ImportExportConst;
import com.tridium.util.CompUtil;
import com.tridium.util.EscUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BCsvFile;
import javax.baja.file.types.text.BJsonFile;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.tag.Id;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BInfoList;
import javax.baja.tagdictionary.BRelationInfo;
import javax.baja.tagdictionary.BRelationInfoList;
import javax.baja.tagdictionary.BSimpleTagInfo;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.tagdictionary.BTagRule;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.tagdictionary.BTagRuleList;
import javax.baja.tagdictionary.TagRule;
import javax.baja.tagdictionary.data.BDataPolicy;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.units.UnitException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public final class ImportUtil
implements ImportExportConst {
    private static final Lexicon LEX = Lexicon.make((String)"tagdictionary");
    private static final Logger LOGGER = Logger.getLogger("tagdictionary.import");

    public static void updateTagDictionary(BTagDictionary source, BTagDictionary dest, Context cx) {
        List<TagGroupInfo> tagGroupsInUse = ImportUtil.areAnyRemovedTagGroupsInUse(source, dest);
        if (!tagGroupsInUse.isEmpty()) {
            StringJoiner isUse = new StringJoiner(" ");
            tagGroupsInUse.forEach(tagGroupInfo -> isUse.add(tagGroupInfo.getName()));
            throw new LocalizableRuntimeException("tagdictionary", "import.tagGroupsInUse", new Object[]{dest.getName(), isUse});
        }
        boolean isFrozen = dest.getFrozen();
        if (isFrozen) {
            dest.setFrozen(false);
        }
        try {
            dest.lease(Integer.MAX_VALUE);
            dest.set(BTagDictionary.namespace, (BValue)BString.make((String)source.getNamespace()), cx);
            ImportUtil.updateTags(source.getTagDefinitions(), dest.getTagDefinitions(), cx);
            ImportUtil.updateTagGroups(source.getTagGroupDefinitions(), dest.getTagGroupDefinitions(), cx);
            ImportUtil.updateRelations(source.getRelationDefinitions(), dest.getRelationDefinitions(), cx);
            try {
                BValue destTagRuleList = dest.get(BSmartTagDictionary.tagRules);
                BValue sourceTagRuleList = source.get(BSmartTagDictionary.tagRules);
                if (destTagRuleList instanceof BTagRuleList && sourceTagRuleList instanceof BTagRuleList) {
                    ImportUtil.updateTagRules((BTagRuleList)sourceTagRuleList, (BTagRuleList)destTagRuleList, cx);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Tag dictionary import update tag rules failed", LOGGER.isLoggable(Level.FINE) ? e : null);
                throw e;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Tag dictionary import failed", LOGGER.isLoggable(Level.FINE) ? e : null);
            throw e;
        }
        finally {
            dest.setFrozen(isFrozen);
        }
    }

    private static List<TagGroupInfo> areAnyRemovedTagGroupsInUse(BTagDictionary newDict, BTagDictionary oldDict) {
        BTagGroupInfoList newTagGroups = newDict.getTagGroupDefinitions();
        ArrayList<TagGroupInfo> tagGroupsInUse = new ArrayList<TagGroupInfo>();
        for (BTagGroupInfo oldTagGroup : (BTagGroupInfo[])oldDict.getTagGroupDefinitions().getChildren(BTagGroupInfo.class)) {
            ComponentRelations relations;
            if (newTagGroups.containsTagId(oldTagGroup.getGroupId()) || !(relations = new ComponentRelations((BComponent)oldTagGroup)).get(BNiagaraTagDictionary.TAG_GROUP_RELATION, 1).isPresent()) continue;
            tagGroupsInUse.add(oldTagGroup);
        }
        return tagGroupsInUse;
    }

    public static void updateTags(BTagInfoList sourceList, BTagInfoList destList, Context cx) {
        destList.removeAll(cx);
        SlotCursor c = sourceList.getProperties();
        while (c.next(TagInfo.class)) {
            BComponent tag = (BComponent)c.get();
            destList.add(tag.getName(), tag.newCopy(true), cx);
        }
    }

    public static void updateTagGroups(BTagGroupInfoList sourceList, BTagGroupInfoList destList, Context cx) {
        int i;
        ArrayList<String> toRemove = new ArrayList<String>();
        SlotCursor c = destList.getProperties();
        while (c.next(TagGroupInfo.class)) {
            if (!(c.get() instanceof BTagGroupInfo)) {
                String name2 = ((TagGroupInfo)c.get()).getName();
                LOGGER.fine(() -> "Tag group " + name2 + " in the destination dictionary removed because it does not extend BTagGroupInfo");
                toRemove.add(name2);
                continue;
            }
            BTagGroupInfo destTagGroup = (BTagGroupInfo)c.get();
            BTagGroupInfo sourceTagGroup = (BTagGroupInfo)sourceList.get(destTagGroup.getName());
            if (sourceTagGroup != null) {
                destTagGroup.setValidity((BTagRuleCondition)sourceTagGroup.getValidity().newCopy(true));
                ImportUtil.updateTags(sourceTagGroup.getTagList(), destTagGroup.getTagList(), cx);
                Property slot = destTagGroup.getPropertyInParent();
                destList.setFlags((Slot)slot, destList.getFlags((Slot)slot) & 0xFFFFFFFB, cx);
                continue;
            }
            toRemove.add(destTagGroup.getName());
        }
        toRemove.forEach(name -> destList.remove((String)name));
        c = sourceList.getProperties();
        while (c.next(BTagGroupInfo.class)) {
            BTagGroupInfo sourceTagGroup = (BTagGroupInfo)c.get();
            String name3 = sourceTagGroup.getName();
            if (destList.get(name3) != null) continue;
            destList.add(name3, sourceTagGroup.newCopy(true), cx);
        }
        Property[] properties = sourceList.getDynamicPropertiesArray();
        if (properties.length == 0) {
            return;
        }
        Property[] destProperties = destList.getDynamicPropertiesArray();
        Property[] sortedDestArray = new Property[properties.length];
        String dictionaryName = "NoDictionaryAvailable";
        BTagDictionary dictionary = destList.getTagDictionary();
        if (dictionary != null) {
            dictionaryName = dictionary.getName();
        }
        for (i = 0; i < properties.length; ++i) {
            String sourcePropertyName = properties[i].getName();
            boolean sortedEntryFound = false;
            for (int j = 0; j < destProperties.length; ++j) {
                if (!sourcePropertyName.equals(destProperties[j].getName())) continue;
                sortedDestArray[i] = destProperties[j];
                sortedEntryFound = true;
                break;
            }
            if (sortedEntryFound) continue;
            LOGGER.warning("Tag group sorting failed during import of dictionary " + dictionaryName + " for property " + sourcePropertyName);
            return;
        }
        for (i = 0; i < sortedDestArray.length; ++i) {
            if (sortedDestArray[i] != null) continue;
            LOGGER.warning("Tag group sorting failed to fill in a slot during import of dictionary " + dictionaryName);
            return;
        }
        destList.reorder(sortedDestArray);
    }

    public static void updateRelations(BRelationInfoList sourceList, BRelationInfoList destList, Context cx) {
        destList.removeAll(cx);
        SlotCursor c = sourceList.getProperties();
        while (c.next(RelationInfo.class)) {
            BComponent relation = (BComponent)c.get();
            destList.add(relation.getName(), relation.newCopy(true), cx);
        }
    }

    public static void updateTagRules(BTagRuleList sourceList, BTagRuleList destList, Context cx) {
        destList.removeAll(cx);
        SlotCursor c = sourceList.getProperties();
        while (c.next(TagRule.class)) {
            BComponent tagRule = (BComponent)c.get();
            destList.add(tagRule.getName(), tagRule.newCopy(true), cx);
        }
    }

    public static ArrayList<ResultInfo> ImportTagDictionary(BTagDictionary dictionary, BOrd file) {
        ArrayList<ResultInfo> results;
        block41: {
            results = new ArrayList<ResultInfo>();
            LOGGER.fine("Importing tagDictionary from: " + file);
            BIFile inFile = (BIFile)file.resolve((BObject)dictionary).get();
            dictionary.checkImportFileSize(inFile);
            if (inFile instanceof BJsonFile) {
                ImportUtil.importFromJson(dictionary, (BJsonFile)inFile, results);
                return results;
            }
            if (!(inFile instanceof BCsvFile)) {
                results.add(ResultInfo.make(LEX.getText("import.notJsonOrCsv"), BColor.red));
                return results;
            }
            BTagDictionary newDictionary = dictionary.getType().is(BSmartTagDictionary.TYPE) ? new BSmartTagDictionary() : new BTagDictionary();
            newDictionary.setImportDictionaryOrd(dictionary.getImportDictionaryOrd());
            newDictionary.setFrozen(dictionary.getFrozen());
            try {
                BCsvFile csvFile = (BCsvFile)inFile;
                InputStream in = csvFile.getInputStream();
                int state = 0;
                String lastGroup = "";
                String lastRule = "";
                boolean hasProcessException = false;
                boolean blankNamespace = false;
                boolean invalidRowFormat = false;
                int tagCount = 0;
                int groupCount = 0;
                int relationCount = 0;
                int ruleCount = 0;
                int row = 0;
                while (in.available() > 0 && !blankNamespace && !invalidRowFormat) {
                    try {
                        String[] rowValues = ImportUtil.getRowValues(in);
                        if (rowValues.length < 12) {
                            invalidRowFormat = true;
                            throw new RuntimeException(LEX.get("import.invalidRowFormat.columns"));
                        }
                        ++row;
                        String value0 = rowValues[0];
                        if (value0.startsWith("#")) continue;
                        if (!value0.isEmpty()) {
                            if (value0.equalsIgnoreCase("namespace")) {
                                state = 0;
                            } else if (value0.equalsIgnoreCase("TagDefinitions")) {
                                state = 2;
                            } else if (value0.equalsIgnoreCase("TagGroupDefinitions")) {
                                state = 3;
                            } else if (value0.equalsIgnoreCase("RelationDefinitions")) {
                                state = 4;
                            } else if (value0.equalsIgnoreCase("RuleDefinitions")) {
                                state = 5;
                            }
                        }
                        switch (state) {
                            case 0: {
                                LOGGER.fine(() -> "Setting namespace: " + rowValues[1]);
                                blankNamespace = rowValues[1].isEmpty();
                                newDictionary.setNamespace(rowValues[1]);
                                state = 1;
                                break;
                            }
                            case 2: {
                                if (!rowValues[3].isEmpty()) {
                                    ++tagCount;
                                }
                                ImportUtil.importTagData(newDictionary, rowValues);
                                break;
                            }
                            case 3: {
                                String thisGroup = rowValues[2];
                                if (!thisGroup.isEmpty() && !thisGroup.equals(lastGroup)) {
                                    ++groupCount;
                                }
                                lastGroup = ImportUtil.importGroupData(newDictionary, lastGroup, rowValues);
                                break;
                            }
                            case 4: {
                                if (!rowValues[3].isEmpty()) {
                                    ++relationCount;
                                }
                                ImportUtil.importRelationData(newDictionary, rowValues);
                                break;
                            }
                            case 5: {
                                if (!rowValues[1].isEmpty()) {
                                    ++ruleCount;
                                }
                                lastRule = ImportUtil.importRuleData(newDictionary, lastRule, rowValues);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        results.add(ResultInfo.make(LEX.getText("row") + ' ' + row + ": " + e.getMessage(), BColor.red));
                        hasProcessException = true;
                    }
                }
                if (blankNamespace) {
                    results.add(ResultInfo.make(LEX.getText("row") + " 1: " + LEX.getText("import.blankNamespace"), BColor.red));
                } else if (hasProcessException) {
                    results.add(ResultInfo.make(LEX.getText("import.fileErrors", new Object[]{inFile.getFileName()}), BColor.red));
                } else {
                    String msg;
                    if (tagCount > 0) {
                        results.add(ResultInfo.make(LEX.getText("import.processTags", new Object[]{tagCount}), BColor.black));
                    }
                    if (groupCount > 0) {
                        results.add(ResultInfo.make(LEX.getText("import.processGroups", new Object[]{groupCount}), BColor.black));
                    }
                    if (relationCount > 0) {
                        results.add(ResultInfo.make(LEX.getText("import.processRelations", new Object[]{relationCount}), BColor.black));
                    }
                    if (ruleCount > 0) {
                        results.add(ResultInfo.make(LEX.getText("import.processRules", new Object[]{ruleCount}), BColor.black));
                    }
                    if (!ImportUtil.equivalent(dictionary, newDictionary)) {
                        msg = LEX.getText("import.wasLoaded", new Object[]{dictionary.getName(), inFile.getFileName()});
                        results.add(ResultInfo.make(msg, BColor.black));
                        LOGGER.fine(() -> msg);
                        ImportUtil.updateTagDictionary(newDictionary, dictionary, BTagDictionary.importContext);
                    } else {
                        msg = LEX.getText("import.uptodate", new Object[]{dictionary.getName()});
                        results.add(ResultInfo.make(msg, BColor.black));
                        LOGGER.fine(() -> msg);
                    }
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (LocalizableRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                results.add(ResultInfo.make(e.getMessage(), BColor.red));
                if (!LOGGER.isLoggable(Level.FINE)) break block41;
                LOGGER.log(Level.FINE, "Tag dictionary import failed: " + e.getMessage(), e);
            }
        }
        return results;
    }

    private static void importFromJson(BTagDictionary dictionary, BJsonFile file, ArrayList<ResultInfo> results) {
        block17: {
            try (InputStream inputStream = file.getInputStream();){
                JSONTokener tokener = new JSONTokener(inputStream);
                JSONObject dictionaryJson = new JSONObject(tokener);
                BTagDictionary newDictionary = (BTagDictionary)dictionary.getType().getInstance();
                newDictionary.decodeFromJson(dictionaryJson);
                if (!ImportUtil.equivalent(dictionary, newDictionary)) {
                    String msg = LEX.getText("import.wasLoaded", new Object[]{dictionary.getName(), file.getFileName()});
                    results.add(ResultInfo.make(msg, BColor.black));
                    LOGGER.fine(msg);
                    ImportUtil.updateTagDictionary(newDictionary, dictionary, BTagDictionary.importContext);
                    dictionary.setVersion(newDictionary.getVersion());
                } else {
                    String msg = LEX.getText("import.uptodate", new Object[]{dictionary.getName()});
                    results.add(ResultInfo.make(msg, BColor.black));
                    LOGGER.fine(msg);
                }
            }
            catch (LocalizableRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                results.add(ResultInfo.make(e.getMessage(), BColor.red));
                if (!LOGGER.isLoggable(Level.FINE)) break block17;
                LOGGER.log(Level.FINE, "Tag dictionary import failed: " + e.getMessage(), e);
            }
        }
    }

    public static void decodeConditions(JSONArray conditionsJson, BTagRuleCondition baseCondition) {
        for (Object o : conditionsJson) {
            JSONObject conditionJson = (JSONObject)o;
            String typeString = conditionJson.getString("type");
            TypeInfo conditionTypeInfo = ImportUtil.decodeType(typeString, BTagRuleCondition.TYPE);
            BTagRuleCondition condition = (BTagRuleCondition)conditionTypeInfo.getInstance();
            condition.decodeFromJson(conditionJson);
            baseCondition.add(null, (BValue)condition);
        }
    }

    public static TypeInfo decodeType(String typeString, Type superType) {
        TypeInfo typeInfo;
        try {
            typeInfo = Sys.getRegistry().getType(typeString);
        }
        catch (TypeNotFoundException e) {
            throw new LocalizableRuntimeException("tagdictionary", "decodeJson.typeNotFound", new Object[]{typeString});
        }
        if (!typeInfo.is(superType)) {
            throw new LocalizableRuntimeException("tagdictionary", "decodeJson.typeIsNotExpected", new Object[]{typeString, superType.getTypeName()});
        }
        return typeInfo;
    }

    public static boolean equivalent(BTagDictionary dict1, BTagDictionary dict2) {
        return ImportUtil.isEquivalent(dict1, dict2);
    }

    public static boolean equivalent(BSmartTagDictionary dict1, BSmartTagDictionary dict2) {
        return ImportUtil.isEquivalent(dict1, dict2);
    }

    private static boolean isEquivalent(BTagDictionary dict1, BTagDictionary dict2) {
        dict1.lease(Integer.MAX_VALUE);
        dict2.lease(Integer.MAX_VALUE);
        if (!dict1.getNamespace().equals(dict2.getNamespace())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Namespace 1 (" + dict1.getNamespace() + ") does not match namespace 2 (" + dict2.getNamespace() + ')');
            }
            return false;
        }
        if (!dict1.getVersion().equals(dict2.getVersion())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Version 1 (" + dict1.getVersion() + ") does not match version 2 (" + dict2.getVersion() + ')');
            }
            return false;
        }
        if (dict1.getFrozen() != dict2.getFrozen()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("IsFrozen 1 (" + dict1.getFrozen() + ") does not match isFrozen 2 (" + dict2.getFrozen() + ')');
            }
            return false;
        }
        if (!dict1.getTagDefinitions().equivalent(dict2.getTagDefinitions())) {
            LOGGER.fine("Tags in 1 do not match tags in 2");
            return false;
        }
        if (!dict1.getTagGroupDefinitions().equivalent(dict2.getTagGroupDefinitions())) {
            LOGGER.fine("Tag groups in 1 do not match tag groups in 2");
            return false;
        }
        if (!dict1.getRelationDefinitions().equivalent(dict2.getRelationDefinitions())) {
            LOGGER.fine("Relations in 1 do not match relations in 2");
            if (LOGGER.isLoggable(Level.FINER)) {
                try {
                    BComponent[] relations1 = ((BSmartTagDictionary)dict1).getTagRules().getChildComponents();
                    BComponent[] relations2 = ((BSmartTagDictionary)dict2).getTagRules().getChildComponents();
                    if (relations1.length != relations2.length) {
                        LOGGER.finer("Relation component counts do not match; dict1: " + relations1.length + ", dict2: " + relations2.length);
                    } else {
                        for (int i = 0; i < relations1.length; ++i) {
                            BComponent relation1 = relations1[i];
                            BComponent relation2 = relations2[i];
                            if (relation1.equivalent((Object)relation2)) continue;
                            LOGGER.finer("Relations at " + i + " are not equivalent; dict1: " + relation1 + ", dict2: " + relation2);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINER, "Exception checking relation equivalency", e);
                }
            }
            return false;
        }
        boolean isSmart1 = dict1 instanceof BSmartTagDictionary;
        boolean isSmart2 = dict2 instanceof BSmartTagDictionary;
        if (isSmart1 || isSmart2) {
            if (isSmart1 && isSmart2) {
                if (!((BSmartTagDictionary)dict1).getTagRules().equivalent(((BSmartTagDictionary)dict2).getTagRules())) {
                    LOGGER.fine("Tag rules in 1 do not match tag rules in 2");
                    if (LOGGER.isLoggable(Level.FINER)) {
                        try {
                            BComponent[] rules1 = ((BSmartTagDictionary)dict1).getTagRules().getChildComponents();
                            BComponent[] rules2 = ((BSmartTagDictionary)dict2).getTagRules().getChildComponents();
                            if (rules1.length != rules2.length) {
                                LOGGER.finer("Rule component counts do not match; dict1: " + rules1.length + ", dict2: " + rules2.length);
                            } else {
                                for (int i = 0; i < rules1.length; ++i) {
                                    BComponent rule1 = rules1[i];
                                    BComponent rule2 = rules2[i];
                                    if (rule1.equivalent((Object)rule2)) continue;
                                    LOGGER.finer("Rules at " + i + " are not equivalent; dict1: " + rule1 + ", dict2: " + rule2);
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINER, "Exception checking rule equivalency", e);
                        }
                    }
                    return false;
                }
            } else {
                LOGGER.fine("Both dictionaries are not smart tag dictionaries");
                return false;
            }
        }
        return true;
    }

    private static void importRelationData(BTagDictionary newDictionary, String[] values) throws Exception {
        String relationId = values[3];
        if (relationId.isEmpty()) {
            return;
        }
        BRelationInfoList relationInfos = newDictionary.getRelationDefinitions();
        relationInfos.add(relationId, (BValue)ImportUtil.makeRelationInfo(values[5]));
        LOGGER.fine(() -> "Relation: " + relationId + " added.");
    }

    private static String importGroupData(BTagDictionary newDictionary, String lastGroup, String[] values) throws Exception {
        String currentGroup;
        String groupName = values[2];
        if (groupName.isEmpty() && (lastGroup == null || lastGroup.isEmpty())) {
            return "";
        }
        BTagGroupInfoList groupInfos = newDictionary.getTagGroupDefinitions();
        BTagGroupInfo groupInfo = null;
        if (!groupName.isEmpty()) {
            currentGroup = groupName;
            String validTypes = values[8];
            if (validTypes == null || validTypes.isEmpty()) {
                validTypes = "baja:Component";
            }
            if ((groupInfo = (BTagGroupInfo)groupInfos.get(groupName)) == null) {
                Property newGroup = groupInfos.add(groupName, (BValue)new BTagGroupInfo());
                groupInfo = (BTagGroupInfo)groupInfos.get(newGroup);
                LOGGER.fine(() -> "TagGroup: " + groupName + " added");
            }
            groupInfo.setValidity(ImportUtil.makeValidityRule(values[6], values[7], validTypes, values[9], values[10]));
        } else {
            currentGroup = lastGroup;
        }
        if (groupInfo == null) {
            groupInfo = (BTagGroupInfo)groupInfos.get(currentGroup);
        }
        if (groupInfo == null) {
            LOGGER.severe(currentGroup + "TagGroup could not be found!");
            return currentGroup;
        }
        if (values[3].isEmpty()) {
            return currentGroup;
        }
        TagInfo tagInfo = newDictionary.getTagDefinitions().getTag(ImportUtil.getIdFromName(newDictionary, values[3])).orElseThrow(() -> new Exception("Group Tag: \"" + values[3] + "\" tag is not defined in TagDefinitions"));
        groupInfo.getTagList().add(tagInfo.getName(), ((BTagInfo)tagInfo).newCopy());
        LOGGER.fine(() -> "TagGroup: " + currentGroup + '.' + values[3] + " added.");
        return currentGroup;
    }

    private static String importRuleData(BTagDictionary newDictionary, String lastRule, String[] values) throws Exception {
        String currentRule;
        String ruleName = values[1];
        if (!newDictionary.getType().is(BSmartTagDictionary.TYPE)) {
            throw new Exception(LEX.getText("import.notSmartTagDictionary"));
        }
        if (ruleName.isEmpty() && (lastRule == null || lastRule.isEmpty())) {
            return "";
        }
        BSmartTagDictionary smartDictionary = (BSmartTagDictionary)newDictionary;
        BTagRuleList ruleInfos = smartDictionary.getTagRules();
        BTagRule ruleInfo = null;
        if (!ruleName.isEmpty()) {
            currentRule = ruleName;
            String validTypes = values[8];
            if (validTypes == null || validTypes.isEmpty()) {
                validTypes = "baja:Component";
            }
            if ((ruleInfo = (BTagRule)ruleInfos.get(ruleName)) == null) {
                Property newRule = ruleInfos.add(ruleName, (BValue)new BTagRule());
                ruleInfo = (BTagRule)ruleInfos.get(newRule);
                LOGGER.fine(() -> "TagRule: " + ruleName + " added");
            }
            ruleInfo.setCondition(ImportUtil.makeValidityRule(values[6], values[7], validTypes, values[9], values[10]));
        } else {
            currentRule = lastRule;
        }
        if (ruleInfo == null) {
            ruleInfo = (BTagRule)ruleInfos.get(currentRule);
        }
        if (ruleInfo == null) {
            LOGGER.severe(currentRule + "TagRule could not be found!");
            return currentRule;
        }
        if (!values[3].isEmpty()) {
            if (!values[4].equalsIgnoreCase("Relation")) {
                TagInfo tagInfo = newDictionary.getTagDefinitions().getTag(ImportUtil.getIdFromName(newDictionary, values[3])).orElseThrow(() -> new Exception("Rule TagList: \"" + values[3] + "\" tag is not defined in TagDefinitions"));
                BTagInfoList tagList = ruleInfo.getTagList();
                if (tagList.get(tagInfo.getName()) != null) {
                    throw new Exception(currentRule + " already has a tag named: " + tagInfo.getName());
                }
                tagList.add(tagInfo.getName(), ((BTagInfo)tagInfo).newCopy());
                LOGGER.fine(() -> "TagRule: " + currentRule + '.' + values[3] + " added.");
            } else if (values[4].equalsIgnoreCase("Relation")) {
                RelationInfo relationInfo = smartDictionary.getRelationDefinitions().getRelation(ImportUtil.getIdFromName(newDictionary, values[3])).orElseThrow(() -> new Exception("Rule Relation: \"" + values[3] + "\" tag relation is not defined in RelationDefinitions"));
                ruleInfo.getRelationList().add(relationInfo.getName(), ((BRelationInfo)relationInfo).newCopy());
                LOGGER.fine(() -> "Relation: " + currentRule + '.' + values[3] + " added.");
            }
        } else if (!values[2].isEmpty()) {
            TagGroupInfo tagGroupInfo = newDictionary.getTagGroupDefinitions().getTagGroup(ImportUtil.getIdFromName(newDictionary, values[2])).orElseThrow(() -> new Exception("Rule TagGroup: \"" + values[2] + "\" tagGroup is not defined in TagGroupDefinitions"));
            ruleInfo.getTagGroupList().add(tagGroupInfo.getName(), ((BTagGroupInfo)tagGroupInfo).newCopy());
            LOGGER.fine(() -> "TagGroup: " + currentRule + '.' + values[2] + " added.");
        }
        return currentRule;
    }

    private static Id getIdFromName(BTagDictionary newDictionary, String value) {
        String unescapedValue = EscUtil.slot.unescape(value);
        if (unescapedValue.contains(String.valueOf(':'))) {
            return Id.newId((String)unescapedValue);
        }
        return Id.newId((String)newDictionary.getNamespace(), (String)unescapedValue);
    }

    private static void importTagData(BTagDictionary newDictionary, String[] values) throws Exception {
        String tagName = values[3];
        if (tagName == null || tagName.isEmpty()) {
            return;
        }
        String tagTypeStr = values[4];
        Type tagType = ImportUtil.decodeTagType(tagTypeStr);
        if (tagType == null) {
            throw new Exception("invalid tagType: " + tagTypeStr);
        }
        BIDataValue defaultValue = (BIDataValue)tagType.getInstance();
        String validTypes = values[8];
        if (validTypes == null || validTypes.isEmpty()) {
            validTypes = "baja:Component";
        }
        BTagRuleCondition tagValidityRule = ImportUtil.makeValidityRule(values[6], values[7], validTypes, values[9], values[10]);
        BTagInfo newTag = ImportUtil.makeTagInfo(values[5], defaultValue);
        if (tagValidityRule != null) {
            newTag.setValidity(tagValidityRule);
        }
        BTagInfoList tagInfos = newDictionary.getTagDefinitions();
        BTagInfo tagInfo = (BTagInfo)tagInfos.get(tagInfos.add(tagName, (BValue)newTag));
        LOGGER.fine(() -> "Tag: " + tagName + " added.");
        String units = values[11];
        if (units != null && !units.isEmpty()) {
            BUnit defUnit;
            try {
                defUnit = UnitDatabase.getUnit((String)units);
            }
            catch (UnitException ignored) {
                throw new Exception(units + " is not a valid unit.");
            }
            BFacets defFacets = BFacets.makeNumeric((BUnit)defUnit, (int)2);
            tagInfo.add("defFacets", (BValue)defFacets);
        }
    }

    public static ArrayList<DataPolicyInfo> saveDataPolicyInfo(BTagDictionary dictionary, ArrayList<DataPolicyInfo> savedDataPolicies) {
        BDataPolicy[] dataPolicies;
        for (BDataPolicy dataPolicy : dataPolicies = (BDataPolicy[])CompUtil.getDescendants((BComponent)dictionary, BDataPolicy.class)) {
            BComplex parent = dataPolicy.getParent();
            boolean isTagGroup = parent instanceof BTagGroupInfo;
            parent.getName();
            savedDataPolicies.add(DataPolicyInfo.make(parent.getName(), isTagGroup, (BDataPolicy)dataPolicy.newCopy()));
            LOGGER.fine(() -> "Saved dataPolicy for: " + parent.getName());
        }
        return savedDataPolicies;
    }

    public static void restoreDataPolicies(ArrayList<DataPolicyInfo> savedDataPolicies, BTagDictionary dictionary) {
        for (DataPolicyInfo dataPolicyInfo : savedDataPolicies) {
            BValue bValue;
            BInfoList dpParent = dictionary.getTagDefinitions();
            if (dataPolicyInfo.isTagGroupInfo()) {
                dpParent = dictionary.getTagGroupDefinitions();
            }
            if ((bValue = dpParent.get(dataPolicyInfo.getTagId())) instanceof BComponent) {
                BComponent parentComp = bValue.asComponent();
                parentComp.add("dp_" + dataPolicyInfo.getTagId(), (BValue)dataPolicyInfo.getDataPolicy());
                LOGGER.fine(() -> "Restored dataPolicy for: " + parentComp.getName());
                continue;
            }
            LOGGER.info(() -> "TagInfo or TagGroupInfo not found: " + dataPolicyInfo.getTagId());
        }
    }

    private static BTagInfo makeTagInfo(String smartType, BIDataValue defaultValue) throws Exception {
        if (smartType.isEmpty()) {
            return new BSimpleTagInfo(defaultValue);
        }
        try {
            return (BTagInfo)BTypeSpec.make((String)smartType).getResolvedType().getInstance();
        }
        catch (Exception ignored) {
            LOGGER.warning(() -> "Invalid smartTagType for: " + smartType);
            throw new Exception("Invalid smartTagType: " + smartType);
        }
    }

    private static BRelationInfo makeRelationInfo(String smartType) throws Exception {
        if (smartType.isEmpty()) {
            return new BRelationInfo();
        }
        try {
            return (BRelationInfo)BTypeSpec.make((String)smartType).getResolvedType().getInstance();
        }
        catch (Exception ignored) {
            LOGGER.warning(() -> "Invalid smartTagType for: " + smartType);
            throw new Exception("Invalid smartTagType: " + smartType);
        }
    }

    private static BTagRuleCondition makeValidityRule(String hasTags, String hasAncestors, String isType, String hasRelation, String hasRelationFilter) throws Exception {
        int condCount = 0;
        BBooleanFilter hasTagsCond = null;
        if (hasTags != null && !hasTags.isEmpty()) {
            String neqlValid = ImportUtil.isNeqlPredicateValid(hasTags, "hasTags");
            if (!neqlValid.isEmpty()) {
                LOGGER.severe(neqlValid);
            }
            hasTagsCond = new BBooleanFilter(hasTags);
            ++condCount;
        }
        BHasAncestor hasAncestorCond = null;
        if (hasAncestors != null && !hasAncestors.isEmpty()) {
            String neqlValid = ImportUtil.isNeqlPredicateValid(hasAncestors, "hasAncestor");
            if (!neqlValid.isEmpty()) {
                LOGGER.severe(neqlValid);
            }
            hasAncestorCond = new BHasAncestor(hasAncestors);
            ++condCount;
        }
        BHasRelation hasRelationCond = null;
        if (hasRelation != null && !hasRelation.isEmpty()) {
            String neqlValid = ImportUtil.isNeqlPredicateValid(hasRelation, "hasRelation");
            if (!neqlValid.isEmpty()) {
                LOGGER.severe(neqlValid);
            }
            hasRelationCond = new BHasRelation(Id.newId((String)hasRelation), hasRelationFilter);
            ++condCount;
        }
        ArrayList<BIsTypeCondition> isTypeConds = new ArrayList<BIsTypeCondition>();
        if (isType != null && !isType.isEmpty()) {
            try {
                String[] isTypeValues = TextUtil.split((String)isType.trim(), (char)' ');
                if (isTypeValues != null && isTypeValues.length > 0) {
                    for (String isTypeValue : isTypeValues) {
                        BTypeSpec typeSpec = BTypeSpec.make((String)isTypeValue.trim());
                        if (typeSpec == null) continue;
                        isTypeConds.add(new BIsTypeCondition(typeSpec.getResolvedType()));
                    }
                    if (!isTypeConds.isEmpty()) {
                        ++condCount;
                    }
                }
            }
            catch (Exception ignored) {
                throw new Exception("isType column has invalid type: " + isType);
            }
        }
        BTagRuleCondition combinedIsTypeConds = null;
        if (!isTypeConds.isEmpty()) {
            if (isTypeConds.size() == 1) {
                combinedIsTypeConds = (BTagRuleCondition)isTypeConds.get(0);
            } else {
                combinedIsTypeConds = new BOr();
                for (BIsTypeCondition isTypeCond : isTypeConds) {
                    combinedIsTypeConds.add("t?", (BValue)isTypeCond, 1, null);
                }
            }
        }
        switch (condCount) {
            case 0: {
                return null;
            }
            case 1: {
                if (hasTagsCond != null) {
                    return hasTagsCond;
                }
                if (hasAncestorCond != null) {
                    return hasAncestorCond;
                }
                if (hasRelationCond != null) {
                    return hasRelationCond;
                }
                if (combinedIsTypeConds != null) {
                    return combinedIsTypeConds;
                }
                return null;
            }
            case 2: 
            case 3: 
            case 4: {
                BAnd andCond = new BAnd();
                if (hasTagsCond != null) {
                    andCond.add("a?", (BValue)hasTagsCond, 1, null);
                }
                if (hasAncestorCond != null) {
                    andCond.add("a?", (BValue)hasAncestorCond, 1, null);
                }
                if (hasRelationCond != null) {
                    andCond.add("a?", (BValue)hasRelationCond, 1, null);
                }
                if (combinedIsTypeConds != null) {
                    andCond.add("a?", (BValue)combinedIsTypeConds, 1, null);
                }
                return andCond;
            }
        }
        return null;
    }

    private static String[] getRowValues(InputStream csvIn) throws Exception {
        String line = ImportUtil.readLine(csvIn);
        String[] elems = TextUtil.splitAndTrim((String)line, (char)',');
        if (elems.length < 2) {
            LOGGER.severe("invalid line: \r\n" + line);
        }
        return elems;
    }

    private static String readLine(InputStream in) throws Exception {
        String line = "";
        StringBuilder sb = new StringBuilder();
        while (in.available() > 0) {
            char data = (char)in.read();
            sb.append(data);
            if (data != '\n') continue;
            line = sb.toString();
            if (line.charAt(0) != '#') break;
            sb = new StringBuilder();
            break;
        }
        if (sb.length() > 0) {
            line = sb.toString();
        }
        return line;
    }

    private static Type decodeTagType(String importType) throws Exception {
        for (int i = 0; i < tagImportTypeStrings.length; ++i) {
            if (!tagImportTypeStrings[i].equalsIgnoreCase(importType)) continue;
            return tagImportTypes[i];
        }
        throw new Exception(importType + " is an invalid type");
    }

    private static String isNeqlPredicateValid(String predicate, String name) throws Exception {
        if (predicate.isEmpty()) {
            return LEX.getText("query.empty", new Object[]{name});
        }
        String neql = "neql:" + predicate;
        BOrd newOrdValue = BOrd.make((String)neql);
        try {
            OrdQuery[] queryList;
            for (OrdQuery query : queryList = newOrdValue.parse()) {
                String scheme = query.getScheme();
                if ("neql".equals(scheme)) continue;
                throw new Exception(LEX.getText("query.invalidScheme", new Object[]{name, scheme}));
            }
        }
        catch (NullOrdException ignored) {
            throw new Exception(LEX.getText("query.empty", new Object[]{name}));
        }
        catch (SyntaxException e) {
            String additionalInfo = "";
            if (predicate.contains("\"")) {
                additionalInfo = "\n " + LEX.getText("query.double.quote");
            }
            throw new Exception(LEX.getText("query.syntax.error", new Object[]{name, predicate, e.getCause().getLocalizedMessage(), additionalInfo}));
        }
        return "";
    }

    public static class DataPolicyInfo {
        String tagId;
        boolean isTagGroupInfo;
        BDataPolicy dataPolicy;

        public static DataPolicyInfo make(String tagId, boolean isTagGroupInfo, BDataPolicy dataPolicy) {
            return new DataPolicyInfo(tagId, isTagGroupInfo, dataPolicy);
        }

        private DataPolicyInfo(String tagId, boolean isTagGroupInfo, BDataPolicy dataPolicy) {
            this.tagId = tagId;
            this.isTagGroupInfo = isTagGroupInfo;
            this.dataPolicy = dataPolicy;
        }

        public String getTagId() {
            return this.tagId;
        }

        public boolean isTagGroupInfo() {
            return this.isTagGroupInfo;
        }

        public BDataPolicy getDataPolicy() {
            return this.dataPolicy;
        }
    }

    public static class ResultInfo {
        String info;
        BColor foreground;

        public static ResultInfo make(String info, BColor foreground) {
            return new ResultInfo(info, foreground);
        }

        private ResultInfo(String info, BColor foreground) {
            this.info = info;
            this.foreground = foreground;
        }

        public String getInfo() {
            return this.info;
        }

        @Deprecated
        public BColor getForground() {
            return this.foreground;
        }

        public BColor getForeground() {
            return this.foreground;
        }
    }
}

