/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.util;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.sys.BMarker;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BSimpleTagInfo;

public class EntityTagIndex {
    private final Map<Id, Integer> tagsToIndex = new ConcurrentHashMap<Id, Integer>();
    private final Map<BOrd, TagInfoArrayWrapper> tagInfoIndex = new HashMap<BOrd, TagInfoArrayWrapper>();
    private final WeakHashMap<TagInfoArrayWrapper, WeakReference<TagInfoArrayWrapper>> tagInfoIndexCache = new WeakHashMap();
    private static final TagInfo NOT_PRESENT = new BSimpleTagInfo((BIDataValue)BMarker.DEFAULT);
    private static final Logger logger = Logger.getLogger("tagdictionary");

    public boolean isIndexed(Id id) {
        Objects.requireNonNull(id, "id");
        return this.tagsToIndex.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Id> getIndexedIds() {
        Map<BOrd, TagInfoArrayWrapper> map = this.tagInfoIndex;
        synchronized (map) {
            return this.tagsToIndex.keySet().stream().collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexedIds(Set<Id> ids) {
        Objects.requireNonNull(ids, "ids");
        Map<BOrd, TagInfoArrayWrapper> map = this.tagInfoIndex;
        synchronized (map) {
            Arrays.stream(this.tagsToIndex.keySet().toArray(new Id[0])).filter(id -> !ids.contains(id)).forEach(this::removeIdFromIndex);
            ids.stream().filter(id -> !this.tagsToIndex.containsKey(id)).forEach(this::addIdToIndex);
            if (this.tagsToIndex.isEmpty()) {
                this.clearAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexedId(Id id) {
        Objects.requireNonNull(id, "id");
        Map<BOrd, TagInfoArrayWrapper> map = this.tagInfoIndex;
        synchronized (map) {
            if (!this.tagsToIndex.containsKey(id)) {
                this.addIdToIndex(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndexedId(Id id) {
        Objects.requireNonNull(id, "id");
        Map<BOrd, TagInfoArrayWrapper> map = this.tagInfoIndex;
        synchronized (map) {
            if (this.tagsToIndex.containsKey(id)) {
                this.removeIdFromIndex(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllIds() {
        Map<BOrd, TagInfoArrayWrapper> map = this.tagInfoIndex;
        synchronized (map) {
            this.clearAll();
            logger.fine("Invalidated all tags within entity tag index.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSingleId(Id id) {
        Objects.requireNonNull(id, "id");
        Map<BOrd, TagInfoArrayWrapper> map = this.tagInfoIndex;
        synchronized (map) {
            this.invalidateId(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TagInfo> getTagInfo(Id id, Entity entity) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(entity, "entity");
        Optional entityOrd = entity.getOrdToEntity();
        if (!entityOrd.isPresent()) {
            return null;
        }
        Map<BOrd, TagInfoArrayWrapper> map = this.tagInfoIndex;
        synchronized (map) {
            TagInfo tagInfo;
            Integer index = this.tagsToIndex.get(id);
            if (index == null) {
                return null;
            }
            TagInfoArrayWrapper entityTagIndex = this.tagInfoIndex.get(entityOrd.get());
            if (entityTagIndex != null && (tagInfo = entityTagIndex.array()[index]) != null) {
                if (tagInfo == NOT_PRESENT) {
                    return Optional.empty();
                }
                return Optional.of(tagInfo);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTagInfo(Id id, Entity entity, Optional<TagInfo> tagInfo) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(entity, "entity");
        Objects.requireNonNull(tagInfo, "tagInfo");
        Optional entityOrd = entity.getOrdToEntity();
        if (!entityOrd.isPresent()) {
            return;
        }
        Map<BOrd, TagInfoArrayWrapper> map = this.tagInfoIndex;
        synchronized (map) {
            Integer index = this.tagsToIndex.get(id);
            if (index != null) {
                TagInfoArrayWrapper wrapper = this.tagInfoIndex.get(entityOrd.get());
                TagInfo[] tagInfos = wrapper != null ? Arrays.copyOf(wrapper.array(), wrapper.array().length) : new TagInfo[this.tagsToIndex.size()];
                tagInfos[index.intValue()] = tagInfo.orElse(NOT_PRESENT);
                this.tagInfoIndex.put((BOrd)entityOrd.get(), this.getWrapper(tagInfos));
            }
        }
    }

    private void addIdToIndex(Id id) {
        int tagsToIndexCount = this.tagsToIndex.size();
        int newSize = tagsToIndexCount + 1;
        this.tagInfoIndex.replaceAll((k, v) -> this.getWrapper(Arrays.copyOf(v.array(), newSize)));
        this.tagsToIndex.put(id, tagsToIndexCount);
        logger.fine(() -> "Added " + id + " to tag index.");
    }

    private void removeIdFromIndex(Id id) {
        int index = this.tagsToIndex.remove(id);
        if (this.tagsToIndex.size() <= 0) {
            this.tagInfoIndex.clear();
            this.tagInfoIndexCache.clear();
        } else {
            this.tagInfoIndex.replaceAll((k, v) -> {
                TagInfo[] oldValue = v.array();
                TagInfo[] newValue = new TagInfo[oldValue.length - 1];
                if (index > 0) {
                    System.arraycopy(oldValue, 0, newValue, 0, index);
                }
                if (index < newValue.length) {
                    System.arraycopy(oldValue, index + 1, newValue, index, newValue.length - index);
                }
                return this.getWrapper(newValue);
            });
            this.tagsToIndex.replaceAll((k, v) -> v > index ? (v = Integer.valueOf(v - 1)) : v);
        }
        logger.fine(() -> "Removed " + id + " from tag index.");
    }

    private void invalidateId(Id id) {
        Integer index = this.tagsToIndex.get(id);
        if (index != null) {
            this.tagInfoIndex.replaceAll((k, v) -> {
                TagInfo[] newValue = Arrays.copyOf(v.array(), v.array().length);
                newValue[index.intValue()] = null;
                return this.getWrapper(newValue);
            });
            logger.fine(() -> "Invalidated tag " + id + " within entity tag index.");
        } else {
            logger.fine(() -> "Tag id " + id + " is not being indexed and, therefore, cannot be invalidated in the entity tag index");
        }
    }

    private void clearAll() {
        this.tagInfoIndex.clear();
        this.tagInfoIndexCache.clear();
    }

    private TagInfoArrayWrapper getWrapper(TagInfo[] tagInfos) {
        TagInfoArrayWrapper wrapper = new TagInfoArrayWrapper(tagInfos);
        if (this.tagInfoIndexCache.containsKey(wrapper)) {
            wrapper = (TagInfoArrayWrapper)this.tagInfoIndexCache.get(wrapper).get();
        } else {
            this.tagInfoIndexCache.put(wrapper, new WeakReference<TagInfoArrayWrapper>(wrapper));
        }
        return wrapper;
    }

    private static final class TagInfoArrayWrapper {
        private final TagInfo[] tagInfos;
        private final int hashCode;

        public TagInfoArrayWrapper(TagInfo[] tagInfos) {
            this.tagInfos = tagInfos;
            int hashCode = 1;
            for (TagInfo element : tagInfos) {
                hashCode = 31 * hashCode + (element != null ? System.identityHashCode(element) : 0);
            }
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TagInfoArrayWrapper)) {
                return false;
            }
            TagInfoArrayWrapper other = (TagInfoArrayWrapper)obj;
            if (this.tagInfos == other.tagInfos) {
                return true;
            }
            if (this.tagInfos == null || other.tagInfos == null) {
                return false;
            }
            if (this.tagInfos.length != other.tagInfos.length) {
                return false;
            }
            for (int i = 0; i < this.tagInfos.length; ++i) {
                if (this.tagInfos[i] == other.tagInfos[i]) continue;
                return false;
            }
            return true;
        }

        public TagInfo[] array() {
            return this.tagInfos;
        }
    }
}

