/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.neqlize;

import com.tridium.tagdictionary.neqlize.FilteredTagsMap;
import com.tridium.tagdictionary.neqlize.TagsCandidateIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BMarker;
import javax.baja.sys.BNumber;
import javax.baja.sys.Type;
import javax.baja.tag.Tag;

public final class TagSetSearch {
    private final Collection<BComponent> searchSet;
    private final FilteredTagsMap filteredTagsMap;
    private static final Logger logger = Logger.getLogger("tagdictionary");

    public TagSetSearch(Collection<BComponent> searchSet, FilteredTagsMap filteredTagsMap) {
        this.searchSet = searchSet;
        this.filteredTagsMap = filteredTagsMap;
    }

    public Set<Tag> findIdentifyingTags(BComponent target) {
        if (target == null || this.searchSet.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.searchSet.size() == 1 && this.searchSet.contains(target)) {
            return Collections.emptySet();
        }
        List<Tag> targetTags = this.filteredTagsMap.getFilteredTags(target);
        if (targetTags.isEmpty()) {
            return Collections.emptySet();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" filtered tags on target = " + TagSetSearch.tagSetToString(targetTags));
        }
        TagsCandidateIterator candidates = new TagsCandidateIterator(targetTags);
        while (candidates.hasNext()) {
            Set candidate = (Set)candidates.next();
            if (!this.isIdentifying(target, candidate)) continue;
            return candidate;
        }
        return Collections.emptySet();
    }

    private boolean isIdentifying(BComponent target, Collection<Tag> candidate) {
        for (BComponent member : this.searchSet) {
            if (member == target) continue;
            List<Tag> peerTags = this.filteredTagsMap.getFilteredTags(member);
            if (peerTags.containsAll(candidate)) {
                return false;
            }
            if (!TagSetSearch.isNumberTagsHaveSameNameAndValue(peerTags, new ArrayList<Tag>(candidate))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumberTagsHaveSameNameAndValue(List<Tag> tagList1, List<Tag> tagList2) {
        HashMap<String, BNumber> tagMap = new HashMap<String, BNumber>();
        for (Tag tag : tagList1) {
            BNumber tagValue1;
            block6: {
                if (!(tag.getValue() instanceof BNumber)) continue;
                tagValue1 = null;
                try {
                    tagValue1 = BNumber.cast((BNumber)((BNumber)tag.getValue()), (Type)BDouble.TYPE);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block6;
                    logger.log(Level.FINE, "Invalid value in tag list 2: '" + tagValue1 + "' to cast to BNumber for the tag: '" + tag.getId().getName() + "'", e);
                }
            }
            tagMap.put(tag.getId().getName(), tagValue1);
        }
        for (Tag tag : tagList2) {
            BNumber tagValue2;
            BNumber tagValueFromTagMap;
            block7: {
                tagValueFromTagMap = (BNumber)tagMap.get(tag.getId().getName());
                if (tagValueFromTagMap == null || !(tag.getValue() instanceof BNumber)) continue;
                tagValue2 = null;
                try {
                    tagValue2 = BNumber.cast((BNumber)((BNumber)tag.getValue()), (Type)BDouble.TYPE);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block7;
                    logger.log(Level.FINE, "Invalid value in tag list 2: '" + tagValue2 + "' to cast to BNumber for the tag: '" + tag.getId().getName() + "'", e);
                }
            }
            if (tagValue2 == null || !tagValue2.equals((Object)tagValueFromTagMap)) continue;
            return true;
        }
        return false;
    }

    private static String tagSetToString(Iterable<Tag> tags) {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        for (Tag tag : tags) {
            joiner.add(tag.getValue() instanceof BMarker ? tag.getId().toString() : tag.getId() + " - " + tag.getValue());
        }
        return joiner.toString();
    }

    public boolean isInSearchSet(BComponent target) {
        return this.searchSet.contains(target);
    }
}

