/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.linkfilter;

import com.tridium.lonworks.datatypes.BLinkFilterEntry;
import com.tridium.lonworks.loncomm.BLinkFilter;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;

@NiagaraType(agent={@AgentOn(types={"lonworks:LinkFilter"}, requiredPermissions="r")})
public class BLinkFilterView
extends BAbstractManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BLinkFilterView.class);
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BLinkFilterView.class);
    static String[] timeKeys = new String[]{"showTimeZone", "showDate", "showTime", "showSeconds", "showMilliseconds"};
    static BBoolean TRUE = BBoolean.TRUE;
    static BBoolean FALSE = BBoolean.FALSE;
    static BFacets timeMilli = BFacets.make((String[])timeKeys, (BIDataValue[])new BIDataValue[]{FALSE, FALSE, TRUE, TRUE, TRUE});
    static BFacets timeDate = BFacets.make((String[])timeKeys, (BIDataValue[])new BIDataValue[]{TRUE, TRUE, FALSE, FALSE, FALSE});
    BLinkFilter linkFilter;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject obj, Context cx) {
        this.linkFilter = (BLinkFilter)obj;
        super.doLoadValue((BObject)this.linkFilter.getEntries(), cx);
    }

    protected MgrController makeController() {
        FilterController ret = new FilterController(this);
        ret.newCommand.setFlags(0);
        ret.edit.setFlags(0);
        return ret;
    }

    protected MgrModel makeModel() {
        return new LinkModel(this);
    }

    private void editPopup(BLinkFilterEntry entry) {
        NAppBuffer ab = entry.getAppBuffer();
        BGridPane gp = new BGridPane(2);
        this.addRow(gp, "queue", this.getString(ab.getQueue(), new int[]{2, 3, 4, 5, 6, 8}, new String[]{"niTQ", "niTQ_P", "niNTQ", "niNTQ_P", "niRESPONSE", "niINCOMING"}));
        this.addRow(gp, "queue command", this.getString(ab.getCommand(), new int[]{16, 32}, new String[]{"niCOMM", "niNETMGMT"}));
        this.addRow(gp, "bufferLength", ab.getBufferLength());
        BGridPane gp2 = new BGridPane(2);
        if (ab.isNetVar()) {
            this.addRow(gp2, "poll", ab.isPoll());
        } else {
            this.addRow(gp2, "service type", ab.getServiceType().getTag());
            this.addRow(gp2, "authenticate", ab.isAuthenticate());
        }
        this.addRow(gp2, "tag", ab.getTag());
        this.addRow(gp2, "priority", ab.isPriority());
        this.addRow(gp2, "path", ab.isPath());
        this.addRow(gp2, "completion", ab.getComplCode().getTag());
        this.addRow(gp2, "address mode", ab.isExplicitAddress() ? "explicit" : "implicit");
        if (ab.isNetVar()) {
            this.addRow(gp2, "turnaround", ab.isTurnaround());
        } else {
            this.addRow(gp2, "altPath", ab.isAltPath());
        }
        this.addRow(gp2, "pool", ab.isPool());
        this.addRow(gp2, "response", ab.isResp());
        this.addRow(gp2, "data length", ab.getDataLength());
        BBorderPane bp = new BBorderPane((BWidget)gp, new BLabel("Application Header"), BBorder.solid);
        BBorderPane bp2 = new BBorderPane((BWidget)gp2, new BLabel("Message Header"), BBorder.solid);
        BEdgePane ep = new BEdgePane();
        ep.setTop((BWidget)bp);
        ep.setBottom((BWidget)bp2);
        BBorderPane content = new BBorderPane((BWidget)ep);
        BDialog.open((BWidget)this, (String)"Application Buffer", (Object)content, (int)1, (BImage)BImage.make((BIcon)entry.getIcon()));
    }

    private void addRow(BGridPane gp, String label, boolean txt) {
        this.addRow(gp, label, Boolean.valueOf(txt).toString());
    }

    private void addRow(BGridPane gp, String label, int txt) {
        this.addRow(gp, label, Integer.toString(txt));
    }

    private void addRow(BGridPane gp, String label, String text) {
        BLabel lb = new BLabel(label);
        gp.add(null, (BValue)lb);
        gp.add(null, (BValue)new BTextField(text, 20, false));
    }

    private String getString(int key, int[] keys, String[] tags) {
        if (keys.length != tags.length) {
            throw new RuntimeException("keys and tags not same length");
        }
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] != key) continue;
            return tags[i];
        }
        return "unknown" + Integer.toString(key);
    }

    static abstract class LinkColumn
    extends MgrColumn {
        public LinkColumn(String displayName, int flags) {
            super(displayName, flags);
        }

        public BValue load(MgrEditRow row) {
            return (BValue)this.get(row.getTarget());
        }
    }

    static class LinkModel
    extends MgrModel {
        public LinkModel(BLinkFilterView manager) {
            super((BAbstractManager)manager);
        }

        public int getSubscribeDepth() {
            return Integer.MAX_VALUE;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BLinkFilterEntry.TYPE};
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new LinkColumn("date", 6){

                public Object get(Object tgt) {
                    return ((BLinkFilterEntry)tgt).getTimeStamp().toString((Context)timeDate);
                }
            }, new LinkColumn("time", 4){

                public Object get(Object tgt) {
                    return ((BLinkFilterEntry)tgt).getTimeStamp().toString((Context)timeMilli);
                }
            }, new LinkColumn("dir", 4){

                public Object get(Object tgt) {
                    return BString.make((String)(((BLinkFilterEntry)tgt).getDirection() ? "recv" : "send"));
                }
            }, new LinkColumn("tag", 6){

                public Object get(Object tgt) {
                    return BInteger.make((int)((BLinkFilterEntry)tgt).getAppBuffer().getTag());
                }
            }, new LinkColumn("header", 6){

                public Object get(Object tgt) {
                    byte[] a = ((BLinkFilterEntry)tgt).getNetBytes();
                    return BString.make((String)LonByteArrayUtil.toString((byte[])a, (int)16, (int)0));
                }
            }, new LinkColumn("message", 4){

                public Object get(Object tgt) {
                    byte[] a = ((BLinkFilterEntry)tgt).getNetBytes();
                    return BString.make((String)LonByteArrayUtil.toString((byte[])a, (int)(a.length - 16), (int)16));
                }
            }, new LinkColumn("serviceType", 6){

                public Object get(Object tgt) {
                    return ((BLinkFilterEntry)tgt).getAppBuffer().getServiceType();
                }
            }};
        }
    }

    class ClearCommand
    extends MgrController.MgrCommand {
        ClearCommand(BWidget owner) {
            super(owner, (Lexicon)lexicon, "filter.clear");
        }

        public CommandArtifact doInvoke() throws Exception {
            BLinkFilterView.this.linkFilter.clearTable();
            return null;
        }
    }

    class FilterController
    extends MgrController {
        public final MgrController.MgrCommand clear;

        FilterController(BAbstractManager manager) {
            super(manager);
            this.clear = new ClearCommand((BWidget)manager);
            this.clear.setFlags(3);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.clear};
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BLinkFilterView.this.editPopup((BLinkFilterEntry)table.getComponentAt(row));
        }
    }
}

