/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui;

import com.tridium.lonworks.ui.tool.BLonXmlOptions;
import com.tridium.workbench.nav.BComponentMenuAgent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.datatypes.BLocalExtractXifParameter;
import javax.baja.lonworks.datatypes.BLocalImportXmlParameter;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"lonworks:LocalLonDevice"}, requiredPermissions="r")})
@NiagaraSingleton
public class BLocalDeviceMenuAgent
extends BComponentMenuAgent {
    @Generated
    public static final BLocalDeviceMenuAgent INSTANCE = new BLocalDeviceMenuAgent();
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalDeviceMenuAgent.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BMenu menu = super.doMakeMenu(owner, target, cx);
        if (!((BComponent)target).isMounted()) {
            return menu;
        }
        if (((BComponent)target).getComponentSpace() != null) {
            ImportCommand icmd = new ImportCommand(owner, target);
            menu.add("importXml", (Command)icmd);
            ExtractXifCommand ecmd = new ExtractXifCommand(owner, target);
            menu.add("ExtractXif", (Command)ecmd);
            menu.add(null, (BValue)new BSeparator());
            Property[] a = menu.getDynamicPropertiesArray();
            for (int i = 0; i < a.length - 3; ++i) {
                if (!a[i].getType().is(BActionMenuItem.TYPE)) continue;
                Property p = a[a.length - 3];
                Property p1 = a[a.length - 2];
                Property p2 = a[a.length - 1];
                System.arraycopy(a, i, a, i + 3, a.length - i - 3);
                a[i] = p;
                a[i + 1] = p1;
                a[i + 2] = p2;
                break;
            }
            menu.reorder(a);
        }
        return menu;
    }

    public static class ImportCommand
    extends Command {
        BLocalLonDevice dev;

        public ImportCommand(BWidget owner, BObject target) {
            super(owner, BLocalLonDevice.TYPE.getModule().getLexicon(), "dynamicDevice.importXml");
            this.dev = (BLocalLonDevice)target;
        }

        public CommandArtifact doInvoke() {
            BLocalImportXmlParameter arg = new BLocalImportXmlParameter();
            String title = this.dev.getLexicon().getText("dynamicDevice.importXml.title");
            try {
                arg = (BLocalImportXmlParameter)BWbFieldEditor.dialog((BWidget)this.getShell(), (String)title, (BObject)arg);
            }
            catch (Exception e) {
                return null;
            }
            if (arg == null) {
                return null;
            }
            this.dev.getComponentSpace().update((BComponent)this.dev, Integer.MAX_VALUE);
            try {
                this.dev.doImportXml(arg);
            }
            catch (UnresolvedException e) {
                this.dev.importXml(arg);
            }
            return null;
        }
    }

    public static class ExtractXifCommand
    extends Command {
        BLocalLonDevice dev;

        public ExtractXifCommand(BWidget owner, BObject target) {
            super(owner, BLocalLonDevice.TYPE.getModule().getLexicon(), "localDevice.extractXif");
            this.dev = (BLocalLonDevice)target;
        }

        public CommandArtifact doInvoke() {
            BLonXmlOptions opts = BLonXmlOptions.make();
            BLocalExtractXifParameter arg = new BLocalExtractXifParameter();
            arg.setFileName(opts.getLocalXif());
            String title = this.dev.getLexicon().getText("localDevice.extractXif.title");
            try {
                arg = (BLocalExtractXifParameter)BWbFieldEditor.dialog((BWidget)this.getShell(), (String)title, (BObject)arg);
            }
            catch (Exception e) {
                return null;
            }
            if (arg == null) {
                return null;
            }
            String xifName = arg.getFileName();
            opts.setLocalXif(xifName);
            opts.save();
            BString bstr = this.dev.extractXif(arg);
            this.saveToFile(arg, bstr.getString());
            return null;
        }

        private void saveToFile(BLocalExtractXifParameter p, String s) {
            try {
                String fname = p.getFileName();
                File dir = new File(Sys.getNiagaraUserHome(), "xif");
                if (!dir.exists() && !dir.mkdirs()) {
                    return;
                }
                File xifF = new File(dir, fname);
                PrintWriter out = new PrintWriter(new FileOutputStream(xifF));
                out.println(s);
                out.close();
            }
            catch (Throwable e) {
                System.out.println(e);
            }
        }
    }
}

