/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.point;

import com.tridium.driver.util.DrUtil;
import com.tridium.edgeIo.BEdgeIoDevice;
import com.tridium.edgeIo.BEdgeIoNetwork;
import com.tridium.edgeIo.enums.BEdgeIoTypeEnum;
import com.tridium.edgeIo.messages.EdgeIoMessage;
import com.tridium.edgeIo.messages.UpdateAnalog;
import com.tridium.edgeIo.messages.UpdateCount;
import com.tridium.edgeIo.messages.UpdateDigital;
import com.tridium.edgeIo.point.BEdgeIoPointDeviceExt;
import com.tridium.json.JSONObject;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="conversion", type="BProxyConversion", defaultValue="BDefaultProxyConversion.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"edgeIo:EdgeIoProxyConversionFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"driver:ProxyConversionEditor\"")}, override=true), @NiagaraProperty(name="pointLabel", type="String", defaultValue="U", flags=1), @NiagaraProperty(name="pointId", type="int", defaultValue="UNDEFINED_POINTID", flags=1, facets={@Facet(name="BFacets.RADIX", value="BInteger.make(16)")}), @NiagaraProperty(name="pointType", type="BEdgeIoTypeEnum", defaultValue="BEdgeIoTypeEnum.DEFAULT", flags=1), @NiagaraProperty(name="pointMode", type="BDynamicEnum", defaultValue="BDynamicEnum.DEFAULT")})
public class BEdgeIoProxyExt
extends BProxyExt {
    public static final int UNDEFINED_POINTID = -1;
    @Generated
    public static final Property conversion = BEdgeIoProxyExt.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"edgeIo:EdgeIoProxyConversionFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"driver:ProxyConversionEditor")));
    @Generated
    public static final Property pointLabel = BEdgeIoProxyExt.newProperty((int)1, (String)"U", null);
    @Generated
    public static final Property pointId = BEdgeIoProxyExt.newProperty((int)1, (int)-1, (BFacets)BFacets.make((String)"radix", (BIDataValue)BInteger.make((int)16)));
    @Generated
    public static final Property pointType = BEdgeIoProxyExt.newProperty((int)1, (BValue)BEdgeIoTypeEnum.DEFAULT, null);
    @Generated
    public static final Property pointMode = BEdgeIoProxyExt.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BEdgeIoProxyExt.class);
    boolean updateInitialized = false;
    public static Logger log = Logger.getLogger("edgeIoProxyExt");

    @Generated
    public String getPointLabel() {
        return this.getString(pointLabel);
    }

    @Generated
    public void setPointLabel(String v) {
        this.setString(pointLabel, v, null);
    }

    @Generated
    public int getPointId() {
        return this.getInt(pointId);
    }

    @Generated
    public void setPointId(int v) {
        this.setInt(pointId, v, null);
    }

    @Generated
    public BEdgeIoTypeEnum getPointType() {
        return (BEdgeIoTypeEnum)this.get(pointType);
    }

    @Generated
    public void setPointType(BEdgeIoTypeEnum v) {
        this.set(pointType, (BValue)v, null);
    }

    @Generated
    public BDynamicEnum getPointMode() {
        return (BDynamicEnum)this.get(pointMode);
    }

    @Generated
    public void setPointMode(BDynamicEnum v) {
        this.set(pointMode, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.isDefined()) {
            this.fault("pointId is not defined");
            return;
        }
        if (this.getEdgeIoDevice().getStatus().isFault()) {
            return;
        }
        this.setFaultCause("");
        this.initProxy();
        this.getEdgeIoDevice().registerPoint(this);
        if (Sys.atSteadyState()) {
            this.checkUpdates();
        }
    }

    public void atSteadyState() throws Exception {
        this.checkUpdates();
    }

    protected void initProxy() throws Exception {
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.getEdgeIoDevice().getStatus().isFault()) {
            return;
        }
        this.sendStop();
        this.getEdgeIoDevice().unregisterPoint(this);
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p == pointMode) {
            if (this.updateInitialized) {
                this.sendStop();
                this.sendInit();
            }
        } else if (p == status) {
            this.checkUpdates();
        }
    }

    private boolean isOkayToUpdate() {
        return !this.getStatus().isDisabled();
    }

    private void checkUpdates() {
        try {
            if (this.isOkayToUpdate()) {
                this.sendInit();
                this.write(null);
                this.updateInitialized = true;
            } else if (this.updateInitialized) {
                this.sendStop();
                this.updateInitialized = false;
            }
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
    }

    private void fault(String cause) {
        this.setFaultCause(cause);
        this.setStatus(BStatus.fault);
    }

    private void clearFault() {
        this.setFaultCause("");
        this.setStatus(BStatus.stale);
    }

    protected LinkCheck doCheckParentLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        if (this.getFallbackSlot() != null && targetSlot.equals((Object)this.getFallbackSlot())) {
            return LinkCheck.makeInvalid((String)"Can not link fallback on EdgeIo proxies");
        }
        if (this.getSetSlot() != null && targetSlot.equals((Object)this.getSetSlot())) {
            return LinkCheck.makeInvalid((String)"Can not link set on EdgeIo proxies");
        }
        return super.doCheckParentLink(source, sourceSlot, targetSlot, cx);
    }

    protected Slot getFallbackSlot() {
        return null;
    }

    protected Slot getSetSlot() {
        return null;
    }

    public final BEdgeIoNetwork getEdgeIoNetwork() {
        return (BEdgeIoNetwork)DrUtil.getParent((BComplex)this, (Type)BEdgeIoNetwork.TYPE);
    }

    public final BEdgeIoDevice getEdgeIoDevice() {
        return (BEdgeIoDevice)DrUtil.getParent((BComplex)this, (Type)BEdgeIoDevice.TYPE);
    }

    public void readSubscribed(Context cx) throws Exception {
    }

    public void readUnsubscribed(Context cx) throws Exception {
    }

    public boolean write(Context cx) throws Exception {
        return true;
    }

    public Type getDeviceExtType() {
        return BEdgeIoPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.isWriteable() ? BReadWriteMode.writeonly : BReadWriteMode.readonly;
    }

    public boolean isWriteable() {
        return this.getParentPoint().isWritablePoint();
    }

    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    public boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric && !this.isPulseInput();
    }

    public boolean isPulseInput() {
        return false;
    }

    public void receiveUpdate(EdgeIoMessage msg) {
    }

    protected void sendInit() {
    }

    protected void sendStop() {
    }

    public boolean isDefined() {
        return this.getPointId() > 0;
    }

    protected void writeDigital(boolean v) throws Exception {
        UpdateDigital update = new UpdateDigital(this.getPointId(), v);
        this.getEdgeIoNetwork().sendMessage(update);
    }

    protected void writeAnalog(float v) throws Exception {
        UpdateAnalog update = new UpdateAnalog(this.getPointId(), v);
        this.getEdgeIoNetwork().sendMessage(update);
    }

    protected void writeCount(long v) throws Exception {
        UpdateCount update = new UpdateCount(this.getPointId(), v);
        this.getEdgeIoNetwork().sendMessage(update);
    }

    protected boolean updateDefault(JSONObject jsonObj) {
        return false;
    }
}

