/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.point;

import com.tridium.edgeIo.enums.BEdgeIoModeEnum;
import com.tridium.edgeIo.messages.BEdgeIoMessageTypeEnum;
import com.tridium.edgeIo.messages.EdgeIoMessage;
import com.tridium.edgeIo.messages.InitAnalog;
import com.tridium.edgeIo.messages.PointMessage;
import com.tridium.edgeIo.messages.UpdateAnalog;
import com.tridium.edgeIo.point.BEdgeIoProxyExt;
import com.tridium.json.JSONObject;
import javax.baja.control.BNumericWritable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFloat;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BEdgeIoAnalogProxyExt
extends BEdgeIoProxyExt {
    @Generated
    public static final Type TYPE = Sys.loadType(BEdgeIoAnalogProxyExt.class);
    boolean overValueDetected = false;
    private static final float OFF_NORMAL = 10.5f;
    private static final float RETURN_TO_NORMAL = 10.4f;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void sendInit() {
        int mode = BEdgeIoModeEnum.make(this.getPointMode().getTag()).getOrdinal();
        InitAnalog init = new InitAnalog(this.getPointId(), mode);
        this.getEdgeIoNetwork().sendMessage(init);
    }

    @Override
    protected void sendStop() {
        PointMessage stop = new PointMessage(BEdgeIoMessageTypeEnum.stopAnalog, this.getPointId());
        this.getEdgeIoNetwork().sendMessage(stop);
    }

    @Override
    public boolean write(Context cx) throws Exception {
        if (!this.isWriteable() || !this.getEnabled()) {
            return false;
        }
        BStatusValue sv = this.getWriteValue();
        this.writeAnalog((float)this.getValue((BStatusNumeric)sv));
        this.writeOk(sv);
        return true;
    }

    @Override
    public void receiveUpdate(EdgeIoMessage msg) {
        float wv;
        if (!(msg instanceof UpdateAnalog)) {
            log.severe("The Message received is not UpdateAnalog message");
            return;
        }
        UpdateAnalog update = (UpdateAnalog)msg;
        BStatusNumeric sval = (BStatusNumeric)this.getReadValue();
        sval.setValue((double)update.value);
        this.readOk((BStatusValue)sval);
        if (this.isWriteable() && this.getWriteValue().getStatus().isValid() && !BFloat.equals((float)update.value, (float)(wv = (float)this.getValue((BStatusNumeric)this.getWriteValue())))) {
            log.info("Reported value " + update.value + " did not match written value " + wv + ". Rewrite value ");
            try {
                this.writeAnalog(wv);
            }
            catch (Exception e) {
                log.severe("catch exception " + e.getMessage());
            }
        }
        if (!this.getPointMode().getTag().equals(BEdgeIoModeEnum.voltageInput.getTag())) {
            return;
        }
        if (update.value >= 10.5f) {
            if (!this.overValueDetected && !this.getStatus().isFault()) {
                this.setFaultCause(this.getLexicon().getText("inputOutOfRange"));
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.overValueDetected = true;
            }
        } else if (this.overValueDetected && update.value < 10.4f) {
            this.setFaultCause("");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            this.overValueDetected = false;
        }
    }

    @Override
    protected boolean updateDefault(JSONObject jsonObj) {
        double currDef;
        double defVal = this.getValue(((BNumericWritable)this.getParent()).getFallback());
        if (defVal == (currDef = jsonObj.getDouble("DefaultValue"))) {
            return false;
        }
        jsonObj.put("DefaultValue", defVal);
        return true;
    }

    @Override
    protected Slot getFallbackSlot() {
        return BNumericWritable.fallback;
    }

    @Override
    protected Slot getSetSlot() {
        return BNumericWritable.set;
    }

    protected double getValue(BStatusNumeric sn) {
        return sn.getStatus().isNull() ? 0.0 : sn.getValue();
    }
}

