/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.tcpip.dhcpd;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetDhcpdMessage;
import com.tridium.platform.daemon.message.GetFileMessage;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdServerType;
import com.tridium.platform.tcpip.dhcpd.DhcpdLeaseSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUnsupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class DhcpdUtil {
    private static final Logger LOG = Logger.getLogger("plat.dhcpd");
    public static final String DHCPD_SLOT_NAME = "dhcpdAdapterSettings";
    private static final String LOOPBACK = "lo";
    private static final String COMMENT = "#";
    private static final String SEMICOLON = ";";
    private static final String COLON = ":";
    private static final String QUOTE = "\"";
    private static final String COMMA = ",";
    private static final String EQUALS = "=";
    private static final String ZERO = "0";
    private static final String NEWLINE = "\n";
    private static final String OPEN_BRACE = "{";
    private static final String CLOSE_BRACE = "}";
    private static final String SPACE = " ";
    private static final String INDENT = "  ";
    private static final char SECONDS = 's';
    private static final char MINUTES = 'm';
    private static final char HOURS = 'h';
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int SECONDS_IN_HOUR = 3600;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String DOT = ".";
    private static final String DESCRIPTION = "# Niagara DHCP Server Configuration File";
    private static final String MODIFY_WARNING = "# Use the DHCP Server editor under the respective Ethernet Adapter to modify this file";
    private static final String CREATED = "# Created: ";
    private static final String DEFAULT_LEASE_TIME_VALUE_HOURS = "6";
    private static final String MAX_LEASE_TIME_VALUE_HOURS = "12";
    private static final String DEFAULT_LEASE_TIME_VALUE_SECONDS = "21600";
    private static final String MAX_LEASE_TIME_VALUE_SECONDS = "43200";
    private static final String DEFAULT_SUBNET_MASK = "255.255.255.0";
    private static final String DEFAULT_SUBNET = "192.168.111.0";
    private static final String DEFAULT_CLIENT_START_IP = "192.168.111.15";
    public static final int MIN_CLIENTS = 1;
    public static final int MAX_CLIENTS = 240;
    public static final String TRIDIUM_LEGACY_WIFI_DHCPD_FILE_PATH = "/opt/niagara/platform/wifi/dhcpd_ti18xx.conf";
    public static final String TRIDIUM_LEGACY_WIFI_DHCPD_ADAPTER_SAP_OSNAME = "tiw_sap0";
    private static final String TRIDIUM_LEGACY_WIFI_DEFAULT_SUBNET_MASK = "255.255.255.0";
    private static final String TRIDIUM_LEGACY_WIFI_DEFAULT_SUBNET = "192.168.11.0";
    private static final String TRIDIUM_LEGACY_WIFI_DEFAULT_CLIENT_START_IP = "192.168.11.10";
    public static final int TRIDIUM_LEGACY_WIFI_MIN_DHCP_CLIENTS = 1;
    public static final int TRIDIUM_LEGACY_WIFI_MAX_DHCP_CLIENTS = 16;
    private static final String TRIDIUM_LEGACY_WIFI_MARKER = "WIFI";
    private static final String TRIDIUM_LEGACY_ADAPTER_DHCPD_OSNAME_PREFIX = "dm";
    private static final String TRIDIUM_LEGACY_ADAPTER_DHCPD_ID_PREFIX = "en";
    private static final String DHCPD_CONF_AUTHORITATIVE_COMMENT = "# DHCP server should send DHCPNAK messages to mis-configured clients";
    private static final String DHCPD_CONF_AUTHORITATIVE = "authoritative";
    private static final String DHCPD_CONF_DDNS_UPDATE_STYLE_COMMENT = "# DHCP server should not handle dynamic DNS change after start";
    private static final String DHCPD_CONF_DDNS_UPDATE_STYLE = "ddns-update-style";
    private static final String DHCPD_CONF_NONE = "none";
    private static final String DHCPD_CONF_DEFAULT_LEASE_TIME = "default-lease-time";
    private static final String DHCPD_CONF_MAX_LEASE_TIME = "max-lease-time";
    private static final String DHCPD_CONF_SUBNET = "subnet";
    private static final String DHCPD_CONF_NETMASK = "netmask";
    private static final String DHCPD_CONF_RANGE = "range";
    private static final String DNSMASQ_CONF_AUTHORITATIVE_COMMENT = "# Device should be the only DHCP server on the network";
    private static final String DNSMASQ_CONF_AUTHORITATIVE = "dhcp-authoritative";
    private static final String DNSMASQ_CONF_PORT_COMMENT = "# Disable DNS";
    private static final String DNSMASQ_CONF_PORT = "port";
    private static final String DNSMASQ_CONF_NO_GATEWAY_COMMENT = "# Disable gateway";
    private static final String DNSMASQ_CONF_DHCP_OPTION = "dhcp-option";
    private static final String DNSMASQ_CONF_OPTION = "option";
    private static final String DNSMASQ_CONF_ROUTER = "router";
    private static final String DNSMASQ_CONF_DHCP_LEASE_MAX_COMMENT = "# Set the limit on DHCP leases";
    private static final String DNSMASQ_CONF_DHCP_LEASE_MAX = "dhcp-lease-max";
    private static final String DNSMASQ_CONF_EXCEPT_INTERFACE_COMMENT = "# Do not listen on loopback";
    private static final String DNSMASQ_CONF_EXCEPT_INTERFACE = "except-interface";
    private static final String DNSMASQ_CONF_INTERFACE = "interface";
    private static final String DNSMASQ_CONF_DHCP_RANGE = "dhcp-range";
    private static final String MARKER_SITE_LOCAL = "site-local-options";
    private static final String MARKER_SUBNET = "SUBNET";
    private static final String MARKER_WARN = "MARKER - DO NOT REMOVE THIS COMMENT";
    private static final String DHCPD_LEASES_LEASE = "lease";
    private static final String DHCPD_LEASES_HARDWARE_ETHERNET = "hardware ethernet";
    private static final String DHCPD_LEASES_STARTS = "starts";
    private static final String DHCPD_LEASES_ENDS = "ends";
    private static final String DHCPD_LEASES_CLTT = "cltt";
    private static final String DHCPD_LEASES_BINDING_STATE = "binding state";
    private static final String DHCPD_LEASES_BINDING_STATE_ACTIVE = "active";
    private static final String DHCPD_LEASES_BINDING_STATE_FREE = "free";
    private static final String DHCPD_LEASES_BINDING_STATE_ABANDONED = "abandoned";
    private static final String DHCPD_LEASES_HOSTID = "set hostid";
    private static final String DHCPD_LEASES_PLATFORM_PORT = "set platform-port";
    private static final String DHCPD_LEASES_PLATFORMS_PORT = "set platforms-port";
    private static final String DHCPD_LEASES_USE_PLATFORMS = "set usePlatforms";
    private static final String DHCPD_LEASES_FOX_PORT = "set fox-port";
    private static final String DHCPD_LEASES_FOXS_PORT = "set foxs-port";
    private static final String DHCPD_LEASES_USE_FOXS = "set useFoxs";
    private static final String DHCPD_LEASES_STATION_NAME = "set station-name";
    private static final String DHCPD_LEASES_FOXWSS_PORT = "set foxwss-port";
    private static final Pattern DNSMASQ_LEASES_LEASE_REGEX = Pattern.compile("^[0-9]+ .*$");

    private DhcpdUtil() {
    }

    public static void loadFromSession(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession daemonSession) throws Exception {
        Objects.requireNonNull(dhcpdHostSettings, "dhcpdHostSettings argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        if (!DhcpdUtil.supportsDhcpd(daemonSession)) {
            throw new UnsupportedOperationException("DHCP server is not supported on platform");
        }
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading DHCP server XML settings from daemon session...");
            start = Clock.ticks();
        }
        InputStream xmlStream = daemonSession.getInputStream(new GetDhcpdMessage());
        XElem servletElement = XParser.make((InputStream)xmlStream).parse();
        DhcpdUtil.dhcpdXmlToDhcpdHostSettings(dhcpdHostSettings, servletElement);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Load of DHCP server XML settings from daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    public static void loadFromSessionWiFi(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession daemonSession) throws Exception {
        InputStream dhcpdConfStream;
        BHostProperties hostProperties;
        Objects.requireNonNull(dhcpdHostSettings, "dhcpdHostSettings argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        if (!DhcpdUtil.supportsDhcpd(daemonSession)) {
            throw new UnsupportedOperationException("DHCP server is not supported on platform");
        }
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading Wi-Fi DHCP server XML settings from daemon session...");
            start = Clock.ticks();
        }
        boolean isTridiumQNX = !(hostProperties = daemonSession.getHostProperties()).getIsNpsdk() && hostProperties.getOsName().toLowerCase().contains("qnx");
        InputStream xmlStream = daemonSession.getInputStream(new GetDhcpdMessage());
        XElem servletElement = XParser.make((InputStream)xmlStream).parse();
        DhcpdUtil.dhcpdXmlToDhcpdHostSettings(dhcpdHostSettings, servletElement);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Load of Wi-Fi DHCP server XML settings from daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
        String dhcpdConfPath = dhcpdHostSettings.getDhcpdConfPath();
        FilePath dhcpdConfFile = new FilePath(dhcpdConfPath);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Retrieving Wi-Fi " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " configuration file at '" + dhcpdConfFile + "'");
            start = Clock.ticks();
        }
        if ((dhcpdConfStream = daemonSession.getInputStream(new GetFileMessage(dhcpdConfFile, daemonSession.getFileSpace()))) != null) {
            DhcpdUtil.stringToDhcpdSettings(dhcpdHostSettings, dhcpdConfStream, isTridiumQNX);
        } else if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Null InputStream occurred while reading Wi-Fi " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " configuration file, use default values on save");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Load of Wi-Fi " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " configuration file from daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    public static void dhcpdXmlToDhcpdHostSettings(BDhcpdHostSettings dhcpdHostSettings, XElem dhcpdElem) {
        Property[] props;
        XElem[] adapterElems;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Using dhcpd servlet XML:");
            dhcpdElem.dump();
        }
        String dhcpdProvider = dhcpdElem.get("provider", "dhcpd");
        dhcpdHostSettings.setDhcpdServerType(BDhcpdServerType.make(dhcpdProvider));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Host uses DHCP server provider '" + dhcpdProvider + "'");
        }
        String dhcpdConfLocation = dhcpdElem.get("conf_file_path");
        dhcpdHostSettings.setDhcpdConfPath(dhcpdConfLocation);
        String leaseFilePath = dhcpdElem.get("lease_file_path");
        dhcpdHostSettings.setDhcpdLeasePath(leaseFilePath);
        String adaptersListPath = dhcpdElem.get("adapters_list_file_path");
        dhcpdHostSettings.setDhcpdAdaptersListPath(adaptersListPath);
        XElem adaptersElem = dhcpdElem.elem("adapters");
        if (adaptersElem == null) {
            dhcpdHostSettings.getDhcpdSubnets().removeAll();
            return;
        }
        HashSet<String> keyNames = new HashSet<String>();
        for (XElem adapterElem : adapterElems = adaptersElem.elems("adapter")) {
            String adapterOsName = adapterElem.get("name");
            String adapterId = adapterElem.get("id");
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Loading DHCP server XML adapter settings for adapter '" + adapterOsName + "'");
            }
            String propName = SlotPath.escape((String)adapterId);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Adapter uses slot name '" + propName + "'");
            }
            keyNames.add(propName);
            BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(propName);
            if (dhcpdAdapterSettings == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Adapter '" + propName + "' not found in settings, creating new slot");
                }
                dhcpdAdapterSettings = new BDhcpdAdapterSettings();
                dhcpdHostSettings.getDhcpdSubnets().add(propName, (BValue)dhcpdAdapterSettings, 3);
            }
            dhcpdAdapterSettings.setAdapterId(adapterId);
            dhcpdAdapterSettings.setAdapterOsName(adapterOsName);
            dhcpdAdapterSettings.setIsReadOnly(false);
            dhcpdAdapterSettings.setIsDhcpdIpv4Supported(adapterElem.getb("supported", false));
            dhcpdAdapterSettings.setIsDhcpdIpv4Enabled(adapterElem.getb("enabled", false));
            DhcpdUtil.fillUpSubnetWithDefaults(dhcpdAdapterSettings);
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.finest("Load DHCP server XML settings for adapter '" + adapterOsName + "' complete");
        }
        for (Property eachProp : props = dhcpdHostSettings.getDhcpdSubnets().getPropertiesArray()) {
            if (keyNames.contains(eachProp.getName())) continue;
            dhcpdHostSettings.getDhcpdSubnets().remove(eachProp.getName());
        }
    }

    public static void loadDhcpdConfFile(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession daemonSession) throws Exception {
        InputStream dhcpdConfStream;
        BHostProperties hostProperties;
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " configuration file from daemon session...");
            start = Clock.ticks();
        }
        boolean isTridiumQNX = !(hostProperties = daemonSession.getHostProperties()).getIsNpsdk() && hostProperties.getOsName().toLowerCase().contains("qnx");
        String dhcpdConfPath = dhcpdHostSettings.getDhcpdConfPath();
        FilePath dhcpdConfFile = new FilePath(dhcpdConfPath);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Retrieving " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " configuration file at '" + dhcpdConfFile + "'");
        }
        if ((dhcpdConfStream = daemonSession.getInputStream(new GetFileMessage(dhcpdConfFile, daemonSession.getFileSpace()))) != null) {
            DhcpdUtil.stringToDhcpdSettings(dhcpdHostSettings, dhcpdConfStream, isTridiumQNX);
        } else if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Null InputStream occurred while reading " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " configuration file, use default values on save");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Load of " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " configuration file from daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    public static void saveToSession(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession daemonSession) throws Exception {
        if (daemonSession == null) {
            return;
        }
        if (dhcpdHostSettings == null) {
            return;
        }
        if (!DhcpdUtil.supportsDhcpd(daemonSession)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Remote session '" + daemonSession.getHost() + "' does not support the dhcpd servlet, skipping save");
            }
            return;
        }
        InputStream xmlStream = daemonSession.getInputStream(new GetDhcpdMessage());
        XElem servletElement = XParser.make((InputStream)xmlStream).parse();
        String dhcpdProvider = servletElement.get("provider", "dhcpd");
        if (!dhcpdHostSettings.getDhcpdServerType().equals((Object)BDhcpdServerType.make(dhcpdProvider))) {
            throw new DhcpdUnsupportedException("Remote session DHCP server type '" + dhcpdProvider + "' does not support assigned DHCP server type '" + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + "'");
        }
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Saving " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " settings to daemon session...");
            start = Clock.ticks();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Saving as DHCP server provider '" + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + "'");
        }
        FileTransferMessage fileTransferMessage = new FileTransferMessage(daemonSession.getFileSpace());
        String configurationFileAsString = DhcpdUtil.dhcpdSettingsToString(dhcpdHostSettings, daemonSession);
        FilePath targetFilePath = new FilePath(dhcpdHostSettings.getDhcpdConfPath());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Saving " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " configuration file to path '" + targetFilePath + "'");
        }
        fileTransferMessage.addElement(new ByteArrayFileTransferElement(targetFilePath, configurationFileAsString.getBytes(), daemonSession.getFileSpace()));
        String adapterListAsString = DhcpdUtil.dhcpdSettingsToStringAdaptersList(dhcpdHostSettings);
        targetFilePath = new FilePath(dhcpdHostSettings.getDhcpdAdaptersListPath());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Saving " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " adapters enabled file to path '" + targetFilePath + "'");
        }
        fileTransferMessage.addElement(new ByteArrayFileTransferElement(targetFilePath, adapterListAsString.getBytes(), daemonSession.getFileSpace()));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Starting file transfer for host...");
        }
        DaemonFileUtil.transfer(daemonSession, fileTransferMessage, null);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("File transfer for host complete");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Save of " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " settings to daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    public static void saveToSessionNoTransfer(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession daemonSession, FileTransferMessage fileTransferMessage) throws Exception {
        String configurationFileAsString = DhcpdUtil.dhcpdSettingsToString(dhcpdHostSettings, daemonSession);
        FilePath targetFilePath = new FilePath(dhcpdHostSettings.getDhcpdConfPath());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Saving " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " configuration file (No Transfer) to path '" + targetFilePath + "'");
        }
        fileTransferMessage.addElement(new ByteArrayFileTransferElement(targetFilePath, configurationFileAsString.getBytes(), daemonSession.getFileSpace()));
        String adapterListAsString = DhcpdUtil.dhcpdSettingsToStringAdaptersList(dhcpdHostSettings);
        targetFilePath = new FilePath(dhcpdHostSettings.getDhcpdAdaptersListPath());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Saving " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " adapters enabled file (No Transfer) to path '" + targetFilePath + "'");
        }
        fileTransferMessage.addElement(new ByteArrayFileTransferElement(targetFilePath, adapterListAsString.getBytes(), daemonSession.getFileSpace()));
    }

    public static boolean supportsDhcpd(BDaemonSession daemonSession) {
        return daemonSession.getHostProperties().supportsServlet("dhcpd");
    }

    public static void setReadOnly(BDhcpdHostSettings dhcpdHostSettings, boolean isReadOnly) {
        SlotCursor c = dhcpdHostSettings.getDhcpdSubnets().loadSlots().getProperties();
        while (c.next()) {
            BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)c.get();
            dhcpdAdapterSettings.setIsReadOnly(isReadOnly);
        }
    }

    public static String dhcpdSettingsToString(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession daemonSession) throws Exception {
        String dhcpdConfPath;
        FilePath optionsFile;
        InputStream optionsStream;
        StringBuilder dhcpdContents = new StringBuilder();
        DhcpdUtil.dhcpdSettingsToStringPreamble(dhcpdContents);
        DhcpdUtil.dhcpdSettingsToStringGlobalOptions(dhcpdHostSettings, dhcpdContents);
        BHostProperties hostProperties = daemonSession.getHostProperties();
        boolean isTridiumQNX = !hostProperties.getIsNpsdk() && hostProperties.getOsName().toLowerCase().contains("qnx");
        DhcpdUtil.dhcpdSettingsToStringSubnetHelper(dhcpdHostSettings, dhcpdContents, isTridiumQNX);
        if (dhcpdHostSettings.getDhcpdServerType() == BDhcpdServerType.dhcpd && (optionsStream = daemonSession.getInputStream(new GetFileMessage(optionsFile = new FilePath(dhcpdConfPath = dhcpdHostSettings.getDhcpdConfPath()), daemonSession.getFileSpace()))) != null) {
            DhcpdUtil.dhcpdSettingsToStringAppendSiteOptions(dhcpdContents, optionsStream);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("dhcpdSettingsToString created " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " configuration string:\n" + dhcpdContents);
        }
        return dhcpdContents.toString();
    }

    private static void dhcpdSettingsToStringPreamble(StringBuilder dhcpdContents) {
        dhcpdContents.append(DESCRIPTION).append(NEWLINE);
        dhcpdContents.append(MODIFY_WARNING).append(NEWLINE);
        dhcpdContents.append(CREATED).append(BAbsTime.now()).append(NEWLINE);
        dhcpdContents.append(NEWLINE);
    }

    private static void dhcpdSettingsToStringGlobalOptions(BDhcpdHostSettings dhcpdHostSettings, StringBuilder dhcpdContents) {
        if (dhcpdHostSettings.getDhcpdServerType() == BDhcpdServerType.dhcpd) {
            dhcpdContents.append(DHCPD_CONF_AUTHORITATIVE_COMMENT).append(NEWLINE);
            dhcpdContents.append(DHCPD_CONF_AUTHORITATIVE).append(SEMICOLON).append(NEWLINE);
            dhcpdContents.append(NEWLINE);
            dhcpdContents.append(DHCPD_CONF_DDNS_UPDATE_STYLE_COMMENT).append(NEWLINE);
            dhcpdContents.append(DHCPD_CONF_DDNS_UPDATE_STYLE).append(SPACE).append(DHCPD_CONF_NONE).append(SEMICOLON).append(NEWLINE);
            dhcpdContents.append(NEWLINE);
            dhcpdContents.append(DHCPD_CONF_DEFAULT_LEASE_TIME).append(SPACE).append(DEFAULT_LEASE_TIME_VALUE_SECONDS).append(SEMICOLON).append(NEWLINE);
            dhcpdContents.append(DHCPD_CONF_MAX_LEASE_TIME).append(SPACE).append(MAX_LEASE_TIME_VALUE_SECONDS).append(SEMICOLON).append(NEWLINE);
            dhcpdContents.append(NEWLINE);
        } else if (dhcpdHostSettings.getDhcpdServerType() == BDhcpdServerType.dnsmasq) {
            dhcpdContents.append(DNSMASQ_CONF_AUTHORITATIVE_COMMENT).append(NEWLINE);
            dhcpdContents.append(DNSMASQ_CONF_AUTHORITATIVE).append(NEWLINE);
            dhcpdContents.append(NEWLINE);
            dhcpdContents.append(DNSMASQ_CONF_PORT_COMMENT).append(NEWLINE);
            dhcpdContents.append(DNSMASQ_CONF_PORT).append(EQUALS).append(ZERO).append(NEWLINE);
            dhcpdContents.append(NEWLINE);
            dhcpdContents.append(DNSMASQ_CONF_NO_GATEWAY_COMMENT).append(NEWLINE);
            dhcpdContents.append(DNSMASQ_CONF_DHCP_OPTION).append(EQUALS).append(DNSMASQ_CONF_OPTION).append(COLON).append(DNSMASQ_CONF_ROUTER).append(NEWLINE);
            dhcpdContents.append(NEWLINE);
            dhcpdContents.append(DNSMASQ_CONF_DHCP_LEASE_MAX_COMMENT).append(NEWLINE);
            int leasesRequiredByRanges = 0;
            SlotCursor c = dhcpdHostSettings.getDhcpdSubnets().loadSlots().getProperties();
            while (c.next()) {
                BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)c.get();
                leasesRequiredByRanges += dhcpdAdapterSettings.getRange();
            }
            dhcpdContents.append(DNSMASQ_CONF_DHCP_LEASE_MAX).append(EQUALS).append(Math.max(240, leasesRequiredByRanges)).append(NEWLINE);
            dhcpdContents.append(NEWLINE);
            dhcpdContents.append(DNSMASQ_CONF_EXCEPT_INTERFACE_COMMENT).append(NEWLINE);
            dhcpdContents.append(DNSMASQ_CONF_EXCEPT_INTERFACE).append(EQUALS).append(LOOPBACK).append(NEWLINE);
            dhcpdContents.append(NEWLINE);
        } else {
            throw new IllegalArgumentException("Unknown DHCP server type " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + ", cannot generate global options");
        }
    }

    private static void dhcpdSettingsToStringSubnetHelper(BDhcpdHostSettings dhcpdHostSettings, StringBuilder dhcpdContents, boolean isTridiumQnx) {
        SlotCursor c = dhcpdHostSettings.getDhcpdSubnets().loadSlots().getProperties();
        while (c.next()) {
            BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)c.get();
            String markerName = DhcpdUtil.adapterOsNameToMarkerName(dhcpdAdapterSettings.getAdapterOsName(), isTridiumQnx);
            dhcpdContents.append(COMMENT).append(markerName).append(SPACE).append(MARKER_SUBNET).append(SPACE).append(MARKER_WARN).append(NEWLINE);
            DhcpdUtil.dhcpdSettingsToStringSubnet(dhcpdContents, dhcpdHostSettings.getDhcpdServerType(), dhcpdAdapterSettings);
        }
    }

    private static void dhcpdSettingsToStringSubnet(StringBuilder dhcpdContents, BDhcpdServerType dhcpdServerType, BDhcpdAdapterSettings dhcpdAdapterSettings) {
        String startClientAddress = dhcpdAdapterSettings.getStartClientAddress();
        String endClientAddress = DhcpdUtil.getEndIpAddress(startClientAddress, dhcpdAdapterSettings.getRange());
        if (dhcpdServerType == BDhcpdServerType.dhcpd) {
            dhcpdContents.append(DHCPD_CONF_SUBNET).append(SPACE).append(dhcpdAdapterSettings.getSubnet()).append(SPACE).append(DHCPD_CONF_NETMASK).append(SPACE).append(dhcpdAdapterSettings.getSubnetMask()).append(SPACE).append(OPEN_BRACE).append(NEWLINE);
            dhcpdContents.append(INDENT).append(DHCPD_CONF_DEFAULT_LEASE_TIME).append(SPACE).append(dhcpdAdapterSettings.getDefaultLeaseTime().getSeconds()).append(SEMICOLON).append(NEWLINE);
            dhcpdContents.append(INDENT).append(DHCPD_CONF_MAX_LEASE_TIME).append(SPACE).append(dhcpdAdapterSettings.getMaxLeaseTime().getSeconds()).append(SEMICOLON).append(NEWLINE);
            dhcpdContents.append(INDENT).append(DHCPD_CONF_RANGE).append(SPACE).append(startClientAddress).append(SPACE).append(endClientAddress).append(SEMICOLON).append(NEWLINE);
            dhcpdContents.append(CLOSE_BRACE).append(NEWLINE);
            dhcpdContents.append(NEWLINE);
        } else if (dhcpdServerType == BDhcpdServerType.dnsmasq) {
            dhcpdContents.append(DNSMASQ_CONF_DHCP_RANGE).append(EQUALS).append(dhcpdAdapterSettings.getAdapterOsName()).append(COMMA).append(startClientAddress).append(COMMA).append(endClientAddress).append(COMMA).append(dhcpdAdapterSettings.getSubnetMask()).append(COMMA).append(dhcpdAdapterSettings.getDefaultLeaseTime().getSeconds()).append('s').append(NEWLINE);
            dhcpdContents.append(NEWLINE);
        } else {
            throw new IllegalArgumentException("Unknown DHCP server type " + (Object)((Object)dhcpdServerType) + ", cannot generate subnet");
        }
    }

    private static void dhcpdSettingsToStringAppendSiteOptions(StringBuilder dhcpdContents, InputStream in) {
        dhcpdContents.append(NEWLINE);
        try {
            String[] dhcpdLines = FileUtil.readLines((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
            boolean appendLines = false;
            for (String currentLine : dhcpdLines) {
                if (currentLine.startsWith("#site-local-options")) {
                    appendLines = true;
                    dhcpdContents.append(COMMENT).append(MARKER_SITE_LOCAL).append(SPACE).append(MARKER_WARN).append(NEWLINE);
                    continue;
                }
                if (!appendLines) continue;
                dhcpdContents.append(currentLine).append(NEWLINE);
            }
        }
        catch (IOException ioException) {
            LOG.log(Level.WARNING, "Exception occurred while appending DHCP site-options settings to file", ioException);
        }
    }

    private static String dhcpdSettingsToStringAdaptersList(BDhcpdHostSettings dhcpdHostSettings) {
        StringBuilder adapterList = new StringBuilder();
        SlotCursor c = dhcpdHostSettings.getDhcpdSubnets().loadSlots().getProperties();
        while (c.next()) {
            BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)c.get();
            if (!dhcpdAdapterSettings.getIsDhcpdIpv4Enabled()) continue;
            if (adapterList.length() > 0) {
                adapterList.append(COMMA);
            }
            adapterList.append(dhcpdAdapterSettings.getAdapterOsName());
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("dhcpdSettingsToStringAdaptersList created adapter list '" + adapterList + "'");
        }
        return adapterList.toString();
    }

    public static void stringToDhcpdSettings(BDhcpdHostSettings dhcpdHostSettings, InputStream in, boolean isTridiumQNX) throws Exception {
        BDhcpdServerType dhcpdServerType;
        String dhcpdLinesAsString = FileUtil.readString((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        String[] dhcpdLines = TextUtil.split((String)dhcpdLinesAsString, (char)'\n');
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("stringToDhcpdSettings creating " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " settings from string:\n" + dhcpdLinesAsString);
        }
        if ((dhcpdServerType = dhcpdHostSettings.getDhcpdServerType()) == BDhcpdServerType.dhcpd) {
            String previousLine = null;
            for (int currentLineNumber = 0; currentLineNumber < dhcpdLines.length; ++currentLineNumber) {
                String currentLine = dhcpdLines[currentLineNumber].trim();
                if (currentLine.startsWith(DHCPD_CONF_SUBNET) && currentLine.endsWith(OPEN_BRACE)) {
                    if (previousLine == null) {
                        throw new NullPointerException("Failed to parse dhcpd subnet block, expected MARKER on previous line");
                    }
                    String[] words = previousLine.split(SPACE);
                    String markerName = words[0].substring(1);
                    String adapterOsName = DhcpdUtil.markerNameToAdapterOsName(markerName, isTridiumQNX);
                    String adapterId = DhcpdUtil.adapterOsNameToAdapterId(adapterOsName, isTridiumQNX);
                    BDhcpdAdapterSettings dhcpdAdapterSettings = DhcpdUtil.getDhcpdAdapterSettingsForAdapterId(dhcpdHostSettings, adapterId);
                    currentLineNumber = DhcpdUtil.stringToDhcpdSettingsDhcpdSubnet(dhcpdAdapterSettings, dhcpdLines, currentLine, currentLineNumber);
                }
                previousLine = currentLine;
            }
        } else if (dhcpdServerType == BDhcpdServerType.dnsmasq) {
            String previousLine = null;
            for (int currentLineNumber = 0; currentLineNumber < dhcpdLines.length; ++currentLineNumber) {
                String currentLine = dhcpdLines[currentLineNumber].trim();
                if (currentLine.startsWith("interface=") || currentLine.startsWith("dhcp-range=")) {
                    if (previousLine == null) {
                        throw new NullPointerException("Failed to parse dnsmasq subnet block, expected MARKER on previous line");
                    }
                    String[] words = previousLine.split(SPACE);
                    String markerName = words[0].substring(1);
                    String adapterOsName = DhcpdUtil.markerNameToAdapterOsName(markerName, isTridiumQNX);
                    String adapterId = DhcpdUtil.adapterOsNameToAdapterId(adapterOsName, isTridiumQNX);
                    if (currentLine.startsWith("interface=")) {
                        if (currentLineNumber == dhcpdLines.length - 1) {
                            LOG.warning("Error occurred parsing DHCP server configuration data from adapter: " + adapterId + ", subnet block not properly terminated");
                            break;
                        }
                        currentLine = dhcpdLines[++currentLineNumber].trim();
                    }
                    BDhcpdAdapterSettings dhcpdAdapterSettings = DhcpdUtil.getDhcpdAdapterSettingsForAdapterId(dhcpdHostSettings, adapterId);
                    currentLineNumber = DhcpdUtil.stringToDhcpdSettingsDnsmasqSubnet(dhcpdAdapterSettings, dhcpdLines, currentLine, currentLineNumber);
                }
                previousLine = currentLine;
            }
        } else {
            throw new IllegalArgumentException("Unknown DHCP server type " + (Object)((Object)dhcpdServerType) + ", cannot parse settings from string");
        }
    }

    public static int stringToDhcpdSettingsDhcpdSubnet(BDhcpdAdapterSettings dhcpdAdapterSettings, String[] dhcpdLines, String currentLine, int currentLineNumber) {
        if (dhcpdAdapterSettings == null || dhcpdLines == null || currentLine == null || currentLineNumber < 0 || currentLineNumber >= dhcpdLines.length) {
            return currentLineNumber;
        }
        boolean errorOccurred = false;
        String[] subnetWords = currentLine.split(SPACE);
        dhcpdAdapterSettings.setSubnet(subnetWords[1]);
        dhcpdAdapterSettings.setSubnetMask(subnetWords[3]);
        currentLine = dhcpdLines[currentLineNumber].trim();
        while (!currentLine.startsWith(CLOSE_BRACE)) {
            block12: {
                try {
                    String intStr;
                    if (currentLine.startsWith(DHCPD_CONF_DEFAULT_LEASE_TIME) && currentLine.endsWith(SEMICOLON)) {
                        String defaultLeaseLine = currentLine.substring(0, currentLine.indexOf(SEMICOLON));
                        intStr = defaultLeaseLine.split(SPACE)[1];
                        dhcpdAdapterSettings.setDefaultLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(intStr)));
                    } else if (currentLine.startsWith(DHCPD_CONF_MAX_LEASE_TIME) && currentLine.endsWith(SEMICOLON)) {
                        String maxLeaseLine = currentLine.substring(0, currentLine.indexOf(SEMICOLON));
                        intStr = maxLeaseLine.split(SPACE)[1];
                        dhcpdAdapterSettings.setMaxLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(intStr)));
                    } else if (currentLine.startsWith(DHCPD_CONF_RANGE) && currentLine.endsWith(SEMICOLON)) {
                        String rangeLine = currentLine.substring(0, currentLine.indexOf(SEMICOLON));
                        String[] rangeWords = rangeLine.split(SPACE);
                        String startClientAddress = rangeWords[1];
                        String endClientAddress = rangeWords[2];
                        if (IPAddressUtil.isIpv4Address((String)startClientAddress) && IPAddressUtil.isIpv4Address((String)endClientAddress)) {
                            dhcpdAdapterSettings.setStartClientAddress(startClientAddress);
                            int range = DhcpdUtil.getIpRange(startClientAddress, endClientAddress);
                            dhcpdAdapterSettings.setRange(range);
                        }
                    }
                }
                catch (Exception exception) {
                    errorOccurred = true;
                    if (!LOG.isLoggable(Level.FINE)) break block12;
                    LOG.log(Level.FINE, "Exception occurred parsing DHCP server configuration data at line '" + currentLine + "'", exception);
                }
            }
            if (errorOccurred) {
                errorOccurred = false;
                LOG.warning("Error occurred parsing DHCP server configuration data from adapter: " + dhcpdAdapterSettings.getAdapterId() + " at line: " + currentLineNumber + ": " + currentLine);
            }
            if (currentLineNumber == dhcpdLines.length - 1) {
                LOG.warning("Error occurred parsing DHCP server configuration data from adapter: " + dhcpdAdapterSettings.getAdapterId() + ", subnet block not properly terminated");
                break;
            }
            currentLine = dhcpdLines[++currentLineNumber].trim();
        }
        return currentLineNumber;
    }

    public static int stringToDhcpdSettingsDnsmasqSubnet(BDhcpdAdapterSettings dhcpdAdapterSettings, String[] dnsmasqLines, String currentLine, int currentLineNumber) {
        boolean errorOccurred;
        block9: {
            if (dhcpdAdapterSettings == null || dnsmasqLines == null || currentLine == null || currentLineNumber < 0 || currentLineNumber >= dnsmasqLines.length) {
                return currentLineNumber;
            }
            errorOccurred = false;
            try {
                String[] dhcpRangeWords = currentLine.split(COMMA);
                String startClientAddress = dhcpRangeWords[1];
                String endClientAddress = dhcpRangeWords[2];
                dhcpdAdapterSettings.setStartClientAddress(startClientAddress);
                int range = DhcpdUtil.getIpRange(startClientAddress, endClientAddress);
                dhcpdAdapterSettings.setRange(range);
                String subnetMask = dhcpRangeWords[3];
                dhcpdAdapterSettings.setSubnetMask(subnetMask);
                dhcpdAdapterSettings.setSubnet(IPAddressUtil.getIPv4NetworkPrefix((String)startClientAddress, (String)subnetMask));
                String defaultLeaseString = dhcpRangeWords[4];
                int defaultLeaseTimeValue = Integer.parseInt(defaultLeaseString.substring(0, defaultLeaseString.length() - 1));
                char defaultLeaseTimeUnit = defaultLeaseString.charAt(defaultLeaseString.length() - 1);
                switch (defaultLeaseTimeUnit) {
                    case 'h': {
                        defaultLeaseTimeValue *= 3600;
                        break;
                    }
                    case 'm': {
                        defaultLeaseTimeValue *= 60;
                        break;
                    }
                    case 's': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized lease time format: " + defaultLeaseString);
                    }
                }
                dhcpdAdapterSettings.setDefaultLeaseTime(BRelTime.makeSeconds((int)defaultLeaseTimeValue));
                dhcpdAdapterSettings.setMaxLeaseTime(BRelTime.makeSeconds((int)defaultLeaseTimeValue));
            }
            catch (Exception exception) {
                errorOccurred = true;
                if (!LOG.isLoggable(Level.FINE)) break block9;
                LOG.log(Level.FINE, "Exception occurred parsing DHCP server configuration data at line '" + currentLine + "'", exception);
            }
        }
        if (errorOccurred) {
            LOG.warning("Error occurred parsing DHCP server configuration data from adapter: " + dhcpdAdapterSettings.getAdapterId() + " at line: " + currentLineNumber + ": " + currentLine);
        }
        return currentLineNumber;
    }

    public static int getIpRange(String startIpAddress, String endIpAddress) {
        if (!IPAddressUtil.isIpv4Address((String)startIpAddress)) {
            throw new IllegalArgumentException("Invalid start IP address " + startIpAddress);
        }
        byte[] startIpBytes = IPAddressUtil.numericStringToByteArray((String)startIpAddress);
        if (startIpBytes == null) {
            throw new IllegalArgumentException("Invalid start IP address " + startIpAddress);
        }
        if (!IPAddressUtil.isIpv4Address((String)endIpAddress)) {
            throw new IllegalArgumentException("Invalid end IP address " + endIpAddress);
        }
        byte[] endIpBytes = IPAddressUtil.numericStringToByteArray((String)endIpAddress);
        if (endIpBytes == null) {
            throw new IllegalArgumentException("Invalid end IP address " + endIpAddress);
        }
        int result = (startIpBytes[0] & 0xFF) << 24;
        result |= (startIpBytes[1] & 0xFF) << 16;
        result |= (startIpBytes[2] & 0xFF) << 8;
        long startIpAddressNumber = (long)(result |= startIpBytes[3] & 0xFF) & 0xFFFFFFFFL;
        result = (endIpBytes[0] & 0xFF) << 24;
        result |= (endIpBytes[1] & 0xFF) << 16;
        result |= (endIpBytes[2] & 0xFF) << 8;
        long endIpAddressNumber = (long)(result |= endIpBytes[3] & 0xFF) & 0xFFFFFFFFL;
        if (startIpAddressNumber > endIpAddressNumber) {
            throw new IllegalArgumentException("Start IP address " + startIpAddress + " > end IP address " + endIpAddress);
        }
        long range = endIpAddressNumber - startIpAddressNumber + 1L;
        if (range > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Range between start address " + startIpAddress + " and end address " + endIpAddress + " too large");
        }
        return (int)range;
    }

    public static String getEndIpAddress(String startIpAddress, int range) {
        if (!IPAddressUtil.isIpv4Address((String)startIpAddress)) {
            throw new IllegalArgumentException("Invalid start IP address " + startIpAddress);
        }
        byte[] startIpBytes = IPAddressUtil.numericStringToByteArray((String)startIpAddress);
        if (startIpBytes == null) {
            throw new IllegalArgumentException("Invalid start IP address " + startIpAddress);
        }
        if (range < 1) {
            throw new IllegalArgumentException("Invalid range " + range);
        }
        int result = (startIpBytes[0] & 0xFF) << 24;
        result |= (startIpBytes[1] & 0xFF) << 16;
        result |= (startIpBytes[2] & 0xFF) << 8;
        long startIpAddressNumber = (long)(result |= startIpBytes[3] & 0xFF) & 0xFFFFFFFFL;
        long endIpAddressNumber = startIpAddressNumber + (long)range - 1L;
        if (startIpAddressNumber > (endIpAddressNumber &= 0xFFFFFFFFL)) {
            throw new IllegalArgumentException("Incrementing address " + startIpAddress + " by range " + range + " results in address rollover");
        }
        StringBuilder endIpAddressNumberBuilder = new StringBuilder();
        endIpAddressNumberBuilder.insert(0, endIpAddressNumber & 0xFFL).insert(0, DOT);
        endIpAddressNumberBuilder.insert(0, endIpAddressNumber >> 8 & 0xFFL).insert(0, DOT);
        endIpAddressNumberBuilder.insert(0, endIpAddressNumber >> 16 & 0xFFL).insert(0, DOT);
        endIpAddressNumberBuilder.insert(0, endIpAddressNumber >> 24 & 0xFFL);
        return endIpAddressNumberBuilder.toString();
    }

    public static String getNextIpAddress(String startIpAddress) {
        return DhcpdUtil.getEndIpAddress(startIpAddress, 2);
    }

    public static int getUsableHosts(String subnetMask) {
        if (!IPAddressUtil.isIpv4SubnetMask((String)subnetMask)) {
            throw new IllegalArgumentException("Invalid subnet mask IP address " + subnetMask);
        }
        byte[] subnetMaskBytes = IPAddressUtil.numericStringToByteArray((String)subnetMask);
        int netmaskBits = (subnetMaskBytes[0] & 0xFF) << 24;
        netmaskBits |= (subnetMaskBytes[1] & 0xFF) << 16;
        netmaskBits |= (subnetMaskBytes[2] & 0xFF) << 8;
        return Math.max((int)Math.pow(2.0, Integer.numberOfTrailingZeros(netmaskBits |= subnetMaskBytes[3] & 0xFF)) - 2, 0);
    }

    private static void fillUpSubnetWithDefaults(BDhcpdAdapterSettings dhcpdAdapterSettings) {
        dhcpdAdapterSettings.setDefaultLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(DEFAULT_LEASE_TIME_VALUE_SECONDS)));
        dhcpdAdapterSettings.setMaxLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(MAX_LEASE_TIME_VALUE_SECONDS)));
        if (dhcpdAdapterSettings.getName().equals(TRIDIUM_LEGACY_WIFI_DHCPD_ADAPTER_SAP_OSNAME)) {
            dhcpdAdapterSettings.setSubnetMask("255.255.255.0");
            dhcpdAdapterSettings.setSubnet(TRIDIUM_LEGACY_WIFI_DEFAULT_SUBNET);
            dhcpdAdapterSettings.setStartClientAddress(TRIDIUM_LEGACY_WIFI_DEFAULT_CLIENT_START_IP);
            dhcpdAdapterSettings.setRange(16);
        } else {
            dhcpdAdapterSettings.setSubnetMask("255.255.255.0");
            dhcpdAdapterSettings.setSubnet(DEFAULT_SUBNET);
            dhcpdAdapterSettings.setStartClientAddress(DEFAULT_CLIENT_START_IP);
            dhcpdAdapterSettings.setRange(240);
        }
    }

    public static int fixDhcpdAdapterSettingsRange(int range, int minClients, int maxClients, String subnetMask) {
        int usableHosts;
        if (minClients < 1) {
            throw new IllegalArgumentException("Cannot fix DHCP adapter settings range, provided minClients < 1");
        }
        if (maxClients < 1) {
            throw new IllegalArgumentException("Cannot fix DHCP adapter settings range, provided maxClients < 1");
        }
        if (minClients > maxClients) {
            throw new IllegalArgumentException("Cannot fix DHCP adapter settings range, provided minClients > maxClients");
        }
        if (!IPAddressUtil.isIpv4SubnetMask((String)subnetMask)) {
            throw new IllegalArgumentException("Cannot fix DHCP adapter settings range, provided subnetMask invalid");
        }
        if (minClients < 1) {
            minClients = 1;
        }
        if (maxClients > 240) {
            maxClients = 240;
        }
        if (range < minClients) {
            range = minClients;
        }
        if (range > maxClients) {
            range = maxClients;
        }
        if ((usableHosts = Math.max(DhcpdUtil.getUsableHosts(subnetMask) - 1, 0)) < minClients) {
            throw new IllegalArgumentException("Cannot fix DHCP adapter settings range, provided usable hosts in subnetMask < minClients");
        }
        if (range > usableHosts) {
            range = usableHosts;
        }
        return range;
    }

    public static String fixDhcpdAdapterSettingsStartAddress(String ipAddress, String subnet, String subnetMask) {
        if (!IPAddressUtil.isIpv4Address((String)ipAddress)) {
            throw new IllegalArgumentException("Cannot fix DHCP adapter settings start address, provided ipAddress invalid");
        }
        if (!IPAddressUtil.isIpv4Address((String)subnet)) {
            throw new IllegalArgumentException("Cannot fix DHCP adapter settings start address, provided subnet invalid");
        }
        if (!IPAddressUtil.isIpv4SubnetMask((String)subnetMask)) {
            throw new IllegalArgumentException("Cannot fix DHCP adapter settings start address, provided subnetMask invalid");
        }
        byte[] ipAddressBytes = IPAddressUtil.numericStringToByteArray((String)ipAddress);
        if (ipAddressBytes == null) {
            throw new IllegalArgumentException("Invalid IP address " + ipAddress);
        }
        byte[] subnetBytes = IPAddressUtil.numericStringToByteArray((String)subnet);
        if (subnetBytes == null) {
            throw new IllegalArgumentException("Invalid network IP address " + subnet);
        }
        byte[] subnetMaskBytes = IPAddressUtil.numericStringToByteArray((String)subnetMask);
        if (subnetMaskBytes == null) {
            throw new IllegalArgumentException("Invalid subnet mask IP address " + subnetMask);
        }
        int usableHosts = Math.max(DhcpdUtil.getUsableHosts(subnetMask) - 1, 0);
        if (usableHosts == 0) {
            throw new IllegalArgumentException("Cannot fix DHCP adapter settings start address, provided usable hosts in subnetMask == 0");
        }
        byte[] firstUsableAddressBytes = IPAddressUtil.numericStringToByteArray((String)DhcpdUtil.getNextIpAddress(subnet));
        byte[] broadcastBytes = new byte[subnetBytes.length];
        for (int i = 0; i < subnetBytes.length; ++i) {
            broadcastBytes[i] = (byte)(subnetBytes[i] | ~subnetMaskBytes[i]);
        }
        byte[] adjustedStartBytes = new byte[ipAddressBytes.length];
        for (int i = 0; i < 4; ++i) {
            adjustedStartBytes[i] = (byte)(ipAddressBytes[i] & ~subnetMaskBytes[i] | subnetBytes[i]);
        }
        boolean isNetworkAddress = ByteArrayUtil.equals((byte[])adjustedStartBytes, (byte[])subnetBytes);
        boolean isFirstUsableAddress = ByteArrayUtil.equals((byte[])adjustedStartBytes, (byte[])firstUsableAddressBytes);
        boolean isBroadcastAddress = ByteArrayUtil.equals((byte[])adjustedStartBytes, (byte[])broadcastBytes);
        if (isNetworkAddress || isFirstUsableAddress || isBroadcastAddress) {
            int result = (adjustedStartBytes[0] & 0xFF) << 24;
            result |= (adjustedStartBytes[1] & 0xFF) << 16;
            result |= (adjustedStartBytes[2] & 0xFF) << 8;
            long resultIpAddress = (long)(result |= adjustedStartBytes[3] & 0xFF) & 0xFFFFFFFFL;
            resultIpAddress = isNetworkAddress ? (resultIpAddress += 2L) : (isFirstUsableAddress ? ++resultIpAddress : --resultIpAddress);
            adjustedStartBytes[0] = (byte)((resultIpAddress &= 0xFFFFFFFFL) >> 24);
            adjustedStartBytes[1] = (byte)(resultIpAddress >> 16);
            adjustedStartBytes[2] = (byte)(resultIpAddress >> 8);
            adjustedStartBytes[3] = (byte)resultIpAddress;
        }
        StringBuilder adjustedIpAddressBuilder = new StringBuilder();
        adjustedIpAddressBuilder.insert(0, adjustedStartBytes[3] & 0xFF).insert(0, DOT);
        adjustedIpAddressBuilder.insert(0, adjustedStartBytes[2] & 0xFF).insert(0, DOT);
        adjustedIpAddressBuilder.insert(0, adjustedStartBytes[1] & 0xFF).insert(0, DOT);
        adjustedIpAddressBuilder.insert(0, adjustedStartBytes[0] & 0xFF);
        return adjustedIpAddressBuilder.toString();
    }

    public static boolean fixDhcpdHostSettings(BDhcpdHostSettings dhcpdHostSettings, BTcpIpHostSettings tcpIpHostSettings) {
        boolean adjustmentOccurred = false;
        SlotCursor c = tcpIpHostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings tcpIpAdapterSettings = (BTcpIpAdapterSettings)c.get();
            String propName = SlotPath.escape((String)tcpIpAdapterSettings.getAdapterId());
            BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(propName);
            if (dhcpdAdapterSettings == null || !DhcpdUtil.fixDhcpdAdapterSettings(dhcpdAdapterSettings, tcpIpAdapterSettings.getIpAddress(), tcpIpAdapterSettings.getSubnetMask())) continue;
            adjustmentOccurred = true;
        }
        return adjustmentOccurred;
    }

    private static boolean fixDhcpdAdapterSettings(BDhcpdAdapterSettings dhcpdAdapterSettings, String adapterIpAddress, String adapterNetmask) {
        String endClientAddress;
        String dhcpEndAddressPrefix;
        String adjustedStartIpAddress;
        String startIpAddress;
        int dhcpdRange;
        int adjustedDhcpdRange;
        String adapterSubnet;
        if (dhcpdAdapterSettings == null) {
            return false;
        }
        if (!IPAddressUtil.isIpv4Address((String)adapterIpAddress) || !IPAddressUtil.isIpv4SubnetMask((String)adapterNetmask)) {
            return false;
        }
        boolean dhcpdAdapterSettingsModified = false;
        if (!dhcpdAdapterSettings.getIsDhcpdIpv4Supported()) {
            dhcpdAdapterSettings.setIsDhcpdIpv4Supported(true);
            dhcpdAdapterSettingsModified = true;
        }
        if (IPAddressUtil.compare((Object)(adapterSubnet = IPAddressUtil.getIPv4NetworkPrefix((String)adapterIpAddress, (String)adapterNetmask)), (Object)dhcpdAdapterSettings.getSubnet()) != 0) {
            dhcpdAdapterSettings.setSubnet(adapterSubnet);
            dhcpdAdapterSettingsModified = true;
        }
        if (IPAddressUtil.compare((Object)adapterNetmask, (Object)dhcpdAdapterSettings.getSubnetMask()) != 0) {
            dhcpdAdapterSettings.setSubnetMask(adapterNetmask);
            dhcpdAdapterSettingsModified = true;
        }
        if ((adjustedDhcpdRange = DhcpdUtil.fixDhcpdAdapterSettingsRange(dhcpdRange = dhcpdAdapterSettings.getRange(), 1, 240, dhcpdAdapterSettings.getSubnetMask())) != dhcpdRange) {
            dhcpdRange = adjustedDhcpdRange;
            dhcpdAdapterSettings.setRange(adjustedDhcpdRange);
            dhcpdAdapterSettingsModified = true;
        }
        if ((startIpAddress = dhcpdAdapterSettings.getStartClientAddress()).isEmpty()) {
            startIpAddress = DhcpdUtil.getNextIpAddress(adapterIpAddress);
            dhcpdAdapterSettings.setStartClientAddress(startIpAddress);
            dhcpdAdapterSettingsModified = true;
        }
        if (IPAddressUtil.compare((Object)(adjustedStartIpAddress = DhcpdUtil.fixDhcpdAdapterSettingsStartAddress(startIpAddress, adapterSubnet, adapterNetmask)), (Object)startIpAddress) != 0) {
            startIpAddress = adjustedStartIpAddress;
            dhcpdAdapterSettings.setStartClientAddress(adjustedStartIpAddress);
            dhcpdAdapterSettingsModified = true;
        }
        if (IPAddressUtil.compare((Object)(dhcpEndAddressPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)(endClientAddress = DhcpdUtil.getEndIpAddress(startIpAddress, dhcpdRange)), (String)adapterNetmask)), (Object)adapterSubnet) != 0) {
            adjustedDhcpdRange = dhcpdRange;
            while (adjustedDhcpdRange >= 1 && IPAddressUtil.compare((Object)dhcpEndAddressPrefix, (Object)adapterSubnet) != 0) {
                endClientAddress = DhcpdUtil.getEndIpAddress(startIpAddress, --adjustedDhcpdRange);
                dhcpEndAddressPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)endClientAddress, (String)adapterNetmask);
            }
            if (adjustedDhcpdRange != dhcpdRange && adjustedDhcpdRange > 1) {
                dhcpdAdapterSettings.setRange(--adjustedDhcpdRange);
                dhcpdAdapterSettingsModified = true;
            }
        }
        return dhcpdAdapterSettingsModified;
    }

    public static List<DhcpdLeaseSettings> getDhcpdLeases(BDaemonSession daemonSession, boolean onlyNiagaraLeases, boolean onlyActiveLeases) throws Exception {
        BDhcpdHostSettings dhcpdHostSettings = new BDhcpdHostSettings();
        DhcpdUtil.loadFromSession(dhcpdHostSettings, daemonSession);
        if (dhcpdHostSettings.getDhcpdServerType() == BDhcpdServerType.dnsmasq && onlyNiagaraLeases) {
            LOG.warning("Get DHCP leases requested onlyNiagaraLeases from a dnsmasq DHCP server provider, list will be empty");
        }
        DhcpdUtil.loadDhcpdConfFile(dhcpdHostSettings, daemonSession);
        String[] leaseLines = DhcpdUtil.loadDhcpdLeaseFile(dhcpdHostSettings, daemonSession);
        return DhcpdUtil.stringToDhcpdLeaseSettings(dhcpdHostSettings, leaseLines, onlyNiagaraLeases, onlyActiveLeases);
    }

    public static String[] loadDhcpdLeaseFile(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession daemonSession) throws Exception {
        InputStream dhcpdLeasesStream;
        String[] fileContent = new String[]{};
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " leases file from daemon session...");
            start = Clock.ticks();
        }
        String dhcpdLeasePath = dhcpdHostSettings.getDhcpdLeasePath();
        FilePath dhcpdLeasesFile = new FilePath(dhcpdLeasePath);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Retrieving " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " leases file at '" + dhcpdLeasesFile + "'");
        }
        if ((dhcpdLeasesStream = daemonSession.getInputStream(new GetFileMessage(dhcpdLeasesFile, daemonSession.getFileSpace()))) != null) {
            fileContent = FileUtil.readLines((Reader)new InputStreamReader(dhcpdLeasesStream, StandardCharsets.UTF_8));
        } else if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Null InputStream occurred while reading " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " leases file, assume no leases");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Load of " + (Object)((Object)dhcpdHostSettings.getDhcpdServerType()) + " leases file from daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
        return fileContent;
    }

    public static List<DhcpdLeaseSettings> stringToDhcpdLeaseSettings(BDhcpdHostSettings dhcpdHostSettings, String[] leaseLines, boolean onlyNiagaraLeases, boolean onlyActiveLeases) {
        int currentLineNumber;
        BDhcpdServerType dhcpdServerType;
        HashMap<String, DhcpdLeaseSettings> leaseMap = new HashMap<String, DhcpdLeaseSettings>();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("stringToDhcpdLeaseSettings creating lease settings from string:\n" + TextUtil.join((String[])leaseLines, (char)'\n'));
        }
        if ((dhcpdServerType = dhcpdHostSettings.getDhcpdServerType()) == BDhcpdServerType.dhcpd) {
            for (currentLineNumber = 0; currentLineNumber < leaseLines.length; ++currentLineNumber) {
                String currentLine = leaseLines[currentLineNumber].trim();
                if (!currentLine.startsWith(DHCPD_LEASES_LEASE) || !currentLine.endsWith(OPEN_BRACE)) continue;
                DhcpdLeaseSettings dhcpdLeaseSettings = new DhcpdLeaseSettings();
                dhcpdLeaseSettings.setIgnoreLease(false);
                String[] words = currentLine.split(SPACE);
                String leaseIpAddress = words[1];
                dhcpdLeaseSettings.setIpAddress(leaseIpAddress);
                DhcpdUtil.setDhcpdLeaseSubnetFromIp(dhcpdLeaseSettings, dhcpdHostSettings);
                currentLineNumber = DhcpdUtil.stringToDhcpdLeaseSettingsDhcpdLease(dhcpdLeaseSettings, leaseLines, currentLineNumber);
                boolean ignoreLeaseFlag = dhcpdLeaseSettings.getIgnoreLease();
                if (ignoreLeaseFlag) continue;
                String hostid = dhcpdLeaseSettings.getHostId();
                if (onlyNiagaraLeases) {
                    if (hostid == null || hostid.trim().isEmpty()) continue;
                    leaseMap.put(leaseIpAddress, dhcpdLeaseSettings);
                    continue;
                }
                leaseMap.put(leaseIpAddress, dhcpdLeaseSettings);
            }
        } else if (dhcpdServerType == BDhcpdServerType.dnsmasq) {
            for (currentLineNumber = 0; currentLineNumber < leaseLines.length; ++currentLineNumber) {
                String currentLine = leaseLines[currentLineNumber].trim();
                if (!DNSMASQ_LEASES_LEASE_REGEX.matcher(currentLine).matches()) continue;
                DhcpdLeaseSettings dhcpdLeaseSettings = new DhcpdLeaseSettings();
                dhcpdLeaseSettings.setIgnoreLease(false);
                String[] words = currentLine.split(SPACE);
                String leaseIpAddress = words[2];
                dhcpdLeaseSettings.setIpAddress(leaseIpAddress);
                DhcpdUtil.setDhcpdLeaseSubnetFromIp(dhcpdLeaseSettings, dhcpdHostSettings);
                currentLineNumber = DhcpdUtil.stringToDhcpdLeaseSettingsDnsmasqLease(dhcpdLeaseSettings, leaseLines, currentLineNumber);
                boolean ignoreLeaseFlag = dhcpdLeaseSettings.getIgnoreLease();
                if (ignoreLeaseFlag) continue;
                String hostid = dhcpdLeaseSettings.getHostId();
                if (onlyNiagaraLeases) {
                    if (hostid == null || hostid.trim().isEmpty()) continue;
                    leaseMap.put(leaseIpAddress, dhcpdLeaseSettings);
                    continue;
                }
                leaseMap.put(leaseIpAddress, dhcpdLeaseSettings);
            }
        } else {
            throw new IllegalArgumentException("Unknown DHCP server type " + (Object)((Object)dhcpdServerType) + ", cannot parse leases from string");
        }
        Collection leases = leaseMap.values();
        return new ArrayList<DhcpdLeaseSettings>(leases);
    }

    private static void setDhcpdLeaseSubnetFromIp(DhcpdLeaseSettings dhcpdLeaseSettings, BDhcpdHostSettings dhcpdHostSettings) {
        String leaseIpAddress = dhcpdLeaseSettings.getIpAddress();
        if (!IPAddressUtil.isIpv4Address((String)leaseIpAddress)) {
            throw new IllegalArgumentException("Invalid lease IP address " + leaseIpAddress);
        }
        SlotCursor c = dhcpdHostSettings.getDhcpdSubnets().loadSlots().getProperties();
        while (c.next()) {
            BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)c.get();
            String networkPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)leaseIpAddress, (String)dhcpdAdapterSettings.getSubnetMask());
            if (IPAddressUtil.compare((Object)networkPrefix, (Object)dhcpdAdapterSettings.getSubnet()) != 0) continue;
            dhcpdLeaseSettings.setSubnet(networkPrefix);
            return;
        }
        String defaultNetwork = IPAddressUtil.getIPv4NetworkPrefix((String)leaseIpAddress, (String)"255.255.255.0");
        LOG.warning("Failed to locate matching DHCP network for lease IP address " + leaseIpAddress + ", fallback to default netmask result " + defaultNetwork);
        dhcpdLeaseSettings.setSubnet(defaultNetwork);
    }

    private static int stringToDhcpdLeaseSettingsDhcpdLease(DhcpdLeaseSettings dhcpdLeaseSettings, String[] leaseLines, int currentLineNumber) {
        if (dhcpdLeaseSettings == null | leaseLines == null || currentLineNumber < 0 || currentLineNumber >= leaseLines.length) {
            return currentLineNumber;
        }
        boolean errorOccurred = false;
        boolean endOfLeaseBlock = false;
        String currentLine = leaseLines[currentLineNumber].trim();
        while (!endOfLeaseBlock) {
            block34: {
                String[] words = currentLine.split(SPACE);
                try {
                    if (currentLine.startsWith(CLOSE_BRACE)) {
                        endOfLeaseBlock = true;
                        continue;
                    }
                    if (currentLine.startsWith(DHCPD_LEASES_HARDWARE_ETHERNET)) {
                        String macAddress = words[2].substring(0, words[2].indexOf(SEMICOLON));
                        dhcpdLeaseSettings.setMacAddress(macAddress);
                    } else if (currentLine.startsWith(DHCPD_LEASES_HOSTID)) {
                        String hostId = words[3].substring(1, words[3].lastIndexOf(QUOTE));
                        dhcpdLeaseSettings.setHostId(hostId);
                    } else if (currentLine.startsWith(DHCPD_LEASES_PLATFORM_PORT)) {
                        String platformPort = words[3].substring(1, words[3].lastIndexOf(QUOTE));
                        dhcpdLeaseSettings.setPlatformPort(Integer.parseInt(platformPort));
                    } else if (currentLine.startsWith(DHCPD_LEASES_PLATFORMS_PORT)) {
                        String platformsPort = words[3].substring(1, words[3].lastIndexOf(QUOTE));
                        dhcpdLeaseSettings.setPlatformsPort(Integer.parseInt(platformsPort));
                    } else if (currentLine.startsWith(DHCPD_LEASES_USE_PLATFORMS)) {
                        if (TRUE.equals(words[3].substring(1, words[3].lastIndexOf(QUOTE)))) {
                            dhcpdLeaseSettings.setUsePlatforms(true);
                        } else if (FALSE.equals(words[3].substring(1, words[3].lastIndexOf(QUOTE)))) {
                            dhcpdLeaseSettings.setUsePlatforms(false);
                        } else {
                            errorOccurred = true;
                        }
                    } else if (currentLine.startsWith(DHCPD_LEASES_FOX_PORT)) {
                        String foxPort = words[3].substring(1, words[3].lastIndexOf(QUOTE));
                        dhcpdLeaseSettings.setFoxPort(Integer.parseInt(foxPort));
                    } else if (currentLine.startsWith(DHCPD_LEASES_FOXS_PORT)) {
                        String foxsPort = words[3].substring(1, words[3].lastIndexOf(QUOTE));
                        dhcpdLeaseSettings.setFoxsPort(Integer.parseInt(foxsPort));
                    } else if (currentLine.startsWith(DHCPD_LEASES_USE_FOXS)) {
                        if (TRUE.equals(words[3].substring(1, words[3].lastIndexOf(QUOTE)))) {
                            dhcpdLeaseSettings.setUseFoxs(true);
                        } else if (FALSE.equals(words[3].substring(1, words[3].lastIndexOf(QUOTE)))) {
                            dhcpdLeaseSettings.setUseFoxs(false);
                        } else {
                            errorOccurred = true;
                        }
                    } else if (currentLine.startsWith(DHCPD_LEASES_STATION_NAME)) {
                        String stationName = words[3].substring(1, words[3].lastIndexOf(QUOTE));
                        dhcpdLeaseSettings.setStationName(stationName);
                    } else if (currentLine.startsWith(DHCPD_LEASES_FOXWSS_PORT)) {
                        String foxwssPort = words[3].substring(1, words[3].lastIndexOf(QUOTE));
                        dhcpdLeaseSettings.setFoxwssPort(Integer.parseInt(foxwssPort));
                    }
                }
                catch (Exception exception) {
                    errorOccurred = true;
                    if (!LOG.isLoggable(Level.FINE)) break block34;
                    LOG.log(Level.FINE, "Exception occurred parsing DHCP server lease data at line '" + currentLine + "'", exception);
                }
            }
            if (errorOccurred) {
                dhcpdLeaseSettings.setIgnoreLease(true);
                errorOccurred = false;
                LOG.warning("Error occurred parsing DHCP server lease data from IP: " + dhcpdLeaseSettings.getIpAddress() + " MAC: " + dhcpdLeaseSettings.getMacAddress() + " at line: " + currentLineNumber + ": " + currentLine);
            }
            if (currentLineNumber == leaseLines.length - 1) {
                dhcpdLeaseSettings.setIgnoreLease(true);
                LOG.warning("Error occurred parsing DHCP server lease data from IP: " + dhcpdLeaseSettings.getIpAddress() + " MAC: " + dhcpdLeaseSettings.getMacAddress() + ", lease block not properly terminated");
                break;
            }
            currentLine = leaseLines[++currentLineNumber].trim();
        }
        return currentLineNumber;
    }

    private static int stringToDhcpdLeaseSettingsDnsmasqLease(DhcpdLeaseSettings dhcpdLeaseSettings, String[] leaseLines, int currentLineNumber) {
        String currentLine;
        boolean errorOccurred;
        block5: {
            if (dhcpdLeaseSettings == null | leaseLines == null || currentLineNumber < 0 || currentLineNumber >= leaseLines.length) {
                return currentLineNumber;
            }
            errorOccurred = false;
            currentLine = leaseLines[currentLineNumber].trim();
            try {
                String[] leaseWords = currentLine.split(SPACE);
                if (leaseWords.length < 5) {
                    throw new IllegalArgumentException("Unrecognized lease token count: " + leaseWords.length);
                }
                String macAddress = leaseWords[1];
                dhcpdLeaseSettings.setMacAddress(macAddress);
            }
            catch (Exception exception) {
                errorOccurred = true;
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.log(Level.FINE, "Exception occurred parsing DHCP server lease data at line '" + currentLine + "'", exception);
            }
        }
        if (errorOccurred) {
            dhcpdLeaseSettings.setIgnoreLease(true);
            LOG.warning("Error occurred parsing DHCP server lease data from IP: " + dhcpdLeaseSettings.getIpAddress() + " MAC: " + dhcpdLeaseSettings.getMacAddress() + " at line: " + currentLineNumber + ": " + currentLine);
        }
        return currentLineNumber;
    }

    public static BDhcpdAdapterSettings getDhcpdAdapterSettingsForAdapterId(BDhcpdHostSettings dhcpdHostSettings, String adapterId) {
        if (dhcpdHostSettings == null) {
            return null;
        }
        if (adapterId == null) {
            return null;
        }
        String propName = SlotPath.escape((String)adapterId);
        return (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(propName);
    }

    public static void copyDhcpdSlotToAdapters(BDhcpdHostSettings dhcpdHostSettings, BTcpIpHostSettings tcpIpHostSettings) {
        DhcpdUtil.copyDhcpdSlotToAdapters(dhcpdHostSettings, tcpIpHostSettings, false);
    }

    public static void copyDhcpdSlotToAdapters(BDhcpdHostSettings dhcpdHostSettings, BTcpIpHostSettings tcpIpHostSettings, boolean applyReadOnlyToAdapter) {
        SlotCursor c = tcpIpHostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings tcpIpAdapterSettings = (BTcpIpAdapterSettings)c.get();
            DhcpdUtil.copyFromDhcpdHostSettingsToAdapter(dhcpdHostSettings, tcpIpAdapterSettings, applyReadOnlyToAdapter);
        }
    }

    private static void copyFromDhcpdHostSettingsToAdapter(BDhcpdHostSettings dhcpdHostSettings, BTcpIpAdapterSettings tcpIpAdapterSettings, boolean applyReadOnlyToAdapter) {
        String propName = SlotPath.escape((String)tcpIpAdapterSettings.getAdapterId());
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(propName);
        if (dhcpdAdapterSettings != null) {
            if (tcpIpAdapterSettings.get(DHCPD_SLOT_NAME) != null) {
                BDhcpdAdapterSettings currentSlot = (BDhcpdAdapterSettings)tcpIpAdapterSettings.get(DHCPD_SLOT_NAME);
                currentSlot.copyFrom((BComplex)dhcpdAdapterSettings);
            } else {
                tcpIpAdapterSettings.add(DHCPD_SLOT_NAME, dhcpdAdapterSettings.newCopy(), 3);
            }
            if (applyReadOnlyToAdapter && dhcpdAdapterSettings.getIsDhcpdIpv4Supported() && dhcpdAdapterSettings.getIsDhcpdIpv4Enabled() && dhcpdAdapterSettings.getIsReadOnly()) {
                tcpIpAdapterSettings.setIsAdapterReadonly(true);
            }
        }
    }

    public static void copyDhcpdSlotFromAdapters(BDhcpdHostSettings dhcpdHostSettings, BTcpIpHostSettings tcpIpHostSettings) {
        SlotCursor c = tcpIpHostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings tcpIpAdapterSettings = (BTcpIpAdapterSettings)c.get();
            DhcpdUtil.copyFromAdapterToDhcpdHostSettings(dhcpdHostSettings, tcpIpAdapterSettings);
        }
    }

    private static void copyFromAdapterToDhcpdHostSettings(BDhcpdHostSettings dhcpdHostSettings, BTcpIpAdapterSettings tcpIpAdapterSettings) {
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)tcpIpAdapterSettings.get(DHCPD_SLOT_NAME);
        if (dhcpdAdapterSettings != null) {
            BDhcpdAdapterSettings dhcpdAdapterSettingsForAdapterId = DhcpdUtil.getDhcpdAdapterSettingsForAdapterId(dhcpdHostSettings, tcpIpAdapterSettings.getAdapterId());
            dhcpdAdapterSettingsForAdapterId.copyFrom((BComplex)dhcpdAdapterSettings);
        }
    }

    private static String adapterOsNameToMarkerName(String adapterOsName, boolean isTridiumQNX) {
        if (adapterOsName == null) {
            return null;
        }
        String markerName = isTridiumQNX && adapterOsName.equals(TRIDIUM_LEGACY_WIFI_DHCPD_ADAPTER_SAP_OSNAME) ? TRIDIUM_LEGACY_WIFI_MARKER : adapterOsName.toUpperCase(Locale.US);
        return markerName;
    }

    private static String markerNameToAdapterOsName(String markerName, boolean isTridiumQNX) {
        if (markerName == null) {
            return null;
        }
        String adapterOsName = isTridiumQNX && markerName.equals(TRIDIUM_LEGACY_WIFI_MARKER) ? TRIDIUM_LEGACY_WIFI_DHCPD_ADAPTER_SAP_OSNAME : markerName.toLowerCase(Locale.US);
        return adapterOsName;
    }

    public static String adapterIdToAdapterOsName(String adapterId, boolean isTridiumQNX) {
        if (adapterId == null) {
            return null;
        }
        String adapterOsName = isTridiumQNX && adapterId.startsWith(TRIDIUM_LEGACY_ADAPTER_DHCPD_ID_PREFIX) ? TRIDIUM_LEGACY_ADAPTER_DHCPD_OSNAME_PREFIX + adapterId.substring(2) : adapterId;
        return adapterOsName;
    }

    public static String adapterOsNameToAdapterId(String adapterOsName, boolean isTridiumQNX) {
        if (adapterOsName == null) {
            return null;
        }
        String adapterIdName = isTridiumQNX && adapterOsName.startsWith(TRIDIUM_LEGACY_ADAPTER_DHCPD_OSNAME_PREFIX) ? TRIDIUM_LEGACY_ADAPTER_DHCPD_ID_PREFIX + adapterOsName.substring(2) : adapterOsName;
        return adapterIdName;
    }

    public static void validateDhcpdAdapterSettings(BDhcpdAdapterSettings dhcpdAdapterSettings, String adapterIpAddress, String adapterSubnetMask, int minClients, int maxClients) throws Exception {
        String subnet = dhcpdAdapterSettings.getSubnet();
        if (!IPAddressUtil.isIpv4Address((String)subnet)) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidSubnet");
        }
        String subnetMask = dhcpdAdapterSettings.getSubnetMask();
        if (!IPAddressUtil.isIpv4SubnetMask((String)subnetMask)) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidMask");
        }
        if (!subnet.equals(IPAddressUtil.getIPv4NetworkPrefix((String)subnet, (String)subnetMask))) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidSubnet");
        }
        int range = dhcpdAdapterSettings.getRange();
        if (range < minClients) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.rangeTooSmall");
        }
        if (range > maxClients) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.rangeTooBig");
        }
        int usableHosts = Math.max(DhcpdUtil.getUsableHosts(subnetMask) - 1, 0);
        if (range > usableHosts) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.rangeTooBigUsableHosts");
        }
        String startClientAddress = dhcpdAdapterSettings.getStartClientAddress();
        if (!IPAddressUtil.isIpv4Address((String)startClientAddress)) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidIp");
        }
        String startClientAddressSubnet = IPAddressUtil.getIPv4NetworkPrefix((String)startClientAddress, (String)subnetMask);
        if (IPAddressUtil.compare((Object)subnet, (Object)startClientAddressSubnet) != 0) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidStartAddressNotInSubnet");
        }
        byte[] subnetBytes = IPAddressUtil.numericStringToByteArray((String)subnet);
        if (subnetBytes == null) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidSubnet");
        }
        byte[] subnetMaskBytes = IPAddressUtil.numericStringToByteArray((String)subnetMask);
        if (subnetMaskBytes == null) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidMask");
        }
        byte[] startIpBytes = IPAddressUtil.numericStringToByteArray((String)startClientAddress);
        if (startIpBytes == null) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidIp");
        }
        byte[] broadcastBytes = new byte[subnetBytes.length];
        for (int i = 0; i < subnetBytes.length; ++i) {
            broadcastBytes[i] = (byte)(subnetBytes[i] | ~subnetMaskBytes[i]);
        }
        boolean isNetworkAddress = startClientAddress.equals(subnet);
        boolean isFirstUsableAddress = startClientAddress.equals(DhcpdUtil.getNextIpAddress(subnet));
        boolean isBroadcastAddress = ByteArrayUtil.equals((byte[])startIpBytes, (byte[])broadcastBytes);
        if (isNetworkAddress || isFirstUsableAddress || isBroadcastAddress) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidStartAddressNotInUsableRange");
        }
        String endClientAddress = DhcpdUtil.getEndIpAddress(startClientAddress, range);
        String dhcpEndAddressPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)endClientAddress, (String)subnetMask);
        if (IPAddressUtil.compare((Object)dhcpEndAddressPrefix, (Object)subnet) != 0) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.endAddrNotInSubnet");
        }
        byte[] endIpBytes = IPAddressUtil.numericStringToByteArray((String)endClientAddress);
        if (endIpBytes == null) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidIp");
        }
        isBroadcastAddress = ByteArrayUtil.equals((byte[])endIpBytes, (byte[])broadcastBytes);
        if (isBroadcastAddress) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidStartAddressNotInUsableRange");
        }
        int lastOctet = startIpBytes[3] & 0xFF;
        int endLastOctet = lastOctet + range - 1;
        if (endLastOctet > 255) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.endAddrTooBig");
        }
        if (dhcpdAdapterSettings.getIsDhcpdIpv4Enabled()) {
            DhcpdUtil.validateAdapterIpInDhcpdSubnet(dhcpdAdapterSettings, adapterIpAddress, adapterSubnetMask);
            DhcpdUtil.validateAdapterIpInDhcpdRange(dhcpdAdapterSettings, adapterIpAddress);
        }
    }

    public static void validateAdapterIpInDhcpdSubnet(BDhcpdAdapterSettings dhcpdAdapterSettings, String adapterIpAddress, String adapterSubnetMask) throws Exception {
        if (IPAddressUtil.compare((Object)dhcpdAdapterSettings.getSubnetMask(), (Object)adapterSubnetMask) != 0) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.tcpipDhcpdv4InvalidMask");
        }
        if (adapterIpAddress == null) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.dhcpdSubnetMismatchWithAdapterIp");
        }
        String adapterSubnet = IPAddressUtil.getIPv4NetworkPrefix((String)adapterIpAddress, (String)adapterSubnetMask);
        if (IPAddressUtil.compare((Object)dhcpdAdapterSettings.getSubnet(), (Object)adapterSubnet) != 0) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.dhcpdSubnetMismatchWithAdapterIp");
        }
    }

    public static void validateAdapterIpInDhcpdRange(BDhcpdAdapterSettings dhcpdAdapterSettings, String adapterIpAddress) throws Exception {
        String startClientAddress = dhcpdAdapterSettings.getStartClientAddress();
        int range = dhcpdAdapterSettings.getRange();
        String endClientAddress = DhcpdUtil.getEndIpAddress(startClientAddress, range);
        if (IPAddressUtil.compare((Object)startClientAddress, (Object)adapterIpAddress) != 1 && IPAddressUtil.compare((Object)endClientAddress, (Object)adapterIpAddress) != -1) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.adapterInClientRange");
        }
    }
}

